import { ValidationMap } from 'react';
import { Props as IconProps } from './components/Icon';
export declare type HeadingTagName = 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'p';
export declare type AppBridgeTarget = 'ADMIN_PATH' | 'REMOTE' | 'APP';
export declare type Error = string | React.ReactElement<any> | (string | React.ReactElement<any>)[];
export interface BaseAction {
    /** A unique identifier for the action */
    id?: string;
    /** Content the action displays */
    content?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** A destination to link to, rendered in the action */
    url?: string;
    /** Forces url to open in a new tab */
    external?: boolean;
    /** Callback when an action takes place */
    onAction?(): void;
}
export interface Action extends BaseAction {
}
export interface AnimationProps {
    in?: boolean;
}
export interface BaseLinkAction {
    /** A unique identifier for the action */
    id?: string;
    /** Content the action displays */
    content?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** A destination to link to */
    url: string;
}
export interface AppBridgeActionTarget {
    /**
     * Where to display the target link
     * @default 'APP'
     * @embeddedAppOnly
     */
    target?: AppBridgeTarget;
}
export interface LinkAction extends BaseLinkAction, AppBridgeActionTarget {
}
export interface BadgeAction {
    badge?: {
        status: 'new';
        content: string;
    };
}
export interface BaseCallbackAction {
    /** A unique identifier for the action */
    id?: string;
    /** Content the action displays */
    content?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** Callback when an action takes place */
    onAction(): void;
}
export interface CallbackAction extends BaseCallbackAction {
}
export interface DisableableAction extends Action {
    /** Should the action be disabled */
    disabled?: boolean;
}
export interface DestructableAction extends Action {
    /** Destructive action */
    destructive?: boolean;
}
export interface AppBridgeAction extends Action, DisableableAction, DestructableAction, AppBridgeActionTarget {
}
export interface IconableAction extends Action {
    /** Source of the icon */
    icon?: IconProps['source'];
}
export interface LoadableAction extends Action {
    /** Should a spinner be displayed */
    loading?: boolean;
}
export interface ActionListItemDescriptor extends IconableAction, DisableableAction, BadgeAction, DestructableAction, AppBridgeAction {
    /** Additional hint text to display with item */
    helpText?: string;
    /** Image source */
    image?: string;
    /**  Add an ellipsis suffix to action content */
    ellipsis?: boolean;
    /** Whether the action is active or not */
    active?: boolean;
    /** Defines a role for the action */
    role?: string;
}
export interface ActionListSection {
    /** Section title */
    title?: string;
    /** Collection of action items for the list */
    items: ActionListItemDescriptor[];
}
export interface ComplexAction extends Action, DisableableAction, DestructableAction, AppBridgeAction, IconableAction, LoadableAction {
}
export declare enum Key {
    Backspace = 8,
    Tab = 9,
    Enter = 13,
    Shift = 16,
    Ctrl = 17,
    Alt = 18,
    Pause = 19,
    CapsLock = 20,
    Escape = 27,
    Space = 32,
    PageUp = 33,
    PageDown = 34,
    End = 35,
    Home = 36,
    LeftArrow = 37,
    UpArrow = 38,
    RightArrow = 39,
    DownArrow = 40,
    Insert = 45,
    Delete = 46,
    Key0 = 48,
    Key1 = 49,
    Key2 = 50,
    Key3 = 51,
    Key4 = 52,
    Key5 = 53,
    Key6 = 54,
    Key7 = 55,
    Key8 = 56,
    Key9 = 57,
    KeyA = 65,
    KeyB = 66,
    KeyC = 67,
    KeyD = 68,
    KeyE = 69,
    KeyF = 70,
    KeyG = 71,
    KeyH = 72,
    KeyI = 73,
    KeyJ = 74,
    KeyK = 75,
    KeyL = 76,
    KeyM = 77,
    KeyN = 78,
    KeyO = 79,
    KeyP = 80,
    KeyQ = 81,
    KeyR = 82,
    KeyS = 83,
    KeyT = 84,
    KeyU = 85,
    KeyV = 86,
    KeyW = 87,
    KeyX = 88,
    KeyY = 89,
    KeyZ = 90,
    LeftMeta = 91,
    RightMeta = 92,
    Select = 93,
    Numpad0 = 96,
    Numpad1 = 97,
    Numpad2 = 98,
    Numpad3 = 99,
    Numpad4 = 100,
    Numpad5 = 101,
    Numpad6 = 102,
    Numpad7 = 103,
    Numpad8 = 104,
    Numpad9 = 105,
    Multiply = 106,
    Add = 107,
    Subtract = 109,
    Decimal = 110,
    Divide = 111,
    F1 = 112,
    F2 = 113,
    F3 = 114,
    F4 = 115,
    F5 = 116,
    F6 = 117,
    F7 = 118,
    F8 = 119,
    F9 = 120,
    F10 = 121,
    F11 = 122,
    F12 = 123,
    NumLock = 144,
    ScrollLock = 145,
    Semicolon = 186,
    Equals = 187,
    Comma = 188,
    Dash = 189,
    Period = 190,
    ForwardSlash = 191,
    GraveAccent = 192,
    OpenBracket = 219,
    BackSlash = 220,
    CloseBracket = 221,
    SingleQuote = 222
}
export declare const contentContextTypes: ValidationMap<any>;
export interface WithContextTypes<IJ> {
    context: IJ;
}
export declare enum TypeOf {
    Undefined = "undefined",
    Object = "object",
    Boolean = "boolean",
    Number = "number",
    String = "string",
    Symbol = "symbol",
    Function = "function"
}
export interface GeneralObject {
    [key: string]: any;
}
