import { RGBColor, RGBAColor, HSBColor, HSBAColor, HSLColor, HSLAColor } from './color-types';
export declare function rgbString(color: RGBColor | RGBAColor): string;
export declare const rgbaString: typeof rgbString;
export declare function rgbToHex({ red, green, blue }: RGBColor): string;
export declare function hsbToHex(color: HSBColor): string;
export declare function hsbToRgb(color: HSBColor): RGBColor;
export declare function hsbToRgb(color: HSBAColor): RGBAColor;
export declare function hslToRgb(color: HSLColor): RGBColor;
export declare function hslToRgb(color: HSLAColor): RGBAColor;
export declare function rgbToHsb(color: RGBColor): HSBColor;
export declare function rgbToHsb(color: RGBAColor): HSBAColor;
export declare function rgbToHsl(color: RGBColor): HSLColor;
export declare function rgbToHsl(color: RGBAColor): HSLAColor;
export declare enum ColorType {
    Hex = "hex",
    Rgb = "rgb",
    Rgba = "rgba",
    Hsl = "hsl",
    Hsla = "hsla",
    Default = "default"
}
export declare function hslToString(hslColor: HSLAColor | string): string;
export declare function colorToHsla(color: string): string | HSLColor;
