---
name: Section header
category: Lists and tables
platforms:
  - android
  - ios
keywords:
  - SectionHeader
  - section header
  - sticky header
  - section divider
  - list group
  - list grouping
  - lists
  - sections
  - android
  - ios
---

# Section header

Use the section header component to group items in a list. It helps merchants to quickly see what items are related.

---

## Best practices

- List the groups in a clear and obvious way, such as alphabetically or by date.
- Avoid cluttering the list with long section titles that make it hard to scan.
- Avoid using section headers if your list usually has only 1 item in every grouping. The more section headers there are, the harder it is for merchants to scan the list.

---

## Content guidelines

- Keep titles short

<!-- usagelist -->

#### Do

- Created today
- Created Aug 15

#### Don’t

- Discount created today, Aug 15
- Created August 15, 2018

<!-- end -->

Read more about [dates and numbers](https://polaris.shopify.com/content/grammar-and-mechanics#section-dates-numbers-and-addresses).

- Use a clear sort order

<!-- usagelist -->

#### Do

- Today
- Yesterday
- Monday

#### Don’t

- Recent
- Other

<!-- end -->

---

## Examples

### Default

Use to group related content together, for example orders received on the same day.

<!-- content-for: android -->

![Shipping costs card with multiple sections: domestic, international](/public_images/components/SectionHeader/android/default@2x.png)

<!-- /content-for -->

<!-- content-for: ios -->

![Shipping costs card with multiple sections: domestic, international](/public_images/components/SectionHeader/ios/default@2x.png)

<!-- /content-for -->

### Fixed

<!-- example-for: ios -->

Use if your list section could be longer than the height of the screen. For example you may need fixed section headers for a list of orders, because merchants may receive many orders in one day.

![Shipping costs card with multiple sections: domestic, international](/public_images/components/SectionHeader/ios/fixed@2x.png)

---

## Related components

- Use section headers if you want to organize [resource list items](https://polaris.shopify.com/components/lists-and-tables/resource-list) into groups.
