import { __rest } from "tslib";
import React from 'react';
import { classNames } from '../../utilities/css';
import { MenuAction, MenuGroup, RollupActions } from './components';
import styles from './ActionMenu.scss';
export class ActionMenu extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            activeMenuGroup: undefined,
        };
        this.renderActions = () => {
            const { actions = [], groups = [] } = this.props;
            const { activeMenuGroup } = this.state;
            const actionsMarkup = actions.length > 0
                ? actions.map((_a, index) => {
                    var { content } = _a, action = __rest(_a, ["content"]);
                    return (<MenuAction key={`MenuAction-${content || index}`} content={content} {...action}/>);
                })
                : null;
            const groupsMarkup = hasGroupsWithActions(groups)
                ? groups.map((_a, index) => {
                    var { title } = _a, rest = __rest(_a, ["title"]);
                    return (<MenuGroup key={`MenuGroup-${title || index}`} title={title} active={title === activeMenuGroup} {...rest} onOpen={this.handleMenuGroupToggle} onClose={this.handleMenuGroupClose}/>);
                })
                : null;
            return actionsMarkup || groupsMarkup ? (<div className={styles.ActionsLayout}>
        {actionsMarkup}
        {groupsMarkup}
      </div>) : null;
        };
        this.handleMenuGroupToggle = (group) => {
            this.setState(({ activeMenuGroup }) => ({
                activeMenuGroup: activeMenuGroup ? undefined : group,
            }));
        };
        this.handleMenuGroupClose = () => {
            this.setState({ activeMenuGroup: undefined });
        };
    }
    render() {
        const { actions = [], groups = [], rollup } = this.props;
        if (actions.length === 0 && groups.length === 0) {
            return null;
        }
        const actionMenuClassNames = classNames(styles.ActionMenu, rollup && styles.rollup);
        const rollupSections = groups.map((group) => convertGroupToSection(group));
        return (<div className={actionMenuClassNames}>
        {rollup ? (<RollupActions items={actions} sections={rollupSections}/>) : (this.renderActions())}
      </div>);
    }
}
export function hasGroupsWithActions(groups = []) {
    return groups.length === 0
        ? false
        : groups.some((group) => group.actions.length > 0);
}
export function convertGroupToSection({ title, actions, }) {
    return { title, items: actions };
}
