import React from 'react';
import { ActionList } from '../../../ActionList';
import { Popover } from '../../../Popover';
import { MenuAction } from '../MenuAction';
import styles from './MenuGroup.scss';
export class MenuGroup extends React.Component {
    constructor() {
        super(...arguments);
        this.handleClose = () => {
            const { title, onClose } = this.props;
            onClose(title);
        };
        this.handleOpen = () => {
            const { title, onOpen } = this.props;
            onOpen(title);
        };
    }
    render() {
        const { accessibilityLabel, active, actions, details, title, icon, } = this.props;
        if (!actions.length) {
            return null;
        }
        const popoverActivator = (<MenuAction disclosure content={title} icon={icon} accessibilityLabel={accessibilityLabel} onAction={this.handleOpen}/>);
        return (<Popover active={Boolean(active)} activator={popoverActivator} preferredAlignment="left" onClose={this.handleClose}>
        <ActionList items={actions} onActionAnyItem={this.handleClose}/>
        {details && <div className={styles.Details}>{details}</div>}
      </Popover>);
    }
}
