import React from 'react';
import { useI18n } from '../../utilities/i18n';
import { DisplayText } from '../DisplayText';
import { TextStyle } from '../TextStyle';
import { Image } from '../Image';
import { Stack } from '../Stack';
import { emptySearch } from './illustrations';
import styles from './EmptySearchResult.scss';
export function EmptySearchResult({ title, description, withIllustration, }) {
    const i18n = useI18n();
    const altText = i18n.translate('Polaris.EmptySearchResult.altText');
    const descriptionMarkup = description ? <p>{description}</p> : null;
    const illustrationMarkup = withIllustration ? (<Image alt={altText} source={emptySearch} className={styles.Image} draggable={false}/>) : null;
    return (<Stack alignment="center" vertical>
      {illustrationMarkup}
      <DisplayText size="small">{title}</DisplayText>
      <TextStyle variation="subdued">{descriptionMarkup}</TextStyle>
    </Stack>);
}
