import { __rest } from "tslib";
import React from 'react';
import { focusFirstFocusableNode } from '@shopify/javascript-utilities/focus';
import isEqual from 'lodash/isEqual';
export class Focus extends React.PureComponent {
    componentDidMount() {
        this.handleSelfFocus();
    }
    componentDidUpdate(_a) {
        var { children: prevChildren } = _a, restPrevProps = __rest(_a, ["children"]);
        const _b = this.props, { children } = _b, restProps = __rest(_b, ["children"]);
        if (isEqual(restProps, restPrevProps)) {
            return;
        }
        this.handleSelfFocus();
    }
    handleSelfFocus() {
        const { disabled, root } = this.props;
        if (disabled) {
            return;
        }
        if (root) {
            if (!root.querySelector('[autofocus]')) {
                focusFirstFocusableNode(root, false);
            }
        }
    }
    render() {
        const { children } = this.props;
        return <React.Fragment>{children}</React.Fragment>;
    }
}
