import React from 'react';
import { addEventListener, removeEventListener, } from '@shopify/javascript-utilities/events';
export class KeypressListener extends React.Component {
    constructor() {
        super(...arguments);
        this.handleKeyEvent = (event) => {
            const { keyCode, handler } = this.props;
            if (event.keyCode === keyCode) {
                handler(event);
            }
        };
    }
    componentDidMount() {
        addEventListener(document, 'keyup', this.handleKeyEvent);
    }
    componentWillUnmount() {
        removeEventListener(document, 'keyup', this.handleKeyEvent);
    }
    render() {
        return null;
    }
}
