import React from 'react';
import { TickSmallMinor } from '@shopify/polaris-icons';
import { classNames } from '../../../../utilities/css';
import { useUniqueId } from '../../../../utilities/unique-id';
import { Icon } from '../../../Icon';
import styles from './Checkbox.scss';
export function Checkbox({ id: idProp, checked = false, disabled, active, onChange, name, value, role, }) {
    const id = useUniqueId('Checkbox', idProp);
    const className = classNames(styles.Checkbox, active && styles.active);
    return (<div className={className}>
      <input id={id} name={name} value={value} type="checkbox" checked={checked} disabled={disabled} className={styles.Input} aria-checked={checked} onChange={onChange} role={role}/>
      <div className={styles.Backdrop}/>
      <div className={styles.Icon}>
        <Icon source={TickSmallMinor}/>
      </div>
    </div>);
}
