import React from 'react';
import { classNames } from '../../../../utilities/css';
import { buttonsFrom } from '../../../Button';
import { useMediaQuery } from '../../../../utilities/media-query';
import { Breadcrumbs } from '../../../Breadcrumbs';
import { Pagination } from '../../../Pagination';
import { ActionMenu, hasGroupsWithActions } from '../../../ActionMenu';
import { Title } from './components';
import styles from './Header.scss';
export function Header({ title, subtitle, titleMetadata, thumbnail, titleHidden = false, separator, primaryAction, pagination, breadcrumbs = [], secondaryActions = [], actionGroups = [], }) {
    const { isNavigationCollapsed } = useMediaQuery();
    const breadcrumbMarkup = breadcrumbs.length > 0 ? (<div className={styles.BreadcrumbWrapper}>
        <Breadcrumbs breadcrumbs={breadcrumbs}/>
      </div>) : null;
    const paginationMarkup = pagination && !isNavigationCollapsed ? (<div className={styles.PaginationWrapper}>
        <Pagination {...pagination} plain/>
      </div>) : null;
    const navigationMarkup = breadcrumbMarkup || paginationMarkup ? (<div className={styles.Navigation}>
        {breadcrumbMarkup}
        {paginationMarkup}
      </div>) : null;
    const pageTitleMarkup = (<Title title={title} subtitle={subtitle} titleMetadata={titleMetadata} thumbnail={thumbnail}/>);
    const primary = primaryAction &&
        (primaryAction.primary === undefined ? true : primaryAction.primary);
    const primaryActionMarkup = primaryAction ? (<div className={styles.PrimaryActionWrapper}>
      {buttonsFrom(primaryAction, { primary })}
    </div>) : null;
    const actionMenuMarkup = secondaryActions.length > 0 || hasGroupsWithActions(actionGroups) ? (<div className={styles.ActionMenuWrapper}>
        <ActionMenu actions={secondaryActions} groups={actionGroups} rollup={isNavigationCollapsed}/>
      </div>) : null;
    const headerClassNames = classNames(styles.Header, titleHidden && styles.titleHidden, separator && styles.separator, navigationMarkup && styles.hasNavigation, actionMenuMarkup && styles.hasActionMenu, isNavigationCollapsed && styles.mobileView);
    return (<div className={headerClassNames}>
      {navigationMarkup}

      <div className={styles.MainContent}>
        <div className={styles.TitleActionMenuWrapper}>
          {pageTitleMarkup}
          {actionMenuMarkup}
        </div>

        {primaryActionMarkup}
      </div>
    </div>);
}
