import { __rest } from "tslib";
import React, { useRef, useEffect, useCallback, useState, } from 'react';
import { findFirstFocusableNode } from '@shopify/javascript-utilities/focus';
import { focusNextFocusableNode } from '../../utilities/focus';
import { Portal } from '../Portal';
import { portal } from '../shared';
import { useUniqueId } from '../../utilities/unique-id';
import { CloseSource, Pane, PopoverOverlay, Section } from './components';
import { setActivatorAttributes } from './set-activator-attributes';
export { CloseSource };
// TypeScript can't generate types that correctly infer the typing of
// subcomponents so explicitly state the subcomponents in the type definition.
// Letting this be implicit works in this project but fails in projects that use
// generated *.d.ts files.
export const Popover = function Popover(_a) {
    var { activatorWrapper = 'div', children, onClose, activator, active, fixed, ariaHaspopup } = _a, rest = __rest(_a, ["activatorWrapper", "children", "onClose", "activator", "active", "fixed", "ariaHaspopup"]);
    const [activatorNode, setActivatorNode] = useState();
    const activatorContainer = useRef(null);
    const WrapperComponent = activatorWrapper;
    const id = useUniqueId('popover');
    const setAccessibilityAttributes = useCallback(() => {
        if (activatorContainer.current == null) {
            return;
        }
        const firstFocusable = findFirstFocusableNode(activatorContainer.current);
        const focusableActivator = firstFocusable || activatorContainer.current;
        setActivatorAttributes(focusableActivator, { id, active, ariaHaspopup });
    }, [active, ariaHaspopup, id]);
    const handleClose = (source) => {
        onClose(source);
        if (activatorContainer.current == null) {
            return;
        }
        if ((source === CloseSource.FocusOut ||
            source === CloseSource.EscapeKeypress) &&
            activatorNode) {
            const focusableActivator = findFirstFocusableNode(activatorNode) ||
                findFirstFocusableNode(activatorContainer.current) ||
                activatorContainer.current;
            if (!focusNextFocusableNode(focusableActivator, isInPortal)) {
                focusableActivator.focus();
            }
        }
    };
    useEffect(() => {
        if (!activatorNode && activatorContainer.current) {
            setActivatorNode(activatorContainer.current.firstElementChild);
        }
        else if (activatorNode &&
            activatorContainer.current &&
            !activatorContainer.current.contains(activatorNode)) {
            setActivatorNode(activatorContainer.current.firstElementChild);
        }
        setAccessibilityAttributes();
    }, [activatorNode, setAccessibilityAttributes]);
    useEffect(() => {
        if (activatorNode && activatorContainer.current) {
            setActivatorNode(activatorContainer.current.firstElementChild);
        }
        setAccessibilityAttributes();
    }, [activatorNode, setAccessibilityAttributes]);
    const portal = activatorNode ? (<Portal idPrefix="popover" testID="portal">
      <PopoverOverlay testID="popoverOverlay" id={id} activator={activatorNode} onClose={handleClose} active={active} fixed={fixed} {...rest}>
        {children}
      </PopoverOverlay>
    </Portal>) : null;
    return (<WrapperComponent ref={activatorContainer}>
      {React.Children.only(activator)}
      {portal}
    </WrapperComponent>);
};
function isInPortal(element) {
    let parentElement = element.parentElement;
    while (parentElement) {
        if (parentElement.matches(portal.selector))
            return false;
        parentElement = parentElement.parentElement;
    }
    return true;
}
Popover.Pane = Pane;
Popover.Section = Section;
