import React from 'react';
import { useUniqueId } from '../../utilities/unique-id';
import { Choice, helpTextID } from '../Choice';
import styles from './RadioButton.scss';
export function RadioButton({ ariaDescribedBy: ariaDescribedByProp, label, labelHidden, helpText, checked, disabled, onChange, onFocus, onBlur, id: idProp, name: nameProp, value, }) {
    const id = useUniqueId('RadioButton', idProp);
    const name = nameProp || id;
    function handleChange({ currentTarget }) {
        onChange && onChange(currentTarget.checked, id);
    }
    const describedBy = [];
    if (helpText) {
        describedBy.push(helpTextID(id));
    }
    if (ariaDescribedByProp) {
        describedBy.push(ariaDescribedByProp);
    }
    const ariaDescribedBy = describedBy.length
        ? describedBy.join(' ')
        : undefined;
    return (<Choice label={label} labelHidden={labelHidden} disabled={disabled} id={id} helpText={helpText}>
      <span className={styles.RadioButton}>
        <input id={id} name={name} value={value} type="radio" checked={checked} disabled={disabled} className={styles.Input} onChange={handleChange} onFocus={onFocus} onBlur={onBlur} aria-describedby={ariaDescribedBy}/>
        <span className={styles.Backdrop}/>
        <span className={styles.Icon}/>
      </span>
    </Choice>);
}
