import { __rest } from "tslib";
import React from 'react';
import { useUniqueId } from '../../utilities/unique-id';
import { RangeSliderDefault } from './utilities';
import { SingleThumb, DualThumb } from './components';
export function RangeSlider(_a) {
    var { min = RangeSliderDefault.Min, max = RangeSliderDefault.Max, step = RangeSliderDefault.Step, value } = _a, rest = __rest(_a, ["min", "max", "step", "value"]);
    const id = useUniqueId('RangeSlider');
    const sharedProps = Object.assign({ id,
        min,
        max,
        step }, rest);
    return isDualThumb(value) ? (<DualThumb value={value} {...sharedProps}/>) : (<SingleThumb value={value} {...sharedProps}/>);
}
function isDualThumb(value) {
    return Array.isArray(value);
}
