import React, { useRef, useEffect } from 'react';
import { useFeatures } from '../../../../utilities/features';
import { classNames } from '../../../../utilities/css';
import { Checkbox } from '../../../Checkbox';
import { ResourceListContext, } from '../../../../utilities/resource-list';
import styles from './CheckableButton.scss';
export function CheckableButton({ accessibilityLabel, label = '', onToggleAll, selected, selectMode, plain, measuring, disabled, smallScreen, }) {
    const checkBoxRef = useRef(null);
    const { unstableGlobalTheming = false } = useFeatures();
    const { registerCheckableButtons } = React.useContext(ResourceListContext);
    let currentKey = 'bulkLg';
    if (plain) {
        currentKey = 'plain';
    }
    else if (smallScreen) {
        currentKey = 'bulkSm';
    }
    useEffect(() => {
        if (checkBoxRef.current && registerCheckableButtons) {
            registerCheckableButtons(currentKey, checkBoxRef.current);
        }
    }, [currentKey, registerCheckableButtons]);
    const className = plain
        ? classNames(styles.CheckableButton, styles['CheckableButton-plain'], unstableGlobalTheming && styles.globalTheming)
        : classNames(styles.CheckableButton, unstableGlobalTheming && styles.globalTheming, selectMode && styles['CheckableButton-selectMode'], selected && styles['CheckableButton-selected'], measuring && styles['CheckableButton-measuring']);
    return (<div className={className} onClick={onToggleAll}>
      <div className={styles.Checkbox}>
        <Checkbox label={accessibilityLabel} labelHidden checked={selected} disabled={disabled} onChange={onToggleAll} ref={checkBoxRef}/>
      </div>
      <span className={styles.Label}>{label}</span>
    </div>);
}
