import React from 'react';
import { classNames } from '../../../../utilities/css';
import { EventListener } from '../../../EventListener';
import { Tab } from '../Tab';
import styles from '../../Tabs.scss';
export class TabMeasurer extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.containerNode = React.createRef();
        this.animationFrame = null;
        this.handleMeasurement = () => {
            if (this.animationFrame) {
                cancelAnimationFrame(this.animationFrame);
            }
            this.animationFrame = requestAnimationFrame(() => {
                if (!this.containerNode.current) {
                    return;
                }
                const { handleMeasurement } = this.props;
                const containerWidth = this.containerNode.current.offsetWidth;
                const hiddenTabNodes = this.containerNode.current.children;
                const hiddenTabNodesArray = Array.from(hiddenTabNodes);
                const hiddenTabWidths = hiddenTabNodesArray.map((node) => {
                    return node.getBoundingClientRect().width;
                });
                const disclosureWidth = hiddenTabWidths.pop();
                handleMeasurement({
                    containerWidth,
                    disclosureWidth,
                    hiddenTabWidths,
                });
            });
        };
    }
    componentDidMount() {
        this.handleMeasurement();
        if (process.env.NODE_ENV === 'development') {
            // We need to defer the calculation in development so the
            // styles have time to be injected.
            setTimeout(this.handleMeasurement, 0);
        }
    }
    componentDidUpdate(prevProps) {
        if (prevProps.tabs !== this.props.tabs) {
            this.handleMeasurement();
        }
    }
    render() {
        const { selected, tabs, activator, tabToFocus, siblingTabHasFocus, } = this.props;
        const tabsMarkup = tabs.map((tab, index) => {
            return (<Tab measuring key={`${index}${tab.id}Hidden`} id={`${tab.id}Measurer`} siblingTabHasFocus={siblingTabHasFocus} focused={index === tabToFocus} selected={index === selected} onClick={noop} url={tab.url}>
          {tab.content}
        </Tab>);
        });
        const classname = classNames(styles.Tabs, styles.TabMeasurer);
        return (<div className={classname} ref={this.containerNode}>
        <EventListener event="resize" handler={this.handleMeasurement}/>
        {tabsMarkup}
        {activator}
      </div>);
    }
}
function noop() { }
