import React from 'react';
import { classNames } from '../../../../utilities/css';
import styles from './Search.scss';
export class Search extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.node = React.createRef();
        this.handleDismiss = ({ target }) => {
            const { onDismiss } = this.props;
            if (onDismiss != null && target === this.node.current) {
                onDismiss();
            }
        };
    }
    render() {
        const { visible, children } = this.props;
        const searchClassName = classNames(styles.Search, visible && styles.visible);
        return (<div ref={this.node} className={searchClassName} onClick={this.handleDismiss}>
        <div className={styles.Overlay}>{children}</div>
      </div>);
    }
}
