import React from 'react';
import { closest } from '@shopify/javascript-utilities/dom';
import { focusFirstFocusableNode, findFirstFocusableNode, focusLastFocusableNode, } from '@shopify/javascript-utilities/focus';
import { write } from '@shopify/javascript-utilities/fastdom';
import { EventListener } from '../EventListener';
import { Focus } from '../Focus';
export class TrapFocus extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            shouldFocusSelf: undefined,
        };
        this.focusTrapWrapper = null;
        this.setFocusTrapWrapper = (node) => {
            this.focusTrapWrapper = node;
        };
        this.handleBlur = (event) => {
            const { relatedTarget } = event;
            const { focusTrapWrapper } = this;
            const { trapping = true } = this.props;
            if (relatedTarget == null || trapping === false) {
                return;
            }
            if (focusTrapWrapper &&
                !focusTrapWrapper.contains(relatedTarget) &&
                (!relatedTarget ||
                    !closest(relatedTarget, '[data-polaris-overlay]'))) {
                event.preventDefault();
                if (event.srcElement === findFirstFocusableNode(focusTrapWrapper)) {
                    return write(() => focusLastFocusableNode(focusTrapWrapper));
                }
                const firstNode = findFirstFocusableNode(focusTrapWrapper) || focusTrapWrapper;
                write(() => focusFirstFocusableNode(firstNode));
            }
        };
    }
    componentDidMount() {
        this.setState(this.handleTrappingChange());
    }
    handleTrappingChange() {
        const { trapping = true } = this.props;
        if (this.focusTrapWrapper &&
            this.focusTrapWrapper.contains(document.activeElement)) {
            return { shouldFocusSelf: false };
        }
        return { shouldFocusSelf: trapping };
    }
    render() {
        const { children } = this.props;
        return (<Focus disabled={this.shouldDisable()} root={this.focusTrapWrapper}>
        <div ref={this.setFocusTrapWrapper}>
          <EventListener event="focusout" handler={this.handleBlur}/>
          {children}
        </div>
      </Focus>);
    }
    shouldDisable() {
        const { trapping = true } = this.props;
        const { shouldFocusSelf } = this.state;
        if (shouldFocusSelf === undefined) {
            return true;
        }
        return shouldFocusSelf ? !trapping : !shouldFocusSelf;
    }
}
