import chalk from 'chalk';
export function toBeDisabled(received) {
    const pass = received.prop('disabled') === true;
    return {
        pass,
        message() {
            return pass
                ? chalk.green(`Expected component not to be disabled, but it was.`)
                : chalk.red(`Expected component to be disabled, but it wasn't.`);
        },
    };
}
