import { FOCUSABLE_SELECTOR } from '@shopify/javascript-utilities/focus';
import { isElementInViewport } from './is-element-in-viewport';
export function handleMouseUpByBlurring({ currentTarget, }) {
    currentTarget.blur();
}
export function nextFocusableNode(node, filter) {
    const allFocusableElements = [
        ...document.querySelectorAll(FOCUSABLE_SELECTOR),
    ];
    const sliceLocation = allFocusableElements.indexOf(node) + 1;
    const focusableElementsAfterNode = allFocusableElements.slice(sliceLocation);
    for (const focusableElement of focusableElementsAfterNode) {
        if (isElementInViewport(focusableElement) &&
            (!filter || (filter && filter(focusableElement)))) {
            return focusableElement;
        }
    }
    return null;
}
export function focusNextFocusableNode(node, filter) {
    const nextFocusable = nextFocusableNode(node, filter);
    if (nextFocusable && nextFocusable instanceof HTMLElement) {
        nextFocusable.focus();
        return true;
    }
    return false;
}
