import { get } from '../get';
import { merge } from '../merge';
const REPLACE_REGEX = /{([^}]*)}/g;
export class I18n {
    /**
     * @param translation A locale object or array of locale objects that overrides default translations. If specifying an array then your fallback language dictionaries should come first, followed by your primary language dictionary
     */
    constructor(translation) {
        this.translation = {};
        this.translation = Array.isArray(translation)
            ? merge(...translation)
            : translation;
    }
    translate(id, replacements) {
        const text = get(this.translation, id, '');
        if (!text) {
            return '';
        }
        if (replacements) {
            return text.replace(REPLACE_REGEX, (match) => {
                const replacement = match.substring(1, match.length - 1);
                if (!Object.prototype.hasOwnProperty.call(replacements, replacement)) {
                    const replacementKeys = Object.keys(replacements)
                        .map((key) => `'${key}'`)
                        .join(', ');
                    throw new Error(`No replacement found for key '${replacement}'. The following replacements were passed: ${replacementKeys}`);
                }
                // Bringing back an old bit of oddness to expedite a release.
                // {foo: undefined} is allowed in calling apps but won't trigger type
                // warnings and won't get caught in the above check so let it through
                // for now as JS can handle it ok. We should work out how to be
                // stricter, or deliberatly allow undefined as a value
                return replacements[replacement];
            });
        }
        return text;
    }
    translationKeyExists(path) {
        return Boolean(get(this.translation, path));
    }
}
