import React__default, { useContext, useState, useEffect, useCallback, useRef, createRef, useMemo, useLayoutEffect, useImperativeHandle, createContext, Component, memo, Fragment, createElement } from 'react';
import { __rest } from 'tslib';
import { CaretDownMinor, HorizontalDotsMinor, TickSmallMinor, AlertMinor, CaretUpMinor, CircleCancelMinor, CancelSmallMinor, CircleTickMajorTwotone, CircleInformationMajorTwotone, CircleAlertMajorTwotone, CircleDisabledMajorTwotone, FlagMajorTwotone, ChevronLeftMinor, MinusMinor, ChevronRightMinor, ArrowLeftMinor, ArrowRightMinor, DragDropMajorMonotone, CircleAlertMajorMonotone, SearchMinor, ChevronUpMinor, ChevronDownMinor, QuestionMarkMajorTwotone, MobileCancelMajorMonotone, ExternalSmallMinor, ArrowUpDownMinor, CalendarMinor, EnableSelectionMinor, MobileHamburgerMajorMonotone } from '@shopify/polaris-icons';
import { FOCUSABLE_SELECTOR, findFirstFocusableNode, focusFirstFocusableNode, focusLastFocusableNode } from '@shopify/javascript-utilities/focus';
import debounce from 'lodash/debounce';
import { addEventListener, removeEventListener } from '@shopify/javascript-utilities/events';
import { closest, nodeContainsDescendant } from '@shopify/javascript-utilities/dom';
import { getRectForNode, Rect } from '@shopify/javascript-utilities/geometry';
import tokens, { durationBase, durationSlow } from '@shopify/polaris-tokens';
import { createPortal } from 'react-dom';
import { createUniqueIDFactory } from '@shopify/javascript-utilities/other';
import { hsluvToHex, hexToHsluv } from 'hsluv';
import { clamp as clamp$1 } from '@shopify/javascript-utilities/math';
import { write, read } from '@shopify/javascript-utilities/fastdom';
import createApp, { getShopOrigin, LifecycleHook } from '@shopify/app-bridge';
import isEqual from 'lodash/isEqual';
import hoistStatics from 'hoist-non-react-statics';
import { isSameDay, Months, Weekdays, getWeeksForMonth, isDateBefore, isDateAfter, dateIsSelected, dateIsInRange, getNewRange, getNextDisplayYear, getNextDisplayMonth, getPreviousDisplayYear, getPreviousDisplayMonth } from '@shopify/javascript-utilities/dates';
export { Months } from '@shopify/javascript-utilities/dates';
import { CSSTransition, TransitionGroup, Transition } from '@material-ui/react-transition-group';
import { Redirect, ButtonGroup as ButtonGroup$1, Button as Button$1, Modal as Modal$2, Loading as Loading$2, TitleBar, ResourcePicker as ResourcePicker$2, Toast as Toast$2 } from '@shopify/app-bridge/actions';

if (typeof window !== 'undefined') {
  window.Polaris = window.Polaris || {};
  window.Polaris.VERSION = '4.10.2';
}

var polarisVersion = '4.10.2';

var Key;

(function (Key) {
  Key[Key["Backspace"] = 8] = "Backspace";
  Key[Key["Tab"] = 9] = "Tab";
  Key[Key["Enter"] = 13] = "Enter";
  Key[Key["Shift"] = 16] = "Shift";
  Key[Key["Ctrl"] = 17] = "Ctrl";
  Key[Key["Alt"] = 18] = "Alt";
  Key[Key["Pause"] = 19] = "Pause";
  Key[Key["CapsLock"] = 20] = "CapsLock";
  Key[Key["Escape"] = 27] = "Escape";
  Key[Key["Space"] = 32] = "Space";
  Key[Key["PageUp"] = 33] = "PageUp";
  Key[Key["PageDown"] = 34] = "PageDown";
  Key[Key["End"] = 35] = "End";
  Key[Key["Home"] = 36] = "Home";
  Key[Key["LeftArrow"] = 37] = "LeftArrow";
  Key[Key["UpArrow"] = 38] = "UpArrow";
  Key[Key["RightArrow"] = 39] = "RightArrow";
  Key[Key["DownArrow"] = 40] = "DownArrow";
  Key[Key["Insert"] = 45] = "Insert";
  Key[Key["Delete"] = 46] = "Delete";
  Key[Key["Key0"] = 48] = "Key0";
  Key[Key["Key1"] = 49] = "Key1";
  Key[Key["Key2"] = 50] = "Key2";
  Key[Key["Key3"] = 51] = "Key3";
  Key[Key["Key4"] = 52] = "Key4";
  Key[Key["Key5"] = 53] = "Key5";
  Key[Key["Key6"] = 54] = "Key6";
  Key[Key["Key7"] = 55] = "Key7";
  Key[Key["Key8"] = 56] = "Key8";
  Key[Key["Key9"] = 57] = "Key9";
  Key[Key["KeyA"] = 65] = "KeyA";
  Key[Key["KeyB"] = 66] = "KeyB";
  Key[Key["KeyC"] = 67] = "KeyC";
  Key[Key["KeyD"] = 68] = "KeyD";
  Key[Key["KeyE"] = 69] = "KeyE";
  Key[Key["KeyF"] = 70] = "KeyF";
  Key[Key["KeyG"] = 71] = "KeyG";
  Key[Key["KeyH"] = 72] = "KeyH";
  Key[Key["KeyI"] = 73] = "KeyI";
  Key[Key["KeyJ"] = 74] = "KeyJ";
  Key[Key["KeyK"] = 75] = "KeyK";
  Key[Key["KeyL"] = 76] = "KeyL";
  Key[Key["KeyM"] = 77] = "KeyM";
  Key[Key["KeyN"] = 78] = "KeyN";
  Key[Key["KeyO"] = 79] = "KeyO";
  Key[Key["KeyP"] = 80] = "KeyP";
  Key[Key["KeyQ"] = 81] = "KeyQ";
  Key[Key["KeyR"] = 82] = "KeyR";
  Key[Key["KeyS"] = 83] = "KeyS";
  Key[Key["KeyT"] = 84] = "KeyT";
  Key[Key["KeyU"] = 85] = "KeyU";
  Key[Key["KeyV"] = 86] = "KeyV";
  Key[Key["KeyW"] = 87] = "KeyW";
  Key[Key["KeyX"] = 88] = "KeyX";
  Key[Key["KeyY"] = 89] = "KeyY";
  Key[Key["KeyZ"] = 90] = "KeyZ";
  Key[Key["LeftMeta"] = 91] = "LeftMeta";
  Key[Key["RightMeta"] = 92] = "RightMeta";
  Key[Key["Select"] = 93] = "Select";
  Key[Key["Numpad0"] = 96] = "Numpad0";
  Key[Key["Numpad1"] = 97] = "Numpad1";
  Key[Key["Numpad2"] = 98] = "Numpad2";
  Key[Key["Numpad3"] = 99] = "Numpad3";
  Key[Key["Numpad4"] = 100] = "Numpad4";
  Key[Key["Numpad5"] = 101] = "Numpad5";
  Key[Key["Numpad6"] = 102] = "Numpad6";
  Key[Key["Numpad7"] = 103] = "Numpad7";
  Key[Key["Numpad8"] = 104] = "Numpad8";
  Key[Key["Numpad9"] = 105] = "Numpad9";
  Key[Key["Multiply"] = 106] = "Multiply";
  Key[Key["Add"] = 107] = "Add";
  Key[Key["Subtract"] = 109] = "Subtract";
  Key[Key["Decimal"] = 110] = "Decimal";
  Key[Key["Divide"] = 111] = "Divide";
  Key[Key["F1"] = 112] = "F1";
  Key[Key["F2"] = 113] = "F2";
  Key[Key["F3"] = 114] = "F3";
  Key[Key["F4"] = 115] = "F4";
  Key[Key["F5"] = 116] = "F5";
  Key[Key["F6"] = 117] = "F6";
  Key[Key["F7"] = 118] = "F7";
  Key[Key["F8"] = 119] = "F8";
  Key[Key["F9"] = 120] = "F9";
  Key[Key["F10"] = 121] = "F10";
  Key[Key["F11"] = 122] = "F11";
  Key[Key["F12"] = 123] = "F12";
  Key[Key["NumLock"] = 144] = "NumLock";
  Key[Key["ScrollLock"] = 145] = "ScrollLock";
  Key[Key["Semicolon"] = 186] = "Semicolon";
  Key[Key["Equals"] = 187] = "Equals";
  Key[Key["Comma"] = 188] = "Comma";
  Key[Key["Dash"] = 189] = "Dash";
  Key[Key["Period"] = 190] = "Period";
  Key[Key["ForwardSlash"] = 191] = "ForwardSlash";
  Key[Key["GraveAccent"] = 192] = "GraveAccent";
  Key[Key["OpenBracket"] = 219] = "OpenBracket";
  Key[Key["BackSlash"] = 220] = "BackSlash";
  Key[Key["CloseBracket"] = 221] = "CloseBracket";
  Key[Key["SingleQuote"] = 222] = "SingleQuote";
})(Key || (Key = {}));

var TypeOf;

(function (TypeOf) {
  TypeOf["Undefined"] = "undefined";
  TypeOf["Object"] = "object";
  TypeOf["Boolean"] = "boolean";
  TypeOf["Number"] = "number";
  TypeOf["String"] = "string";
  TypeOf["Symbol"] = "symbol";
  TypeOf["Function"] = "function";
})(TypeOf || (TypeOf = {}));

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _construct(Parent, args, Class) {
  if (isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }

  return _construct.apply(null, arguments);
}

function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}

function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? new Map() : undefined;

  _wrapNativeSuper = function _wrapNativeSuper(Class) {
    if (Class === null || !_isNativeFunction(Class)) return Class;

    if (typeof Class !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }

    if (typeof _cache !== "undefined") {
      if (_cache.has(Class)) return _cache.get(Class);

      _cache.set(Class, Wrapper);
    }

    function Wrapper() {
      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
    }

    Wrapper.prototype = Object.create(Class.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class);
  };

  return _wrapNativeSuper(Class);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
    return;
  }

  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

function classNames() {
  for (var _len = arguments.length, classes = new Array(_len), _key = 0; _key < _len; _key++) {
    classes[_key] = arguments[_key];
  }

  return classes.filter(Boolean).join(' ');
}
function variationName(name, value) {
  return "".concat(name).concat(value.charAt(0).toUpperCase()).concat(value.slice(1));
}

var FeaturesContext = React__default.createContext(undefined);

function useFeatures() {
  var features = useContext(FeaturesContext);

  if (!features) {
    throw new Error('No Features were provided.');
  }

  return features;
}

var I18nContext = React__default.createContext(undefined);

var MissingAppProviderError =
/*#__PURE__*/
function (_Error) {
  _inherits(MissingAppProviderError, _Error);

  function MissingAppProviderError() {
    var _this;

    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

    _classCallCheck(this, MissingAppProviderError);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(MissingAppProviderError).call(this, "".concat(message ? "".concat(message, " ") : message, "Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/structure/app-provider for implementation instructions.")));
    _this.name = 'MissingAppProviderError';
    return _this;
  }

  return MissingAppProviderError;
}(_wrapNativeSuper(Error));

function useI18n() {
  var i18n = useContext(I18nContext);

  if (!i18n) {
    throw new MissingAppProviderError('No i18n was provided.');
  }

  return i18n;
}

var OBJECT_NOTATION_MATCHER = /\[(.*?)\]|(\w+)/g;
function get(obj, keypath, defaultValue) {
  if (obj == null) return undefined;
  var keys = Array.isArray(keypath) ? keypath : getKeypath(keypath);
  var acc = obj; // eslint-disable-next-line @typescript-eslint/prefer-for-of

  for (var i = 0; i < keys.length; i++) {
    var val = acc[keys[i]];
    if (val === undefined) return defaultValue;
    acc = val;
  }

  return acc;
}

function getKeypath(str) {
  var path = [];
  var result;

  while (result = OBJECT_NOTATION_MATCHER.exec(str)) {
    var _result = result,
        _result2 = _slicedToArray(_result, 3),
        first = _result2[1],
        second = _result2[2];

    path.push(first || second);
  }

  return path;
}

function merge() {
  var final = {};

  for (var _len = arguments.length, objs = new Array(_len), _key = 0; _key < _len; _key++) {
    objs[_key] = arguments[_key];
  }

  for (var _i = 0, _objs = objs; _i < _objs.length; _i++) {
    var obj = _objs[_i];
    final = mergeRecursively(final, obj);
  }

  return final;
}

function mergeRecursively(inputObjA, objB) {
  var objA = Array.isArray(inputObjA) ? _toConsumableArray(inputObjA) : Object.assign({}, inputObjA);

  for (var key in objB) {
    if (!Object.prototype.hasOwnProperty.call(objB, key)) {
      continue;
    } else if (isMergeableValue(objB[key]) && isMergeableValue(objA[key])) {
      objA[key] = mergeRecursively(objA[key], objB[key]);
    } else {
      objA[key] = objB[key];
    }
  }

  return objA;
}

function isMergeableValue(value) {
  return value !== null && typeof value === 'object';
}

var REPLACE_REGEX = /{([^}]*)}/g;
var I18n =
/*#__PURE__*/
function () {
  /**
   * @param translation A locale object or array of locale objects that overrides default translations. If specifying an array then your fallback language dictionaries should come first, followed by your primary language dictionary
   */
  function I18n(translation) {
    _classCallCheck(this, I18n);

    this.translation = {};
    this.translation = Array.isArray(translation) ? merge.apply(void 0, _toConsumableArray(translation)) : translation;
  }

  _createClass(I18n, [{
    key: "translate",
    value: function translate(id, replacements) {
      var text = get(this.translation, id, '');

      if (!text) {
        return '';
      }

      if (replacements) {
        return text.replace(REPLACE_REGEX, function (match) {
          var replacement = match.substring(1, match.length - 1);

          if (!Object.prototype.hasOwnProperty.call(replacements, replacement)) {
            var replacementKeys = Object.keys(replacements).map(function (key) {
              return "'".concat(key, "'");
            }).join(', ');
            throw new Error("No replacement found for key '".concat(replacement, "'. The following replacements were passed: ").concat(replacementKeys));
          } // Bringing back an old bit of oddness to expedite a release.
          // {foo: undefined} is allowed in calling apps but won't trigger type
          // warnings and won't get caught in the above check so let it through
          // for now as JS can handle it ok. We should work out how to be
          // stricter, or deliberatly allow undefined as a value


          return replacements[replacement];
        });
      }

      return text;
    }
  }, {
    key: "translationKeyExists",
    value: function translationKeyExists(path) {
      return Boolean(get(this.translation, path));
    }
  }]);

  return I18n;
}();

var isServer = typeof window === 'undefined' || typeof document === 'undefined';

function Image(_a) {
  var sourceSet = _a.sourceSet,
      source = _a.source,
      crossOrigin = _a.crossOrigin,
      rest = __rest(_a, ["sourceSet", "source", "crossOrigin"]);

  var finalSourceSet = sourceSet ? sourceSet.map(function (_ref) {
    var subSource = _ref.source,
        descriptor = _ref.descriptor;
    return "".concat(subSource, " ").concat(descriptor);
  }).join(',') : null;
  return finalSourceSet ? // eslint-disable-next-line jsx-a11y/alt-text
  React__default.createElement("img", Object.assign({
    src: source,
    srcSet: finalSourceSet,
    crossOrigin: crossOrigin
  }, rest)) : // eslint-disable-next-line jsx-a11y/alt-text
  React__default.createElement("img", Object.assign({
    src: source
  }, rest, {
    crossOrigin: crossOrigin
  }));
}

var styles = {
  "Avatar": "Polaris-Avatar",
  "hidden": "Polaris-Avatar--hidden",
  "sizeSmall": "Polaris-Avatar--sizeSmall",
  "sizeMedium": "Polaris-Avatar--sizeMedium",
  "sizeLarge": "Polaris-Avatar--sizeLarge",
  "styleOne": "Polaris-Avatar--styleOne",
  "styleTwo": "Polaris-Avatar--styleTwo",
  "styleThree": "Polaris-Avatar--styleThree",
  "styleFour": "Polaris-Avatar--styleFour",
  "styleFive": "Polaris-Avatar--styleFive",
  "styleSix": "Polaris-Avatar--styleSix",
  "hasImage": "Polaris-Avatar--hasImage",
  "Image": "Polaris-Avatar__Image",
  "Initials": "Polaris-Avatar__Initials",
  "Svg": "Polaris-Avatar__Svg"
};

var avatar1 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjMjQ1YjQ4IiBkPSJNMCAwaDEwMHYxMDBIMHoiLz48cGF0aCBmaWxsPSIjMmRiMTY3IiBkPSJNNjkgMHY2NS42NWwtMi0uMDF2MTkuODVsMiAuMDJWMTAwSDBWMGg2OXoiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJNNjcgNjUuNjR2MTkuODVsLTI1LjU3LS4xOUMzMiA4NS4yMiAyNS42IDgxLjQ2IDI1LjY4IDcyLjA2cy4yNS02Ljc0LjI1LTYuNzR6Ii8+PHBhdGggZmlsbD0iIzhkYzk1OCIgZD0iTTg2Ljk5IDU4SDY5VjBoMTAuOTNsNy4wNiA1OHoiLz48cGF0aCBmaWxsPSIjZWJlZGYxIiBkPSJNMjQuNTMgNDAuMjlhMTIuMjMgMTIuMjMgMCAwMTI0LjQ2IDAiIG9wYWNpdHk9Ii4yIi8+PHBhdGggZmlsbD0iIzhkYzk1OCIgZD0iTTU5LjYyIDU4QTEwLjY5IDEwLjY5IDAgMDE4MSA1OHoiLz48L3N2Zz4K';

var avatar2 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjMWUyNjVjIiBkPSJNLS4wMSAwaDEwMHYxMDBoLTEwMHoiLz48cGF0aCBmaWxsPSIjNWQ2Y2MxIiBkPSJNLS4wMSAwaDY5LjAydjEwMEgtLjAxeiIvPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik02OC45MyA2NS44OGwtMjQuNDQtLjE5LS4wNSA2LjA5YzAgNS4yMiAzLjQ4IDkuNDcgOC42OSA5LjUybDE1LjguMTJ6Ii8+PHBhdGggZmlsbD0iI2ZmYzA0ZCIgZD0iTTY4LjkxIDExLjNsMTkuMTcgNDYuMjktMTkuMTctLjE2VjExLjN6Ii8+PHBhdGggZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjZmZmIiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiIGQ9Ik0yMy4yNSAzNi40M2EzLjIyIDMuMjIgMCAxMDAgNi40NG0yMS4wMS02LjQ0YTMuMjIgMy4yMiAwIDAwMCA2LjQ0bS0xMy41NSAzLjc0YTMuMjIgMy4yMiAwIDEwMCA2LjQ0bTMuMjItMjUuNTFhMy4yMiAzLjIyIDAgMDAwIDYuNDQiLz48L3N2Zz4K';

var avatar3 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjNWQ2Y2MxIiBkPSJNLS4wMiAwaDEwMHYxMDBoLTEwMHoiLz48cGF0aCBmaWxsPSIjNmRjYWNlIiBkPSJNLjM5IDBoNjkuMDJ2MTAwSC4zOXoiLz48cGF0aCBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiIGQ9Ik0yNC4xOCAzMS4yMXYzLjQ3QTEwLjQzIDEwLjQzIDAgMDAzNC40IDQ1LjIxYTEwLjQzIDEwLjQzIDAgMDAxMC4yMi0xMC41M3YtMy40NyIvPjxwYXRoIGZpbGw9IiNlYmVkZjEiIGQ9Ik0yMC4xMSA0OS4wN2ExNi4yMiAxNi4yMiAwIDExMCAzMi40NCIgb3BhY2l0eT0iLjIiLz48cGF0aCBkPSJNNjkuNDQgMTguODNMOTAgNzFINjkuNDRWMTguODN6IiBmaWxsPSIjZmZmIi8+PHBhdGggZD0iTTU3LjU5IDcxYTYgNiAwIDAxMTIgMHoiIGZpbGw9IiNmZmYiLz48L3N2Zz4K';

var avatar4 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjZmZlMGMzIiBkPSJNMC0uMDFoMTAwdjEwMEgweiIvPjxwYXRoIGZpbGw9IiM1ZDZjYzEiIGQ9Ik0wIDBoNjkuMDJ2MTAwSDB6Ii8+PHBhdGggZD0iTTY5LjAyIDBsMjQuMDMgNjEuNjlINjkuMDJWMHoiIGZpbGw9IiNmZjk2N2QiLz48cGF0aCBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiIGQ9Ik0zMC42OSAzMS45MXYtM2MwLTQuNzggMy40Ni04LjY1IDgtOC42NXM4IDMuODcgOCA4LjY1djMiLz48cGF0aCBmaWxsPSIjZWJlZGYxIiBkPSJNMTIuNzYgNTYuMDZhMTMuMzYgMTMuMzYgMCAxMTI2LjcyIDAiIG9wYWNpdHk9Ii4yIi8+PHBhdGggZD0iTTgwIDYxLjQ2bC0yOS4zNC4yM3YtNy4zM2MwLTYuMjggNC4wNy0xMS4zNiAxMC4zNC0xMS40NGwxOS0uMTR6IiBmaWxsPSIjZmY5NjdkIi8+PC9zdmc+Cg==';

var avatar5 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjOGRjOTU4IiBkPSJNMCAwaDcwLjAydjEwMEgweiIvPjxwYXRoIGQ9Ik02OS45MiAwdjU2LjMyTDQ5IDY3bC0uMyAyNS4wN1YxMDBIMTAwVjB6IiBmaWxsPSIjMmRiMTY3Ii8+PHBhdGggZmlsbD0iIzI0NWI0OCIgZD0iTTU5LjI3IDU4LjI5YTUuMjIgNS4yMiAwIDAwLTkuNDMgNC40OCIvPjxwYXRoIGQ9Ik0yNy4xMiA5LjMzaDQ0LjUzdjIuMTlIMjcuMTJ6bS0xMi40MSA5LjQ5aDU2Ljk0djIuMTlIMTQuNzF6IiBmaWxsPSIjMmRiMTY3Ii8+PGNpcmNsZSBjeD0iMTkuNjYiIGN5PSI0NC44IiByPSIxMS4yMiIgZmlsbD0iI2ViZWRmMSIgb3BhY2l0eT0iLjIiLz48L3N2Zz4K';

var avatar6 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBkPSJNLS4wMi0uMDFoMTAwdjEwMGgtMTAweiIgZmlsbD0iI2ZmZTBjMyIvPjxwYXRoIGZpbGw9IiNmZjk2N2QiIGQ9Ik0wIDBoNjkuNDF2MTAwSDB6Ii8+PHBhdGggZD0iTTY5LjkyIDB2NDQuMzJMNTEuMzQgNTV2NDVIMTAwVjB6IiBmaWxsPSIjZmZlMGMzIi8+PHBhdGggZmlsbD0iIzMyY2FjNiIgZD0iTTM5LjMyIDc2YTExLjg1IDExLjg1IDAgMDAxMiAxMS42MlY3NiIvPjxwYXRoIGZpbGw9IiMwMDk3OTYiIGQ9Ik0zOS4zMiA3NmExMiAxMiAwIDAxMTItMTEuODJWNzYiLz48cGF0aCBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiIGQ9Ik00My43NCAxOS44M2ExMi44MiAxMi44MiAwIDExLTI1LjY0IDAiLz48cGF0aCBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjQiIGQ9Ik0yNy4zOSAzMS42bC0xLjU4IDUuOTZtOS4zNy01LjcybDIuNTUgNS40N200LjI2LTkuODVsMy41MyA0LjVtLTI1LjQzLTQuNWwtMy41MyA0LjUiLz48L3N2Zz4K';

var avatar7 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBkPSJNMCAwaDEwMHYxMDAuNDhIMHoiIGZpbGw9IiM4ZGM5NTgiLz48cGF0aCBmaWxsPSIjMmRiMTY3IiBkPSJNODMgNjh2MzJsLTE0LS4xNnYuMTZIMFYwaDY5djY4aDE0eiIvPjxwYXRoIGQ9Ik02OS4yOSA0MS42OUgyMC42NnMtLjA5LTMtLjE3IDcuMTUgNyAxOC41MSAxNy4zNSAxOC41OWwzMS40NS41N3oiIGZpbGw9IiM4ZGM5NTgiLz48cGF0aCBkPSJNNjguNyAxMi40bDExLjU0IDI5LjI5SDY4LjdWMTIuNHoiIGZpbGw9IiNmZmYiLz48cGF0aCBkPSJNNjIuMjIgNDEuNjlhMy4zNCAzLjM0IDAgMTE2LjY5IDB6IiBmaWxsPSIjZmZmIi8+PHBhdGggZmlsbD0iIzI0NWI0OCIgZD0iTTQxLjQ1IDE4LjA2YTIuNTcgMi41NyAwIDAwLTUuMTQgME0zMy4zMyAyNGEyLjU3IDIuNTcgMCAxMC01LjE0IDBtMjAuMzYgMi41OGEyLjU3IDIuNTcgMCAxMC01LjE0IDAiLz48L3N2Zz4K';

var avatar8 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBmaWxsPSIjZmZlZGI5IiBkPSJNMCAwaDEwMHYxMDBIMHoiLz48cGF0aCBkPSJNNjQuNjMgMTcuMzNhMTcgMTcgMCAwMTUgMjkuNzIgMTYuNzUgMTYuNzUgMCAwMS01IDIuNjIiIGZpbGw9Im5vbmUiIHN0cm9rZT0iI2ZmZiIgc3Ryb2tlLW1pdGVybGltaXQ9IjEwIiBzdHJva2Utd2lkdGg9IjUiLz48cGF0aCBmaWxsPSIjZmZjMDRkIiBkPSJNMCAwaDY5LjAydjEwMEgweiIvPjxjaXJjbGUgY3g9IjQ1LjExIiBjeT0iMzMuNDkiIHI9IjE2Ljk4IiBmaWxsPSJub25lIiBzdHJva2U9IiNmZmYiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIgc3Ryb2tlLXdpZHRoPSI1IiB0cmFuc2Zvcm09InJvdGF0ZSgtMzcuMDIgNDUuMTI0IDMzLjQ5MykiLz48cGF0aCBmaWxsPSIjNWQ2Y2MxIiBkPSJNNjkuMDIgMzQuNDhsMTkuNDcgMzguNzQtMTkuNDcgMS41M1YzNC40OHoiLz48cGF0aCBkPSJNNjEuNiAzMy42N2ExMC4xNyAxMC4xNyAwIDAxMTUuNC4wOCIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjZmZmIiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiIHN0cm9rZS13aWR0aD0iNSIvPjwvc3ZnPgo=';

var avatar9 = 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48cGF0aCBkPSJNMCAwaDEwMHYxMDBIMHoiIGZpbGw9IiNmZmMwNGQiLz48cGF0aCBkPSJNMCAwaDY5LjQxdjEwMEgweiIgZmlsbD0iIzVkNmNjMSIvPjxwYXRoIGQ9Ik03MC4yMSA4MC44OGgtMTUuMWMtNC44MSAwLTUuNjgtNS44NC01LjY4LTUuODRoMjAuNzgiIGZpbGw9IiNmZmMwNGQiLz48cGF0aCBkPSJNODIgNjAuNDhsLTE0IC4yNVYwaDEwLjE3QzgwLjU5IDIwLjE0IDgyIDYwLjQ4IDgyIDYwLjQ4eiIgZmlsbD0iIzVkNmNjMSIvPjxwYXRoIGZpbGw9IiM0MTIzNmUiIGQ9Ik01Ny43MSA2MC40OGE1LjQ0IDUuNDQgMCAxMTEwLjg3IDAiLz48Y2lyY2xlIGN4PSIyNC43NyIgY3k9IjQwLjE5IiByPSIxMS4yMiIgZmlsbD0iI2ViZWRmMSIgb3BhY2l0eT0iLjIiLz48L3N2Zz4K';



var avatars = /*#__PURE__*/Object.freeze({
  avatarOne: avatar1,
  avatarTwo: avatar2,
  avatarThree: avatar3,
  avatarFour: avatar4,
  avatarFive: avatar5,
  avatarSix: avatar6,
  avatarSeven: avatar7,
  avatarEight: avatar8,
  avatarNine: avatar9
});

var Status;

(function (Status) {
  Status["Pending"] = "PENDING";
  Status["Loaded"] = "LOADED";
  Status["Errored"] = "ERRORED";
})(Status || (Status = {}));

var STYLE_CLASSES = ['one', 'two', 'three', 'four', 'five'];
var AVATAR_IMAGES = Object.keys(avatars).map( // import/namespace does not allow computed values by default
// eslint-disable-next-line import/namespace
function (key) {
  return avatars[key];
});
function Avatar(_ref) {
  var name = _ref.name,
      source = _ref.source,
      initials = _ref.initials,
      customer = _ref.customer,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size,
      accessibilityLabel = _ref.accessibilityLabel;
  var i18n = useI18n();

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  function styleClass(name) {
    var finalStyleClasses = unstableGlobalTheming ? STYLE_CLASSES : [].concat(STYLE_CLASSES, ['six']);
    return name ? finalStyleClasses[name.charCodeAt(0) % finalStyleClasses.length] : finalStyleClasses[0];
  }

  var _useState = useState(Status.Pending),
      _useState2 = _slicedToArray(_useState, 2),
      status = _useState2[0],
      setStatus = _useState2[1]; // If the source changes, set the status back to pending


  useEffect(function () {
    setStatus(Status.Pending);
  }, [source]);
  var handleError = useCallback(function () {
    setStatus(Status.Errored);
  }, []);
  var handleLoad = useCallback(function () {
    setStatus(Status.Loaded);
  }, []);
  var hasImage = (source || customer) && status !== Status.Errored;
  var nameString = name || initials;
  var finalSource;
  var label;

  if (accessibilityLabel) {
    label = accessibilityLabel;
  } else if (name) {
    label = name;
  } else if (initials) {
    var splitInitials = initials.split('').join(' ');
    label = i18n.translate('Polaris.Avatar.labelWithInitials', {
      initials: splitInitials
    });
  } else {
    label = i18n.translate('Polaris.Avatar.label');
  }

  if (source) {
    finalSource = source;
  } else if (customer) {
    finalSource = customerPlaceholder(nameString);
  }

  var className = classNames(styles.Avatar, styles[variationName('style', styleClass(nameString))], size && styles[variationName('size', size)], hasImage && status !== Status.Loaded && styles.hidden, hasImage && styles.hasImage);
  var imageMarkUp = finalSource && !isServer && status !== Status.Errored ? React__default.createElement(Image, {
    className: styles.Image,
    source: finalSource,
    alt: "",
    role: "presentation",
    onLoad: handleLoad,
    onError: handleError
  }) : null; // Use `dominant-baseline: central` instead of `dy` when Edge supports it.

  var verticalOffset = '0.35em';
  var initialsMarkup = initials && !hasImage ? React__default.createElement("span", {
    className: styles.Initials
  }, React__default.createElement("svg", {
    className: styles.Svg,
    viewBox: "0 0 48 48"
  }, React__default.createElement("text", {
    x: "50%",
    y: "50%",
    dy: verticalOffset,
    fill: "currentColor",
    fontSize: "26",
    textAnchor: "middle"
  }, initials))) : null;
  return React__default.createElement("span", {
    "aria-label": label,
    role: "img",
    className: className
  }, initialsMarkup, imageMarkUp);
}

function customerPlaceholder(name) {
  return name ? AVATAR_IMAGES[name.charCodeAt(0) % AVATAR_IMAGES.length] : AVATAR_IMAGES[0];
}

function isElementInViewport(element) {
  var _element$getBoundingC = element.getBoundingClientRect(),
      top = _element$getBoundingC.top,
      left = _element$getBoundingC.left,
      bottom = _element$getBoundingC.bottom,
      right = _element$getBoundingC.right;

  return top >= 0 && right <= window.innerWidth && bottom <= window.innerHeight && left >= 0;
}

function handleMouseUpByBlurring(_ref) {
  var currentTarget = _ref.currentTarget;
  currentTarget.blur();
}
function nextFocusableNode(node, filter) {
  var allFocusableElements = _toConsumableArray(document.querySelectorAll(FOCUSABLE_SELECTOR));

  var sliceLocation = allFocusableElements.indexOf(node) + 1;
  var focusableElementsAfterNode = allFocusableElements.slice(sliceLocation);
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = focusableElementsAfterNode[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var focusableElement = _step.value;

      if (isElementInViewport(focusableElement) && (!filter || filter && filter(focusableElement))) {
        return focusableElement;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return null;
}
function focusNextFocusableNode(node, filter) {
  var nextFocusable = nextFocusableNode(node, filter);

  if (nextFocusable && nextFocusable instanceof HTMLElement) {
    nextFocusable.focus();
    return true;
  }

  return false;
}

var scrollable = {
  props: {
    'data-polaris-scrollable': true
  },
  selector: '[data-polaris-scrollable]'
};
var overlay = {
  props: {
    'data-polaris-overlay': true
  },
  selector: '[data-polaris-overlay]'
};
var layer = {
  props: {
    'data-polaris-layer': true
  },
  selector: '[data-polaris-layer]'
};
var unstyled = {
  props: {
    'data-polaris-unstyled': true
  },
  selector: '[data-polaris-unstyled]'
};
var dataPolarisTopBar = {
  props: {
    'data-polaris-top-bar': true
  },
  selector: '[data-polaris-top-bar]'
};
var headerCell = {
  props: {
    'data-polaris-header-cell': true
  },
  selector: '[data-polaris-header-cell]'
};
var portal = {
  props: ['data-portal-id'],
  selector: '[data-portal-id]'
};
var DATA_ATTRIBUTE = {
  overlay,
  layer
}; // these match our values in duration.scss

var Duration;

(function (Duration) {
  Duration[Duration["Instant"] = 0] = "Instant";
  Duration[Duration["Fast"] = 100] = "Fast";
  Duration[Duration["Base"] = 200] = "Base";
  Duration[Duration["Slow"] = 300] = "Slow";
  Duration[Duration["Slower"] = 400] = "Slower";
  Duration[Duration["Slowest"] = 500] = "Slowest";
})(Duration || (Duration = {}));

var LinkContext = React__default.createContext(undefined);

function useLink() {
  return React__default.useContext(LinkContext);
}

// https://github.com/facebook/react/issues/16722
// but eslint-plugin-react doesn't know that just yet
// eslint-disable-next-line react/display-name

var UnstyledLink = React__default.memo(React__default.forwardRef(function UnstyledLink(props, _ref) {
  var LinkComponent = useLink();

  if (LinkComponent) {
    return React__default.createElement(LinkComponent, Object.assign({}, unstyled.props, props));
  }

  var external = props.external,
      url = props.url,
      rest = __rest(props, ["external", "url"]);

  var target = external ? '_blank' : undefined;
  var rel = external ? 'noopener noreferrer' : undefined;
  return React__default.createElement("a", Object.assign({
    target: target
  }, rest, {
    href: url,
    rel: rel
  }, unstyled.props));
}));

var TelemetryContext = React__default.createContext(undefined);

function noop() {}

var defaultTelemetry = {
  produce: noop
};
function useTelemetry() {
  return React__default.useContext(TelemetryContext) || defaultTelemetry;
}

var styles$1 = {
  "Icon": "Polaris-Icon",
  "hasBackdrop": "Polaris-Icon--hasBackdrop",
  "isColored": "Polaris-Icon--isColored",
  "colorWhite": "Polaris-Icon--colorWhite",
  "colorBlack": "Polaris-Icon--colorBlack",
  "colorSkyLighter": "Polaris-Icon--colorSkyLighter",
  "colorSkyLight": "Polaris-Icon--colorSkyLight",
  "colorSky": "Polaris-Icon--colorSky",
  "colorSkyDark": "Polaris-Icon--colorSkyDark",
  "colorInkLightest": "Polaris-Icon--colorInkLightest",
  "colorInkLighter": "Polaris-Icon--colorInkLighter",
  "colorInkLight": "Polaris-Icon--colorInkLight",
  "colorInk": "Polaris-Icon--colorInk",
  "colorBlueLighter": "Polaris-Icon--colorBlueLighter",
  "colorBlueLight": "Polaris-Icon--colorBlueLight",
  "colorBlue": "Polaris-Icon--colorBlue",
  "colorBlueDark": "Polaris-Icon--colorBlueDark",
  "colorBlueDarker": "Polaris-Icon--colorBlueDarker",
  "colorIndigoLighter": "Polaris-Icon--colorIndigoLighter",
  "colorIndigoLight": "Polaris-Icon--colorIndigoLight",
  "colorIndigo": "Polaris-Icon--colorIndigo",
  "colorIndigoDark": "Polaris-Icon--colorIndigoDark",
  "colorIndigoDarker": "Polaris-Icon--colorIndigoDarker",
  "colorTealLighter": "Polaris-Icon--colorTealLighter",
  "colorTealLight": "Polaris-Icon--colorTealLight",
  "colorTeal": "Polaris-Icon--colorTeal",
  "colorTealDark": "Polaris-Icon--colorTealDark",
  "colorTealDarker": "Polaris-Icon--colorTealDarker",
  "colorGreenLighter": "Polaris-Icon--colorGreenLighter",
  "colorGreen": "Polaris-Icon--colorGreen",
  "colorGreenDark": "Polaris-Icon--colorGreenDark",
  "colorYellowLighter": "Polaris-Icon--colorYellowLighter",
  "colorYellow": "Polaris-Icon--colorYellow",
  "colorYellowDark": "Polaris-Icon--colorYellowDark",
  "colorOrange": "Polaris-Icon--colorOrange",
  "colorOrangeDark": "Polaris-Icon--colorOrangeDark",
  "colorRedLighter": "Polaris-Icon--colorRedLighter",
  "colorRed": "Polaris-Icon--colorRed",
  "colorRedDark": "Polaris-Icon--colorRedDark",
  "colorPurple": "Polaris-Icon--colorPurple",
  "Svg": "Polaris-Icon__Svg",
  "Img": "Polaris-Icon__Img",
  "Placeholder": "Polaris-Icon__Placeholder"
};

var COLORS_WITH_BACKDROPS = ['teal', 'tealDark', 'greenDark', 'redDark', 'yellowDark', 'ink', 'inkLighter'];
function Icon(_ref) {
  var source = _ref.source,
      color = _ref.color,
      backdrop = _ref.backdrop,
      accessibilityLabel = _ref.accessibilityLabel;
  var i18n = useI18n();
  var telemetry = useTelemetry();
  useEffect(function () {
    telemetry.produce('polaris_icons_usage/1.0', {
      // eslint-disable-next-line @typescript-eslint/camelcase
      icon_source: parseSource(source)
    });
  }, [source, telemetry]);

  if (color && backdrop && !COLORS_WITH_BACKDROPS.includes(color)) {
    // eslint-disable-next-line no-console
    console.warn(i18n.translate('Polaris.Icon.backdropWarning', {
      color,
      colorsWithBackDrops: COLORS_WITH_BACKDROPS.join(', ')
    }));
  }

  var className = classNames(styles$1.Icon, color && styles$1[variationName('color', color)], color && color !== 'white' && styles$1.isColored, backdrop && styles$1.hasBackdrop);
  var contentMarkup;

  if (typeof source === 'function') {
    var SourceComponent = source;
    contentMarkup = React__default.createElement(SourceComponent, {
      className: styles$1.Svg,
      focusable: "false",
      "aria-hidden": "true"
    });
  } else if (source === 'placeholder') {
    contentMarkup = React__default.createElement("div", {
      className: styles$1.Placeholder
    });
  } else {
    contentMarkup = React__default.createElement("img", {
      className: styles$1.Img,
      src: "data:image/svg+xml;utf8,".concat(source),
      alt: "",
      "aria-hidden": "true"
    });
  }

  return React__default.createElement("span", {
    className: className,
    "aria-label": accessibilityLabel
  }, contentMarkup);
}

function parseSource(source) {
  if (typeof source === 'function') {
    return source.name;
  } else if (source === 'placeholder') {
    return source;
  }

  return 'custom icon string';
}

var styles$2 = {
  "VisuallyHidden": "Polaris-VisuallyHidden"
};

function VisuallyHidden(_ref) {
  var children = _ref.children;
  return React__default.createElement("span", {
    className: styles$2.VisuallyHidden
  }, children);
}

/**
 * useIsAfterInitialMount will trigger a re-render to provide
 * you with an updated value. Using this you enhance server-side
 * code that can only run on the client.
 * @returns MutableRefObject<T> - Returns a ref object with the
 * results from invoking initial value
 * @example
 * function ComponentExample({children}) {
 *  const isMounted = useIsAfterInitialMount();
 *  const content = isMounted ? children : null;
 *
 *  return <React.Fragment>{content}</React.Fragment>;
 * }
 */

function useIsAfterInitialMount() {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isAfterInitialMount = _useState2[0],
      setIsAfterInitialMount = _useState2[1];

  useEffect(function () {
    setIsAfterInitialMount(true);
  }, []);
  return isAfterInitialMount;
}

var styles$3 = {
  "Spinner": "Polaris-Spinner",
  "loading": "Polaris-Spinner--loading",
  "sizeSmall": "Polaris-Spinner--sizeSmall",
  "sizeLarge": "Polaris-Spinner--sizeLarge",
  "colorWhite": "Polaris-Spinner--colorWhite",
  "colorTeal": "Polaris-Spinner--colorTeal",
  "colorInkLightest": "Polaris-Spinner--colorInkLightest"
};

var spinnerLarge = 'data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSIwIDAgNDQgNDQiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTE1LjU0MiAxLjQ4N0EyMS41MDcgMjEuNTA3IDAgMDAuNSAyMmMwIDExLjg3NCA5LjYyNiAyMS41IDIxLjUgMjEuNSA5Ljg0NyAwIDE4LjM2NC02LjY3NSAyMC44MDktMTYuMDcyYTEuNSAxLjUgMCAwMC0yLjkwNC0uNzU2QzM3LjgwMyAzNC43NTUgMzAuNDczIDQwLjUgMjIgNDAuNSAxMS43ODMgNDAuNSAzLjUgMzIuMjE3IDMuNSAyMmMwLTguMTM3IDUuMy0xNS4yNDcgMTIuOTQyLTE3LjY1YTEuNSAxLjUgMCAxMC0uOS0yLjg2M3oiIGZpbGw9IiM5MTlFQUIiLz48L3N2Zz4K';

var spinnerSmall = 'data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSIwIDAgMjAgMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTcuMjI5IDEuMTczYTkuMjUgOS4yNSAwIDEwMTEuNjU1IDExLjQxMiAxLjI1IDEuMjUgMCAxMC0yLjQtLjY5OCA2Ljc1IDYuNzUgMCAxMS04LjUwNi04LjMyOSAxLjI1IDEuMjUgMCAxMC0uNzUtMi4zODV6IiBmaWxsPSIjOTE5RUFCIi8+PC9zdmc+Cg==';

var COLORS_FOR_LARGE_SPINNER = ['teal', 'inkLightest'];
function Spinner(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'large' : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'teal' : _ref$color,
      accessibilityLabel = _ref.accessibilityLabel,
      hasFocusableParent = _ref.hasFocusableParent;
  var i18n = useI18n();
  var isAfterInitialMount = useIsAfterInitialMount();

  if (size === 'large' && !COLORS_FOR_LARGE_SPINNER.includes(color)) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(i18n.translate('Polaris.Spinner.warningMessage', {
        color,
        size,
        colors: COLORS_FOR_LARGE_SPINNER.join(', ')
      }));
    } // eslint-disable-next-line no-param-reassign


    size = 'small';
  }

  var className = classNames(styles$3.Spinner, color && styles$3[variationName('color', color)], size && styles$3[variationName('size', size)]);
  var spinnerSVG = size === 'large' ? spinnerLarge : spinnerSmall;
  var spanAttributes = Object.assign({}, !hasFocusableParent && {
    role: 'status'
  });
  var accessibilityLabelMarkup = (isAfterInitialMount || !hasFocusableParent) && React__default.createElement(VisuallyHidden, null, accessibilityLabel);
  return React__default.createElement(React__default.Fragment, null, React__default.createElement(Image, {
    alt: "",
    source: spinnerSVG,
    className: className,
    draggable: false
  }), React__default.createElement("span", spanAttributes, accessibilityLabelMarkup));
}

var styles$4 = {
  "Button": "Polaris-Button",
  "globalTheming": "Polaris-Button--globalTheming",
  "disabled": "Polaris-Button--disabled",
  "Content": "Polaris-Button__Content",
  "textAlignLeft": "Polaris-Button--textAlignLeft",
  "textAlignCenter": "Polaris-Button--textAlignCenter",
  "textAlignRight": "Polaris-Button--textAlignRight",
  "Icon": "Polaris-Button__Icon",
  "Spinner": "Polaris-Button__Spinner",
  "primary": "Polaris-Button--primary",
  "pressed": "Polaris-Button--pressed",
  "destructive": "Polaris-Button--destructive",
  "outline": "Polaris-Button--outline",
  "loading": "Polaris-Button--loading",
  "plain": "Polaris-Button--plain",
  "iconOnly": "Polaris-Button--iconOnly",
  "fullWidth": "Polaris-Button--fullWidth",
  "sizeSlim": "Polaris-Button--sizeSlim",
  "sizeLarge": "Polaris-Button--sizeLarge",
  "monochrome": "Polaris-Button--monochrome",
  "Text": "Polaris-Button__Text",
  "DisclosureIcon": "Polaris-Button__DisclosureIcon",
  "DisclosureIconFacingUp": "Polaris-Button__DisclosureIconFacingUp"
};

var DEFAULT_SIZE = 'medium';
function Button(_ref) {
  var id = _ref.id,
      url = _ref.url,
      disabled = _ref.disabled,
      loading = _ref.loading,
      children = _ref.children,
      accessibilityLabel = _ref.accessibilityLabel,
      ariaControls = _ref.ariaControls,
      ariaExpanded = _ref.ariaExpanded,
      ariaPressed = _ref.ariaPressed,
      onClick = _ref.onClick,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      onKeyDown = _ref.onKeyDown,
      onKeyPress = _ref.onKeyPress,
      onKeyUp = _ref.onKeyUp,
      onMouseEnter = _ref.onMouseEnter,
      onTouchStart = _ref.onTouchStart,
      external = _ref.external,
      download = _ref.download,
      icon = _ref.icon,
      primary = _ref.primary,
      outline = _ref.outline,
      destructive = _ref.destructive,
      disclosure = _ref.disclosure,
      plain = _ref.plain,
      monochrome = _ref.monochrome,
      submit = _ref.submit,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? DEFAULT_SIZE : _ref$size,
      textAlign = _ref.textAlign,
      fullWidth = _ref.fullWidth,
      pressed = _ref.pressed;

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  var hasGivenDeprecationWarning = useRef(false);

  if (ariaPressed && !hasGivenDeprecationWarning.current) {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: The ariaPressed prop has been replaced with pressed');
    hasGivenDeprecationWarning.current = true;
  }

  var i18n = useI18n();
  var isDisabled = disabled || loading;
  var className = classNames(styles$4.Button, unstableGlobalTheming && styles$4.globalTheming, primary && styles$4.primary, outline && styles$4.outline, destructive && styles$4.destructive, isDisabled && styles$4.disabled, loading && styles$4.loading, plain && styles$4.plain, pressed && !disabled && !url && styles$4.pressed, monochrome && styles$4.monochrome, size && size !== DEFAULT_SIZE && styles$4[variationName('size', size)], textAlign && styles$4[variationName('textAlign', textAlign)], fullWidth && styles$4.fullWidth, icon && children == null && styles$4.iconOnly);
  var disclosureIcon = React__default.createElement(Icon, {
    source: loading ? 'placeholder' : CaretDownMinor
  });
  var disclosureIconMarkup = disclosure ? React__default.createElement(IconWrapper, null, React__default.createElement("div", {
    className: classNames(styles$4.DisclosureIcon, disclosure === 'up' && styles$4.DisclosureIconFacingUp)
  }, disclosureIcon)) : null;
  var iconMarkup;

  if (icon) {
    var iconInner = isIconSource(icon) ? React__default.createElement(Icon, {
      source: loading ? 'placeholder' : icon
    }) : icon;
    iconMarkup = React__default.createElement(IconWrapper, null, iconInner);
  }

  var childMarkup = children ? React__default.createElement("span", {
    className: styles$4.Text
  }, children) : null;
  var spinnerColor = primary || destructive ? 'white' : 'inkLightest';
  var spinnerSVGMarkup = loading ? React__default.createElement("span", {
    className: styles$4.Spinner
  }, React__default.createElement(Spinner, {
    size: "small",
    color: spinnerColor,
    accessibilityLabel: i18n.translate('Polaris.Button.spinnerAccessibilityLabel')
  })) : null;
  var content = iconMarkup || disclosureIconMarkup ? React__default.createElement("span", {
    className: styles$4.Content
  }, spinnerSVGMarkup, iconMarkup, childMarkup, disclosureIconMarkup) : React__default.createElement("span", {
    className: styles$4.Content
  }, spinnerSVGMarkup, childMarkup);
  var type = submit ? 'submit' : 'button';

  if (url) {
    return isDisabled ? // Render an `<a>` so toggling disabled/enabled state changes only the
    // `href` attribute instead of replacing the whole element.
    // eslint-disable-next-line jsx-a11y/anchor-is-valid
    React__default.createElement("a", {
      id: id,
      className: className,
      "aria-label": accessibilityLabel
    }, content) : React__default.createElement(UnstyledLink, {
      id: id,
      url: url,
      external: external,
      download: download,
      onClick: onClick,
      onFocus: onFocus,
      onBlur: onBlur,
      onMouseUp: handleMouseUpByBlurring,
      onMouseEnter: onMouseEnter,
      onTouchStart: onTouchStart,
      className: className,
      "aria-label": accessibilityLabel
    }, content);
  }

  var ariaPressedStatus = pressed !== undefined ? pressed : ariaPressed;
  return React__default.createElement("button", {
    id: id,
    type: type,
    onClick: onClick,
    onFocus: onFocus,
    onBlur: onBlur,
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp,
    onKeyPress: onKeyPress,
    onMouseUp: handleMouseUpByBlurring,
    onMouseEnter: onMouseEnter,
    onTouchStart: onTouchStart,
    className: className,
    disabled: isDisabled,
    "aria-label": accessibilityLabel,
    "aria-controls": ariaControls,
    "aria-expanded": ariaExpanded,
    "aria-pressed": ariaPressedStatus,
    role: loading ? 'alert' : undefined,
    "aria-busy": loading ? true : undefined
  }, content);
}
function IconWrapper(_ref2) {
  var children = _ref2.children;
  return React__default.createElement("span", {
    className: styles$4.Icon
  }, children);
}

function isIconSource(x) {
  return typeof x === 'string' || typeof x === 'object' && x.body || typeof x === 'function';
}

function buttonsFrom(actions) {
  var overrides = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (Array.isArray(actions)) {
    return actions.map(function (action, index) {
      return buttonFrom(action, overrides, index);
    });
  } else {
    var action = actions;
    return buttonFrom(action, overrides);
  }
}
function buttonFrom(_a, overrides, key) {
  var content = _a.content,
      onAction = _a.onAction,
      action = __rest(_a, ["content", "onAction"]);

  return React__default.createElement(Button, Object.assign({
    key: key,
    onClick: onAction
  }, action, overrides), content);
}

/**
 * Returns a stateful value, and a set of memoized functions to toggle it,
 * set it to true and set it to false
 */

function useToggle(initialState) {
  var _useState = useState(initialState),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setState = _useState2[1];

  return {
    value,
    toggle: useCallback(function () {
      return setState(function (state) {
        return !state;
      });
    }, []),
    setTrue: useCallback(function () {
      return setState(true);
    }, []),
    setFalse: useCallback(function () {
      return setState(false);
    }, [])
  };
}

var WithinContentContext = React__default.createContext(false);

// `Component`. If `props` is passed, those will be added as props on the
// wrapped component. If `element` is null, the component is not wrapped.

function wrapWithComponent(element, Component, props) {
  if (element == null) {
    return null;
  }

  return isElementOfType(element, Component) ? element : React__default.createElement(Component, props, element);
} // In development, we compare based on the name of the function because
// React Hot Loader proxies React components in order to make updates. In
// production we can simply compare the components for equality.

var isComponent = process.env.NODE_ENV === 'development' ? hotReloadComponentCheck : function (AComponent, AnotherComponent) {
  return AComponent === AnotherComponent;
}; // Checks whether `element` is a React element of type `Component` (or one of
// the passed components, if `Component` is an array of React components).

function isElementOfType(element, Component) {
  if (element == null || !React__default.isValidElement(element) || typeof element.type === 'string') {
    return false;
  }

  var type = element.type;
  var Components = Array.isArray(Component) ? Component : [Component];
  return Components.some(function (AComponent) {
    return typeof type !== 'string' && isComponent(AComponent, type);
  });
} // Returns all children that are valid elements as an array. Can optionally be
// filtered by passing `predicate`.

function elementChildren(children) {
  var predicate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {
    return true;
  };
  return React__default.Children.toArray(children).filter(function (child) {
    return React__default.isValidElement(child) && predicate(child);
  });
}

function hotReloadComponentCheck(AComponent, AnotherComponent) {
  var componentName = AComponent.name;
  var anotherComponentName = AnotherComponent.displayName;
  return AComponent === AnotherComponent || Boolean(componentName) && componentName === anotherComponentName;
}

var styles$5 = {
  "ButtonGroup": "Polaris-ButtonGroup",
  "Item": "Polaris-ButtonGroup__Item",
  "Item-plain": "Polaris-ButtonGroup__Item--plain",
  "segmented": "Polaris-ButtonGroup--segmented",
  "Item-focused": "Polaris-ButtonGroup__Item--focused",
  "fullWidth": "Polaris-ButtonGroup--fullWidth"
};

function Item(_ref) {
  var button = _ref.button;

  var _useToggle = useToggle(false),
      focused = _useToggle.value,
      forceTrueFocused = _useToggle.setTrue,
      forceFalseFocused = _useToggle.setFalse;

  var className = classNames(styles$5.Item, focused && styles$5['Item-focused'], button.props.plain && styles$5['Item-plain']);
  return React__default.createElement("div", {
    className: className,
    onFocus: forceTrueFocused,
    onBlur: forceFalseFocused
  }, button);
}

function ButtonGroup(_ref) {
  var children = _ref.children,
      segmented = _ref.segmented,
      fullWidth = _ref.fullWidth,
      connectedTop = _ref.connectedTop;
  var className = classNames(styles$5.ButtonGroup, segmented && styles$5.segmented, fullWidth && styles$5.fullWidth);
  var contents = elementChildren(children).map(function (child, index) {
    return React__default.createElement(Item, {
      button: child,
      key: index
    });
  });
  return React__default.createElement("div", {
    className: className,
    "data-buttongroup-segmented": segmented,
    "data-buttongroup-connected-top": connectedTop,
    "data-buttongroup-full-width": fullWidth
  }, contents);
}

var StickyManagerContext = React__default.createContext(undefined);

function useStickyManager() {
  var stickyManager = useContext(StickyManagerContext);

  if (!stickyManager) {
    throw new MissingAppProviderError('No StickyManager was provided.');
  }

  return stickyManager;
}

var Breakpoints = {
  navigationBarCollapsed: '768px',
  stackedContent: '1043px'
};
var noWindowMatches = {
  media: '',
  addListener: noop$1,
  removeListener: noop$1,
  matches: false,
  onchange: noop$1,
  addEventListener: noop$1,
  removeEventListener: noop$1,
  dispatchEvent: function dispatchEvent(_) {
    return true;
  }
};

function noop$1() {}

function navigationBarCollapsed() {
  return typeof window === 'undefined' ? noWindowMatches : window.matchMedia("(max-width: ".concat(Breakpoints.navigationBarCollapsed, ")"));
}
function stackedContent() {
  return typeof window === 'undefined' ? noWindowMatches : window.matchMedia("(max-width: ".concat(Breakpoints.stackedContent, ")"));
}

var StickyManager =
/*#__PURE__*/
function () {
  function StickyManager(container) {
    var _this = this;

    _classCallCheck(this, StickyManager);

    this.stickyItems = [];
    this.stuckItems = [];
    this.container = null;
    this.topBarOffset = 0;
    this.handleResize = debounce(function () {
      _this.manageStickyItems();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });
    this.handleScroll = debounce(function () {
      _this.manageStickyItems();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });

    if (container) {
      this.setContainer(container);
    }
  }

  _createClass(StickyManager, [{
    key: "registerStickyItem",
    value: function registerStickyItem(stickyItem) {
      this.stickyItems.push(stickyItem);
    }
  }, {
    key: "unregisterStickyItem",
    value: function unregisterStickyItem(nodeToRemove) {
      var nodeIndex = this.stickyItems.findIndex(function (_ref) {
        var stickyNode = _ref.stickyNode;
        return nodeToRemove === stickyNode;
      });
      this.stickyItems.splice(nodeIndex, 1);
    }
  }, {
    key: "setContainer",
    value: function setContainer(el) {
      this.container = el;

      if (isDocument(el)) {
        this.setTopBarOffset(el);
      }

      addEventListener(this.container, 'scroll', this.handleScroll);
      addEventListener(window, 'resize', this.handleResize);
      this.manageStickyItems();
    }
  }, {
    key: "removeScrollListener",
    value: function removeScrollListener() {
      if (this.container) {
        removeEventListener(this.container, 'scroll', this.handleScroll);
        removeEventListener(window, 'resize', this.handleResize);
      }
    }
  }, {
    key: "manageStickyItems",
    value: function manageStickyItems() {
      var _this2 = this;

      if (this.stickyItems.length <= 0) {
        return;
      }

      var scrollTop = this.container ? scrollTopFor(this.container) : 0;
      var containerTop = getRectForNode(this.container).top + this.topBarOffset;
      this.stickyItems.forEach(function (stickyItem) {
        var handlePositioning = stickyItem.handlePositioning;

        var _this2$evaluateSticky = _this2.evaluateStickyItem(stickyItem, scrollTop, containerTop),
            sticky = _this2$evaluateSticky.sticky,
            top = _this2$evaluateSticky.top,
            left = _this2$evaluateSticky.left,
            width = _this2$evaluateSticky.width;

        _this2.updateStuckItems(stickyItem, sticky);

        handlePositioning(sticky, top, left, width);
      });
    }
  }, {
    key: "evaluateStickyItem",
    value: function evaluateStickyItem(stickyItem, scrollTop, containerTop) {
      var stickyNode = stickyItem.stickyNode,
          placeHolderNode = stickyItem.placeHolderNode,
          boundingElement = stickyItem.boundingElement,
          offset = stickyItem.offset,
          disableWhenStacked = stickyItem.disableWhenStacked;

      if (disableWhenStacked && stackedContent().matches) {
        return {
          sticky: false,
          top: 0,
          left: 0,
          width: 'auto'
        };
      }

      var stickyOffset = offset ? this.getOffset(stickyNode) + parseInt(tokens.spacingLoose, 10) : this.getOffset(stickyNode);
      var scrollPosition = scrollTop + stickyOffset;
      var placeHolderNodeCurrentTop = placeHolderNode.getBoundingClientRect().top - containerTop + scrollTop;
      var top = containerTop + stickyOffset;
      var width = placeHolderNode.getBoundingClientRect().width;
      var left = placeHolderNode.getBoundingClientRect().left;
      var sticky;

      if (boundingElement == null) {
        sticky = scrollPosition >= placeHolderNodeCurrentTop;
      } else {
        var stickyItemHeight = stickyNode.getBoundingClientRect().height;
        var stickyItemBottomPosition = boundingElement.getBoundingClientRect().bottom - stickyItemHeight + scrollTop - containerTop;
        sticky = scrollPosition >= placeHolderNodeCurrentTop && scrollPosition < stickyItemBottomPosition;
      }

      return {
        sticky,
        top,
        left,
        width
      };
    }
  }, {
    key: "updateStuckItems",
    value: function updateStuckItems(item, sticky) {
      var stickyNode = item.stickyNode;

      if (sticky && !this.isNodeStuck(stickyNode)) {
        this.addStuckItem(item);
      } else if (!sticky && this.isNodeStuck(stickyNode)) {
        this.removeStuckItem(item);
      }
    }
  }, {
    key: "addStuckItem",
    value: function addStuckItem(stickyItem) {
      this.stuckItems.push(stickyItem);
    }
  }, {
    key: "removeStuckItem",
    value: function removeStuckItem(stickyItem) {
      var nodeToRemove = stickyItem.stickyNode;
      var nodeIndex = this.stuckItems.findIndex(function (_ref2) {
        var stickyNode = _ref2.stickyNode;
        return nodeToRemove === stickyNode;
      });
      this.stuckItems.splice(nodeIndex, 1);
    }
  }, {
    key: "getOffset",
    value: function getOffset(node) {
      if (this.stuckItems.length === 0) {
        return 0;
      }

      var offset = 0;
      var count = 0;
      var stuckNodesLength = this.stuckItems.length;
      var nodeRect = getRectForNode(node);

      while (count < stuckNodesLength) {
        var stuckNode = this.stuckItems[count].stickyNode;

        if (stuckNode !== node) {
          var stuckNodeRect = getRectForNode(stuckNode);

          if (!horizontallyOverlaps(nodeRect, stuckNodeRect)) {
            offset += getRectForNode(stuckNode).height;
          }
        } else {
          break;
        }

        count++;
      }

      return offset;
    }
  }, {
    key: "isNodeStuck",
    value: function isNodeStuck(node) {
      var nodeFound = this.stuckItems.findIndex(function (_ref3) {
        var stickyNode = _ref3.stickyNode;
        return node === stickyNode;
      });
      return nodeFound >= 0;
    }
  }, {
    key: "setTopBarOffset",
    value: function setTopBarOffset(container) {
      var topbarElement = container.querySelector(":not(".concat(scrollable.selector, ") ").concat(dataPolarisTopBar.selector));
      this.topBarOffset = topbarElement ? topbarElement.clientHeight : 0;
    }
  }]);

  return StickyManager;
}();

function isDocument(node) {
  return node === document;
}

function scrollTopFor(container) {
  return isDocument(container) ? document.body.scrollTop || document.documentElement.scrollTop : container.scrollTop;
}

function horizontallyOverlaps(rect1, rect2) {
  var rect1Left = rect1.left;
  var rect1Right = rect1.left + rect1.width;
  var rect2Left = rect2.left;
  var rect2Right = rect2.left + rect2.width;
  return rect2Right < rect1Left || rect1Right < rect2Left;
}

var UniqueIdFactoryContext = React__default.createContext(undefined);

/**
 * Returns a unique id that remains consistent across multiple re-renders of the
 * same hook
 * @param prefix Defines a prefix for the ID. You probably want to set this to
 *   the name of the component you're calling `useUniqueId` in.
 * @param overrideId Defines a fixed value to use instead of generating a unique
 *   ID. Useful for components that allow consumers to specify their own ID.
 */

function useUniqueId() {
  var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var overrideId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var idFactory = useContext(UniqueIdFactoryContext); // By using a ref to store the uniqueId for each invocation of the hook and
  // checking that it is not already populated we ensure that we don’t generate
  // a new ID on every re-render of a component.

  var uniqueIdRef = useRef(null);

  if (!idFactory) {
    throw new MissingAppProviderError('No UniqueIdFactory was provided.');
  } // If an override was specified, then use that instead of using a unique ID
  // Hooks can’t be called conditionally so this has to go after all use* calls


  if (overrideId) {
    return overrideId;
  } // If a unique id has not yet been generated, then get a new one


  if (!uniqueIdRef.current) {
    uniqueIdRef.current = idFactory.nextId(prefix);
  }

  return uniqueIdRef.current;
}

var UniqueIdFactory =
/*#__PURE__*/
function () {
  function UniqueIdFactory(idGeneratorFactory) {
    _classCallCheck(this, UniqueIdFactory);

    this.idGenerators = {};
    this.idGeneratorFactory = idGeneratorFactory;
  }

  _createClass(UniqueIdFactory, [{
    key: "nextId",
    value: function nextId(prefix) {
      if (!this.idGenerators[prefix]) {
        this.idGenerators[prefix] = this.idGeneratorFactory(prefix);
      }

      return this.idGenerators[prefix]();
    }
  }]);

  return UniqueIdFactory;
}();
function globalIdGeneratorFactory() {
  var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var index = 1;
  return function () {
    return "Polaris".concat(prefix).concat(index++);
  };
}

var ScrollableContext = React__default.createContext(undefined);

function ScrollTo() {
  var anchorNode = useRef(null);
  var scrollToPosition = useContext(ScrollableContext);
  useEffect(function () {
    if (!scrollToPosition || !anchorNode.current) {
      return;
    }

    scrollToPosition(anchorNode.current.offsetTop);
  }, [scrollToPosition]);
  var id = useUniqueId("ScrollTo"); // eslint-disable-next-line jsx-a11y/anchor-is-valid

  return React__default.createElement("a", {
    id: id,
    ref: anchorNode
  });
}

var styles$6 = {
  "Scrollable": "Polaris-Scrollable",
  "horizontal": "Polaris-Scrollable--horizontal",
  "vertical": "Polaris-Scrollable--vertical",
  "hasTopShadow": "Polaris-Scrollable--hasTopShadow",
  "hasBottomShadow": "Polaris-Scrollable--hasBottomShadow"
};

var MAX_SCROLL_DISTANCE = 100;
var DELTA_THRESHOLD = 0.2;
var DELTA_PERCENTAGE = 0.2;
var EVENTS_TO_LOCK = ['scroll', 'touchmove', 'wheel'];
var PREFERS_REDUCED_MOTION = prefersReducedMotion();
var Scrollable =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Scrollable, _React$Component);

  function Scrollable() {
    var _this;

    _classCallCheck(this, Scrollable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Scrollable).apply(this, arguments));
    _this.state = {
      topShadow: false,
      bottomShadow: false,
      scrollPosition: 0
    };
    _this.stickyManager = new StickyManager();
    _this.scrollArea = null;
    _this.handleResize = debounce(function () {
      _this.handleScroll();
    }, 50, {
      trailing: true
    });

    _this.setScrollArea = function (scrollArea) {
      _this.scrollArea = scrollArea;
    };

    _this.handleScroll = function () {
      var _assertThisInitialize = _assertThisInitialized(_this),
          scrollArea = _assertThisInitialize.scrollArea;

      var _this$props = _this.props,
          shadow = _this$props.shadow,
          onScrolledToBottom = _this$props.onScrolledToBottom;

      if (scrollArea == null) {
        return;
      }

      var scrollTop = scrollArea.scrollTop,
          clientHeight = scrollArea.clientHeight,
          scrollHeight = scrollArea.scrollHeight;
      var shouldBottomShadow = Boolean(shadow && !(scrollTop + clientHeight >= scrollHeight));
      var shouldTopShadow = Boolean(shadow && scrollTop > 0);
      var canScroll = scrollHeight > clientHeight;
      var hasScrolledToBottom = scrollHeight - scrollTop === clientHeight;

      if (canScroll && hasScrolledToBottom && onScrolledToBottom) {
        onScrolledToBottom();
      }

      _this.setState({
        topShadow: shouldTopShadow,
        bottomShadow: shouldBottomShadow,
        scrollPosition: scrollTop
      });
    };

    _this.scrollHint = function () {
      var _assertThisInitialize2 = _assertThisInitialized(_this),
          scrollArea = _assertThisInitialize2.scrollArea;

      if (scrollArea == null) {
        return;
      }

      var clientHeight = scrollArea.clientHeight,
          scrollHeight = scrollArea.scrollHeight;

      if (PREFERS_REDUCED_MOTION || _this.state.scrollPosition > 0 || scrollHeight <= clientHeight) {
        return;
      }

      var scrollDistance = scrollHeight - clientHeight;

      _this.toggleLock();

      _this.setState({
        scrollPosition: scrollDistance > MAX_SCROLL_DISTANCE ? MAX_SCROLL_DISTANCE : scrollDistance
      }, function () {
        window.requestAnimationFrame(_this.scrollStep);
      });
    };

    _this.scrollStep = function () {
      _this.setState(function (_ref) {
        var scrollPosition = _ref.scrollPosition;
        var delta = scrollPosition * DELTA_PERCENTAGE;
        return {
          scrollPosition: delta < DELTA_THRESHOLD ? 0 : scrollPosition - delta
        };
      }, function () {
        if (_this.state.scrollPosition > 0) {
          window.requestAnimationFrame(_this.scrollStep);
        } else {
          _this.toggleLock(false);
        }
      });
    };

    _this.scrollToPosition = function (scrollY) {
      _this.setState({
        scrollPosition: scrollY
      });
    };

    return _this;
  }

  _createClass(Scrollable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      if (this.scrollArea == null) {
        return;
      }

      this.stickyManager.setContainer(this.scrollArea);
      addEventListener(this.scrollArea, 'scroll', function () {
        window.requestAnimationFrame(_this2.handleScroll);
      });
      addEventListener(window, 'resize', this.handleResize);
      window.requestAnimationFrame(function () {
        _this2.handleScroll();

        if (_this2.props.hint) {
          _this2.scrollHint();
        }
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.scrollArea == null) {
        return;
      }

      removeEventListener(this.scrollArea, 'scroll', this.handleScroll);
      removeEventListener(window, 'resize', this.handleResize);
      this.stickyManager.removeScrollListener();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var scrollPosition = this.state.scrollPosition;

      if (scrollPosition && this.scrollArea && scrollPosition > 0) {
        this.scrollArea.scrollTop = scrollPosition;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          topShadow = _this$state.topShadow,
          bottomShadow = _this$state.bottomShadow;

      var _a = this.props,
          children = _a.children,
          className = _a.className,
          horizontal = _a.horizontal,
          _a$vertical = _a.vertical,
          vertical = _a$vertical === void 0 ? true : _a$vertical,
          shadow = _a.shadow,
          hint = _a.hint,
          onScrolledToBottom = _a.onScrolledToBottom,
          rest = __rest(_a, ["children", "className", "horizontal", "vertical", "shadow", "hint", "onScrolledToBottom"]);

      var finalClassName = classNames(className, styles$6.Scrollable, vertical && styles$6.vertical, horizontal && styles$6.horizontal, topShadow && styles$6.hasTopShadow, bottomShadow && styles$6.hasBottomShadow);
      return React__default.createElement(ScrollableContext.Provider, {
        value: this.scrollToPosition
      }, React__default.createElement(StickyManagerContext.Provider, {
        value: this.stickyManager
      }, React__default.createElement("div", Object.assign({
        className: finalClassName
      }, scrollable.props, rest, {
        ref: this.setScrollArea
      }), children)));
    }
  }, {
    key: "toggleLock",
    value: function toggleLock() {
      var shouldLock = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var scrollArea = this.scrollArea;

      if (scrollArea == null) {
        return;
      }

      EVENTS_TO_LOCK.forEach(function (eventName) {
        if (shouldLock) {
          addEventListener(scrollArea, eventName, prevent);
        } else {
          removeEventListener(scrollArea, eventName, prevent);
        }
      });
    }
  }], [{
    key: "forNode",
    value: function forNode(node) {
      return closest(node, scrollable.selector) || document;
    }
  }]);

  return Scrollable;
}(React__default.Component);
Scrollable.ScrollTo = ScrollTo;

function prevent(evt) {
  evt.preventDefault();
}

function prefersReducedMotion() {
  try {
    return window.matchMedia('(prefers-reduced-motion: reduce)').matches;
  } catch (err) {
    return false;
  }
}

var styles$7 = {
  "Badge": "Polaris-Badge",
  "Pip": "Polaris-Badge__Pip",
  "sizeSmall": "Polaris-Badge--sizeSmall",
  "statusSuccess": "Polaris-Badge--statusSuccess",
  "Content": "Polaris-Badge__Content",
  "statusInfo": "Polaris-Badge--statusInfo",
  "statusAttention": "Polaris-Badge--statusAttention",
  "statusWarning": "Polaris-Badge--statusWarning",
  "statusNew": "Polaris-Badge--statusNew",
  "progressIncomplete": "Polaris-Badge--progressIncomplete",
  "progressPartiallyComplete": "Polaris-Badge--progressPartiallyComplete",
  "progressComplete": "Polaris-Badge--progressComplete"
};

var PROGRESS_LABELS = {
  incomplete: 'incomplete',
  partiallyComplete: 'partiallyComplete',
  complete: 'complete'
};
var STATUS_LABELS = {
  info: 'info',
  success: 'success',
  warning: 'warning',
  attention: 'attention',
  new: 'new'
};
var DEFAULT_SIZE$1 = 'medium';
function Badge(_ref) {
  var children = _ref.children,
      status = _ref.status,
      progress = _ref.progress,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? DEFAULT_SIZE$1 : _ref$size;
  var i18n = useI18n();
  var className = classNames(styles$7.Badge, status && styles$7[variationName('status', status)], progress && styles$7[variationName('progress', progress)], size && size !== DEFAULT_SIZE$1 && styles$7[variationName('size', size)]);
  var progressMarkup;

  switch (progress) {
    case PROGRESS_LABELS.incomplete:
      progressMarkup = i18n.translate('Polaris.Badge.PROGRESS_LABELS.incomplete');
      break;

    case PROGRESS_LABELS.partiallyComplete:
      progressMarkup = i18n.translate('Polaris.Badge.PROGRESS_LABELS.partiallyComplete');
      break;

    case PROGRESS_LABELS.complete:
      progressMarkup = i18n.translate('Polaris.Badge.PROGRESS_LABELS.complete');
      break;
  }

  var pipMarkup = progress ? React__default.createElement("span", {
    className: styles$7.Pip
  }, React__default.createElement(VisuallyHidden, null, progressMarkup)) : null;
  var statusMarkup;

  switch (status) {
    case STATUS_LABELS.info:
      statusMarkup = i18n.translate('Polaris.Badge.STATUS_LABELS.info');
      break;

    case STATUS_LABELS.success:
      statusMarkup = i18n.translate('Polaris.Badge.STATUS_LABELS.success');
      break;

    case STATUS_LABELS.warning:
      statusMarkup = i18n.translate('Polaris.Badge.STATUS_LABELS.warning');
      break;

    case STATUS_LABELS.attention:
      statusMarkup = i18n.translate('Polaris.Badge.STATUS_LABELS.attention');
      break;

    case STATUS_LABELS.new:
      statusMarkup = i18n.translate('Polaris.Badge.STATUS_LABELS.new');
      break;
  }

  var statusLabelMarkup = status ? React__default.createElement(VisuallyHidden, null, statusMarkup) : null;
  return React__default.createElement("span", {
    className: className
  }, statusLabelMarkup, pipMarkup, React__default.createElement("span", {
    className: styles$7.Content
  }, children));
}

var styles$8 = {
  "variationPositive": "Polaris-TextStyle--variationPositive",
  "variationNegative": "Polaris-TextStyle--variationNegative",
  "variationCode": "Polaris-TextStyle--variationCode",
  "variationStrong": "Polaris-TextStyle--variationStrong",
  "variationSubdued": "Polaris-TextStyle--variationSubdued"
};

var VariationValue;

(function (VariationValue) {
  VariationValue["Positive"] = "positive";
  VariationValue["Negative"] = "negative";
  VariationValue["Strong"] = "strong";
  VariationValue["Subdued"] = "subdued";
  VariationValue["Code"] = "code";
})(VariationValue || (VariationValue = {}));

function TextStyle(_ref) {
  var variation = _ref.variation,
      children = _ref.children;
  var className = classNames(variation && styles$8[variationName('variation', variation)], variation === VariationValue.Code && styles$8.code);
  var Element = variationElement(variation);
  return React__default.createElement(Element, {
    className: className
  }, children);
}

function variationElement(variation) {
  return variation === VariationValue.Code ? 'code' : 'span';
}

var styles$9 = {
  "ActionList": "Polaris-ActionList",
  "globalTheming": "Polaris-ActionList--globalTheming",
  "Section-withoutTitle": "Polaris-ActionList__Section--withoutTitle",
  "Actions": "Polaris-ActionList__Actions",
  "Section": "Polaris-ActionList__Section",
  "Title": "Polaris-ActionList__Title",
  "Item": "Polaris-ActionList__Item",
  "active": "Polaris-ActionList--active",
  "destructive": "Polaris-ActionList--destructive",
  "disabled": "Polaris-ActionList--disabled",
  "Image": "Polaris-ActionList__Image",
  "Content": "Polaris-ActionList__Content",
  "Text": "Polaris-ActionList__Text",
  "BadgeWrapper": "Polaris-ActionList__BadgeWrapper"
};

function Item$1(_ref) {
  var id = _ref.id,
      badge = _ref.badge,
      content = _ref.content,
      accessibilityLabel = _ref.accessibilityLabel,
      helpText = _ref.helpText,
      url = _ref.url,
      onAction = _ref.onAction,
      icon = _ref.icon,
      image = _ref.image,
      disabled = _ref.disabled,
      external = _ref.external,
      destructive = _ref.destructive,
      ellipsis = _ref.ellipsis,
      active = _ref.active,
      role = _ref.role;

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  var className = classNames(styles$9.Item, disabled && styles$9.disabled, destructive && styles$9.destructive, active && styles$9.active, unstableGlobalTheming && styles$9.globalTheming);
  var imageElement = null;

  if (icon) {
    imageElement = React__default.createElement("div", {
      className: styles$9.Image
    }, React__default.createElement(Icon, {
      source: icon
    }));
  } else if (image) {
    imageElement = React__default.createElement("div", {
      role: "presentation",
      className: styles$9.Image,
      style: {
        backgroundImage: "url(".concat(image)
      }
    });
  }

  var contentText = ellipsis && content ? "".concat(content, "\u2026") : content;
  var contentMarkup = helpText ? React__default.createElement("div", null, React__default.createElement("div", null, contentText), React__default.createElement(TextStyle, {
    variation: "subdued"
  }, helpText)) : contentText;
  var badgeMarkup = badge && React__default.createElement("span", {
    className: styles$9.BadgeWrapper
  }, React__default.createElement(Badge, {
    status: badge.status
  }, badge.content));
  var textMarkup = imageElement ? React__default.createElement("div", {
    className: styles$9.Text
  }, contentMarkup) : contentMarkup;
  var contentElement = React__default.createElement("div", {
    className: styles$9.Content
  }, imageElement, textMarkup, badgeMarkup);
  var scrollMarkup = active ? React__default.createElement(Scrollable.ScrollTo, null) : null;
  var control = url ? React__default.createElement(UnstyledLink, {
    id: id,
    url: url,
    className: className,
    external: external,
    "aria-label": accessibilityLabel,
    onClick: onAction
  }, contentElement) : React__default.createElement("button", {
    id: id,
    type: "button",
    className: className,
    disabled: disabled,
    "aria-label": accessibilityLabel,
    onClick: onAction
  }, contentElement);
  return React__default.createElement("li", {
    role: role,
    "aria-selected": active
  }, scrollMarkup, control);
}

function Section(_ref) {
  var section = _ref.section,
      hasMultipleSections = _ref.hasMultipleSections,
      actionRole = _ref.actionRole,
      onActionAnyItem = _ref.onActionAnyItem;

  var handleAction = function handleAction(itemOnAction) {
    return function () {
      if (itemOnAction) {
        itemOnAction();
      }

      if (onActionAnyItem) {
        onActionAnyItem();
      }
    };
  };

  var actionMarkup = section.items.map(function (_a, index) {
    var content = _a.content,
        helpText = _a.helpText,
        onAction = _a.onAction,
        item = __rest(_a, ["content", "helpText", "onAction"]);

    return React__default.createElement(Item$1, Object.assign({
      key: "".concat(content, "-").concat(index),
      content: content,
      helpText: helpText,
      role: actionRole,
      onAction: handleAction(onAction)
    }, item));
  });
  var className = section.title ? undefined : styles$9['Section-withoutTitle'];
  var titleMarkup = section.title ? React__default.createElement("p", {
    className: styles$9.Title
  }, section.title) : null;
  var sectionRole = actionRole === 'option' ? 'presentation' : undefined;
  var sectionMarkup = React__default.createElement("div", {
    className: className
  }, titleMarkup, React__default.createElement("ul", {
    className: styles$9.Actions,
    role: sectionRole
  }, actionMarkup));
  return hasMultipleSections ? React__default.createElement("li", {
    className: styles$9.Section
  }, sectionMarkup) : sectionMarkup;
}

function ActionList(_ref) {
  var items = _ref.items,
      _ref$sections = _ref.sections,
      sections = _ref$sections === void 0 ? [] : _ref$sections,
      actionRole = _ref.actionRole,
      onActionAnyItem = _ref.onActionAnyItem;
  var finalSections = [];

  if (items) {
    finalSections = [{
      items
    }].concat(_toConsumableArray(sections));
  } else if (sections) {
    finalSections = sections;
  }

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  var className = classNames(styles$9.ActionList, unstableGlobalTheming && styles$9.globalTheming);
  var hasMultipleSections = finalSections.length > 1; // Type asserting to any is required for TS3.2 but can be removed when we update to 3.3
  // see https://github.com/Microsoft/TypeScript/issues/28768

  var Element = hasMultipleSections ? 'ul' : 'div';
  var sectionMarkup = finalSections.map(function (section, index) {
    return section.items.length > 0 ? React__default.createElement(Section, {
      key: section.title || index,
      section: section,
      hasMultipleSections: hasMultipleSections,
      actionRole: actionRole,
      onActionAnyItem: onActionAnyItem
    }) : null;
  });
  return React__default.createElement(Element, {
    className: className
  }, sectionMarkup);
}

var ThemeContext = React__default.createContext(undefined);

function useTheme() {
  var theme = useContext(ThemeContext);

  if (!theme) {
    throw new MissingAppProviderError('No Theme was provided.');
  }

  return theme;
}

var DefaultThemeColors = {
  surface: '#111213',
  onSurface: '#111213',
  interactive: '#2E72D2',
  secondary: '#111213',
  primary: '#008060',
  critical: '#D82C0D',
  warning: '#FFC453',
  highlight: '#5BCDDA',
  success: '#008060',
  decorative: '#FDC7CE'
};
var DefaultColorScheme = 'light';
var roleVariants = {
  surface: [{
    name: 'background',
    description: 'For use as a background color, in components such as Page and Frame backgrounds.',
    light: {
      lightness: 98.3
    },
    dark: {
      lightness: 3.3
    }
  }, {
    name: 'surface',
    description: 'For use as a background color, in components such as Card, Modal, and Popover.',
    light: {
      lightness: 100
    },
    dark: {
      lightness: 12.7
    }
  }, {
    name: 'surfaceSubdued',
    description: 'For use as a subdued background color, in components such as Card, Modal, and Popover.',
    light: {
      lightness: 98.3
    },
    dark: {
      lightness: 10
    }
  }, {
    name: 'surfaceHovered',
    description: 'For use as a surface color on interactive elements such as resource list items and action list items when in a hovered state.',
    light: {
      lightness: 96
    },
    dark: {
      lightness: 20
    }
  }, {
    name: 'surfacePressed',
    description: 'For use as a surface color on interactive elements such as resource list items and action list items when in a pressed state.',
    light: {
      lightness: 90
    },
    dark: {
      lightness: 27
    }
  }, {
    name: 'backdrop',
    description: 'For use as the background color of the backdrop component for navigation and modal. This color has an alpha of `0.5`.',
    light: {
      hue: 0,
      saturation: 0,
      lightness: 0,
      alpha: 0.5
    },
    dark: {
      hue: 0,
      saturation: 0,
      lightness: 0,
      alpha: 0.5
    }
  }, {
    name: 'shadowFromAmbientLight',
    description: 'For use in building shadows for popovers, cards, and modals. This color has an alpha of `0.05`.',
    light: {
      hue: 180,
      saturation: 5,
      lightness: 8,
      alpha: 0.05
    },
    dark: {
      hue: 180,
      saturation: 5,
      lightness: 8,
      alpha: 0.05
    }
  }, {
    name: 'shadowFromDirectLight',
    description: 'For use in building shadows for popovers, cards, and modals. This color has an alpha of `0.15`.',
    light: {
      hue: 0,
      saturation: 0,
      lightness: 0,
      alpha: 0.15
    },
    dark: {
      hue: 0,
      saturation: 0,
      lightness: 0,
      alpha: 0.15
    }
  }],
  onSurface: [{
    name: 'border',
    description: 'For use as a border (border or interactive outline).',
    light: {
      lightness: 75
    },
    dark: {
      lightness: 35
    }
  }, {
    name: 'borderDisabled',
    description: 'For use as a an interactive outline on disabled elements.',
    light: {
      lightness: 95
    },
    dark: {
      lightness: 70
    }
  }, {
    name: 'borderSubdued',
    description: 'For use as a subdued border (border or interactive outline).',
    light: {
      lightness: 85
    },
    dark: {
      lightness: 32
    }
  }, {
    name: 'icon',
    description: 'For use as the fill color of secondary icons.',
    light: {
      lightness: 40.1
    },
    dark: {
      lightness: 70.1
    }
  }, {
    name: 'iconDisabled',
    description: 'For use as the fill color of disabled secondary icons.',
    light: {
      lightness: 76.9
    },
    dark: {
      lightness: 36.8
    }
  }, {
    name: 'iconSubdued',
    description: 'For use as the fill color of subdued secondary icons.',
    light: {
      lightness: 59.8
    },
    dark: {
      lightness: 52.1
    }
  }, {
    name: 'text',
    description: 'For use as a secondary text color.',
    light: {
      lightness: 13.1
    },
    dark: {
      lightness: 90.8
    }
  }, {
    name: 'textDisabled',
    description: 'For use as a disabled secondary text color.',
    light: {
      lightness: 61.3
    },
    dark: {
      lightness: 48.2
    }
  }, {
    name: 'textSubdued',
    description: 'For use as a subdued secondary text color.',
    light: {
      lightness: 47.4
    },
    dark: {
      lightness: 65.1
    }
  }],
  interactive: [{
    name: 'actionInteractive',
    description: 'Used for links and plain buttons.',
    light: {
      lightness: 48.6
    },
    dark: {
      lightness: 65,
      saturation: 100,
      hue: 247.6
    }
  }, {
    name: 'actionInteractiveDisabled',
    description: 'Used for disabled links and plain buttons.',
    light: {
      lightness: 58
    },
    dark: {
      lightness: 42
    }
  }, {
    name: 'actionInteractiveHovered',
    description: 'Used for hovered links and plain buttons.',
    light: {
      lightness: 37
    },
    dark: {
      lightness: 70,
      saturation: 100,
      hue: 247.6
    }
  }, {
    name: 'actionInteractiveSubdued',
    description: 'Used for subdued links and plain buttons.',
    light: {
      lightness: 51
    },
    dark: {
      lightness: 49
    }
  }, {
    name: 'actionInteractivePressed',
    description: 'Used for pressed links and plain buttons.',
    light: {
      lightness: 31
    },
    dark: {
      lightness: 75,
      saturation: 100,
      hue: 247.6
    }
  }, {
    name: 'focused',
    description: 'For use in the focus ring on interactive elements.',
    light: {
      lightness: 58
    },
    dark: {
      lightness: 42
    }
  }, {
    name: 'surfaceSelected',
    description: 'For use as a surface color in selected interactive elements, in components such as option list and resource list.',
    light: {
      lightness: 96
    },
    dark: {
      lightness: 4
    }
  }, {
    name: 'surfaceSelectedHovered',
    description: 'For use as a surface color in selected interactive elements that are hovered, in components such as option list and resource list.',
    light: {
      lightness: 89
    },
    dark: {
      lightness: 11
    }
  }, {
    name: 'surfaceSelectedPressed',
    description: 'For use as a surface color in selected interactive elements that are pressed, in components such as option list and resource list.',
    light: {
      lightness: 82
    },
    dark: {
      lightness: 18
    }
  }],
  secondary: [{
    name: 'actionSecondary',
    description: 'Used for secondary buttons and tertiary buttons, as well as in form elements as a background color and pontentially other secondary surfaces.',
    light: {
      lightness: 93
    },
    dark: {
      lightness: 22
    }
  }, {
    name: 'actionSecondaryDisabled',
    description: 'Used as a disabled state for secondary buttons',
    light: {
      lightness: 94
    },
    dark: {
      lightness: 13
    }
  }, {
    name: 'actionSecondaryHovered',
    description: 'Used as a hovered state for secondary buttons',
    light: {
      lightness: 90
    },
    dark: {
      lightness: 37
    }
  }, {
    name: 'actionSecondaryPressed',
    description: 'Used as a pressed state for secondary buttons',
    light: {
      lightness: 87
    },
    dark: {
      lightness: 42
    }
  }],
  primary: [{
    name: 'actionPrimary',
    description: 'Used as the background color for primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states.',
    light: {
      lightness: 47.3
    },
    dark: {
      lightness: 47.3
    }
  }, {
    name: 'actionPrimaryDisabled',
    description: 'Used as the background color for disabled primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states.',
    light: {
      lightness: 32
    },
    dark: {
      lightness: 32
    }
  }, {
    name: 'actionPrimaryHovered',
    description: 'Used as the background color for hovered primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states.',
    light: {
      lightness: 42.3
    },
    dark: {
      lightness: 55
    }
  }, {
    name: 'actionPrimaryPressed',
    description: 'Used as the background color for pressed primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states.',
    light: {
      lightness: 37.3
    },
    dark: {
      lightness: 60
    }
  }, {
    name: 'iconOnPrimary',
    description: 'For use as a fill color for icons on primary actions. Not for use in icons on navigation and tabs.',
    light: {
      lightness: 98
    },
    dark: {
      lightness: 98
    }
  }, {
    name: 'textOnPrimary',
    description: 'For use as a text color on primary actions. Not for use in text on navigation and tabs.',
    light: {
      lightness: 100
    },
    dark: {
      lightness: 100
    }
  }, {
    name: 'primarySelected',
    description: 'Used as a surface color to indicate selected interactive states in navigation and tabs.',
    light: {
      lightness: 95,
      saturation: 30
    },
    dark: {
      lightness: 5,
      saturation: 30
    }
  }, {
    name: 'primarySelectedHovered',
    description: 'Used as a surface color to indicate selected interactive states that are hovered in navigation and tabs.',
    light: {
      lightness: 81,
      saturation: 22
    },
    dark: {
      lightness: 19,
      saturation: 22
    }
  }, {
    name: 'primarySelectedPressed',
    description: 'Used as a surface color to indicate selected interactive states that are pressed in navigation and tabs.',
    light: {
      lightness: 74,
      saturation: 22
    },
    dark: {
      lightness: 26,
      saturation: 22
    }
  }],
  critical: [{
    name: 'borderCritical',
    description: 'For use as a border on critical components such as banners, and as an outline on interactive elements in an error state.',
    light: {
      lightness: 50
    },
    dark: {
      lightness: 50
    }
  }, {
    name: 'borderCriticalDisabled',
    description: 'For use as a disabled border on critical components such as banners, and as an outline on interactive elements in an error state.',
    light: {
      lightness: 82
    },
    dark: {
      lightness: 28
    }
  }, {
    name: 'iconCritical',
    description: 'For use as an icon fill color on top of critical elements.',
    light: {
      lightness: 52
    },
    dark: {
      lightness: 48
    }
  }, {
    name: 'surfaceCritical',
    description: 'For use as a surface color on critical elements including badges.',
    light: {
      lightness: 98.6
    },
    dark: {
      lightness: 12
    }
  }, {
    name: 'surfaceCriticalSubdued',
    description: 'For use as a subdued surface color on critical elements including banners.',
    light: {
      lightness: 98
    },
    dark: {
      lightness: 12
    }
  }, {
    name: 'surfaceCriticalSubduedHovered',
    description: 'For use as a surface color on critical interactive elements including action list items in a hovered state.',
    light: {
      lightness: 96
    },
    dark: {
      lightness: 15,
      saturation: 60
    }
  }, {
    name: 'surfaceCriticalSubduedPressed',
    description: 'For use as a surface color on critical interactive elements including action list items in a pressed state.',
    light: {
      lightness: 88
    },
    dark: {
      lightness: 22
    }
  }, {
    name: 'textCritical',
    description: 'For use as a text color in inert critical elements such as exception list. Not for use as a text color on banners and badges.',
    light: {
      lightness: 47.3
    },
    dark: {
      lightness: 65,
      saturation: 70
    }
  }, {
    name: 'actionCritical',
    description: 'For use as the background color for destructive buttons, and as the background color for error toast messages.',
    light: {
      lightness: 47.5
    },
    dark: {
      lightness: 45
    }
  }, {
    name: 'actionCriticalDisabled',
    description: 'For use as the background color for disabled destructive buttons, and as the background color for error toast messages.',
    light: {
      lightness: 59
    },
    dark: {
      lightness: 41
    }
  }, {
    name: 'actionCriticalHovered',
    description: 'For use as the background color for hovered destructive buttons, and as the background color for error toast messages.',
    light: {
      lightness: 42.5
    },
    dark: {
      lightness: 50
    }
  }, {
    name: 'actionCriticalPressed',
    description: 'For use as the background color for pressed destructive buttons, and as the background color for error toast messages.',
    light: {
      lightness: 37.5
    },
    dark: {
      lightness: 55
    }
  }, {
    name: 'iconOnCritical',
    description: 'For use as a fill color for icons on critical actions.',
    light: {
      lightness: 98
    },
    dark: {
      lightness: 98
    }
  }, {
    name: 'textOnCritical',
    description: 'For use as a text color on critical actions.',
    light: {
      lightness: 100
    },
    dark: {
      lightness: 100
    }
  }, {
    name: 'criticalLink',
    description: 'For use as a text color in destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges.',
    light: {
      lightness: 48.5
    },
    dark: {
      lightness: 65
    }
  }, {
    name: 'criticalLinkDisabled',
    description: 'For use as a text color in disabled destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges.',
    light: {
      lightness: 72
    },
    dark: {
      lightness: 78
    }
  }, {
    name: 'criticalLinkHovered',
    description: 'For use as a text color in hovered destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges.',
    light: {
      lightness: 45
    },
    dark: {
      lightness: 70
    }
  }, {
    name: 'criticalLinkPressed',
    description: 'For use as a text color in pressed destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges.',
    light: {
      lightness: 21
    },
    dark: {
      lightness: 75
    }
  }],
  warning: [{
    name: 'borderWarning',
    description: 'For use as a border on warning components such as banners.',
    light: {
      lightness: 76.6
    },
    dark: {
      lightness: 50
    }
  }, {
    name: 'iconWarning',
    description: 'For use as an icon fill color on top of warning elements.',
    light: {
      lightness: 66
    },
    dark: {
      lightness: 34
    }
  }, {
    name: 'surfaceWarning',
    description: 'For use as a surface color on warning elements including badges.',
    light: {
      lightness: 84.5
    },
    dark: {
      lightness: 50
    }
  }, {
    name: 'surfaceWarningSubdued',
    description: 'For use as a subdued surface color on warning elements including banners.',
    light: {
      lightness: 96
    },
    dark: {
      lightness: 26,
      saturation: 71
    }
  }, {
    name: 'textWarning',
    description: 'For use as a text color in inert critical elements such as exception list. Not for use as a text color on banners and badges.',
    light: {
      lightness: 47.4
    },
    dark: {
      lightness: 64.9
    }
  }],
  highlight: [{
    name: 'borderHighlight',
    description: 'For use as a border on informational components such as banners.',
    light: {
      lightness: 60
    },
    dark: {
      lightness: 60
    }
  }, {
    name: 'iconHighlight',
    description: 'For use as an icon fill color on top of informational elements.',
    light: {
      lightness: 58
    },
    dark: {
      lightness: 42
    }
  }, {
    name: 'surfaceHighlight',
    description: 'For use as a surface color on information elements including badges.',
    light: {
      lightness: 84.5,
      saturation: 60
    },
    dark: {
      lightness: 40,
      saturation: 100
    }
  }, {
    name: 'surfaceHighlightSubdued',
    description: 'For use as a surface color on information elements including banners.',
    light: {
      lightness: 98.6
    },
    dark: {
      lightness: 20
    }
  }, {
    name: 'textHighlight',
    description: 'For use as a text color in inert informational elements. Not for use as a text color on banners and badges.',
    light: {
      lightness: 10
    },
    dark: {
      lightness: 90
    }
  }],
  success: [{
    name: 'borderSuccess',
    description: 'For use as a border on success components such as banners.',
    light: {
      lightness: 50
    },
    dark: {
      lightness: 50
    }
  }, {
    name: 'iconSuccess',
    description: 'For use as an icon fill color on top of success elements.',
    light: {
      lightness: 25
    },
    dark: {
      lightness: 35
    }
  }, {
    name: 'surfaceSuccess',
    description: 'For use as a surface color on success elements including badges.',
    light: {
      lightness: 84.5,
      saturation: 60
    },
    dark: {
      lightness: 35
    }
  }, {
    name: 'surfaceSuccessSubdued',
    description: 'For use as a surface color on information elements including banners.',
    light: {
      lightness: 99,
      saturation: 60
    },
    dark: {
      lightness: 20,
      saturation: 60
    }
  }, {
    name: 'textSuccess',
    description: 'For use as a text color in inert success elements. Not for use as a text color on banners and badges.',
    light: {
      lightness: 47.3
    },
    dark: {
      lightness: 65,
      saturation: 70
    }
  }],
  decorative: [{
    name: 'decorativeOneSurface',
    description: 'For use as a decorative surface color.',
    light: {
      hue: 56,
      saturation: 100,
      lightness: 84
    },
    dark: {
      hue: 54,
      saturation: 98,
      lightness: 46
    }
  }, {
    name: 'decorativeOneText',
    description: 'For use as a decorative text color that is applied on a decorative surface.',
    light: {
      hue: 52,
      saturation: 100,
      lightness: 18
    },
    dark: {
      lightness: 100
    }
  }, {
    name: 'decorativeTwoSurface',
    description: 'For use as a decorative surface color.',
    light: {
      hue: 30,
      saturation: 100,
      lightness: 84
    },
    dark: {
      hue: 24,
      saturation: 96,
      lightness: 52
    }
  }, {
    name: 'decorativeTwoText',
    description: 'For use as a decorative text color that is applied on a decorative surface.',
    light: {
      hue: 362,
      saturation: 80,
      lightness: 14
    },
    dark: {
      lightness: 100
    }
  }, {
    name: 'decorativeThreeSurface',
    description: 'For use as a decorative surface color.',
    light: {
      hue: 144,
      saturation: 54,
      lightness: 84
    },
    dark: {
      hue: 154,
      saturation: 100,
      lightness: 46
    }
  }, {
    name: 'decorativeThreeText',
    description: 'For use as a decorative text color that is applied on a decorative surface.',
    light: {
      hue: 144,
      saturation: 100,
      lightness: 16
    },
    dark: {
      lightness: 100
    }
  }, {
    name: 'decorativeFourSurface',
    description: 'For use as a decorative surface color.',
    light: {
      hue: 180,
      saturation: 56,
      lightness: 84
    },
    dark: {
      hue: 188,
      saturation: 95,
      lightness: 47
    }
  }, {
    name: 'decorativeFourText',
    description: 'For use as a decorative text color that is applied on a decorative surface.',
    light: {
      hue: 190,
      saturation: 100,
      lightness: 16
    },
    dark: {
      lightness: 100
    }
  }, {
    name: 'decorativeFiveSurface',
    description: 'For use as a decorative surface color.',
    light: {},
    dark: {
      hue: 363,
      saturation: 77,
      lightness: 45
    }
  }, {
    name: 'decorativeFiveText',
    description: 'For use as a decorative text color that is applied on a decorative surface.',
    light: {
      hue: 363,
      saturation: 78,
      lightness: 16
    },
    dark: {
      lightness: 100
    }
  }]
};

function compose() {
  for (var _len = arguments.length, fns = new Array(_len), _key = 0; _key < _len; _key++) {
    fns[_key] = arguments[_key];
  }

  return fns.reduce(function (func, group) {
    return function () {
      return func(group.apply(void 0, arguments));
    };
  });
}

function rgbString(color) {
  var red = color.red,
      green = color.green,
      blue = color.blue;

  if (Object.prototype.hasOwnProperty.call(color, 'alpha')) {
    return "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", ").concat(color.alpha, ")");
  } else {
    return "rgb(".concat(red, ", ").concat(green, ", ").concat(blue, ")");
  }
}
var rgbaString = rgbString;
function rgbToHex(_ref) {
  var red = _ref.red,
      green = _ref.green,
      blue = _ref.blue;
  return "#".concat(componentToHex(red)).concat(componentToHex(green)).concat(componentToHex(blue));
}

function componentToHex(component) {
  var hex = component.toString(16);
  return hex.length === 1 ? "0".concat(hex) : hex;
}

function hsbToHex(color) {
  return rgbToHex(hsbToRgb(color));
}

function rgbFromHueAndChroma(hue, chroma) {
  var huePrime = hue / 60;
  var hueDelta = 1 - Math.abs(huePrime % 2 - 1);
  var intermediateValue = chroma * hueDelta;
  var red = 0;
  var green = 0;
  var blue = 0;

  if (huePrime >= 0 && huePrime <= 1) {
    red = chroma;
    green = intermediateValue;
    blue = 0;
  }

  if (huePrime >= 1 && huePrime <= 2) {
    red = intermediateValue;
    green = chroma;
    blue = 0;
  }

  if (huePrime >= 2 && huePrime <= 3) {
    red = 0;
    green = chroma;
    blue = intermediateValue;
  }

  if (huePrime >= 3 && huePrime <= 4) {
    red = 0;
    green = intermediateValue;
    blue = chroma;
  }

  if (huePrime >= 4 && huePrime <= 5) {
    red = intermediateValue;
    green = 0;
    blue = chroma;
  }

  if (huePrime >= 5 && huePrime <= 6) {
    red = chroma;
    green = 0;
    blue = intermediateValue;
  }

  return {
    red,
    green,
    blue
  };
}

function hsbToRgb(color) {
  var hue = color.hue,
      saturation = color.saturation,
      brightness = color.brightness,
      _color$alpha = color.alpha,
      alpha = _color$alpha === void 0 ? 1 : _color$alpha;
  var chroma = brightness * saturation;

  var _rgbFromHueAndChroma = rgbFromHueAndChroma(hue, chroma),
      red = _rgbFromHueAndChroma.red,
      green = _rgbFromHueAndChroma.green,
      blue = _rgbFromHueAndChroma.blue;

  var chromaBrightnessDelta = brightness - chroma;
  red += chromaBrightnessDelta;
  green += chromaBrightnessDelta;
  blue += chromaBrightnessDelta;
  return {
    red: Math.round(red * 255),
    green: Math.round(green * 255),
    blue: Math.round(blue * 255),
    alpha
  };
}
function hslToRgb(color) {
  var hue = color.hue,
      saturation = color.saturation,
      lightness = color.lightness,
      _color$alpha2 = color.alpha,
      alpha = _color$alpha2 === void 0 ? 1 : _color$alpha2;
  var chroma = (1 - Math.abs(2 * (lightness / 100) - 1)) * (saturation / 100);

  var _rgbFromHueAndChroma2 = rgbFromHueAndChroma(hue, chroma),
      red = _rgbFromHueAndChroma2.red,
      green = _rgbFromHueAndChroma2.green,
      blue = _rgbFromHueAndChroma2.blue;

  var lightnessVal = lightness / 100 - chroma / 2;
  red += lightnessVal;
  green += lightnessVal;
  blue += lightnessVal;
  return {
    red: Math.round(red * 255),
    green: Math.round(green * 255),
    blue: Math.round(blue * 255),
    alpha
  };
} // ref https://en.wikipedia.org/wiki/HSL_and_HSV

function rgbToHsbl(color) {
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'b';
  var r = color.red,
      g = color.green,
      b = color.blue,
      _color$alpha3 = color.alpha,
      alpha = _color$alpha3 === void 0 ? 1 : _color$alpha3;
  var red = r / 255;
  var green = g / 255;
  var blue = b / 255;
  var largestComponent = Math.max(red, green, blue);
  var smallestComponent = Math.min(red, green, blue);
  var delta = largestComponent - smallestComponent;
  var lightness = (largestComponent + smallestComponent) / 2;
  var saturation = 0;

  if (largestComponent === 0) {
    saturation = 0;
  } else if (type === 'b') {
    saturation = delta / largestComponent;
  } else if (type === 'l') {
    var baseSaturation = lightness > 0.5 ? delta / (2 - largestComponent - smallestComponent) : delta / (largestComponent + smallestComponent);
    saturation = isNaN(baseSaturation) ? 0 : baseSaturation;
  }

  var huePercentage = 0;

  switch (largestComponent) {
    case red:
      huePercentage = (green - blue) / delta + (green < blue ? 6 : 0);
      break;

    case green:
      huePercentage = (blue - red) / delta + 2;
      break;

    case blue:
      huePercentage = (red - green) / delta + 4;
  }

  var hue = Math.round(huePercentage / 6 * 360);
  return {
    hue: clamp$1(hue, 0, 360) || 0,
    saturation: parseFloat(clamp$1(saturation, 0, 1).toFixed(2)),
    brightness: parseFloat(clamp$1(largestComponent, 0, 1).toFixed(2)),
    lightness: parseFloat(lightness.toFixed(2)),
    alpha: parseFloat(alpha.toFixed(2))
  };
}

function rgbToHsb(color) {
  var _rgbToHsbl = rgbToHsbl(color, 'b'),
      hue = _rgbToHsbl.hue,
      saturation = _rgbToHsbl.saturation,
      brightness = _rgbToHsbl.brightness,
      _rgbToHsbl$alpha = _rgbToHsbl.alpha,
      alpha = _rgbToHsbl$alpha === void 0 ? 1 : _rgbToHsbl$alpha;

  return {
    hue,
    saturation,
    brightness,
    alpha
  };
}
function rgbToHsl(color) {
  var _rgbToHsbl2 = rgbToHsbl(color, 'l'),
      hue = _rgbToHsbl2.hue,
      rawSaturation = _rgbToHsbl2.saturation,
      rawLightness = _rgbToHsbl2.lightness,
      _rgbToHsbl2$alpha = _rgbToHsbl2.alpha,
      alpha = _rgbToHsbl2$alpha === void 0 ? 1 : _rgbToHsbl2$alpha;

  var saturation = rawSaturation * 100;
  var lightness = rawLightness * 100;
  return {
    hue,
    saturation,
    lightness,
    alpha
  };
}
function hexToRgb(color) {
  if (color.length === 4) {
    var repeatHex = function repeatHex(hex1, hex2) {
      return color.slice(hex1, hex2).repeat(2);
    };

    var _red = parseInt(repeatHex(1, 2), 16);

    var _green = parseInt(repeatHex(2, 3), 16);

    var _blue = parseInt(repeatHex(3, 4), 16);

    return {
      red: _red,
      green: _green,
      blue: _blue
    };
  }

  var red = parseInt(color.slice(1, 3), 16);
  var green = parseInt(color.slice(3, 5), 16);
  var blue = parseInt(color.slice(5, 7), 16);
  return {
    red,
    green,
    blue
  };
}
var ColorType;

(function (ColorType) {
  ColorType["Hex"] = "hex";
  ColorType["Rgb"] = "rgb";
  ColorType["Rgba"] = "rgba";
  ColorType["Hsl"] = "hsl";
  ColorType["Hsla"] = "hsla";
  ColorType["Default"] = "default";
})(ColorType || (ColorType = {}));

function getColorType(color) {
  if (color.includes('#')) {
    return ColorType.Hex;
  } else if (color.includes('rgb')) {
    return ColorType.Rgb;
  } else if (color.includes('rgba')) {
    return ColorType.Rgba;
  } else if (color.includes('hsl')) {
    return ColorType.Hsl;
  } else if (color.includes('hsla')) {
    return ColorType.Hsla;
  } else {
    if (process.env.NODE_ENV === 'development') {
      /* eslint-disable-next-line no-console */
      console.warn('Accepted colors formats are: hex, rgb, rgba, hsl and hsla');
    }

    return ColorType.Default;
  }
}

function hslToString(hslColor) {
  if (typeof hslColor === 'string') {
    return hslColor;
  }

  var _hslColor$alpha = hslColor.alpha,
      alpha = _hslColor$alpha === void 0 ? 1 : _hslColor$alpha,
      hue = hslColor.hue,
      lightness = hslColor.lightness,
      saturation = hslColor.saturation;
  return "hsla(".concat(hue, ", ").concat(saturation, "%, ").concat(lightness, "%, ").concat(alpha, ")");
}

function rgbToObject(color) {
  // eslint-disable-next-line @typescript-eslint/prefer-regexp-exec
  var colorMatch = color.match(/\(([^)]+)\)/);

  if (!colorMatch) {
    return {
      red: 0,
      green: 0,
      blue: 0,
      alpha: 0
    };
  }

  var _colorMatch$1$split = colorMatch[1].split(','),
      _colorMatch$1$split2 = _slicedToArray(_colorMatch$1$split, 4),
      red = _colorMatch$1$split2[0],
      green = _colorMatch$1$split2[1],
      blue = _colorMatch$1$split2[2],
      alpha = _colorMatch$1$split2[3];

  var objColor = {
    red: parseInt(red, 10),
    green: parseInt(green, 10),
    blue: parseInt(blue, 10),
    alpha: parseInt(alpha, 10) || 1
  };
  return objColor;
}

var hexToHsla = compose(rgbToHsl, hexToRgb);
var rbgStringToHsla = compose(rgbToHsl, rgbToObject);

function hslToObject(color) {
  // eslint-disable-next-line @typescript-eslint/prefer-regexp-exec
  var colorMatch = color.match(/\(([^)]+)\)/);

  if (!colorMatch) {
    return {
      hue: 0,
      saturation: 0,
      lightness: 0,
      alpha: 0
    };
  }

  var _colorMatch$1$split3 = colorMatch[1].split(','),
      _colorMatch$1$split4 = _slicedToArray(_colorMatch$1$split3, 4),
      hue = _colorMatch$1$split4[0],
      saturation = _colorMatch$1$split4[1],
      lightness = _colorMatch$1$split4[2],
      alpha = _colorMatch$1$split4[3];

  var objColor = {
    hue: parseInt(hue, 10),
    saturation: parseInt(saturation, 10),
    lightness: parseInt(lightness, 10),
    alpha: parseFloat(alpha) || 1
  };
  return objColor;
}

function colorToHsla(color) {
  var type = getColorType(color);

  switch (type) {
    case ColorType.Hex:
      return hexToHsla(color);

    case ColorType.Rgb:
    case ColorType.Rgba:
      return rbgStringToHsla(color);

    case ColorType.Hsla:
    case ColorType.Hsl:
      return hslToObject(color);

    case ColorType.Default:
    default:
      throw new Error('Accepted color formats are: hex, rgb, rgba, hsl and hsla');
  }
}

// implements: https://www.w3.org/WAI/ER/WD-AERT/#color-contrast
function isLight(_ref) {
  var red = _ref.red,
      green = _ref.green,
      blue = _ref.blue;
  var contrast = (red * 299 + green * 587 + blue * 114) / 1000;
  return contrast > 125;
}

function normalizeName(name) {
  return name.split(/(?=[A-Z])/).join('-').toLowerCase();
}
function constructColorName(baseName, property, suffix) {
  var name = normalizeName(baseName);
  var propertyName = property ? "-".concat(normalizeName(property)) : '';
  var constructedSuffix = suffix ? "-".concat(suffix) : '';
  return "--".concat(name).concat(propertyName).concat(constructedSuffix);
}

function lightenColor(color) {
  var lighten = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (typeof color === 'string') {
    return color;
  }

  var lightness = color.lightness;
  var nextLightness = lightness + lighten;
  return Object.assign(Object.assign({}, color), {
    lightness: clamp$1(nextLightness, 0, 100)
  });
}
function saturateColor(color) {
  var saturate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (typeof color === 'string') {
    return color;
  }

  var saturation = color.saturation;
  var nextSaturation = saturation + saturate;
  return Object.assign(Object.assign({}, color), {
    saturation: nextSaturation
  });
}
function createLightColor(color, lightness, saturation) {
  var lightenedColor = lightenColor(color, lightness);
  var saturatedColor = saturateColor(lightenedColor, -saturation);
  return saturatedColor;
}

var needsVariantList = ['topBar'];

function buildCustomProperties(themeConfig, globalTheming, tokens) {
  var _themeConfig$UNSTABLE = themeConfig.UNSTABLE_colors,
      UNSTABLE_colors = _themeConfig$UNSTABLE === void 0 ? {} : _themeConfig$UNSTABLE,
      colorScheme = themeConfig.colorScheme;
  return globalTheming ? customPropertyTransformer(Object.assign(Object.assign({}, buildColors(UNSTABLE_colors, roleVariants, colorScheme)), tokens)) : buildLegacyColors(themeConfig);
}
function buildThemeContext(themeConfig, cssCustomProperties) {
  var logo = themeConfig.logo,
      UNSTABLE_colors = themeConfig.UNSTABLE_colors,
      colorScheme = themeConfig.colorScheme;
  return {
    logo,
    UNSTABLE_cssCustomProperties: toString(cssCustomProperties),
    UNSTABLE_colors,
    colorScheme
  };
}

function toString(obj) {
  if (obj) {
    return Object.entries(obj).map(function (pair) {
      return pair.join(':');
    }).join(';');
  } else {
    return undefined;
  }
}

function hexToHsluvObj(hex) {
  var _hexToHsluv = hexToHsluv(hex),
      _hexToHsluv2 = _slicedToArray(_hexToHsluv, 3),
      hue = _hexToHsluv2[0],
      saturation = _hexToHsluv2[1],
      lightness = _hexToHsluv2[2];

  return {
    hue,
    saturation,
    lightness
  };
}

function buildColors(colors, roleVariants, colorScheme) {
  return Object.assign.apply(Object, [{}].concat(_toConsumableArray(Object.entries(colors).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        role = _ref2[0],
        hex = _ref2[1];

    var base = hexToHsluvObj(hex);
    var variants = roleVariants[role] || [];
    return Object.assign({}, variants.reduce(function (accumulator, _a) {
      var name = _a.name,
          settings = __rest(_a, ["name"]);

      var _settings$colorScheme = settings[colorScheme],
          _settings$colorScheme2 = _settings$colorScheme.hue,
          hue = _settings$colorScheme2 === void 0 ? base.hue : _settings$colorScheme2,
          _settings$colorScheme3 = _settings$colorScheme.saturation,
          saturation = _settings$colorScheme3 === void 0 ? base.saturation : _settings$colorScheme3,
          _settings$colorScheme4 = _settings$colorScheme.lightness,
          lightness = _settings$colorScheme4 === void 0 ? base.lightness : _settings$colorScheme4,
          _settings$colorScheme5 = _settings$colorScheme.alpha,
          alpha = _settings$colorScheme5 === void 0 ? 1 : _settings$colorScheme5;
      return Object.assign(Object.assign({}, accumulator), {
        [name]: hslToString(Object.assign(Object.assign({}, colorToHsla(hsluvToHex([hue, saturation, lightness]))), {
          alpha
        }))
      });
    }, {}));
  }))));
}

function customPropertyTransformer(properties) {
  return Object.entries(properties).reduce(function (transformed, _ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        key = _ref4[0],
        value = _ref4[1];

    return Object.assign(Object.assign({}, transformed), {
      [toCssCustomPropertySyntax(key)]: value
    });
  }, {});
}

function toCssCustomPropertySyntax(camelCase) {
  return "--p-".concat(camelCase.replace(/([A-Z0-9])/g, '-$1').toLowerCase());
}

function buildLegacyColors(theme) {
  var colorPairs;
  var colors = theme && theme.colors && theme.colors.topBar ? theme.colors.topBar : {
    background: '#00848e',
    backgroundLighter: '#1d9ba4',
    color: '#f9fafb'
  };
  var colorKey = 'topBar';
  var colorKeys = Object.keys(colors);

  if (colorKeys.length > 1) {
    colorPairs = colorKeys.map(function (key) {
      return [constructColorName(colorKey, key), colors[key]];
    });
  } else {
    colorPairs = parseColors([colorKey, colors]);
  }

  return colorPairs.reduce(function (state, _ref5) {
    var _ref6 = _slicedToArray(_ref5, 2),
        key = _ref6[0],
        value = _ref6[1];

    return Object.assign(Object.assign({}, state), {
      [key]: value
    });
  }, {});
}

function needsVariant(name) {
  return needsVariantList.includes(name);
}
var lightenToString = compose(hslToString, createLightColor);
function setTextColor(name) {
  var variant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'dark';

  if (variant === 'light') {
    return [name, tokens.colorInk];
  }

  return [name, tokens.colorWhite];
}
function setTheme(color, baseName, key, variant) {
  var colorPairs = [];

  switch (variant) {
    case 'light':
      colorPairs.push(setTextColor(constructColorName(baseName, null, 'color'), 'light'));
      colorPairs.push([constructColorName(baseName, key, 'lighter'), lightenToString(color, 7, -10)]);
      break;

    case 'dark':
      colorPairs.push(setTextColor(constructColorName(baseName, null, 'color'), 'dark'));
      colorPairs.push([constructColorName(baseName, key, 'lighter'), lightenToString(color, 15, 15)]);
      break;

    default:
  }

  return colorPairs;
}

function parseColors(_ref7) {
  var _ref8 = _slicedToArray(_ref7, 2),
      baseName = _ref8[0],
      colors = _ref8[1];

  var keys = Object.keys(colors);
  var colorPairs = [];

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];
    colorPairs.push([constructColorName(baseName, key), colors[key]]);

    if (needsVariant(baseName)) {
      var hslColor = colorToHsla(colors[key]);

      if (typeof hslColor === 'string') {
        return colorPairs;
      }

      var rgbColor = hslToRgb(hslColor);

      if (isLight(rgbColor)) {
        colorPairs.push.apply(colorPairs, _toConsumableArray(setTheme(hslColor, baseName, key, 'light')));
      } else {
        colorPairs.push.apply(colorPairs, _toConsumableArray(setTheme(hslColor, baseName, key, 'dark')));
      }
    }
  }

  return colorPairs;
}

var BorderRadius = {
  borderRadiusBase: rem('4px'),
  borderRadiusWide: rem('8px')
};
var Shadow = {
  cardShadow: '0px 0px 5px var(--p-shadow-from-ambient-light), 0px 1px 2px var(--p-shadow-from-direct-light)',
  popoverShadow: '-1px 0px 20px var(--p-shadow-from-ambient-light), 0px 1px 5px var(--p-shadow-from-direct-light)',
  modalShadow: '0px 6px 32px var(--p-shadow-from-ambient-light), 0px 1px 6px var(--p-shadow-from-direct-light)'
};
var Overrides = {
  overrideNone: 'none',
  overrideTransparent: 'transparent',
  overrideOne: '1',
  overrideVisible: 'visible',
  overrideZero: '0',
  overrideLoadingZIndex: '514',
  buttonFontWeight: '500',
  nonNullContent: "''",
  bannerBorderDefault: buildBannerBorder('--p-border'),
  bannerBorderSuccess: buildBannerBorder('--p-border-success'),
  bannerBorderHighlight: buildBannerBorder('--p-border-highlight'),
  bannerBorderWarning: buildBannerBorder('--p-border-warning'),
  bannerBorderCritical: buildBannerBorder('--p-border-critical'),
  badgeMixBlendMode: 'luminosity',
  thinBorderSubdued: "".concat(rem('1px'), " solid var(--p-border-subdued)"),
  textFieldSpinnerOffset: rem('2px'),
  textFieldFocusRingOffset: rem('-4px'),
  textFieldFocusRingBorderRadius: rem('7px'),
  buttonGroupItemSpacing: rem('2px')
};
var Tokens = Object.assign(Object.assign(Object.assign({}, BorderRadius), Shadow), Overrides);

function rem(px) {
  var baseFontSize = 10;
  return "".concat(parseInt(px, 10) / baseFontSize, "rem");
}

function buildBannerBorder(cssVar) {
  return "inset 0 ".concat(rem('2px'), " 0 0 var(").concat(cssVar, "), inset 0 0 0 ").concat(rem('2px'), " var(").concat(cssVar, ")");
}

var getUniqueID = createUniqueIDFactory('portal-');
var Portal =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Portal, _React$PureComponent);

  function Portal() {
    var _this;

    _classCallCheck(this, Portal);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Portal).apply(this, arguments));
    _this.state = {
      isMounted: false
    };
    _this.portalNode = null;
    _this.portalId = _this.props.idPrefix !== '' ? "".concat(_this.props.idPrefix, "-").concat(getUniqueID()) : getUniqueID();
    return _this;
  }

  _createClass(Portal, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.portalNode = document.createElement('div');
      this.portalNode.setAttribute(portal.props[0], this.portalId);

      if (this.context != null) {
        var UNSTABLE_cssCustomProperties = this.context.UNSTABLE_cssCustomProperties;

        if (UNSTABLE_cssCustomProperties != null) {
          this.portalNode.setAttribute('style', UNSTABLE_cssCustomProperties);
        } else {
          this.portalNode.removeAttribute('style');
        }
      }

      document.body.appendChild(this.portalNode);
      this.setState({
        isMounted: true
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_, prevState) {
      var _this$props$onPortalC = this.props.onPortalCreated,
          onPortalCreated = _this$props$onPortalC === void 0 ? noop$2 : _this$props$onPortalC;

      if (this.portalNode && this.context != null) {
        var _this$context = this.context,
            UNSTABLE_cssCustomProperties = _this$context.UNSTABLE_cssCustomProperties,
            textColor = _this$context.textColor;

        if (UNSTABLE_cssCustomProperties != null) {
          var style = "".concat(UNSTABLE_cssCustomProperties, ";color:").concat(textColor, ";");
          this.portalNode.setAttribute('style', style);
        } else {
          this.portalNode.removeAttribute('style');
        }
      }

      if (!prevState.isMounted && this.state.isMounted) {
        onPortalCreated();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.portalNode) {
        document.body.removeChild(this.portalNode);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return this.portalNode && this.state.isMounted ? createPortal(this.props.children, this.portalNode) : null;
    }
  }]);

  return Portal;
}(React__default.PureComponent);
Portal.defaultProps = {
  idPrefix: ''
};
Portal.contextType = ThemeContext;

function noop$2() {}

var styles$a = {
  "Popover": "Polaris-Popover",
  "PopoverOverlay": "Polaris-Popover__PopoverOverlay",
  "PopoverOverlay-entering": "Polaris-Popover__PopoverOverlay--entering",
  "PopoverOverlay-open": "Polaris-Popover__PopoverOverlay--open",
  "PopoverOverlay-exiting": "Polaris-Popover__PopoverOverlay--exiting",
  "measuring": "Polaris-Popover--measuring",
  "fullWidth": "Polaris-Popover--fullWidth",
  "Content": "Polaris-Popover__Content",
  "positionedAbove": "Polaris-Popover--positionedAbove",
  "Wrapper": "Polaris-Popover__Wrapper",
  "Content-fullHeight": "Polaris-Popover__Content--fullHeight",
  "Content-fluidContent": "Polaris-Popover__Content--fluidContent",
  "Pane": "Polaris-Popover__Pane",
  "Pane-fixed": "Polaris-Popover__Pane--fixed",
  "Section": "Polaris-Popover__Section",
  "FocusTracker": "Polaris-Popover__FocusTracker"
};

function Section$1(_ref) {
  var children = _ref.children;
  return React__default.createElement("div", {
    className: styles$a.Section
  }, children);
}

function Pane(_ref) {
  var fixed = _ref.fixed,
      sectioned = _ref.sectioned,
      children = _ref.children,
      onScrolledToBottom = _ref.onScrolledToBottom;
  var className = classNames(styles$a.Pane, fixed && styles$a['Pane-fixed']);
  var content = sectioned ? wrapWithComponent(children, Section$1, {}) : children;
  return fixed ? React__default.createElement("div", {
    className: className
  }, content) : React__default.createElement(Scrollable, {
    hint: true,
    shadow: true,
    className: className,
    onScrolledToBottom: onScrolledToBottom
  }, content);
}

var EventListener =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(EventListener, _React$PureComponent);

  function EventListener() {
    _classCallCheck(this, EventListener);

    return _possibleConstructorReturn(this, _getPrototypeOf(EventListener).apply(this, arguments));
  }

  _createClass(EventListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.attachListener();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_a) {
      var passive = _a.passive,
          detachProps = __rest(_a, ["passive"]);

      this.detachListener(detachProps);
      this.attachListener();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.detachListener();
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }, {
    key: "attachListener",
    value: function attachListener() {
      var _this$props = this.props,
          event = _this$props.event,
          handler = _this$props.handler,
          capture = _this$props.capture,
          passive = _this$props.passive;
      addEventListener(window, event, handler, {
        capture,
        passive
      });
    }
  }, {
    key: "detachListener",
    value: function detachListener(prevProps) {
      var _ref = prevProps || this.props,
          event = _ref.event,
          handler = _ref.handler,
          capture = _ref.capture;

      removeEventListener(window, event, handler, capture);
    }
  }]);

  return EventListener;
}(React__default.PureComponent);

var KeypressListener =
/*#__PURE__*/
function (_React$Component) {
  _inherits(KeypressListener, _React$Component);

  function KeypressListener() {
    var _this;

    _classCallCheck(this, KeypressListener);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(KeypressListener).apply(this, arguments));

    _this.handleKeyEvent = function (event) {
      var _this$props = _this.props,
          keyCode = _this$props.keyCode,
          handler = _this$props.handler;

      if (event.keyCode === keyCode) {
        handler(event);
      }
    };

    return _this;
  }

  _createClass(KeypressListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      addEventListener(document, 'keyup', this.handleKeyEvent);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      removeEventListener(document, 'keyup', this.handleKeyEvent);
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return KeypressListener;
}(React__default.Component);

function calculateVerticalPosition(activatorRect, overlayRect, overlayMargins, scrollableContainerRect, containerRect, preferredPosition, fixed) {
  var activatorTop = activatorRect.top;
  var activatorBottom = activatorTop + activatorRect.height;
  var spaceAbove = activatorRect.top;
  var spaceBelow = containerRect.height - activatorRect.top - activatorRect.height;
  var desiredHeight = overlayRect.height;
  var verticalMargins = overlayMargins.activator + overlayMargins.container;
  var minimumSpaceToScroll = overlayMargins.container;
  var distanceToTopScroll = activatorRect.top - Math.max(scrollableContainerRect.top, 0);
  var distanceToBottomScroll = containerRect.top + Math.min(containerRect.height, scrollableContainerRect.top + scrollableContainerRect.height) - (activatorRect.top + activatorRect.height);
  var enoughSpaceFromTopScroll = distanceToTopScroll >= minimumSpaceToScroll;
  var enoughSpaceFromBottomScroll = distanceToBottomScroll >= minimumSpaceToScroll;
  var heightIfBelow = Math.min(spaceBelow, desiredHeight);
  var heightIfAbove = Math.min(spaceAbove, desiredHeight);
  var containerRectTop = fixed ? 0 : containerRect.top;
  var positionIfAbove = {
    height: heightIfAbove - verticalMargins,
    top: activatorTop + containerRectTop - heightIfAbove,
    positioning: 'above'
  };
  var positionIfBelow = {
    height: heightIfBelow - verticalMargins,
    top: activatorBottom + containerRectTop,
    positioning: 'below'
  };

  if (preferredPosition === 'above') {
    return (enoughSpaceFromTopScroll || distanceToTopScroll >= distanceToBottomScroll && !enoughSpaceFromBottomScroll) && (spaceAbove > desiredHeight || spaceAbove > spaceBelow) ? positionIfAbove : positionIfBelow;
  }

  if (preferredPosition === 'below') {
    return (enoughSpaceFromBottomScroll || distanceToBottomScroll >= distanceToTopScroll && !enoughSpaceFromTopScroll) && (spaceBelow > desiredHeight || spaceBelow > spaceAbove) ? positionIfBelow : positionIfAbove;
  }

  if (enoughSpaceFromTopScroll && enoughSpaceFromBottomScroll) {
    return spaceAbove > spaceBelow ? positionIfAbove : positionIfBelow;
  }

  return distanceToTopScroll > minimumSpaceToScroll ? positionIfAbove : positionIfBelow;
}
function calculateHorizontalPosition(activatorRect, overlayRect, containerRect, overlayMargins, preferredAlignment) {
  var maximum = containerRect.width - overlayRect.width;

  if (preferredAlignment === 'left') {
    return Math.min(maximum, Math.max(0, activatorRect.left - overlayMargins.horizontal));
  } else if (preferredAlignment === 'right') {
    var activatorRight = activatorRect.left + activatorRect.width;
    return Math.min(maximum, Math.max(0, activatorRight - overlayRect.width + overlayMargins.horizontal));
  }

  return Math.min(maximum, Math.max(0, activatorRect.center.x - overlayRect.width / 2));
}
function rectIsOutsideOfRect(inner, outer) {
  var center = inner.center;
  return center.y < outer.top || center.y > outer.top + outer.height;
}

var styles$b = {
  "PositionedOverlay": "Polaris-PositionedOverlay",
  "fixed": "Polaris-PositionedOverlay--fixed",
  "calculating": "Polaris-PositionedOverlay--calculating"
};

var OBSERVER_CONFIG = {
  childList: true,
  subtree: true
};
var PositionedOverlay =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(PositionedOverlay, _React$PureComponent);

  function PositionedOverlay(props) {
    var _this;

    _classCallCheck(this, PositionedOverlay);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PositionedOverlay).call(this, props));
    _this.state = {
      measuring: true,
      activatorRect: getRectForNode(_this.props.activator),
      left: 0,
      top: 0,
      height: 0,
      width: null,
      positioning: 'below',
      zIndex: null,
      outsideScrollableContainer: false,
      lockPosition: false
    };
    _this.overlay = null;
    _this.scrollableContainer = null;

    _this.overlayDetails = function () {
      var _this$state = _this.state,
          measuring = _this$state.measuring,
          left = _this$state.left,
          positioning = _this$state.positioning,
          height = _this$state.height,
          activatorRect = _this$state.activatorRect;
      return {
        measuring,
        left,
        desiredHeight: height,
        positioning,
        activatorRect
      };
    };

    _this.setOverlay = function (node) {
      _this.overlay = node;
    };

    _this.handleMeasurement = function () {
      var _this$state2 = _this.state,
          lockPosition = _this$state2.lockPosition,
          top = _this$state2.top;

      _this.observer.disconnect();

      _this.setState(function (_ref) {
        var left = _ref.left,
            top = _ref.top;
        return {
          left,
          top,
          height: 0,
          positioning: 'below',
          measuring: true
        };
      }, function () {
        if (_this.overlay == null || _this.scrollableContainer == null) {
          return;
        }

        var _this$props = _this.props,
            activator = _this$props.activator,
            _this$props$preferred = _this$props.preferredPosition,
            preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred,
            _this$props$preferred2 = _this$props.preferredAlignment,
            preferredAlignment = _this$props$preferred2 === void 0 ? 'center' : _this$props$preferred2,
            onScrollOut = _this$props.onScrollOut,
            fullWidth = _this$props.fullWidth,
            fixed = _this$props.fixed;
        var textFieldActivator = activator.querySelector('input');
        var activatorRect = textFieldActivator != null ? getRectForNode(textFieldActivator) : getRectForNode(activator);
        var currentOverlayRect = getRectForNode(_this.overlay);
        var scrollableElement = isDocument$1(_this.scrollableContainer) ? document.body : _this.scrollableContainer;
        var scrollableContainerRect = getRectForNode(scrollableElement);
        var overlayRect = fullWidth ? Object.assign(Object.assign({}, currentOverlayRect), {
          width: activatorRect.width
        }) : currentOverlayRect; // If `body` is 100% height, it still acts as though it were not constrained to that size. This adjusts for that.

        if (scrollableElement === document.body) {
          scrollableContainerRect.height = document.body.scrollHeight;
        }

        var overlayMargins = _this.overlay.firstElementChild ? getMarginsForNode(_this.overlay.firstElementChild) : {
          activator: 0,
          container: 0,
          horizontal: 0
        };
        var containerRect = windowRect();
        var zIndexForLayer = getZIndexForLayerFromNode(activator);
        var zIndex = zIndexForLayer == null ? zIndexForLayer : zIndexForLayer + 1;
        var verticalPosition = calculateVerticalPosition(activatorRect, overlayRect, overlayMargins, scrollableContainerRect, containerRect, preferredPosition, fixed);
        var horizontalPosition = calculateHorizontalPosition(activatorRect, overlayRect, containerRect, overlayMargins, preferredAlignment);

        _this.setState({
          measuring: false,
          activatorRect: getRectForNode(activator),
          left: horizontalPosition,
          top: lockPosition ? top : verticalPosition.top,
          lockPosition: Boolean(fixed),
          height: verticalPosition.height || 0,
          width: fullWidth ? overlayRect.width : null,
          positioning: verticalPosition.positioning,
          outsideScrollableContainer: onScrollOut != null && rectIsOutsideOfRect(activatorRect, intersectionWithViewport(scrollableContainerRect)),
          zIndex
        }, function () {
          if (!_this.overlay) return;

          _this.observer.observe(_this.overlay, OBSERVER_CONFIG);
        });
      });
    };

    _this.observer = new MutationObserver(_this.handleMeasurement);
    return _this;
  }

  _createClass(PositionedOverlay, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.scrollableContainer = Scrollable.forNode(this.props.activator);

      if (this.scrollableContainer && !this.props.fixed) {
        this.scrollableContainer.addEventListener('scroll', this.handleMeasurement);
      }

      this.handleMeasurement();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.scrollableContainer && !this.props.fixed) {
        this.scrollableContainer.removeEventListener('scroll', this.handleMeasurement);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this$state3 = this.state,
          outsideScrollableContainer = _this$state3.outsideScrollableContainer,
          top = _this$state3.top;
      var _this$props2 = this.props,
          onScrollOut = _this$props2.onScrollOut,
          active = _this$props2.active;

      if (active && onScrollOut != null && top !== 0 && outsideScrollableContainer) {
        onScrollOut();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state4 = this.state,
          left = _this$state4.left,
          top = _this$state4.top,
          zIndex = _this$state4.zIndex,
          width = _this$state4.width;
      var _this$props3 = this.props,
          render = _this$props3.render,
          fixed = _this$props3.fixed,
          propClassNames = _this$props3.classNames;
      var style = {
        top: top == null || isNaN(top) ? undefined : top,
        left: left == null || isNaN(left) ? undefined : left,
        width: width == null || isNaN(width) ? undefined : width,
        zIndex: zIndex == null || isNaN(zIndex) ? undefined : zIndex
      };
      var className = classNames(styles$b.PositionedOverlay, fixed && styles$b.fixed, propClassNames);
      return React__default.createElement("div", {
        className: className,
        style: style,
        ref: this.setOverlay
      }, React__default.createElement(EventListener, {
        event: "resize",
        handler: this.handleMeasurement
      }), render(this.overlayDetails()));
    }
  }]);

  return PositionedOverlay;
}(React__default.PureComponent);
function intersectionWithViewport(rect) {
  var viewport = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : windowRect();
  var top = Math.max(rect.top, 0);
  var left = Math.max(rect.left, 0);
  var bottom = Math.min(rect.top + rect.height, viewport.height);
  var right = Math.min(rect.left + rect.width, viewport.width);
  return new Rect({
    top,
    left,
    height: bottom - top,
    width: right - left
  });
}

function getMarginsForNode(node) {
  var nodeStyles = window.getComputedStyle(node);
  return {
    activator: parseFloat(nodeStyles.marginTop || ''),
    container: parseFloat(nodeStyles.marginBottom || ''),
    horizontal: parseFloat(nodeStyles.marginLeft || '')
  };
}

function getZIndexForLayerFromNode(node) {
  var layerNode = closest(node, layer.selector) || document.body;
  var zIndex = layerNode === document.body ? 'auto' : parseInt(window.getComputedStyle(layerNode).zIndex || '0', 10);
  return zIndex === 'auto' || isNaN(zIndex) ? null : zIndex;
}

function windowRect() {
  return new Rect({
    top: window.scrollY,
    left: window.scrollX,
    height: window.innerHeight,
    width: window.innerWidth
  });
}

function isDocument$1(node) {
  return node === document;
}

var CloseSource;

(function (CloseSource) {
  CloseSource[CloseSource["Click"] = 0] = "Click";
  CloseSource[CloseSource["EscapeKeypress"] = 1] = "EscapeKeypress";
  CloseSource[CloseSource["FocusOut"] = 2] = "FocusOut";
  CloseSource[CloseSource["ScrollOut"] = 3] = "ScrollOut";
})(CloseSource || (CloseSource = {}));

var TransitionStatus;

(function (TransitionStatus) {
  TransitionStatus["Entering"] = "entering";
  TransitionStatus["Entered"] = "entered";
  TransitionStatus["Exiting"] = "exiting";
  TransitionStatus["Exited"] = "exited";
})(TransitionStatus || (TransitionStatus = {}));

var PopoverOverlay =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(PopoverOverlay, _React$PureComponent);

  function PopoverOverlay() {
    var _this;

    _classCallCheck(this, PopoverOverlay);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(PopoverOverlay).apply(this, arguments));
    _this.state = {
      transitionStatus: _this.props.active ? TransitionStatus.Entering : TransitionStatus.Exited
    };
    _this.contentNode = createRef();

    _this.renderPopover = function (overlayDetails) {
      var measuring = overlayDetails.measuring,
          desiredHeight = overlayDetails.desiredHeight,
          positioning = overlayDetails.positioning;
      var _this$props = _this.props,
          id = _this$props.id,
          children = _this$props.children,
          sectioned = _this$props.sectioned,
          fullWidth = _this$props.fullWidth,
          fullHeight = _this$props.fullHeight,
          fluidContent = _this$props.fluidContent;
      var className = classNames(styles$a.Popover, positioning === 'above' && styles$a.positionedAbove, fullWidth && styles$a.fullWidth, measuring && styles$a.measuring);
      var contentStyles = measuring ? undefined : {
        height: desiredHeight
      };
      var contentClassNames = classNames(styles$a.Content, fullHeight && styles$a['Content-fullHeight'], fluidContent && styles$a['Content-fluidContent']);
      var content = React__default.createElement("div", {
        id: id,
        tabIndex: -1,
        className: contentClassNames,
        style: contentStyles,
        ref: _this.contentNode
      }, renderPopoverContent(children, {
        sectioned
      }));
      return React__default.createElement("div", Object.assign({
        className: className
      }, overlay.props), React__default.createElement(EventListener, {
        event: "click",
        handler: _this.handleClick
      }), React__default.createElement(EventListener, {
        event: "touchstart",
        handler: _this.handleClick
      }), React__default.createElement(KeypressListener, {
        keyCode: Key.Escape,
        handler: _this.handleEscape
      }), React__default.createElement("div", {
        className: styles$a.FocusTracker // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
        ,
        tabIndex: 0,
        onFocus: _this.handleFocusFirstItem
      }), React__default.createElement("div", {
        className: styles$a.Wrapper
      }, content), React__default.createElement("div", {
        className: styles$a.FocusTracker // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
        ,
        tabIndex: 0,
        onFocus: _this.handleFocusLastItem
      }));
    };

    _this.handleClick = function (event) {
      var target = event.target;

      var _assertThisInitialize = _assertThisInitialized(_this),
          contentNode = _assertThisInitialize.contentNode,
          _assertThisInitialize2 = _assertThisInitialize.props,
          activator = _assertThisInitialize2.activator,
          onClose = _assertThisInitialize2.onClose;

      var isDescendant = contentNode.current != null && nodeContainsDescendant(contentNode.current, target);
      var isActivatorDescendant = nodeContainsDescendant(activator, target);

      if (isDescendant || isActivatorDescendant || _this.state.transitionStatus !== TransitionStatus.Entered) {
        return;
      }

      onClose(CloseSource.Click);
    };

    _this.handleScrollOut = function () {
      _this.props.onClose(CloseSource.ScrollOut);
    };

    _this.handleEscape = function () {
      _this.props.onClose(CloseSource.EscapeKeypress);
    };

    _this.handleFocusFirstItem = function () {
      _this.props.onClose(CloseSource.FocusOut);
    };

    _this.handleFocusLastItem = function () {
      _this.props.onClose(CloseSource.FocusOut);
    };

    return _this;
  }

  _createClass(PopoverOverlay, [{
    key: "changeTransitionStatus",
    value: function changeTransitionStatus(transitionStatus, cb) {
      this.setState({
        transitionStatus
      }, cb); // Forcing a reflow to enable the animation

      this.contentNode.current && this.contentNode.current.getBoundingClientRect();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.active) {
        this.focusContent();
        this.changeTransitionStatus(TransitionStatus.Entered);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(oldProps) {
      var _this2 = this;

      if (this.props.active && !oldProps.active) {
        this.focusContent();
        this.changeTransitionStatus(TransitionStatus.Entering, function () {
          _this2.clearTransitionTimeout();

          _this2.enteringTimer = window.setTimeout(function () {
            _this2.setState({
              transitionStatus: TransitionStatus.Entered
            });
          }, durationBase);
        });
      }

      if (!this.props.active && oldProps.active) {
        this.changeTransitionStatus(TransitionStatus.Exiting, function () {
          _this2.clearTransitionTimeout();

          _this2.exitingTimer = window.setTimeout(function () {
            _this2.setState({
              transitionStatus: TransitionStatus.Exited
            });
          }, durationBase);
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearTransitionTimeout();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          active = _this$props2.active,
          activator = _this$props2.activator,
          fullWidth = _this$props2.fullWidth,
          _this$props2$preferre = _this$props2.preferredPosition,
          preferredPosition = _this$props2$preferre === void 0 ? 'below' : _this$props2$preferre,
          _this$props2$preferre2 = _this$props2.preferredAlignment,
          preferredAlignment = _this$props2$preferre2 === void 0 ? 'center' : _this$props2$preferre2,
          fixed = _this$props2.fixed;
      var transitionStatus = this.state.transitionStatus;
      if (transitionStatus === TransitionStatus.Exited && !active) return null;
      var className = classNames(styles$a.PopoverOverlay, transitionStatus === TransitionStatus.Entering && styles$a['PopoverOverlay-entering'], transitionStatus === TransitionStatus.Entered && styles$a['PopoverOverlay-open'], transitionStatus === TransitionStatus.Exiting && styles$a['PopoverOverlay-exiting']);
      return React__default.createElement(PositionedOverlay, {
        fullWidth: fullWidth,
        active: active,
        activator: activator,
        preferredPosition: preferredPosition,
        preferredAlignment: preferredAlignment,
        render: this.renderPopover.bind(this),
        fixed: fixed,
        onScrollOut: this.handleScrollOut,
        classNames: className
      });
    }
  }, {
    key: "clearTransitionTimeout",
    value: function clearTransitionTimeout() {
      if (this.enteringTimer) {
        window.clearTimeout(this.enteringTimer);
      }

      if (this.exitingTimer) {
        window.clearTimeout(this.exitingTimer);
      }
    }
  }, {
    key: "focusContent",
    value: function focusContent() {
      var _this3 = this;

      if (this.props.preventAutofocus) {
        return;
      }

      if (this.contentNode == null) {
        return;
      }

      write(function () {
        if (_this3.contentNode.current == null) {
          return;
        }

        _this3.contentNode.current.focus({
          preventScroll: process.env.NODE_ENV === 'development'
        });
      });
    }
  }]);

  return PopoverOverlay;
}(React__default.PureComponent);

function renderPopoverContent(children, props) {
  var childrenArray = React__default.Children.toArray(children);

  if (isElementOfType(childrenArray[0], Pane)) {
    return childrenArray;
  }

  return wrapWithComponent(childrenArray, Pane, props);
}

function setActivatorAttributes(activator, _ref) {
  var id = _ref.id,
      active = _ref.active,
      ariaHaspopup = _ref.ariaHaspopup;
  activator.tabIndex = activator.tabIndex || 0;
  activator.setAttribute('aria-controls', id);
  activator.setAttribute('aria-owns', id);
  activator.setAttribute('aria-expanded', String(active));

  if (ariaHaspopup != null) {
    activator.setAttribute('aria-haspopup', String(ariaHaspopup));
  }
}

// subcomponents so explicitly state the subcomponents in the type definition.
// Letting this be implicit works in this project but fails in projects that use
// generated *.d.ts files.

var Popover = function Popover(_a) {
  var _a$activatorWrapper = _a.activatorWrapper,
      activatorWrapper = _a$activatorWrapper === void 0 ? 'div' : _a$activatorWrapper,
      children = _a.children,
      onClose = _a.onClose,
      activator = _a.activator,
      active = _a.active,
      fixed = _a.fixed,
      ariaHaspopup = _a.ariaHaspopup,
      rest = __rest(_a, ["activatorWrapper", "children", "onClose", "activator", "active", "fixed", "ariaHaspopup"]);

  var _useState = useState(),
      _useState2 = _slicedToArray(_useState, 2),
      activatorNode = _useState2[0],
      setActivatorNode = _useState2[1];

  var activatorContainer = useRef(null);
  var WrapperComponent = activatorWrapper;
  var id = useUniqueId('popover');
  var setAccessibilityAttributes = useCallback(function () {
    if (activatorContainer.current == null) {
      return;
    }

    var firstFocusable = findFirstFocusableNode(activatorContainer.current);
    var focusableActivator = firstFocusable || activatorContainer.current;
    setActivatorAttributes(focusableActivator, {
      id,
      active,
      ariaHaspopup
    });
  }, [active, ariaHaspopup, id]);

  var handleClose = function handleClose(source) {
    onClose(source);

    if (activatorContainer.current == null) {
      return;
    }

    if ((source === CloseSource.FocusOut || source === CloseSource.EscapeKeypress) && activatorNode) {
      var focusableActivator = findFirstFocusableNode(activatorNode) || findFirstFocusableNode(activatorContainer.current) || activatorContainer.current;

      if (!focusNextFocusableNode(focusableActivator, isInPortal)) {
        focusableActivator.focus();
      }
    }
  };

  useEffect(function () {
    if (!activatorNode && activatorContainer.current) {
      setActivatorNode(activatorContainer.current.firstElementChild);
    } else if (activatorNode && activatorContainer.current && !activatorContainer.current.contains(activatorNode)) {
      setActivatorNode(activatorContainer.current.firstElementChild);
    }

    setAccessibilityAttributes();
  }, [activatorNode, setAccessibilityAttributes]);
  useEffect(function () {
    if (activatorNode && activatorContainer.current) {
      setActivatorNode(activatorContainer.current.firstElementChild);
    }

    setAccessibilityAttributes();
  }, [activatorNode, setAccessibilityAttributes]);
  var portal = activatorNode ? React__default.createElement(Portal, {
    idPrefix: "popover"
  }, React__default.createElement(PopoverOverlay, Object.assign({
    id: id,
    activator: activatorNode,
    onClose: handleClose,
    active: active,
    fixed: fixed
  }, rest), children)) : null;
  return React__default.createElement(WrapperComponent, {
    ref: activatorContainer
  }, React__default.Children.only(activator), portal);
};

function isInPortal(element) {
  var parentElement = element.parentElement;

  while (parentElement) {
    if (parentElement.matches(portal.selector)) return false;
    parentElement = parentElement.parentElement;
  }

  return true;
}

Popover.Pane = Pane;
Popover.Section = Section$1;

var styles$c = {
  "Stack": "Polaris-Stack",
  "Item": "Polaris-Stack__Item",
  "noWrap": "Polaris-Stack--noWrap",
  "spacingNone": "Polaris-Stack--spacingNone",
  "spacingExtraTight": "Polaris-Stack--spacingExtraTight",
  "spacingTight": "Polaris-Stack--spacingTight",
  "spacingLoose": "Polaris-Stack--spacingLoose",
  "spacingExtraLoose": "Polaris-Stack--spacingExtraLoose",
  "distributionLeading": "Polaris-Stack--distributionLeading",
  "distributionTrailing": "Polaris-Stack--distributionTrailing",
  "distributionCenter": "Polaris-Stack--distributionCenter",
  "distributionEqualSpacing": "Polaris-Stack--distributionEqualSpacing",
  "distributionFill": "Polaris-Stack--distributionFill",
  "distributionFillEvenly": "Polaris-Stack--distributionFillEvenly",
  "alignmentLeading": "Polaris-Stack--alignmentLeading",
  "alignmentTrailing": "Polaris-Stack--alignmentTrailing",
  "alignmentCenter": "Polaris-Stack--alignmentCenter",
  "alignmentFill": "Polaris-Stack--alignmentFill",
  "alignmentBaseline": "Polaris-Stack--alignmentBaseline",
  "vertical": "Polaris-Stack--vertical",
  "Item-fill": "Polaris-Stack__Item--fill"
};

function Item$2(_ref) {
  var children = _ref.children,
      fill = _ref.fill;
  var className = classNames(styles$c.Item, fill && styles$c['Item-fill']);
  return React__default.createElement("div", {
    className: className
  }, children);
}

var Stack =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Stack, _React$PureComponent);

  function Stack() {
    _classCallCheck(this, Stack);

    return _possibleConstructorReturn(this, _getPrototypeOf(Stack).apply(this, arguments));
  }

  _createClass(Stack, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          vertical = _this$props.vertical,
          spacing = _this$props.spacing,
          distribution = _this$props.distribution,
          alignment = _this$props.alignment,
          wrap = _this$props.wrap;
      var className = classNames(styles$c.Stack, vertical && styles$c.vertical, spacing && styles$c[variationName('spacing', spacing)], distribution && styles$c[variationName('distribution', distribution)], alignment && styles$c[variationName('alignment', alignment)], wrap === false && styles$c.noWrap);
      var itemMarkup = elementChildren(children).map(function (child, index) {
        var props = {
          key: index
        };
        return wrapWithComponent(child, Item$2, props);
      });
      return React__default.createElement("div", {
        className: className
      }, itemMarkup);
    }
  }]);

  return Stack;
}(React__default.PureComponent);
Stack.Item = Item$2;

var styles$d = {
  "Heading": "Polaris-Heading"
};

function Heading(_ref) {
  var _ref$element = _ref.element,
      Element = _ref$element === void 0 ? 'h2' : _ref$element,
      children = _ref.children;
  return React__default.createElement(Element, {
    className: styles$d.Heading
  }, children);
}

var styles$e = {
  "Card": "Polaris-Card",
  "subdued": "Polaris-Card--subdued",
  "Header": "Polaris-Card__Header",
  "Section": "Polaris-Card__Section",
  "Section-fullWidth": "Polaris-Card__Section--fullWidth",
  "Section-subdued": "Polaris-Card__Section--subdued",
  "SectionHeader": "Polaris-Card__SectionHeader",
  "Subsection": "Polaris-Card__Subsection",
  "Footer": "Polaris-Card__Footer",
  "LeftJustified": "Polaris-Card__LeftJustified"
};

function Header(_ref) {
  var children = _ref.children,
      title = _ref.title,
      actions = _ref.actions;
  var actionMarkup = actions ? React__default.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  var titleMarkup = React__default.isValidElement(title) ? title : React__default.createElement(Heading, null, title);
  var headingMarkup = actionMarkup || children ? React__default.createElement(Stack, {
    alignment: "baseline"
  }, React__default.createElement(Stack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children) : titleMarkup;
  return React__default.createElement("div", {
    className: styles$e.Header
  }, headingMarkup);
}

var styles$f = {
  "Subheading": "Polaris-Subheading"
};

function Subheading(_ref) {
  var _ref$element = _ref.element,
      Element = _ref$element === void 0 ? 'h3' : _ref$element,
      children = _ref.children;
  var ariaLabel = typeof children === 'string' ? children : undefined;
  return React__default.createElement(Element, {
    "aria-label": ariaLabel,
    className: styles$f.Subheading
  }, children);
}

function Section$2(_ref) {
  var children = _ref.children,
      title = _ref.title,
      subdued = _ref.subdued,
      fullWidth = _ref.fullWidth,
      actions = _ref.actions;
  var className = classNames(styles$e.Section, subdued && styles$e['Section-subdued'], fullWidth && styles$e['Section-fullWidth']);
  var actionMarkup = actions ? React__default.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  var titleMarkup = typeof title === 'string' ? React__default.createElement(Subheading, null, title) : title;
  var titleAreaMarkup = titleMarkup || actionMarkup ? React__default.createElement("div", {
    className: styles$e.SectionHeader
  }, actionMarkup ? React__default.createElement(Stack, {
    alignment: "baseline"
  }, React__default.createElement(Stack.Item, {
    fill: true
  }, titleMarkup), actionMarkup) : titleMarkup) : null;
  return React__default.createElement("div", {
    className: className
  }, titleAreaMarkup, children);
}

function Subsection(_ref) {
  var children = _ref.children;
  return React__default.createElement("div", {
    className: styles$e.Subsection
  }, children);
}

// subcomponents so explicitly state the subcomponents in the type definition.
// Letting this be implicit works in this project but fails in projects that use
// generated *.d.ts files.

var Card = function Card(_ref) {
  var children = _ref.children,
      title = _ref.title,
      subdued = _ref.subdued,
      sectioned = _ref.sectioned,
      actions = _ref.actions,
      primaryFooterAction = _ref.primaryFooterAction,
      secondaryFooterActions = _ref.secondaryFooterActions,
      secondaryFooterActionsDisclosureText = _ref.secondaryFooterActionsDisclosureText,
      _ref$footerActionAlig = _ref.footerActionAlignment,
      footerActionAlignment = _ref$footerActionAlig === void 0 ? 'right' : _ref$footerActionAlig;
  var i18n = useI18n();

  var _useToggle = useToggle(false),
      secondaryActionsPopoverOpen = _useToggle.value,
      toggleSecondaryActionsPopoverOpen = _useToggle.toggle;

  var className = classNames(styles$e.Card, subdued && styles$e.subdued);
  var headerMarkup = title || actions ? React__default.createElement(Header, {
    actions: actions,
    title: title
  }) : null;
  var content = sectioned ? React__default.createElement(Section$2, null, children) : children;
  var primaryFooterActionMarkup = primaryFooterAction ? buttonFrom(primaryFooterAction, {
    primary: true
  }) : null;
  var secondaryFooterActionsMarkup = null;

  if (secondaryFooterActions && secondaryFooterActions.length) {
    if (secondaryFooterActions.length === 1) {
      secondaryFooterActionsMarkup = buttonFrom(secondaryFooterActions[0]);
    } else {
      secondaryFooterActionsMarkup = React__default.createElement(React__default.Fragment, null, React__default.createElement(Popover, {
        active: secondaryActionsPopoverOpen,
        activator: React__default.createElement(Button, {
          disclosure: true,
          onClick: toggleSecondaryActionsPopoverOpen
        }, secondaryFooterActionsDisclosureText || i18n.translate('Polaris.Common.more')),
        onClose: toggleSecondaryActionsPopoverOpen
      }, React__default.createElement(ActionList, {
        items: secondaryFooterActions
      })));
    }
  }

  var footerMarkup = primaryFooterActionMarkup || secondaryFooterActionsMarkup ? React__default.createElement("div", {
    className: classNames(styles$e.Footer, footerActionAlignment === 'left' && styles$e.LeftJustified)
  }, footerActionAlignment === 'right' ? React__default.createElement(ButtonGroup, null, secondaryFooterActionsMarkup, primaryFooterActionMarkup) : React__default.createElement(ButtonGroup, null, primaryFooterActionMarkup, secondaryFooterActionsMarkup)) : null;
  return React__default.createElement(WithinContentContext.Provider, {
    value: true
  }, React__default.createElement("div", {
    className: className
  }, headerMarkup, content, footerMarkup));
};
Card.Header = Header;
Card.Section = Section$2;
Card.Subsection = Subsection;

var styles$g = {
  "SettingAction": "Polaris-SettingAction",
  "Setting": "Polaris-SettingAction__Setting",
  "Action": "Polaris-SettingAction__Action"
};

function SettingAction(_ref) {
  var action = _ref.action,
      children = _ref.children;
  return React__default.createElement("div", {
    className: styles$g.SettingAction
  }, React__default.createElement("div", {
    className: styles$g.Setting
  }, children), React__default.createElement("div", {
    className: styles$g.Action
  }, action));
}

var styles$h = {
  "TermsOfService": "Polaris-AccountConnection__TermsOfService",
  "Content": "Polaris-AccountConnection__Content"
};

function AccountConnection(_ref) {
  var _ref$connected = _ref.connected,
      connected = _ref$connected === void 0 ? false : _ref$connected,
      action = _ref.action,
      avatarUrl = _ref.avatarUrl,
      _ref$accountName = _ref.accountName,
      accountName = _ref$accountName === void 0 ? '' : _ref$accountName,
      title = _ref.title,
      details = _ref.details,
      termsOfService = _ref.termsOfService;
  var initials = accountName ? accountName.split(/\s+/).map(function (name) {
    return name[0];
  }).join('') : undefined;
  var avatarMarkup = connected ? React__default.createElement(Avatar, {
    accessibilityLabel: "",
    name: accountName,
    initials: initials,
    source: avatarUrl
  }) : null;
  var titleMarkup = null;

  if (title) {
    titleMarkup = React__default.createElement("div", null, title);
  } else if (accountName) {
    titleMarkup = React__default.createElement("div", null, accountName);
  }

  var detailsMarkup = details ? React__default.createElement("div", null, React__default.createElement(TextStyle, {
    variation: "subdued"
  }, details)) : null;
  var termsOfServiceMarkup = termsOfService ? React__default.createElement("div", {
    className: styles$h.TermsOfService
  }, termsOfService) : null;
  var actionElement = action ? buttonFrom(action, {
    primary: !connected
  }) : null;
  return React__default.createElement(Card, {
    sectioned: true
  }, React__default.createElement(SettingAction, {
    action: actionElement
  }, React__default.createElement(Stack, null, avatarMarkup, React__default.createElement(Stack.Item, {
    fill: true
  }, React__default.createElement("div", {
    className: styles$h.Content
  }, titleMarkup, detailsMarkup)))), termsOfServiceMarkup);
}

var styles$i = {
  "MenuAction": "Polaris-ActionMenu-MenuAction",
  "IconWrapper": "Polaris-ActionMenu-MenuAction__IconWrapper",
  "disabled": "Polaris-ActionMenu-MenuAction--disabled",
  "ContentWrapper": "Polaris-ActionMenu-MenuAction__ContentWrapper"
};

function MenuAction(_ref) {
  var content = _ref.content,
      accessibilityLabel = _ref.accessibilityLabel,
      url = _ref.url,
      external = _ref.external,
      icon = _ref.icon,
      disclosure = _ref.disclosure,
      disabled = _ref.disabled,
      onAction = _ref.onAction;
  var iconMarkup = icon && React__default.createElement("span", {
    className: styles$i.IconWrapper
  }, React__default.createElement(Icon, {
    source: icon
  }));
  var disclosureIconMarkup = disclosure && React__default.createElement("span", {
    className: styles$i.IconWrapper
  }, React__default.createElement(Icon, {
    source: CaretDownMinor
  }));
  var contentMarkup = iconMarkup || disclosureIconMarkup ? React__default.createElement("span", {
    className: styles$i.ContentWrapper
  }, iconMarkup, React__default.createElement("span", {
    className: styles$i.Content
  }, content), disclosureIconMarkup) : content;
  var menuActionClassNames = classNames(styles$i.MenuAction, disabled && styles$i.disabled);

  if (url) {
    return React__default.createElement(UnstyledLink, {
      className: menuActionClassNames,
      url: url,
      external: external,
      "aria-label": accessibilityLabel,
      onMouseUp: handleMouseUpByBlurring
    }, contentMarkup);
  }

  return React__default.createElement("button", {
    type: "button",
    className: menuActionClassNames,
    disabled: disabled,
    "aria-label": accessibilityLabel,
    onClick: onAction,
    onMouseUp: handleMouseUpByBlurring
  }, contentMarkup);
}

var styles$j = {
  "Details": "Polaris-ActionMenu-MenuGroup__Details"
};

var MenuGroup =
/*#__PURE__*/
function (_React$Component) {
  _inherits(MenuGroup, _React$Component);

  function MenuGroup() {
    var _this;

    _classCallCheck(this, MenuGroup);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(MenuGroup).apply(this, arguments));

    _this.handleClose = function () {
      var _this$props = _this.props,
          title = _this$props.title,
          onClose = _this$props.onClose;
      onClose(title);
    };

    _this.handleOpen = function () {
      var _this$props2 = _this.props,
          title = _this$props2.title,
          onOpen = _this$props2.onOpen;
      onOpen(title);
    };

    return _this;
  }

  _createClass(MenuGroup, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          accessibilityLabel = _this$props3.accessibilityLabel,
          active = _this$props3.active,
          actions = _this$props3.actions,
          details = _this$props3.details,
          title = _this$props3.title,
          icon = _this$props3.icon;

      if (!actions.length) {
        return null;
      }

      var popoverActivator = React__default.createElement(MenuAction, {
        disclosure: true,
        content: title,
        icon: icon,
        accessibilityLabel: accessibilityLabel,
        onAction: this.handleOpen
      });
      return React__default.createElement(Popover, {
        active: Boolean(active),
        activator: popoverActivator,
        preferredAlignment: "left",
        onClose: this.handleClose
      }, React__default.createElement(ActionList, {
        items: actions,
        onActionAnyItem: this.handleClose
      }), details && React__default.createElement("div", {
        className: styles$j.Details
      }, details));
    }
  }]);

  return MenuGroup;
}(React__default.Component);

var styles$k = {
  "RollupActivator": "Polaris-ActionMenu-RollupActions__RollupActivator"
};

function RollupActions(_ref) {
  var _ref$items = _ref.items,
      items = _ref$items === void 0 ? [] : _ref$items,
      _ref$sections = _ref.sections,
      sections = _ref$sections === void 0 ? [] : _ref$sections;
  var i18n = useI18n();

  var _useToggle = useToggle(false),
      rollupOpen = _useToggle.value,
      toggleRollupOpen = _useToggle.toggle;

  if (items.length === 0 && sections.length === 0) {
    return null;
  }

  var activatorMarkup = React__default.createElement("div", {
    className: styles$k.RollupActivator
  }, React__default.createElement(Button, {
    plain: true,
    icon: HorizontalDotsMinor,
    accessibilityLabel: i18n.translate('Polaris.ActionMenu.RollupActions.rollupButton'),
    onClick: toggleRollupOpen
  }));
  return React__default.createElement(Popover, {
    active: rollupOpen,
    activator: activatorMarkup,
    preferredAlignment: "right",
    onClose: toggleRollupOpen
  }, React__default.createElement(ActionList, {
    items: items,
    sections: sections,
    onActionAnyItem: toggleRollupOpen
  }));
}

var styles$l = {
  "ActionMenu": "Polaris-ActionMenu",
  "rollup": "Polaris-ActionMenu--rollup",
  "ActionsLayout": "Polaris-ActionMenu__ActionsLayout"
};

var ActionMenu =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ActionMenu, _React$PureComponent);

  function ActionMenu() {
    var _this;

    _classCallCheck(this, ActionMenu);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ActionMenu).apply(this, arguments));
    _this.state = {
      activeMenuGroup: undefined
    };

    _this.renderActions = function () {
      var _this$props = _this.props,
          _this$props$actions = _this$props.actions,
          actions = _this$props$actions === void 0 ? [] : _this$props$actions,
          _this$props$groups = _this$props.groups,
          groups = _this$props$groups === void 0 ? [] : _this$props$groups;
      var activeMenuGroup = _this.state.activeMenuGroup;
      var actionsMarkup = actions.length > 0 ? actions.map(function (_a, index) {
        var content = _a.content,
            action = __rest(_a, ["content"]);

        return React__default.createElement(MenuAction, Object.assign({
          key: "MenuAction-".concat(content || index),
          content: content
        }, action));
      }) : null;
      var groupsMarkup = hasGroupsWithActions(groups) ? groups.map(function (_a, index) {
        var title = _a.title,
            rest = __rest(_a, ["title"]);

        return React__default.createElement(MenuGroup, Object.assign({
          key: "MenuGroup-".concat(title || index),
          title: title,
          active: title === activeMenuGroup
        }, rest, {
          onOpen: _this.handleMenuGroupToggle,
          onClose: _this.handleMenuGroupClose
        }));
      }) : null;
      return actionsMarkup || groupsMarkup ? React__default.createElement("div", {
        className: styles$l.ActionsLayout
      }, actionsMarkup, groupsMarkup) : null;
    };

    _this.handleMenuGroupToggle = function (group) {
      _this.setState(function (_ref) {
        var activeMenuGroup = _ref.activeMenuGroup;
        return {
          activeMenuGroup: activeMenuGroup ? undefined : group
        };
      });
    };

    _this.handleMenuGroupClose = function () {
      _this.setState({
        activeMenuGroup: undefined
      });
    };

    return _this;
  }

  _createClass(ActionMenu, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          _this$props2$actions = _this$props2.actions,
          actions = _this$props2$actions === void 0 ? [] : _this$props2$actions,
          _this$props2$groups = _this$props2.groups,
          groups = _this$props2$groups === void 0 ? [] : _this$props2$groups,
          rollup = _this$props2.rollup;

      if (actions.length === 0 && groups.length === 0) {
        return null;
      }

      var actionMenuClassNames = classNames(styles$l.ActionMenu, rollup && styles$l.rollup);
      var rollupSections = groups.map(function (group) {
        return convertGroupToSection(group);
      });
      return React__default.createElement("div", {
        className: actionMenuClassNames
      }, rollup ? React__default.createElement(RollupActions, {
        items: actions,
        sections: rollupSections
      }) : this.renderActions());
    }
  }]);

  return ActionMenu;
}(React__default.PureComponent);
function hasGroupsWithActions() {
  var groups = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return groups.length === 0 ? false : groups.some(function (group) {
    return group.actions.length > 0;
  });
}
function convertGroupToSection(_ref2) {
  var title = _ref2.title,
      actions = _ref2.actions;
  return {
    title,
    items: actions
  };
}

function ThemeProvider(_ref) {
  var themeConfig = _ref.theme,
      children = _ref.children;

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  var parentContext = useContext(ThemeContext);
  var isParentThemeProvider = parentContext === undefined;
  var parentColorScheme = parentContext && parentContext.colorScheme && parentContext.colorScheme;
  var parentColors = parentContext && parentContext.UNSTABLE_colors && parentContext.UNSTABLE_colors;

  var UNSTABLE_colors = themeConfig.UNSTABLE_colors,
      colorScheme = themeConfig.colorScheme,
      rest = __rest(themeConfig, ["UNSTABLE_colors", "colorScheme"]);

  var processedThemeConfig = Object.assign(Object.assign(Object.assign({}, rest), {
    colorScheme: getColorScheme(colorScheme, parentColorScheme)
  }), {
    UNSTABLE_colors: Object.assign(Object.assign(Object.assign({}, isParentThemeProvider && DefaultThemeColors), shouldInheritParentColors(isParentThemeProvider, colorScheme, parentColorScheme) && parentColors), UNSTABLE_colors)
  });
  var customProperties = useMemo(function () {
    return buildCustomProperties(processedThemeConfig, unstableGlobalTheming, Tokens);
  }, [processedThemeConfig, unstableGlobalTheming]);
  var theme = useMemo(function () {
    return buildThemeContext(processedThemeConfig, unstableGlobalTheming ? customProperties : undefined);
  }, [customProperties, processedThemeConfig, unstableGlobalTheming]); // We want these values to be empty string instead of `undefined` when not set.
  // Otherwise, setting a style property to `undefined` does not remove it from the DOM.

  var backgroundColor = customProperties['--p-background'] || '';
  var color = customProperties['--p-text'] || '';
  useEffect(function () {
    if (isParentThemeProvider) {
      document.body.style.backgroundColor = backgroundColor;
      document.body.style.color = color;
    }
  }, [backgroundColor, color, isParentThemeProvider]);
  var style = Object.assign(Object.assign({}, customProperties), !isParentThemeProvider && {
    color
  });
  return React__default.createElement(ThemeContext.Provider, {
    value: Object.assign(Object.assign({}, theme), {
      textColor: color
    })
  }, React__default.createElement("div", {
    style: style
  }, children));
}

function isInverseColorScheme(colorScheme) {
  return colorScheme === 'inverse';
}

function getColorScheme(colorScheme, parentColorScheme) {
  if (colorScheme == null) {
    return parentColorScheme || DefaultColorScheme;
  } else if (isInverseColorScheme(colorScheme)) {
    return parentColorScheme === 'dark' || parentColorScheme === undefined ? 'light' : 'dark';
  } else {
    return colorScheme;
  }
}

function shouldInheritParentColors(isParentThemeProvider, colorScheme, parentColorScheme) {
  if (isParentThemeProvider) {
    return false;
  } else if (isInverseColorScheme(colorScheme) || colorScheme === 'dark' && parentColorScheme === 'light' || colorScheme === 'light' && parentColorScheme === 'dark') {
    return true;
  } else {
    return false;
  }
}

var MediaQueryContext = React__default.createContext(undefined);

function useMediaQuery() {
  var mediaQuery = useContext(MediaQueryContext);

  if (!mediaQuery) {
    throw new Error('No mediaQuery was provided. Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/structure/app-provider for implementation instructions.');
  }

  return mediaQuery;
}

var MediaQueryProvider = function MediaQueryProvider(_ref) {
  var children = _ref.children;

  var _useState = useState(navigationBarCollapsed().matches),
      _useState2 = _slicedToArray(_useState, 2),
      isNavigationCollapsed = _useState2[0],
      setIsNavigationCollapsed = _useState2[1];

  var handleResize = useCallback(debounce(function () {
    if (isNavigationCollapsed !== navigationBarCollapsed().matches) {
      setIsNavigationCollapsed(!isNavigationCollapsed);
    }
  }, 40, {
    trailing: true,
    leading: true,
    maxWait: 40
  }), [isNavigationCollapsed]);
  useEffect(function () {
    setIsNavigationCollapsed(navigationBarCollapsed().matches);
  }, []);
  return React__default.createElement(MediaQueryContext.Provider, {
    value: {
      isNavigationCollapsed
    }
  }, React__default.createElement(EventListener, {
    event: "resize",
    handler: handleResize
  }), children);
};

var ScrollLockManagerContext = React__default.createContext(undefined);

function useScrollLockManager() {
  var scrollLockManager = useContext(ScrollLockManagerContext);

  if (!scrollLockManager) {
    throw new MissingAppProviderError('No ScrollLockManager was provided.');
  }

  return scrollLockManager;
}

var SCROLL_LOCKING_ATTRIBUTE = 'data-lock-scrolling';
var SCROLL_LOCKING_WRAPPER_ATTRIBUTE = 'data-lock-scrolling-wrapper';
var scrollPosition = 0;
var ScrollLockManager =
/*#__PURE__*/
function () {
  function ScrollLockManager() {
    _classCallCheck(this, ScrollLockManager);

    this.scrollLocks = 0;
    this.locked = false;
  }

  _createClass(ScrollLockManager, [{
    key: "registerScrollLock",
    value: function registerScrollLock() {
      this.scrollLocks += 1;
      this.handleScrollLocking();
    }
  }, {
    key: "unregisterScrollLock",
    value: function unregisterScrollLock() {
      this.scrollLocks -= 1;
      this.handleScrollLocking();
    }
  }, {
    key: "handleScrollLocking",
    value: function handleScrollLocking() {
      if (isServer) return;
      var scrollLocks = this.scrollLocks;
      var _document = document,
          body = _document.body;
      var wrapper = body.firstElementChild;

      if (scrollLocks === 0) {
        body.removeAttribute(SCROLL_LOCKING_ATTRIBUTE);

        if (wrapper) {
          wrapper.removeAttribute(SCROLL_LOCKING_WRAPPER_ATTRIBUTE);
        }

        window.scroll(0, scrollPosition);
        this.locked = false;
      } else if (scrollLocks > 0 && !this.locked) {
        scrollPosition = window.pageYOffset;
        body.setAttribute(SCROLL_LOCKING_ATTRIBUTE, '');

        if (wrapper) {
          wrapper.setAttribute(SCROLL_LOCKING_WRAPPER_ATTRIBUTE, '');
          wrapper.scrollTop = scrollPosition;
        }

        this.locked = true;
      }
    }
  }, {
    key: "resetScrollPosition",
    value: function resetScrollPosition() {
      scrollPosition = 0;
    }
  }]);

  return ScrollLockManager;
}();

var AppBridgeContext = React__default.createContext(undefined);

function useAppBridge() {
  return useContext(AppBridgeContext);
}

function createAppBridge(_ref) {
  var apiKey = _ref.apiKey,
      shopOrigin = _ref.shopOrigin,
      forceRedirect = _ref.forceRedirect;
  var appBridge = apiKey ? createApp({
    apiKey,
    shopOrigin: shopOrigin || getShopOrigin(),
    forceRedirect
  }) : undefined;

  if (appBridge !== undefined) {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: Using `apiKey` and `shopOrigin` on `AppProvider` to initialize the Shopify App Bridge is deprecated. Support for this will be removed in v5.0. Use `Provider` from `@shopify/app-bridge-react` instead: https://help.shopify.com/en/api/embedded-apps/app-bridge/react-components/provider');
  }

  if (appBridge && appBridge.hooks) {
    appBridge.hooks.set(LifecycleHook.DispatchAction, setClientInterfaceHook);
  }

  return appBridge;
}
var setClientInterfaceHook = function setClientInterfaceHook(next) {
  return function (action) {
    action.clientInterface = {
      name: '@shopify/polaris',
      version: polarisVersion
    };
    return next(action);
  };
};

var AppProvider =
/*#__PURE__*/
function (_React$Component) {
  _inherits(AppProvider, _React$Component);

  function AppProvider(props) {
    var _this;

    _classCallCheck(this, AppProvider);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AppProvider).call(this, props));
    _this.stickyManager = new StickyManager();
    _this.scrollLockManager = new ScrollLockManager();
    _this.uniqueIdFactory = new UniqueIdFactory(globalIdGeneratorFactory);
    var _this$props = _this.props,
        i18n = _this$props.i18n,
        apiKey = _this$props.apiKey,
        shopOrigin = _this$props.shopOrigin,
        forceRedirect = _this$props.forceRedirect,
        linkComponent = _this$props.linkComponent; // eslint-disable-next-line react/state-in-constructor

    _this.state = {
      link: linkComponent,
      intl: new I18n(i18n),
      appBridge: createAppBridge({
        shopOrigin,
        apiKey,
        forceRedirect
      })
    };
    return _this;
  }

  _createClass(AppProvider, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (document != null) {
        this.stickyManager.setContainer(document);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref) {
      var prevI18n = _ref.i18n,
          prevLinkComponent = _ref.linkComponent,
          prevApiKey = _ref.apiKey,
          prevShopOrigin = _ref.shopOrigin,
          prevForceRedirect = _ref.forceRedirect;
      var _this$props2 = this.props,
          i18n = _this$props2.i18n,
          linkComponent = _this$props2.linkComponent,
          apiKey = _this$props2.apiKey,
          shopOrigin = _this$props2.shopOrigin,
          forceRedirect = _this$props2.forceRedirect;

      if (i18n === prevI18n && linkComponent === prevLinkComponent && apiKey === prevApiKey && shopOrigin === prevShopOrigin && forceRedirect === prevForceRedirect) {
        return;
      } // eslint-disable-next-line react/no-did-update-set-state


      this.setState({
        link: linkComponent,
        intl: new I18n(i18n),
        appBridge: createAppBridge({
          shopOrigin,
          apiKey,
          forceRedirect
        })
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          _this$props3$theme = _this$props3.theme,
          theme = _this$props3$theme === void 0 ? {} : _this$props3$theme,
          _this$props3$features = _this$props3.features,
          features = _this$props3$features === void 0 ? {} : _this$props3$features,
          UNSTABLE_telemetry = _this$props3.UNSTABLE_telemetry,
          children = _this$props3.children;
      var _this$state = this.state,
          intl = _this$state.intl,
          appBridge = _this$state.appBridge,
          link = _this$state.link;
      return React__default.createElement(FeaturesContext.Provider, {
        value: features
      }, React__default.createElement(I18nContext.Provider, {
        value: intl
      }, React__default.createElement(ScrollLockManagerContext.Provider, {
        value: this.scrollLockManager
      }, React__default.createElement(StickyManagerContext.Provider, {
        value: this.stickyManager
      }, React__default.createElement(UniqueIdFactoryContext.Provider, {
        value: this.uniqueIdFactory
      }, React__default.createElement(AppBridgeContext.Provider, {
        value: appBridge
      }, React__default.createElement(LinkContext.Provider, {
        value: link
      }, React__default.createElement(ThemeProvider, {
        theme: theme
      }, React__default.createElement(TelemetryContext.Provider, {
        value: UNSTABLE_telemetry
      }, React__default.createElement(MediaQueryProvider, null, children))))))))));
    }
  }]);

  return AppProvider;
}(React__default.Component);

function arraysAreEqual(firstArray, secondArray, comparator) {
  if (firstArray.length !== secondArray.length) {
    return false;
  }

  return firstArray.every(function (firstItem, index) {
    var secondItem = secondArray[index];

    if (comparator != null) {
      return comparator(firstItem, secondItem);
    }

    return firstItem === secondItem;
  });
}

/**
 * Allows for custom or deep comparison of a dependency list. Useful to keep a consistent dependency
 * list across reference changes.
 * @param dependencies A dependency array similar to React.useEffect/React.useCallback/React.useMemo
 * @param comparator An optional function to compare dependencies that'll default to a deep comparison
 * @returns A dependency list
 * @see {@link https://github.com/Shopify/polaris-react/blob/master/src/utilities/use-deep-effect.tsx}
 * @see {@link https://github.com/Shopify/polaris-react/blob/master/src/utilities/use-deep-callback.tsx}
 * @example
 * function useDeepEffectExample(callback, dependencies, customCompare) {
 *  useEffect(callback, useDeepCompareRef(dependencies, customCompare));
 * }
 */

function useDeepCompareRef(dependencies) {
  var comparator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : isEqual;
  var dependencyList = useRef(dependencies);

  if (!comparator(dependencyList.current, dependencies)) {
    dependencyList.current = dependencies;
  }

  return dependencyList.current;
}

/**
 * A replacement for React.useEffect that'll allow for custom and deep
 * compares of the dependency list.
 * @see {@link https://reactjs.org/docs/hooks-reference.html#useeffect}
 * @param callback Accepts a callback that's forwarded to React.useEffect
 * @param dependencies A dependency array similar to React.useEffect however it utilizes a deep compare
 * @param customCompare Opportunity to provide a custom compare function
 * @example
 * function ComponentExample() {
 *  const [, forceUpdate] = useState();
 *  const obj = {a: 1};
 *
 *  useDeepEffect(() => {
 *    console.log('useDeepEffect invocation');
 *    forceUpdate(obj);
 *  }, [obj]);
 *
 *  return null;
 * }
 */

function useDeepEffect(callback, dependencies, customCompare) {
  useEffect(callback, useDeepCompareRef(dependencies, customCompare));
}

var styles$m = {
  "Checkbox": "Polaris-OptionList-Checkbox",
  "Input": "Polaris-OptionList-Checkbox__Input",
  "Backdrop": "Polaris-OptionList-Checkbox__Backdrop",
  "Icon": "Polaris-OptionList-Checkbox__Icon",
  "active": "Polaris-OptionList-Checkbox--active"
};

function Checkbox(_ref) {
  var idProp = _ref.id,
      _ref$checked = _ref.checked,
      checked = _ref$checked === void 0 ? false : _ref$checked,
      disabled = _ref.disabled,
      active = _ref.active,
      onChange = _ref.onChange,
      name = _ref.name,
      value = _ref.value,
      role = _ref.role;
  var id = useUniqueId('Checkbox', idProp);
  var className = classNames(styles$m.Checkbox, active && styles$m.active);
  return React__default.createElement("div", {
    className: className
  }, React__default.createElement("input", {
    id: id,
    name: name,
    value: value,
    type: "checkbox",
    checked: checked,
    disabled: disabled,
    className: styles$m.Input,
    "aria-checked": checked,
    onChange: onChange,
    role: role
  }), React__default.createElement("div", {
    className: styles$m.Backdrop
  }), React__default.createElement("div", {
    className: styles$m.Icon
  }, React__default.createElement(Icon, {
    source: TickSmallMinor
  })));
}

var styles$n = {
  "Option": "Polaris-OptionList-Option",
  "SingleSelectOption": "Polaris-OptionList-Option__SingleSelectOption",
  "disabled": "Polaris-OptionList-Option--disabled",
  "Media": "Polaris-OptionList-Option__Media",
  "Label": "Polaris-OptionList-Option__Label",
  "Checkbox": "Polaris-OptionList-Option__Checkbox",
  "focused": "Polaris-OptionList-Option--focused",
  "select": "Polaris-OptionList-Option--select",
  "active": "Polaris-OptionList-Option--active"
};

var Option =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Option, _React$Component);

  function Option() {
    var _this;

    _classCallCheck(this, Option);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Option).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleClick = function () {
      var _this$props = _this.props,
          onClick = _this$props.onClick,
          section = _this$props.section,
          index = _this$props.index,
          disabled = _this$props.disabled;

      if (disabled) {
        return;
      }

      onClick(section, index);
    };

    _this.toggleFocus = function () {
      _this.setState(function (prevState) {
        return {
          focused: !prevState.focused
        };
      });
    };

    return _this;
  }

  _createClass(Option, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          label = _this$props2.label,
          value = _this$props2.value,
          id = _this$props2.id,
          select = _this$props2.select,
          active = _this$props2.active,
          allowMultiple = _this$props2.allowMultiple,
          disabled = _this$props2.disabled,
          role = _this$props2.role,
          media = _this$props2.media;
      var focused = this.state.focused;
      var mediaMarkup = media ? React__default.createElement("div", {
        className: styles$n.Media
      }, media) : null;
      var singleSelectClassName = classNames(styles$n.SingleSelectOption, focused && styles$n.focused, disabled && styles$n.disabled, select && styles$n.select, active && styles$n.active);
      var multiSelectClassName = classNames(styles$n.Label, active && styles$n.active);
      var checkBoxRole = role === 'option' ? 'presentation' : undefined;
      var optionMarkup = allowMultiple ? React__default.createElement("label", {
        htmlFor: id,
        className: multiSelectClassName
      }, React__default.createElement("div", {
        className: styles$n.Checkbox
      }, React__default.createElement(Checkbox, {
        id: id,
        value: value,
        checked: select,
        active: active,
        disabled: disabled,
        onChange: this.handleClick,
        role: checkBoxRole
      })), mediaMarkup, label) : React__default.createElement("button", {
        id: id,
        type: "button",
        className: singleSelectClassName,
        onClick: this.handleClick,
        disabled: disabled,
        onFocus: this.toggleFocus,
        onBlur: this.toggleFocus
      }, mediaMarkup, label);
      var scrollMarkup = active ? React__default.createElement(Scrollable.ScrollTo, null) : null;
      return React__default.createElement("li", {
        key: id,
        className: styles$n.Option,
        tabIndex: -1,
        "aria-selected": active,
        role: role
      }, scrollMarkup, optionMarkup);
    }
  }]);

  return Option;
}(React__default.Component);

var styles$o = {
  "OptionList": "Polaris-OptionList",
  "Options": "Polaris-OptionList__Options",
  "Title": "Polaris-OptionList__Title"
};

function OptionList(_ref) {
  var options = _ref.options,
      sections = _ref.sections,
      title = _ref.title,
      selected = _ref.selected,
      allowMultiple = _ref.allowMultiple,
      role = _ref.role,
      optionRole = _ref.optionRole,
      onChange = _ref.onChange,
      idProp = _ref.id;

  var _useState = useState(createNormalizedOptions(options, sections, title)),
      _useState2 = _slicedToArray(_useState, 2),
      normalizedOptions = _useState2[0],
      setNormalizedOptions = _useState2[1];

  var id = useUniqueId('OptionList', idProp);
  useDeepEffect(function () {
    setNormalizedOptions(createNormalizedOptions(options || [], sections || [], title));
  }, [options, sections, title], optionArraysAreEqual);
  var handleClick = useCallback(function (sectionIndex, optionIndex) {
    var selectedValue = normalizedOptions[sectionIndex].options[optionIndex].value;
    var foundIndex = selected.indexOf(selectedValue);

    if (allowMultiple) {
      var newSelection = foundIndex === -1 ? [selectedValue].concat(_toConsumableArray(selected)) : [].concat(_toConsumableArray(selected.slice(0, foundIndex)), _toConsumableArray(selected.slice(foundIndex + 1, selected.length)));
      onChange(newSelection);
      return;
    }

    onChange([selectedValue]);
  }, [normalizedOptions, selected, allowMultiple, onChange]);
  var optionsExist = normalizedOptions.length > 0;
  var optionsMarkup = optionsExist ? normalizedOptions.map(function (_ref2, sectionIndex) {
    var title = _ref2.title,
        options = _ref2.options;
    var titleMarkup = title ? React__default.createElement("p", {
      className: styles$o.Title,
      role: role
    }, title) : null;
    var optionsMarkup = options && options.map(function (option, optionIndex) {
      var isSelected = selected.includes(option.value);
      var optionId = option.id || "".concat(id, "-").concat(sectionIndex, "-").concat(optionIndex);
      return React__default.createElement(Option, Object.assign({}, option, {
        key: optionId,
        id: optionId,
        section: sectionIndex,
        index: optionIndex,
        onClick: handleClick,
        select: isSelected,
        allowMultiple: allowMultiple,
        role: optionRole
      }));
    });
    return React__default.createElement("li", {
      key: title || "noTitle-".concat(sectionIndex)
    }, titleMarkup, React__default.createElement("ul", {
      className: styles$o.Options,
      id: "".concat(id, "-").concat(sectionIndex),
      role: role,
      "aria-multiselectable": allowMultiple
    }, optionsMarkup));
  }) : null;
  return React__default.createElement("ul", {
    className: styles$o.OptionList,
    role: role
  }, optionsMarkup);
}

function createNormalizedOptions(options, sections, title) {
  if (options == null) {
    var section = {
      options: [],
      title
    };
    return sections == null ? [] : [section].concat(_toConsumableArray(sections));
  }

  if (sections == null) {
    return [{
      title,
      options
    }];
  }

  return [{
    title,
    options
  }].concat(_toConsumableArray(sections));
}

function isSection(arr) {
  return typeof arr[0] === 'object' && Object.prototype.hasOwnProperty.call(arr[0], 'options');
}

function optionArraysAreEqual(firstArray, secondArray) {
  if (isSection(firstArray) && isSection(secondArray)) {
    return arraysAreEqual(firstArray, secondArray, testSectionsPropEquality);
  }

  return arraysAreEqual(firstArray, secondArray);
}

function testSectionsPropEquality(previousSection, currentSection) {
  var previousOptions = previousSection.options;
  var currentOptions = currentSection.options;
  var optionsAreEqual = arraysAreEqual(previousOptions, currentOptions);
  var titlesAreEqual = previousSection.title === currentSection.title;
  return optionsAreEqual && titlesAreEqual;
}

var ComboBoxContext = React__default.createContext({});

var styles$p = {
  "EmptyState": "Polaris-Autocomplete-ComboBox__EmptyState"
};

var getUniqueId = createUniqueIDFactory('ComboBox');
var ComboBox =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ComboBox, _React$PureComponent);

  function ComboBox() {
    var _this;

    _classCallCheck(this, ComboBox);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ComboBox).apply(this, arguments));
    _this.state = {
      comboBoxId: _this.getComboBoxId(),
      selectedOption: undefined,
      selectedIndex: -1,
      selectedOptions: _this.props.selected,
      navigableOptions: [],
      popoverActive: false,
      popoverWasActive: false
    };

    _this.handleDownArrow = function () {
      _this.selectNextOption();

      _this.handlePopoverOpen;
    };

    _this.handleUpArrow = function () {
      _this.selectPreviousOption();

      _this.handlePopoverOpen;
    };

    _this.handleEnter = function (event) {
      if (event.keyCode !== Key.Enter) {
        return;
      }

      var selectedOption = _this.state.selectedOption;

      if (_this.state.popoverActive && selectedOption) {
        if (isOption(selectedOption)) {
          event.preventDefault();

          _this.handleSelection(selectedOption.value);
        } else {
          selectedOption.onAction && selectedOption.onAction();
        }
      }

      _this.handlePopoverOpen;
    };

    _this.handleFocus = function () {
      _this.setState({
        popoverActive: true,
        popoverWasActive: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        popoverActive: false,
        popoverWasActive: false
      }, function () {
        _this.resetVisuallySelectedOptions();
      });
    };

    _this.handleClick = function () {
      !_this.state.popoverActive && _this.setState({
        popoverActive: true
      });
    };

    _this.handleSelection = function (newSelected) {
      var _this$props = _this.props,
          selected = _this$props.selected,
          allowMultiple = _this$props.allowMultiple;
      var newlySelectedOptions = selected;

      if (selected.includes(newSelected)) {
        newlySelectedOptions.splice(newlySelectedOptions.indexOf(newSelected), 1);
      } else if (allowMultiple) {
        newlySelectedOptions.push(newSelected);
      } else {
        newlySelectedOptions = [newSelected];
      }

      _this.selectOptions(newlySelectedOptions);
    };

    _this.selectOptions = function (selected) {
      var _this$props2 = _this.props,
          onSelect = _this$props2.onSelect,
          allowMultiple = _this$props2.allowMultiple;
      selected && onSelect(selected);

      if (!allowMultiple) {
        _this.resetVisuallySelectedOptions();

        _this.setState({
          popoverActive: false,
          popoverWasActive: false
        });
      }
    };

    _this.updateIndexOfSelectedOption = function (newOptions) {
      var _this$state = _this.state,
          selectedIndex = _this$state.selectedIndex,
          selectedOption = _this$state.selectedOption;

      if (selectedOption && newOptions.includes(selectedOption)) {
        _this.selectOptionAtIndex(newOptions.indexOf(selectedOption));
      } else if (selectedIndex > newOptions.length - 1) {
        _this.resetVisuallySelectedOptions();
      } else {
        _this.selectOptionAtIndex(selectedIndex);
      }
    };

    _this.resetVisuallySelectedOptions = function () {
      var navigableOptions = _this.state.navigableOptions;

      _this.setState({
        selectedOption: undefined,
        selectedIndex: -1
      });

      navigableOptions && navigableOptions.forEach(function (option) {
        option.active = false;
      });
    };

    _this.handlePopoverClose = function () {
      _this.setState({
        popoverActive: false,
        popoverWasActive: false
      });
    };

    _this.handlePopoverOpen = function () {
      var _this$state2 = _this.state,
          popoverActive = _this$state2.popoverActive,
          navigableOptions = _this$state2.navigableOptions;
      !popoverActive && navigableOptions && navigableOptions.length > 0 && _this.setState({
        popoverActive: true,
        popoverWasActive: true
      });
    };

    _this.selectNextOption = function () {
      var _this$state3 = _this.state,
          selectedIndex = _this$state3.selectedIndex,
          navigableOptions = _this$state3.navigableOptions;

      if (!navigableOptions || navigableOptions.length === 0) {
        return;
      }

      var newIndex = selectedIndex;

      if (selectedIndex + 1 >= navigableOptions.length) {
        newIndex = 0;
      } else {
        newIndex++;
      }

      _this.selectOptionAtIndex(newIndex);
    };

    _this.selectPreviousOption = function () {
      var _this$state4 = _this.state,
          selectedIndex = _this$state4.selectedIndex,
          navigableOptions = _this$state4.navigableOptions;

      if (!navigableOptions || navigableOptions.length === 0) {
        return;
      }

      var newIndex = selectedIndex;

      if (selectedIndex <= 0) {
        newIndex = navigableOptions.length - 1;
      } else {
        newIndex--;
      }

      _this.selectOptionAtIndex(newIndex);
    };

    _this.selectOptionAtIndex = function (newOptionIndex) {
      _this.setState(function (prevState) {
        if (!prevState.navigableOptions || prevState.navigableOptions.length === 0) {
          return prevState;
        }

        var newSelectedOption = prevState.navigableOptions[newOptionIndex];

        _this.visuallyUpdateSelectedOption(newSelectedOption, prevState.selectedOption);

        return Object.assign(Object.assign({}, prevState), {
          selectedOption: newSelectedOption,
          selectedIndex: newOptionIndex
        });
      });
    };

    _this.visuallyUpdateSelectedOption = function (newOption, oldOption) {
      if (oldOption) {
        oldOption.active = false;
      }

      if (newOption) {
        newOption.active = true;
      }
    };

    return _this;
  }

  _createClass(ComboBox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props3 = this.props,
          options = _this$props3.options,
          actionsBefore = _this$props3.actionsBefore,
          actionsAfter = _this$props3.actionsAfter;
      var comboBoxId = this.getComboBoxId();
      var navigableOptions = [];

      if (actionsBefore) {
        navigableOptions = navigableOptions.concat(actionsBefore);
      }

      if (options) {
        navigableOptions = navigableOptions.concat(options);
      }

      if (actionsAfter) {
        navigableOptions = navigableOptions.concat(actionsAfter);
      }

      navigableOptions = assignOptionIds(navigableOptions, comboBoxId);
      this.setState({
        navigableOptions
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_, prevState) {
      var _this$props4 = this.props,
          contentBefore = _this$props4.contentBefore,
          contentAfter = _this$props4.contentAfter,
          emptyState = _this$props4.emptyState;
      var _this$state5 = this.state,
          navigableOptions = _this$state5.navigableOptions,
          popoverWasActive = _this$state5.popoverWasActive;
      var optionsChanged = navigableOptions && prevState.navigableOptions && !optionsAreEqual(navigableOptions, prevState.navigableOptions);

      if (optionsChanged) {
        this.updateIndexOfSelectedOption(navigableOptions);
      }

      if (navigableOptions && navigableOptions.length === 0 && !contentBefore && !contentAfter && !emptyState) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          popoverActive: false
        });
      } else if (popoverWasActive && navigableOptions && navigableOptions.length !== 0) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          popoverActive: true
        });
      }
    }
  }, {
    key: "getComboBoxId",
    value: function getComboBoxId() {
      if (this.state && this.state.comboBoxId) {
        return this.state.comboBoxId;
      }

      return this.props.id || getUniqueId();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props5 = this.props,
          options = _this$props5.options,
          textField = _this$props5.textField,
          listTitle = _this$props5.listTitle,
          allowMultiple = _this$props5.allowMultiple,
          preferredPosition = _this$props5.preferredPosition,
          actionsBefore = _this$props5.actionsBefore,
          actionsAfter = _this$props5.actionsAfter,
          contentBefore = _this$props5.contentBefore,
          contentAfter = _this$props5.contentAfter,
          onEndReached = _this$props5.onEndReached,
          emptyState = _this$props5.emptyState;
      var _this$state6 = this.state,
          comboBoxId = _this$state6.comboBoxId,
          navigableOptions = _this$state6.navigableOptions,
          selectedOptions = _this$state6.selectedOptions;
      var actionsBeforeMarkup = actionsBefore && actionsBefore.length > 0 && React__default.createElement(ActionList, {
        actionRole: "option",
        items: actionsBefore
      });
      var actionsAfterMarkup = actionsAfter && actionsAfter.length > 0 && React__default.createElement(ActionList, {
        actionRole: "option",
        items: actionsAfter
      });
      var optionsMarkup = options.length > 0 && React__default.createElement(OptionList, {
        role: "presentation",
        optionRole: "option",
        options: filterForOptions(navigableOptions),
        onChange: this.selectOptions,
        selected: selectedOptions,
        title: listTitle,
        allowMultiple: allowMultiple
      });
      var emptyStateMarkup = !actionsAfter && !actionsBefore && !contentAfter && !contentBefore && options.length === 0 && emptyState && React__default.createElement("div", {
        className: styles$p.EmptyState
      }, emptyState);
      var context = {
        comboBoxId,
        selectedOptionId: this.selectedOptionId()
      };
      return React__default.createElement(ComboBoxContext.Provider, {
        value: context
      }, React__default.createElement("div", {
        onClick: this.handleClick,
        role: "combobox",
        "aria-expanded": this.state.popoverActive,
        "aria-owns": this.state.comboBoxId,
        "aria-controls": this.state.comboBoxId,
        "aria-haspopup": true,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        tabIndex: 0
      }, React__default.createElement(KeypressListener, {
        keyCode: Key.DownArrow,
        handler: this.handleDownArrow
      }), React__default.createElement(KeypressListener, {
        keyCode: Key.UpArrow,
        handler: this.handleUpArrow
      }), React__default.createElement(EventListener, {
        event: "keydown",
        handler: this.handleEnter
      }), React__default.createElement(KeypressListener, {
        keyCode: Key.Escape,
        handler: this.handlePopoverClose
      }), React__default.createElement(Popover, {
        activator: textField,
        active: this.state.popoverActive,
        onClose: this.handlePopoverClose,
        preferredPosition: preferredPosition,
        fullWidth: true,
        preventAutofocus: true
      }, React__default.createElement(Popover.Pane, {
        onScrolledToBottom: onEndReached
      }, React__default.createElement("div", {
        id: this.state.comboBoxId,
        role: "listbox",
        "aria-multiselectable": allowMultiple
      }, contentBefore, actionsBeforeMarkup, optionsMarkup, actionsAfterMarkup, contentAfter, emptyStateMarkup)))));
    }
  }, {
    key: "selectedOptionId",
    value: function selectedOptionId() {
      var _this$state7 = this.state,
          selectedOption = _this$state7.selectedOption,
          selectedIndex = _this$state7.selectedIndex,
          comboBoxId = _this$state7.comboBoxId;
      return selectedOption ? "".concat(comboBoxId, "-").concat(selectedIndex) : undefined;
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, _ref2) {
      var nextOptions = _ref.options,
          nextSelected = _ref.selected,
          nextActionsBefore = _ref.actionsBefore,
          nextActionsAfter = _ref.actionsAfter;
      var navigableOptions = _ref2.navigableOptions,
          selectedOptions = _ref2.selectedOptions,
          comboBoxId = _ref2.comboBoxId;
      var optionsChanged = filterForOptions(navigableOptions) && nextOptions && !optionsAreEqual(navigableOptions, nextOptions);
      var newNavigableOptions = [];

      if (nextActionsBefore) {
        newNavigableOptions = newNavigableOptions.concat(nextActionsBefore);
      }

      if (optionsChanged || nextActionsBefore) {
        newNavigableOptions = newNavigableOptions.concat(nextOptions);
      }

      if (nextActionsAfter) {
        newNavigableOptions = newNavigableOptions.concat(nextActionsAfter);
      }

      newNavigableOptions = assignOptionIds(newNavigableOptions, comboBoxId);

      if (optionsChanged && selectedOptions !== nextSelected) {
        return {
          navigableOptions: newNavigableOptions,
          selectedOptions: nextSelected
        };
      } else if (optionsChanged) {
        return {
          navigableOptions: newNavigableOptions
        };
      } else if (selectedOptions !== nextSelected) {
        return {
          selectedOptions: nextSelected
        };
      }

      return null;
    }
  }]);

  return ComboBox;
}(React__default.PureComponent);

function assignOptionIds(options, comboBoxId) {
  options.map(function (option, optionIndex) {
    option.id = "".concat(comboBoxId, "-").concat(optionIndex);
  });
  return options;
}

function optionsAreEqual(firstOptions, secondOptions) {
  if (firstOptions.length !== secondOptions.length) {
    return false;
  }

  return firstOptions.every(function (firstItem, index) {
    var secondItem = secondOptions[index];

    if (isOption(firstItem)) {
      if (isOption(secondItem)) {
        return firstItem.value === secondItem.value;
      }

      return false;
    } else {
      if (!isOption(secondItem)) {
        return firstItem.content === secondItem.content;
      }

      return false;
    }
  });
}

function isOption(navigableOption) {
  return navigableOption.value !== undefined;
}

function filterForOptions(mixedArray) {
  return mixedArray.filter(function (item) {
    return isOption(item);
  });
}

var styles$q = {
  "Label": "Polaris-Label",
  "hidden": "Polaris-Label--hidden",
  "Text": "Polaris-Label__Text"
};

function labelID(id) {
  return "".concat(id, "Label");
}
function Label(_ref) {
  var children = _ref.children,
      id = _ref.id,
      hidden = _ref.hidden;
  var className = classNames(styles$q.Label, hidden && styles$q.hidden);
  return React__default.createElement("div", {
    className: className
  }, React__default.createElement("label", {
    id: labelID(id),
    htmlFor: id,
    className: styles$q.Text
  }, children));
}

var styles$r = {
  "InlineError": "Polaris-InlineError",
  "Icon": "Polaris-InlineError__Icon"
};

function InlineError(_ref) {
  var message = _ref.message,
      fieldID = _ref.fieldID;

  if (!message) {
    return null;
  }

  return React__default.createElement("div", {
    id: errorTextID(fieldID),
    className: styles$r.InlineError
  }, React__default.createElement("div", {
    className: styles$r.Icon
  }, React__default.createElement(Icon, {
    source: AlertMinor
  })), message);
}
function errorTextID(id) {
  return "".concat(id, "Error");
}

var styles$s = {
  "hidden": "Polaris-Labelled--hidden",
  "LabelWrapper": "Polaris-Labelled__LabelWrapper",
  "HelpText": "Polaris-Labelled__HelpText",
  "Error": "Polaris-Labelled__Error",
  "Action": "Polaris-Labelled__Action"
};

function Labelled(_a) {
  var id = _a.id,
      label = _a.label,
      error = _a.error,
      action = _a.action,
      helpText = _a.helpText,
      children = _a.children,
      labelHidden = _a.labelHidden,
      rest = __rest(_a, ["id", "label", "error", "action", "helpText", "children", "labelHidden"]);

  var className = classNames(labelHidden && styles$s.hidden);
  var actionMarkup = action ? React__default.createElement("div", {
    className: styles$s.Action
  }, buttonFrom(action, {
    plain: true
  })) : null;
  var helpTextMarkup = helpText ? React__default.createElement("div", {
    className: styles$s.HelpText,
    id: helpTextID(id)
  }, helpText) : null;
  var errorMarkup = error && typeof error !== 'boolean' && React__default.createElement("div", {
    className: styles$s.Error
  }, React__default.createElement(InlineError, {
    message: error,
    fieldID: id
  }));
  var labelMarkup = label ? React__default.createElement("div", {
    className: styles$s.LabelWrapper
  }, React__default.createElement(Label, Object.assign({
    id: id
  }, rest, {
    hidden: false
  }), label), actionMarkup) : null;
  return React__default.createElement("div", {
    className: className
  }, labelMarkup, children, errorMarkup, helpTextMarkup);
}
function helpTextID(id) {
  return "".concat(id, "HelpText");
}

var styles$t = {
  "Connected": "Polaris-Connected",
  "Item": "Polaris-Connected__Item",
  "Item-primary": "Polaris-Connected__Item--primary",
  "Item-connection": "Polaris-Connected__Item--connection",
  "Item-focused": "Polaris-Connected__Item--focused"
};

var ItemPosition;

(function (ItemPosition) {
  ItemPosition[ItemPosition["Left"] = 0] = "Left";
  ItemPosition[ItemPosition["Primary"] = 1] = "Primary";
  ItemPosition[ItemPosition["Right"] = 2] = "Right";
})(ItemPosition || (ItemPosition = {}));

var Item$3 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleBlur = function () {
      _this.setState({
        focused: false
      });
    };

    _this.handleFocus = function () {
      _this.setState({
        focused: true
      });
    };

    return _this;
  }

  _createClass(Item, [{
    key: "render",
    value: function render() {
      var focused = this.state.focused;
      var _this$props = this.props,
          children = _this$props.children,
          position = _this$props.position;
      var className = classNames(styles$t.Item, focused && styles$t['Item-focused'], position === ItemPosition.Primary ? styles$t['Item-primary'] : styles$t['Item-connection']);
      return React__default.createElement("div", {
        onBlur: this.handleBlur,
        onFocus: this.handleFocus,
        className: className
      }, children);
    }
  }]);

  return Item;
}(React__default.PureComponent);

function Connected(_ref) {
  var children = _ref.children,
      left = _ref.left,
      right = _ref.right;
  var leftConnectionMarkup = left ? React__default.createElement(Item$3, {
    position: ItemPosition.Left
  }, left) : null;
  var rightConnectionMarkup = right ? React__default.createElement(Item$3, {
    position: ItemPosition.Right
  }, right) : null;
  return React__default.createElement("div", {
    className: styles$t.Connected
  }, leftConnectionMarkup, React__default.createElement(Item$3, {
    position: ItemPosition.Primary
  }, children), rightConnectionMarkup);
}

var styles$u = {
  "TextField": "Polaris-TextField",
  "multiline": "Polaris-TextField--multiline",
  "Input": "Polaris-TextField__Input",
  "hasValue": "Polaris-TextField--hasValue",
  "focus": "Polaris-TextField--focus",
  "Backdrop": "Polaris-TextField__Backdrop",
  "error": "Polaris-TextField--error",
  "readOnly": "Polaris-TextField--readOnly",
  "disabled": "Polaris-TextField--disabled",
  "Prefix": "Polaris-TextField__Prefix",
  "Input-hasClearButton": "Polaris-TextField__Input--hasClearButton",
  "Input-suffixed": "Polaris-TextField__Input--suffixed",
  "Input-alignRight": "Polaris-TextField__Input--alignRight",
  "Input-alignLeft": "Polaris-TextField__Input--alignLeft",
  "Input-alignCenter": "Polaris-TextField__Input--alignCenter",
  "Suffix": "Polaris-TextField__Suffix",
  "CharacterCount": "Polaris-TextField__CharacterCount",
  "AlignFieldBottom": "Polaris-TextField__AlignFieldBottom",
  "ClearButton": "Polaris-TextField__ClearButton",
  "Spinner": "Polaris-TextField__Spinner",
  "SpinnerIcon": "Polaris-TextField__SpinnerIcon",
  "Resizer": "Polaris-TextField__Resizer",
  "DummyInput": "Polaris-TextField__DummyInput",
  "Segment": "Polaris-TextField__Segment",
  "globalTheming": "Polaris-TextField--globalTheming"
};

function Resizer(_ref) {
  var contents = _ref.contents,
      _ref$currentHeight = _ref.currentHeight,
      currentHeightProp = _ref$currentHeight === void 0 ? null : _ref$currentHeight,
      minimumLines = _ref.minimumLines,
      onHeightChange = _ref.onHeightChange;
  var contentNode = useRef(null);
  var minimumLinesNode = useRef(null);
  var animationFrame = useRef();
  var currentHeight = useRef(currentHeightProp);

  if (currentHeightProp !== currentHeight.current) {
    currentHeight.current = currentHeightProp;
  }

  useEffect(function () {
    return function () {
      if (animationFrame.current) {
        cancelAnimationFrame(animationFrame.current);
      }
    };
  }, []);
  var minimumLinesMarkup = minimumLines ? React__default.createElement("div", {
    ref: minimumLinesNode,
    className: styles$u.DummyInput,
    dangerouslySetInnerHTML: {
      __html: getContentsForMinimumLines(minimumLines)
    }
  }) : null;
  var handleHeightCheck = useCallback(function () {
    if (animationFrame.current) {
      cancelAnimationFrame(animationFrame.current);
    }

    animationFrame.current = requestAnimationFrame(function () {
      if (!contentNode.current || !minimumLinesNode.current) {
        return;
      }

      var newHeight = Math.max(contentNode.current.offsetHeight, minimumLinesNode.current.offsetHeight);

      if (newHeight !== currentHeight.current) {
        onHeightChange(newHeight);
      }
    });
  }, [onHeightChange]);
  useLayoutEffect(function () {
    handleHeightCheck();
  });
  return React__default.createElement("div", {
    "aria-hidden": true,
    className: styles$u.Resizer
  }, React__default.createElement(EventListener, {
    event: "resize",
    handler: handleHeightCheck
  }), React__default.createElement("div", {
    ref: contentNode,
    className: styles$u.DummyInput,
    dangerouslySetInnerHTML: {
      __html: getFinalContents(contents)
    }
  }), minimumLinesMarkup);
}
var ENTITIES_TO_REPLACE = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '\n': '<br>',
  '\r': ''
};
var REPLACE_REGEX$1 = new RegExp("[".concat(Object.keys(ENTITIES_TO_REPLACE).join(), "]"), 'g');

function replaceEntity(entity) {
  return ENTITIES_TO_REPLACE[entity];
}

function getContentsForMinimumLines(minimumLines) {
  var content = '';

  for (var line = 0; line < minimumLines; line++) {
    content += '<br>';
  }

  return content;
}

function getFinalContents(contents) {
  return contents ? "".concat(contents.replace(REPLACE_REGEX$1, replaceEntity), "<br>") : '<br>';
}

function Spinner$1(_ref) {
  var onChange = _ref.onChange,
      onClick = _ref.onClick,
      onMouseDown = _ref.onMouseDown,
      onMouseUp = _ref.onMouseUp;

  function handleStep(step) {
    return function () {
      return onChange(step);
    };
  }

  function handleMouseDown(onChange) {
    return function (event) {
      if (event.button !== 0) return;
      onMouseDown(onChange);
    };
  }

  return React__default.createElement("div", {
    className: styles$u.Spinner,
    onClick: onClick,
    "aria-hidden": true
  }, React__default.createElement("div", {
    role: "button",
    className: styles$u.Segment,
    tabIndex: -1,
    onClick: handleStep(1),
    onMouseDown: handleMouseDown(handleStep(1)),
    onMouseUp: onMouseUp
  }, React__default.createElement("div", {
    className: styles$u.SpinnerIcon
  }, React__default.createElement(Icon, {
    source: CaretUpMinor
  }))), React__default.createElement("div", {
    role: "button",
    className: styles$u.Segment,
    tabIndex: -1,
    onClick: handleStep(-1),
    onMouseDown: handleMouseDown(handleStep(-1)),
    onMouseUp: onMouseUp
  }, React__default.createElement("div", {
    className: styles$u.SpinnerIcon
  }, React__default.createElement(Icon, {
    source: CaretDownMinor
  }))));
}

function TextField(_ref) {
  var prefix = _ref.prefix,
      suffix = _ref.suffix,
      placeholder = _ref.placeholder,
      value = _ref.value,
      helpText = _ref.helpText,
      label = _ref.label,
      labelAction = _ref.labelAction,
      labelHidden = _ref.labelHidden,
      disabled = _ref.disabled,
      clearButton = _ref.clearButton,
      readOnly = _ref.readOnly,
      autoFocus = _ref.autoFocus,
      focused = _ref.focused,
      multiline = _ref.multiline,
      error = _ref.error,
      connectedRight = _ref.connectedRight,
      connectedLeft = _ref.connectedLeft,
      type = _ref.type,
      name = _ref.name,
      idProp = _ref.id,
      role = _ref.role,
      step = _ref.step,
      autoComplete = _ref.autoComplete,
      max = _ref.max,
      maxLength = _ref.maxLength,
      min = _ref.min,
      minLength = _ref.minLength,
      pattern = _ref.pattern,
      spellCheck = _ref.spellCheck,
      ariaOwns = _ref.ariaOwns,
      ariaControls = _ref.ariaControls,
      ariaActiveDescendant = _ref.ariaActiveDescendant,
      ariaAutocomplete = _ref.ariaAutocomplete,
      showCharacterCount = _ref.showCharacterCount,
      align = _ref.align,
      onClearButtonClick = _ref.onClearButtonClick,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur;
  var i18n = useI18n();

  var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      height = _useState2[0],
      setHeight = _useState2[1];

  var _useState3 = useState(Boolean(focused)),
      _useState4 = _slicedToArray(_useState3, 2),
      focus = _useState4[0],
      setFocus = _useState4[1];

  var isAfterInitial = useIsAfterInitialMount();
  var id = useUniqueId('TextField', idProp);
  var inputRef = useRef(null);
  var prefixRef = useRef(null);
  var suffixRef = useRef(null);
  var buttonPressTimer = useRef();
  useEffect(function () {
    var input = inputRef.current;
    if (!input || focused === undefined) return;
    focused ? input.focus() : input.blur();
  }, [focused]);
  var normalizedValue = value != null ? value : '';

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  var normalizedStep = step != null ? step : 1;
  var normalizedMax = max != null ? max : Infinity;
  var normalizedMin = min != null ? min : -Infinity;
  var className = classNames(styles$u.TextField, Boolean(normalizedValue) && styles$u.hasValue, disabled && styles$u.disabled, readOnly && styles$u.readOnly, error && styles$u.error, multiline && styles$u.multiline, focus && styles$u.focus, unstableGlobalTheming && styles$u.globalTheming);
  var inputType = type === 'currency' ? 'text' : type;
  var prefixMarkup = prefix ? React__default.createElement("div", {
    className: styles$u.Prefix,
    id: "".concat(id, "Prefix"),
    ref: prefixRef
  }, prefix) : null;
  var suffixMarkup = suffix ? React__default.createElement("div", {
    className: styles$u.Suffix,
    id: "".concat(id, "Suffix"),
    ref: suffixRef
  }, suffix) : null;
  var characterCount = normalizedValue.length;
  var characterCountLabel = maxLength ? i18n.translate('Polaris.TextField.characterCountWithMaxLength', {
    count: characterCount,
    limit: maxLength
  }) : i18n.translate('Polaris.TextField.characterCount', {
    count: characterCount
  });
  var characterCountClassName = classNames(styles$u.CharacterCount, multiline && styles$u.AlignFieldBottom);
  var characterCountText = !maxLength ? characterCount : "".concat(characterCount, "/").concat(maxLength);
  var characterCountMarkup = showCharacterCount ? React__default.createElement("div", {
    id: "".concat(id, "CharacterCounter"),
    className: characterCountClassName,
    "aria-label": characterCountLabel,
    "aria-live": focus ? 'polite' : 'off',
    "aria-atomic": "true"
  }, characterCountText) : null;
  var clearButtonMarkup = clearButton && normalizedValue !== '' ? React__default.createElement("button", {
    type: "button",
    className: styles$u.ClearButton,
    onClick: handleClearButtonPress,
    disabled: disabled
  }, React__default.createElement(VisuallyHidden, null, i18n.translate('Polaris.Common.clear')), React__default.createElement(Icon, {
    source: CircleCancelMinor,
    color: "inkLightest"
  })) : null;
  var handleNumberChange = useCallback(function (steps) {
    if (onChange == null) {
      return;
    } // Returns the length of decimal places in a number


    var dpl = function dpl(num) {
      return (num.toString().split('.')[1] || []).length;
    };

    var numericValue = value ? parseFloat(value) : 0;

    if (isNaN(numericValue)) {
      return;
    } // Making sure the new value has the same length of decimal places as the
    // step / value has.


    var decimalPlaces = Math.max(dpl(numericValue), dpl(normalizedStep));
    var newValue = Math.min(Number(normalizedMax), Math.max(numericValue + steps * normalizedStep, Number(normalizedMin)));
    onChange(String(newValue.toFixed(decimalPlaces)), id);
  }, [id, normalizedMax, normalizedMin, onChange, normalizedStep, value]);
  var handleButtonRelease = useCallback(function () {
    clearTimeout(buttonPressTimer.current);
  }, []);
  var handleButtonPress = useCallback(function (onChange) {
    var minInterval = 50;
    var decrementBy = 10;
    var interval = 200;

    var onChangeInterval = function onChangeInterval() {
      if (interval > minInterval) interval -= decrementBy;
      onChange();
      buttonPressTimer.current = window.setTimeout(onChangeInterval, interval);
    };

    buttonPressTimer.current = window.setTimeout(onChangeInterval, interval);
    addEventListener(document, 'mouseup', handleButtonRelease, {
      once: true
    });
  }, [handleButtonRelease]);
  var spinnerMarkup = type === 'number' && !disabled && !readOnly ? React__default.createElement(Spinner$1, {
    onChange: handleNumberChange,
    onMouseDown: handleButtonPress,
    onMouseUp: handleButtonRelease
  }) : null;
  var style = multiline && height ? {
    height
  } : null;
  var handleExpandingResize = useCallback(function (height) {
    setHeight(height);
  }, []);
  var resizer = multiline && isAfterInitial ? React__default.createElement(Resizer, {
    contents: normalizedValue || placeholder,
    currentHeight: height,
    minimumLines: typeof multiline === 'number' ? multiline : 1,
    onHeightChange: handleExpandingResize
  }) : null;
  var describedBy = [];

  if (error) {
    describedBy.push("".concat(id, "Error"));
  }

  if (helpText) {
    describedBy.push(helpTextID(id));
  }

  if (showCharacterCount) {
    describedBy.push("".concat(id, "CharacterCounter"));
  }

  var labelledBy = [];

  if (prefix) {
    labelledBy.push("".concat(id, "Prefix"));
  }

  if (suffix) {
    labelledBy.push("".concat(id, "Suffix"));
  }

  labelledBy.unshift(labelID(id));
  var inputClassName = classNames(styles$u.Input, align && styles$u[variationName('Input-align', align)], suffix && styles$u['Input-suffixed'], clearButton && styles$u['Input-hasClearButton']);
  var input = React__default.createElement(multiline ? 'textarea' : 'input', {
    name,
    id,
    disabled,
    readOnly,
    role,
    autoFocus,
    value: normalizedValue,
    placeholder,
    onFocus,
    onBlur,
    onKeyPress: handleKeyPress,
    style,
    autoComplete: normalizeAutoComplete(autoComplete),
    className: inputClassName,
    onChange: handleChange,
    ref: inputRef,
    min,
    max,
    step,
    minLength,
    maxLength,
    spellCheck,
    pattern,
    type: inputType,
    'aria-describedby': describedBy.length ? describedBy.join(' ') : undefined,
    'aria-labelledby': labelledBy.join(' '),
    'aria-invalid': Boolean(error),
    'aria-owns': ariaOwns,
    'aria-activedescendant': ariaActiveDescendant,
    'aria-autocomplete': ariaAutocomplete,
    'aria-controls': ariaControls,
    'aria-multiline': normalizeAriaMultiline(multiline)
  });
  return React__default.createElement(Labelled, {
    label: label,
    id: id,
    error: error,
    action: labelAction,
    labelHidden: labelHidden,
    helpText: helpText
  }, React__default.createElement(Connected, {
    left: connectedLeft,
    right: connectedRight
  }, React__default.createElement("div", {
    className: className,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onClick: handleClick
  }, prefixMarkup, input, suffixMarkup, characterCountMarkup, clearButtonMarkup, spinnerMarkup, React__default.createElement("div", {
    className: styles$u.Backdrop
  }), resizer)));

  function handleClearButtonPress() {
    onClearButtonClick && onClearButtonClick(id);
  }

  function handleKeyPress(event) {
    var key = event.key,
        which = event.which;
    var numbersSpec = /[\d.eE+-]$/;

    if (type !== 'number' || which === Key.Enter || numbersSpec.test(key)) {
      return;
    }

    event.preventDefault();
  }

  function containsAffix(target) {
    return target instanceof HTMLElement && (prefixRef.current && prefixRef.current.contains(target) || suffixRef.current && suffixRef.current.contains(target));
  }

  function handleChange(event) {
    onChange && onChange(event.currentTarget.value, id);
  }

  function handleFocus(_ref2) {
    var target = _ref2.target;

    if (containsAffix(target)) {
      return;
    }

    setFocus(true);
  }

  function handleBlur() {
    setFocus(false);
  }

  function handleClick(_ref3) {
    var target = _ref3.target;

    if (containsAffix(target)) {
      return;
    }

    inputRef.current && inputRef.current.focus();
  }
}

function normalizeAutoComplete(autoComplete) {
  if (autoComplete == null) {
    return autoComplete;
  } else if (autoComplete === true) {
    return 'on';
  } else if (autoComplete === false) {
    return 'off';
  } else {
    return autoComplete;
  }
}

function normalizeAriaMultiline(multiline) {
  switch (typeof multiline) {
    case 'undefined':
      return false;

    case 'boolean':
      return multiline;

    case 'number':
      return Boolean(multiline > 0);
  }
}

function TextField$1(props) {
  return React__default.createElement(ComboBoxContext.Consumer, null, function (_ref) {
    var selectedOptionId = _ref.selectedOptionId,
        comboBoxId = _ref.comboBoxId;
    return React__default.createElement(TextField, Object.assign({}, props, {
      autoComplete: false,
      ariaAutocomplete: "list",
      ariaActiveDescendant: selectedOptionId,
      ariaControls: comboBoxId
    }));
  });
}

var styles$v = {
  "Loading": "Polaris-Autocomplete__Loading"
};

// subcomponents so explicitly state the subcomponents in the type definition.
// Letting this be implicit works in this project but fails in projects that use
// generated *.d.ts files.

var Autocomplete = function Autocomplete(_ref) {
  var id = _ref.id,
      options = _ref.options,
      selected = _ref.selected,
      textField = _ref.textField,
      preferredPosition = _ref.preferredPosition,
      listTitle = _ref.listTitle,
      allowMultiple = _ref.allowMultiple,
      loading = _ref.loading,
      actionBefore = _ref.actionBefore,
      willLoadMoreResults = _ref.willLoadMoreResults,
      emptyState = _ref.emptyState,
      onSelect = _ref.onSelect,
      onLoadMoreResults = _ref.onLoadMoreResults;
  var i18n = useI18n();
  var spinnerMarkup = loading ? React__default.createElement("div", {
    className: styles$v.Loading
  }, React__default.createElement(Spinner, {
    size: "small",
    accessibilityLabel: i18n.translate('Polaris.Autocomplete.spinnerAccessibilityLabel')
  })) : null;
  var conditionalOptions = loading && !willLoadMoreResults ? [] : options;
  var conditionalAction = actionBefore && actionBefore !== [] ? [actionBefore] : undefined;
  return React__default.createElement(ComboBox, {
    id: id,
    options: conditionalOptions,
    selected: selected,
    textField: textField,
    preferredPosition: preferredPosition,
    listTitle: listTitle,
    allowMultiple: allowMultiple,
    contentAfter: spinnerMarkup,
    actionsBefore: conditionalAction,
    onSelect: onSelect,
    onEndReached: onLoadMoreResults,
    emptyState: emptyState
  });
};
Autocomplete.ComboBox = ComboBox;
Autocomplete.TextField = TextField$1;

// in the styleguide works without warnings about unfound props

function ScrollLock(_) {
  var scrollLockManager = useScrollLockManager();
  useEffect(function () {
    scrollLockManager.registerScrollLock();
    return function () {
      scrollLockManager.unregisterScrollLock();
    };
  }, [scrollLockManager]);
  return null;
}

var styles$w = {
  "Backdrop": "Polaris-Backdrop",
  "fade-in": "Polaris-Backdrop__fade--in",
  "transparent": "Polaris-Backdrop--transparent",
  "belowNavigation": "Polaris-Backdrop--belowNavigation"
};

function Backdrop(props) {
  var onClick = props.onClick,
      onTouchStart = props.onTouchStart,
      belowNavigation = props.belowNavigation,
      transparent = props.transparent;
  var className = classNames(styles$w.Backdrop, belowNavigation && styles$w.belowNavigation, transparent && styles$w.transparent);
  return React__default.createElement(React__default.Fragment, null, React__default.createElement(ScrollLock, null), React__default.createElement("div", {
    className: className,
    onClick: onClick,
    onTouchStart: onTouchStart
  }));
}

var BannerContext = React__default.createContext(false);

var styles$x = {
  "Banner": "Polaris-Banner",
  "withinContentContainer": "Polaris-Banner--withinContentContainer",
  "statusSuccess": "Polaris-Banner--statusSuccess",
  "statusInfo": "Polaris-Banner--statusInfo",
  "statusWarning": "Polaris-Banner--statusWarning",
  "statusCritical": "Polaris-Banner--statusCritical",
  "Ribbon": "Polaris-Banner__Ribbon",
  "Actions": "Polaris-Banner__Actions",
  "Dismiss": "Polaris-Banner__Dismiss",
  "withinPage": "Polaris-Banner--withinPage",
  "hasDismiss": "Polaris-Banner--hasDismiss",
  "Heading": "Polaris-Banner__Heading",
  "Content": "Polaris-Banner__Content",
  "PrimaryAction": "Polaris-Banner__PrimaryAction",
  "SecondaryAction": "Polaris-Banner__SecondaryAction",
  "Text": "Polaris-Banner__Text"
};

var Banner =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Banner, _React$PureComponent);

  function Banner() {
    var _this;

    _classCallCheck(this, Banner);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Banner).apply(this, arguments));
    _this.wrapper = React__default.createRef();
    return _this;
  }

  _createClass(Banner, [{
    key: "focus",
    value: function focus() {
      this.wrapper.current && this.wrapper.current.focus();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      return React__default.createElement(BannerContext.Provider, {
        value: true
      }, React__default.createElement(WithinContentContext.Consumer, null, function (withinContentContainer) {
        var _this2$props = _this2.props,
            icon = _this2$props.icon,
            action = _this2$props.action,
            secondaryAction = _this2$props.secondaryAction,
            title = _this2$props.title,
            children = _this2$props.children,
            status = _this2$props.status,
            onDismiss = _this2$props.onDismiss,
            stopAnnouncements = _this2$props.stopAnnouncements;
        var color;
        var defaultIcon;
        var ariaRoleType = 'status';

        switch (status) {
          case 'success':
            color = 'greenDark';
            defaultIcon = CircleTickMajorTwotone;
            break;

          case 'info':
            color = 'tealDark';
            defaultIcon = CircleInformationMajorTwotone;
            break;

          case 'warning':
            color = 'yellowDark';
            defaultIcon = CircleAlertMajorTwotone;
            ariaRoleType = 'alert';
            break;

          case 'critical':
            color = 'redDark';
            defaultIcon = CircleDisabledMajorTwotone;
            ariaRoleType = 'alert';
            break;

          default:
            color = 'inkLighter';
            defaultIcon = FlagMajorTwotone;
        }

        var className = classNames(styles$x.Banner, status && styles$x[variationName('status', status)], onDismiss && styles$x.hasDismiss, withinContentContainer ? styles$x.withinContentContainer : styles$x.withinPage);
        var id = uniqueID();
        var iconName = icon || defaultIcon;
        var headingMarkup = null;
        var headingID;

        if (title) {
          headingID = "".concat(id, "Heading");
          headingMarkup = React__default.createElement("div", {
            className: styles$x.Heading,
            id: headingID
          }, React__default.createElement(Heading, {
            element: "p"
          }, title));
        }

        var buttonSizeValue = withinContentContainer ? 'slim' : undefined;
        var secondaryActionMarkup = secondaryAction ? secondaryActionFrom(secondaryAction) : null;
        var actionMarkup = action ? React__default.createElement("div", {
          className: styles$x.Actions
        }, React__default.createElement(ButtonGroup, null, React__default.createElement("div", {
          className: styles$x.PrimaryAction
        }, buttonFrom(action, {
          outline: true,
          size: buttonSizeValue
        })), secondaryActionMarkup)) : null;
        var contentMarkup = null;
        var contentID;

        if (children || actionMarkup) {
          contentID = "".concat(id, "Content");
          contentMarkup = React__default.createElement("div", {
            className: styles$x.Content,
            id: contentID
          }, children, actionMarkup);
        }

        var dismissButton = onDismiss ? React__default.createElement("div", {
          className: styles$x.Dismiss
        }, React__default.createElement(Button, {
          plain: true,
          icon: CancelSmallMinor,
          onClick: onDismiss,
          accessibilityLabel: "Dismiss notification"
        })) : null;
        return React__default.createElement("div", {
          className: className // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
          ,
          tabIndex: 0,
          ref: _this2.wrapper,
          role: ariaRoleType,
          "aria-live": stopAnnouncements ? 'off' : 'polite',
          onMouseUp: handleMouseUp,
          "aria-labelledby": headingID,
          "aria-describedby": contentID
        }, dismissButton, React__default.createElement("div", {
          className: styles$x.Ribbon
        }, React__default.createElement(Icon, {
          source: iconName,
          color: color,
          backdrop: true
        })), React__default.createElement("div", null, headingMarkup, contentMarkup));
      }));
    }
  }]);

  return Banner;
}(React__default.PureComponent);
var index = 1;

function uniqueID() {
  return "Banner".concat(index++);
}

function handleMouseUp(_ref) {
  var currentTarget = _ref.currentTarget;
  currentTarget.blur();
}

function secondaryActionFrom(action) {
  if (action.url) {
    return React__default.createElement(UnstyledLink, {
      className: styles$x.SecondaryAction,
      url: action.url,
      external: action.external
    }, React__default.createElement("span", {
      className: styles$x.Text
    }, action.content));
  }

  return React__default.createElement("button", {
    className: styles$x.SecondaryAction,
    onClick: action.onAction
  }, React__default.createElement("span", {
    className: styles$x.Text
  }, action.content));
}

var styles$y = {
  "Breadcrumb": "Polaris-Breadcrumbs__Breadcrumb",
  "Icon": "Polaris-Breadcrumbs__Icon",
  "ContentWrapper": "Polaris-Breadcrumbs__ContentWrapper",
  "Content": "Polaris-Breadcrumbs__Content"
};

var Breadcrumbs =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Breadcrumbs, _React$PureComponent);

  function Breadcrumbs() {
    _classCallCheck(this, Breadcrumbs);

    return _possibleConstructorReturn(this, _getPrototypeOf(Breadcrumbs).apply(this, arguments));
  }

  _createClass(Breadcrumbs, [{
    key: "render",
    value: function render() {
      var breadcrumbs = this.props.breadcrumbs;
      var breadcrumb = breadcrumbs[breadcrumbs.length - 1];

      if (breadcrumb == null) {
        return null;
      }

      var content = breadcrumb.content;
      var contentMarkup = React__default.createElement("span", {
        className: styles$y.ContentWrapper
      }, React__default.createElement("span", {
        className: styles$y.Icon
      }, React__default.createElement(Icon, {
        source: ChevronLeftMinor
      })), React__default.createElement("span", {
        className: styles$y.Content
      }, content));
      var breadcrumbMarkup = 'url' in breadcrumb ? React__default.createElement(UnstyledLink, {
        key: content,
        url: breadcrumb.url,
        className: styles$y.Breadcrumb,
        onMouseUp: handleMouseUpByBlurring,
        "aria-label": breadcrumb.accessibilityLabel
      }, contentMarkup) : React__default.createElement("button", {
        key: content,
        className: styles$y.Breadcrumb,
        onClick: breadcrumb.onAction,
        onMouseUp: handleMouseUpByBlurring,
        type: "button",
        "aria-label": breadcrumb.accessibilityLabel
      }, contentMarkup);
      return React__default.createElement("nav", {
        role: "navigation"
      }, breadcrumbMarkup);
    }
  }]);

  return Breadcrumbs;
}(React__default.PureComponent);

var styles$z = {
  "TextContainer": "Polaris-TextContainer",
  "spacingTight": "Polaris-TextContainer--spacingTight",
  "spacingLoose": "Polaris-TextContainer--spacingLoose"
};

function TextContainer(_ref) {
  var spacing = _ref.spacing,
      children = _ref.children;
  var className = classNames(styles$z.TextContainer, spacing && styles$z[variationName('spacing', spacing)]);
  return React__default.createElement("div", {
    className: className
  }, children);
}

var styles$A = {
  "CalloutCard": "Polaris-CalloutCard",
  "Image": "Polaris-CalloutCard__Image",
  "DismissImage": "Polaris-CalloutCard__DismissImage",
  "Content": "Polaris-CalloutCard__Content",
  "Title": "Polaris-CalloutCard__Title",
  "Buttons": "Polaris-CalloutCard__Buttons",
  "Container": "Polaris-CalloutCard__Container",
  "Dismiss": "Polaris-CalloutCard__Dismiss"
};

function CalloutCard(_ref) {
  var title = _ref.title,
      children = _ref.children,
      illustration = _ref.illustration,
      primaryAction = _ref.primaryAction,
      secondaryAction = _ref.secondaryAction,
      onDismiss = _ref.onDismiss;
  var primaryActionMarkup = buttonFrom(primaryAction);
  var secondaryActionMarkup = secondaryAction ? buttonFrom(secondaryAction, {
    plain: true
  }) : null;
  var buttonMarkup = secondaryActionMarkup ? React__default.createElement(ButtonGroup, null, primaryActionMarkup, secondaryActionMarkup) : primaryActionMarkup;
  var dismissButton = onDismiss ? React__default.createElement("div", {
    className: styles$A.Dismiss
  }, React__default.createElement(Button, {
    plain: true,
    icon: CancelSmallMinor,
    onClick: onDismiss,
    accessibilityLabel: "Dismiss card"
  })) : null;
  var imageClassName = classNames(styles$A.Image, onDismiss && styles$A.DismissImage);
  return React__default.createElement(Card, null, React__default.createElement("div", {
    className: styles$A.Container
  }, dismissButton, React__default.createElement(Card.Section, null, React__default.createElement("div", {
    className: styles$A.CalloutCard
  }, React__default.createElement("div", {
    className: styles$A.Content
  }, React__default.createElement("div", {
    className: styles$A.Title
  }, React__default.createElement(Heading, null, title)), React__default.createElement(TextContainer, null, children), React__default.createElement("div", {
    className: styles$A.Buttons
  }, buttonMarkup)), React__default.createElement(Image, {
    alt: "",
    className: imageClassName,
    source: illustration
  })))));
}

var styles$B = {
  "Caption": "Polaris-Caption"
};

function Caption(_ref) {
  var children = _ref.children;
  return React__default.createElement("p", {
    className: styles$B.Caption
  }, children);
}

var styles$C = {
  "Choice": "Polaris-Choice",
  "labelHidden": "Polaris-Choice--labelHidden",
  "Label": "Polaris-Choice__Label",
  "Control": "Polaris-Choice__Control",
  "disabled": "Polaris-Choice--disabled",
  "Descriptions": "Polaris-Choice__Descriptions",
  "HelpText": "Polaris-Choice__HelpText"
};

function Choice(_ref) {
  var id = _ref.id,
      label = _ref.label,
      disabled = _ref.disabled,
      error = _ref.error,
      children = _ref.children,
      labelHidden = _ref.labelHidden,
      helpText = _ref.helpText,
      onClick = _ref.onClick;
  var className = classNames(styles$C.Choice, labelHidden && styles$C.labelHidden, disabled && styles$C.disabled);
  var labelMarkup = React__default.createElement("label", {
    className: className,
    htmlFor: id,
    onClick: onClick
  }, React__default.createElement("span", {
    className: styles$C.Control
  }, children), React__default.createElement("span", {
    className: styles$C.Label
  }, label));
  var helpTextMarkup = helpText ? React__default.createElement("div", {
    className: styles$C.HelpText,
    id: helpTextID$1(id)
  }, helpText) : null;
  var errorMarkup = error && typeof error !== 'boolean' && React__default.createElement("div", {
    className: styles$C.Error
  }, React__default.createElement(InlineError, {
    message: error,
    fieldID: id
  }));
  var descriptionMarkup = helpTextMarkup || errorMarkup ? React__default.createElement("div", {
    className: styles$C.Descriptions
  }, errorMarkup, helpTextMarkup) : null;
  return descriptionMarkup ? React__default.createElement("div", null, labelMarkup, descriptionMarkup) : labelMarkup;
}
function helpTextID$1(id) {
  return "".concat(id, "HelpText");
}

var styles$D = {
  "Checkbox": "Polaris-Checkbox",
  "error": "Polaris-Checkbox--error",
  "Input": "Polaris-Checkbox__Input",
  "Backdrop": "Polaris-Checkbox__Backdrop",
  "Input-indeterminate": "Polaris-Checkbox__Input--indeterminate",
  "Icon": "Polaris-Checkbox__Icon"
};

var Checkbox$1 = React__default.forwardRef(function Checkbox(_ref, ref) {
  var ariaDescribedByProp = _ref.ariaDescribedBy,
      label = _ref.label,
      labelHidden = _ref.labelHidden,
      _ref$checked = _ref.checked,
      checked = _ref$checked === void 0 ? false : _ref$checked,
      helpText = _ref.helpText,
      disabled = _ref.disabled,
      idProp = _ref.id,
      name = _ref.name,
      value = _ref.value,
      error = _ref.error,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur;
  var inputNode = useRef(null);
  var id = useUniqueId('Checkbox', idProp);
  useImperativeHandle(ref, function () {
    return {
      focus: function focus() {
        if (inputNode.current) {
          inputNode.current.focus();
        }
      }
    };
  });

  var handleInput = function handleInput() {
    if (onChange == null || inputNode.current == null || disabled) {
      return;
    }

    onChange(!inputNode.current.checked, id);
    inputNode.current.focus();
  };

  var handleKeyUp = function handleKeyUp(event) {
    var keyCode = event.keyCode;
    if (keyCode !== Key.Space) return;
    handleInput();
  };

  var describedBy = [];

  if (error && typeof error !== 'boolean') {
    describedBy.push(errorTextID(id));
  }

  if (helpText) {
    describedBy.push(helpTextID$1(id));
  }

  if (ariaDescribedByProp) {
    describedBy.push(ariaDescribedByProp);
  }

  var ariaDescribedBy = describedBy.length ? describedBy.join(' ') : undefined;
  var wrapperClassName = classNames(styles$D.Checkbox, error && styles$D.error);
  var isIndeterminate = checked === 'indeterminate';
  var isChecked = !isIndeterminate && Boolean(checked);
  var indeterminateAttributes = isIndeterminate ? {
    indeterminate: 'true',
    'aria-checked': 'mixed'
  } : {
    'aria-checked': isChecked
  };
  var iconSource = isIndeterminate ? MinusMinor : TickSmallMinor;
  var inputClassName = classNames(styles$D.Input, isIndeterminate && styles$D['Input-indeterminate']);
  return (
    /* eslint-disable jsx-a11y/no-redundant-roles */
    React__default.createElement(Choice, {
      id: id,
      label: label,
      labelHidden: labelHidden,
      helpText: helpText,
      error: error,
      disabled: disabled,
      onClick: handleInput
    }, React__default.createElement("span", {
      className: wrapperClassName
    }, React__default.createElement("input", Object.assign({
      onKeyUp: handleKeyUp,
      ref: inputNode,
      id: id,
      name: name,
      value: value,
      type: "checkbox",
      checked: isChecked,
      disabled: disabled,
      className: inputClassName,
      onFocus: onFocus,
      onBlur: onBlur,
      onClick: stopPropagation,
      onChange: noop$3,
      "aria-invalid": error != null,
      "aria-describedby": ariaDescribedBy,
      role: "checkbox"
    }, indeterminateAttributes)), React__default.createElement("span", {
      className: styles$D.Backdrop
    }), React__default.createElement("span", {
      className: styles$D.Icon
    }, React__default.createElement(Icon, {
      source: iconSource
    }))))
    /* eslint-enable jsx-a11y/no-redundant-roles */

  );
});

function noop$3() {}

function stopPropagation(event) {
  event.stopPropagation();
}

var styles$E = {
  "RadioButton": "Polaris-RadioButton",
  "Input": "Polaris-RadioButton__Input",
  "Backdrop": "Polaris-RadioButton__Backdrop",
  "Icon": "Polaris-RadioButton__Icon"
};

function RadioButton(_ref) {
  var ariaDescribedByProp = _ref.ariaDescribedBy,
      label = _ref.label,
      labelHidden = _ref.labelHidden,
      helpText = _ref.helpText,
      checked = _ref.checked,
      disabled = _ref.disabled,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      idProp = _ref.id,
      nameProp = _ref.name,
      value = _ref.value;
  var id = useUniqueId('RadioButton', idProp);
  var name = nameProp || id;

  function handleChange(_ref2) {
    var currentTarget = _ref2.currentTarget;
    onChange && onChange(currentTarget.checked, id);
  }

  var describedBy = [];

  if (helpText) {
    describedBy.push(helpTextID$1(id));
  }

  if (ariaDescribedByProp) {
    describedBy.push(ariaDescribedByProp);
  }

  var ariaDescribedBy = describedBy.length ? describedBy.join(' ') : undefined;
  return React__default.createElement(Choice, {
    label: label,
    labelHidden: labelHidden,
    disabled: disabled,
    id: id,
    helpText: helpText
  }, React__default.createElement("span", {
    className: styles$E.RadioButton
  }, React__default.createElement("input", {
    id: id,
    name: name,
    value: value,
    type: "radio",
    checked: checked,
    disabled: disabled,
    className: styles$E.Input,
    onChange: handleChange,
    onFocus: onFocus,
    onBlur: onBlur,
    "aria-describedby": ariaDescribedBy
  }), React__default.createElement("span", {
    className: styles$E.Backdrop
  }), React__default.createElement("span", {
    className: styles$E.Icon
  })));
}

var styles$F = {
  "ChoiceList": "Polaris-ChoiceList",
  "titleHidden": "Polaris-ChoiceList--titleHidden",
  "Title": "Polaris-ChoiceList__Title",
  "Choices": "Polaris-ChoiceList__Choices",
  "ChoiceChildren": "Polaris-ChoiceList__ChoiceChildren",
  "ChoiceError": "Polaris-ChoiceList__ChoiceError"
};

function ChoiceList(_ref) {
  var title = _ref.title,
      titleHidden = _ref.titleHidden,
      allowMultiple = _ref.allowMultiple,
      choices = _ref.choices,
      selected = _ref.selected,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop$4 : _ref$onChange,
      error = _ref.error,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      nameProp = _ref.name;
  // Type asserting to any is required for TS3.2 but can be removed when we update to 3.3
  // see https://github.com/Microsoft/TypeScript/issues/28768
  var ControlComponent = allowMultiple ? Checkbox$1 : RadioButton;
  var name = useUniqueId('ChoiceList', nameProp);
  var finalName = allowMultiple ? "".concat(name, "[]") : name;
  var className = classNames(styles$F.ChoiceList, titleHidden && styles$F.titleHidden);
  var titleMarkup = title ? React__default.createElement("legend", {
    className: styles$F.Title
  }, title) : null;
  var choicesMarkup = choices.map(function (choice) {
    var value = choice.value,
        label = choice.label,
        helpText = choice.helpText,
        choiceDisabled = choice.disabled,
        describedByError = choice.describedByError;

    function handleChange(checked) {
      onChange(updateSelectedChoices(choice, checked, selected, allowMultiple), name);
    }

    var isSelected = choiceIsSelected(choice, selected);
    var renderedChildren = choice.renderChildren ? choice.renderChildren(isSelected) : null;
    var children = renderedChildren ? React__default.createElement("div", {
      className: styles$F.ChoiceChildren
    }, renderedChildren) : null;
    return React__default.createElement("li", {
      key: value
    }, React__default.createElement(ControlComponent, {
      name: finalName,
      value: value,
      label: label,
      disabled: choiceDisabled || disabled,
      checked: choiceIsSelected(choice, selected),
      helpText: helpText,
      onChange: handleChange,
      ariaDescribedBy: error && describedByError ? errorTextID(finalName) : null
    }), children);
  });
  var errorMarkup = error && React__default.createElement("div", {
    className: styles$F.ChoiceError
  }, React__default.createElement(InlineError, {
    message: error,
    fieldID: finalName
  }));
  return React__default.createElement("fieldset", {
    className: className,
    id: finalName,
    "aria-invalid": error != null
  }, titleMarkup, React__default.createElement("ul", {
    className: styles$F.Choices
  }, choicesMarkup), errorMarkup);
}

function noop$4() {}

function choiceIsSelected(_ref2, selected) {
  var value = _ref2.value;
  return selected.includes(value);
}

function updateSelectedChoices(_ref3, checked, selected) {
  var value = _ref3.value;
  var allowMultiple = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  if (checked) {
    return allowMultiple ? [].concat(_toConsumableArray(selected), [value]) : [value];
  }

  return selected.filter(function (selectedChoice) {
    return selectedChoice !== value;
  });
}

var styles$G = {
  "Collapsible": "Polaris-Collapsible",
  "animating": "Polaris-Collapsible--animating",
  "open": "Polaris-Collapsible--open",
  "fullyOpen": "Polaris-Collapsible--fullyOpen"
};

var ParentCollapsibleExpandingContext = createContext(false);

var Collapsible =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Collapsible, _React$Component);

  function Collapsible() {
    var _this;

    _classCallCheck(this, Collapsible);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Collapsible).apply(this, arguments));
    _this.state = {
      height: null,
      animationState: 'idle',
      // eslint-disable-next-line react/no-unused-state
      open: _this.props.open
    };
    _this.node = createRef();
    _this.heightNode = createRef();

    _this.handleTransitionEnd = function (event) {
      var target = event.target;

      if (target === _this.node.current) {
        _this.setState({
          animationState: 'idle',
          height: null
        });
      }
    };

    return _this;
  }

  _createClass(Collapsible, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref) {
      var _this2 = this;

      var wasOpen = _ref.open;
      var animationState = this.state.animationState;
      var parentCollapsibleExpanding = this.context;

      if (parentCollapsibleExpanding && animationState !== 'idle') {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          animationState: 'idle'
        });
        return;
      }

      read(function () {
        var heightNode = _this2.heightNode.current;

        switch (animationState) {
          case 'idle':
            break;

          case 'measuring':
            _this2.setState({
              animationState: wasOpen ? 'closingStart' : 'openingStart',
              height: wasOpen && heightNode ? heightNode.scrollHeight : 0
            });

            break;

          case 'closingStart':
            _this2.setState({
              animationState: 'closing',
              height: 0
            });

            break;

          case 'openingStart':
            _this2.setState({
              animationState: 'opening',
              height: heightNode ? heightNode.scrollHeight : 0
            });

        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          open = _this$props.open,
          children = _this$props.children;
      var _this$state = this.state,
          animationState = _this$state.animationState,
          height = _this$state.height;
      var parentCollapsibleExpanding = this.context;
      var animating = animationState !== 'idle';
      var wrapperClassName = classNames(styles$G.Collapsible, open && styles$G.open, animating && styles$G.animating, !animating && open && styles$G.fullyOpen);
      var displayHeight = collapsibleHeight(open, animationState, height);
      var content = animating || open ? children : null;
      return React__default.createElement(ParentCollapsibleExpandingContext.Provider, {
        value: parentCollapsibleExpanding || open && animationState !== 'idle'
      }, React__default.createElement("div", {
        id: id,
        "aria-hidden": !open,
        style: {
          maxHeight: displayHeight
        },
        className: wrapperClassName,
        ref: this.node,
        onTransitionEnd: this.handleTransitionEnd
      }, React__default.createElement("div", {
        ref: this.heightNode
      }, content)));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, _ref3) {
      var willOpen = _ref2.open;
      var open = _ref3.open,
          prevAnimationState = _ref3.animationState;
      var nextAnimationState = prevAnimationState;

      if (open !== willOpen) {
        nextAnimationState = 'measuring';
      }

      return {
        animationState: nextAnimationState,
        open: willOpen
      };
    }
  }]);

  return Collapsible;
}(React__default.Component);

Collapsible.contextType = ParentCollapsibleExpandingContext;

function collapsibleHeight(open, animationState, height) {
  if (animationState === 'idle' && open) {
    return open ? 'none' : undefined;
  }

  if (animationState === 'measuring') {
    return open ? undefined : 'none';
  }

  return "".concat(height || 0, "px");
} // Use named export once we work out why not casting this breaks web

var styles$H = {
  "ColorPicker": "Polaris-ColorPicker",
  "MainColor": "Polaris-ColorPicker__MainColor",
  "Dragger": "Polaris-ColorPicker__Dragger",
  "ColorLayer": "Polaris-ColorPicker__ColorLayer",
  "HuePicker": "Polaris-ColorPicker__HuePicker",
  "AlphaPicker": "Polaris-ColorPicker__AlphaPicker",
  "Slidable": "Polaris-ColorPicker__Slidable"
};

var isDragging = false; // Required to solve a bug causing the underlying page/container to scroll
// while trying to drag the ColorPicker controls.
// This must be called as soon as possible to properly prevent the event.
// `passive: false` must also be set, as it seems webkit has changed the "default" behaviour
// https://bugs.webkit.org/show_bug.cgi?id=182521

if (!isServer) {
  window.addEventListener('touchmove', function (event) {
    if (!isDragging) {
      return;
    }

    event.preventDefault();
  }, {
    passive: false
  });
}

var Slidable =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Slidable, _React$PureComponent);

  function Slidable() {
    var _this;

    _classCallCheck(this, Slidable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Slidable).apply(this, arguments));
    _this.state = {
      dragging: false
    };
    _this.node = null;
    _this.draggerNode = null;

    _this.setDraggerNode = function (node) {
      _this.draggerNode = node;
    };

    _this.setNode = function (node) {
      _this.node = node;
    };

    _this.startDrag = function (event) {
      if (event.type === 'mousedown') {
        var mouseEvent = event;

        _this.handleDraggerMove(mouseEvent.clientX, mouseEvent.clientY);
      }

      isDragging = true;

      _this.setState({
        dragging: true
      });
    };

    _this.handleDragEnd = function () {
      isDragging = false;

      _this.setState({
        dragging: false
      });
    };

    _this.handleMove = function (event) {
      event.stopImmediatePropagation();
      event.stopPropagation();

      if (event.cancelable) {
        event.preventDefault();
      }

      if (event.type === 'mousemove') {
        var mouseEvent = event;

        _this.handleDraggerMove(mouseEvent.clientX, mouseEvent.clientY);

        return;
      }

      var touchEvent = event;

      _this.handleDraggerMove(touchEvent.touches[0].clientX, touchEvent.touches[0].clientY);
    };

    _this.handleDraggerMove = function (x, y) {
      if (_this.node == null) {
        return;
      }

      var onChange = _this.props.onChange;

      var rect = _this.node.getBoundingClientRect();

      var offsetX = x - rect.left;
      var offsetY = y - rect.top;
      onChange({
        x: offsetX,
        y: offsetY
      });
    };

    return _this;
  }

  _createClass(Slidable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var onDraggerHeight = this.props.onDraggerHeight;

      if (onDraggerHeight == null) {
        return;
      }

      var draggerNode = this.draggerNode;

      if (draggerNode == null) {
        return;
      }

      onDraggerHeight(draggerNode.clientWidth);

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          onDraggerHeight(draggerNode.clientWidth);
        }, 0);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var dragging = this.state.dragging;
      var _this$props = this.props,
          _this$props$draggerX = _this$props.draggerX,
          draggerX = _this$props$draggerX === void 0 ? 0 : _this$props$draggerX,
          _this$props$draggerY = _this$props.draggerY,
          draggerY = _this$props$draggerY === void 0 ? 0 : _this$props$draggerY;
      var draggerPositioning = {
        transform: "translate3d(".concat(draggerX, "px, ").concat(draggerY, "px, 0)")
      };
      var moveListener = dragging ? React__default.createElement(EventListener, {
        event: "mousemove",
        handler: this.handleMove,
        passive: false
      }) : null;
      var touchMoveListener = dragging ? React__default.createElement(EventListener, {
        event: "touchmove",
        handler: this.handleMove,
        passive: false
      }) : null;
      var endDragListener = dragging ? React__default.createElement(EventListener, {
        event: "mouseup",
        handler: this.handleDragEnd
      }) : null;
      var touchEndListener = dragging ? React__default.createElement(EventListener, {
        event: "touchend",
        handler: this.handleDragEnd
      }) : null;
      var touchCancelListener = dragging ? React__default.createElement(EventListener, {
        event: "touchcancel",
        handler: this.handleDragEnd
      }) : null;
      return React__default.createElement("div", {
        ref: this.setNode,
        className: styles$H.Slidable,
        onMouseDown: this.startDrag,
        onTouchStart: this.startDrag
      }, endDragListener, moveListener, touchMoveListener, touchEndListener, touchCancelListener, React__default.createElement("div", {
        style: draggerPositioning,
        className: styles$H.Dragger,
        ref: this.setDraggerNode
      }));
    }
  }]);

  return Slidable;
}(React__default.PureComponent);

var VERTICAL_PADDING = 13;
function calculateDraggerY(alpha, sliderHeight, draggerHeight) {
  var offset = offsetForAlpha(alpha, sliderHeight, draggerHeight);
  return clamp$1(offset, 0, sliderHeight);
}
function alphaForDraggerY(y, sliderHeight) {
  var offsetY = clamp$1(y, 0, sliderHeight);
  return alphaForOffset(offsetY, sliderHeight);
}
function alphaForOffset(offset, sliderHeight) {
  var selectionHeight = offset - VERTICAL_PADDING;
  var slidableArea = sliderHeight - VERTICAL_PADDING * 2;
  return clamp$1(1 - selectionHeight / slidableArea, 0, 1);
}

function offsetForAlpha(alpha, sliderHeight, draggerHeight) {
  var slidableArea = sliderHeight - (draggerHeight + VERTICAL_PADDING);
  return clamp$1((1 - alpha) * slidableArea + VERTICAL_PADDING, 0, sliderHeight - draggerHeight);
}

var AlphaPicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(AlphaPicker, _React$PureComponent);

  function AlphaPicker() {
    var _this;

    _classCallCheck(this, AlphaPicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AlphaPicker).apply(this, arguments));
    _this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };

    _this.setSliderHeight = function (node) {
      if (node == null) {
        return;
      }

      _this.setState({
        sliderHeight: node.clientHeight
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };

    _this.setDraggerHeight = function (height) {
      _this.setState({
        draggerHeight: height
      });
    };

    _this.handleChange = function (_ref) {
      var y = _ref.y;
      var onChange = _this.props.onChange;
      var sliderHeight = _this.state.sliderHeight;
      var alpha = alphaForDraggerY(y, sliderHeight);
      onChange(alpha);
    };

    return _this;
  }

  _createClass(AlphaPicker, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          color = _this$props.color,
          alpha = _this$props.alpha;
      var _this$state = this.state,
          sliderHeight = _this$state.sliderHeight,
          draggerHeight = _this$state.draggerHeight;
      var draggerY = calculateDraggerY(alpha, sliderHeight, draggerHeight);
      var background = alphaGradientForColor(color);
      return React__default.createElement("div", {
        className: styles$H.AlphaPicker,
        ref: this.setSliderHeight
      }, React__default.createElement("div", {
        className: styles$H.ColorLayer,
        style: {
          background
        }
      }), React__default.createElement(Slidable, {
        draggerY: draggerY,
        draggerX: 0,
        onChange: this.handleChange,
        onDraggerHeight: this.setDraggerHeight
      }));
    }
  }]);

  return AlphaPicker;
}(React__default.PureComponent);

function alphaGradientForColor(color) {
  var _hsbToRgb = hsbToRgb(color),
      red = _hsbToRgb.red,
      green = _hsbToRgb.green,
      blue = _hsbToRgb.blue;

  var rgb = "".concat(red, ", ").concat(green, ", ").concat(blue);
  return "linear-gradient(to top, rgba(".concat(rgb, ", 0) 18px, rgba(").concat(rgb, ", 1) calc(100% - 18px))");
}

var VERTICAL_PADDING$1 = 13;
function calculateDraggerY$1(hue, sliderHeight, draggerHeight) {
  var offset = offsetForHue(hue, sliderHeight, draggerHeight);
  return clamp$1(offset, 0, sliderHeight);
}
function hueForDraggerY(y, sliderHeight) {
  var offsetY = clamp$1(y, 0, sliderHeight);
  return hueForOffset(offsetY, sliderHeight);
}

function hueForOffset(offset, sliderHeight) {
  var selectionHeight = offset - VERTICAL_PADDING$1;
  var slidableArea = sliderHeight - VERTICAL_PADDING$1 * 2;
  return clamp$1(selectionHeight / slidableArea * 360, 0, 360);
}

function offsetForHue(hue, sliderHeight, draggerHeight) {
  var slidableArea = sliderHeight - (draggerHeight + VERTICAL_PADDING$1);
  return clamp$1(hue / 360 * slidableArea + VERTICAL_PADDING$1, 0, sliderHeight - draggerHeight);
}

var HuePicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(HuePicker, _React$PureComponent);

  function HuePicker() {
    var _this;

    _classCallCheck(this, HuePicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(HuePicker).apply(this, arguments));
    _this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };

    _this.setSliderHeight = function (node) {
      if (node == null) {
        return;
      }

      _this.setState({
        sliderHeight: node.clientHeight
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };

    _this.setDraggerHeight = function (height) {
      _this.setState({
        draggerHeight: height
      });
    };

    _this.handleChange = function (_ref) {
      var y = _ref.y;
      var onChange = _this.props.onChange;
      var sliderHeight = _this.state.sliderHeight;
      var hue = hueForDraggerY(y, sliderHeight);
      onChange(hue);
    };

    return _this;
  }

  _createClass(HuePicker, [{
    key: "render",
    value: function render() {
      var hue = this.props.hue;
      var _this$state = this.state,
          sliderHeight = _this$state.sliderHeight,
          draggerHeight = _this$state.draggerHeight;
      var draggerY = calculateDraggerY$1(hue, sliderHeight, draggerHeight);
      return React__default.createElement("div", {
        className: styles$H.HuePicker,
        ref: this.setSliderHeight
      }, React__default.createElement(Slidable, {
        draggerY: draggerY,
        draggerX: 0,
        onChange: this.handleChange,
        onDraggerHeight: this.setDraggerHeight
      }));
    }
  }]);

  return HuePicker;
}(React__default.PureComponent);

var ColorPicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ColorPicker, _React$PureComponent);

  function ColorPicker() {
    var _this;

    _classCallCheck(this, ColorPicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ColorPicker).apply(this, arguments));
    _this.state = {
      pickerSize: 0
    };
    _this.colorNode = null;

    _this.setColorNode = function (node) {
      _this.colorNode = node;
    };

    _this.handleHueChange = function (hue) {
      var _this$props = _this.props,
          _this$props$color = _this$props.color,
          brightness = _this$props$color.brightness,
          saturation = _this$props$color.saturation,
          _this$props$color$alp = _this$props$color.alpha,
          alpha = _this$props$color$alp === void 0 ? 1 : _this$props$color$alp,
          onChange = _this$props.onChange;
      onChange({
        hue,
        brightness,
        saturation,
        alpha
      });
    };

    _this.handleAlphaChange = function (alpha) {
      var _this$props2 = _this.props,
          _this$props2$color = _this$props2.color,
          hue = _this$props2$color.hue,
          brightness = _this$props2$color.brightness,
          saturation = _this$props2$color.saturation,
          onChange = _this$props2.onChange;
      onChange({
        hue,
        brightness,
        saturation,
        alpha
      });
    };

    _this.handleDraggerMove = function (_ref) {
      var x = _ref.x,
          y = _ref.y;
      var pickerSize = _this.state.pickerSize;
      var _this$props3 = _this.props,
          _this$props3$color = _this$props3.color,
          hue = _this$props3$color.hue,
          _this$props3$color$al = _this$props3$color.alpha,
          alpha = _this$props3$color$al === void 0 ? 1 : _this$props3$color$al,
          onChange = _this$props3.onChange;
      var saturation = clamp$1(x / pickerSize, 0, 1);
      var brightness = clamp$1(1 - y / pickerSize, 0, 1);
      onChange({
        hue,
        saturation,
        brightness,
        alpha
      });
    };

    _this.handlePickerDrag = function (event) {
      // prevents external elements from being selected
      event.preventDefault();
    };

    return _this;
  }

  _createClass(ColorPicker, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var colorNode = this.colorNode;

      if (colorNode == null) {
        return;
      }

      this.setState({
        pickerSize: colorNode.clientWidth
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this2.setState({
            pickerSize: colorNode.clientWidth
          });
        }, 0);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          id = _this$props4.id,
          color = _this$props4.color,
          allowAlpha = _this$props4.allowAlpha;
      var hue = color.hue,
          saturation = color.saturation,
          brightness = color.brightness,
          providedAlpha = color.alpha;
      var pickerSize = this.state.pickerSize;
      var alpha = providedAlpha != null && allowAlpha ? providedAlpha : 1;

      var _hsbToRgb = hsbToRgb({
        hue,
        saturation: 1,
        brightness: 1
      }),
          red = _hsbToRgb.red,
          green = _hsbToRgb.green,
          blue = _hsbToRgb.blue;

      var colorString = "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", ").concat(alpha, ")");
      var draggerX = clamp$1(saturation * pickerSize, 0, pickerSize);
      var draggerY = clamp$1(pickerSize - brightness * pickerSize, 0, pickerSize);
      var alphaSliderMarkup = allowAlpha ? React__default.createElement(AlphaPicker, {
        alpha: alpha,
        color: color,
        onChange: this.handleAlphaChange
      }) : null;
      return React__default.createElement("div", {
        className: styles$H.ColorPicker,
        id: id,
        onMouseDown: this.handlePickerDrag
      }, React__default.createElement("div", {
        ref: this.setColorNode,
        className: styles$H.MainColor
      }, React__default.createElement("div", {
        className: styles$H.ColorLayer,
        style: {
          backgroundColor: colorString
        }
      }), React__default.createElement(Slidable, {
        onChange: this.handleDraggerMove,
        draggerX: draggerX,
        draggerY: draggerY
      })), React__default.createElement(HuePicker, {
        hue: hue,
        onChange: this.handleHueChange
      }), alphaSliderMarkup);
    }
  }]);

  return ColorPicker;
}(React__default.PureComponent);

var FrameContext = React__default.createContext(undefined);

var defaultFrame = {
  showToast: noop$5,
  hideToast: noop$5,
  setContextualSaveBar: noop$5,
  removeContextualSaveBar: noop$5,
  startLoading: noop$5,
  stopLoading: noop$5
};
function useFrame() {
  var frame = useContext(FrameContext);
  var appBridge = useAppBridge();

  if (!frame && !appBridge) {
    throw new Error('No Frame context was provided. Your component must be wrapped in a <Frame> component, or be used within an embedded application by setting the apiKey and shopOrigin properties on <AppProvider>. See https://polaris.shopify.com/components/structure/frame for implementation instructions.');
  } // This makes sure the useFrame hook always returns a FrameContext object, never undefined


  if (appBridge || !frame) {
    return defaultFrame;
  }

  return frame;
}

function noop$5() {}

var ContextualSaveBar = React__default.memo(function ContextualSaveBar(_ref) {
  var message = _ref.message,
      saveAction = _ref.saveAction,
      discardAction = _ref.discardAction,
      alignContentFlush = _ref.alignContentFlush;

  var _useFrame = useFrame(),
      setContextualSaveBar = _useFrame.setContextualSaveBar,
      removeContextualSaveBar = _useFrame.removeContextualSaveBar;

  React__default.useEffect(function () {
    setContextualSaveBar({
      message,
      saveAction,
      discardAction,
      alignContentFlush
    });
  }, [message, saveAction, discardAction, alignContentFlush, setContextualSaveBar]);
  React__default.useEffect(function () {
    return removeContextualSaveBar;
  }, [removeContextualSaveBar]);
  return null;
});

function withAppProvider() {
  return function addProvider(WrappedComponent) {
    var WithAppProvider = function WithAppProvider(props) {
      var polaris = {
        intl: useI18n(),
        stickyManager: useStickyManager(),
        appBridge: useAppBridge(),
        mediaQuery: useMediaQuery()
      };
      return React__default.createElement(WrappedComponent, Object.assign({}, props, {
        polaris: polaris
      }));
    };

    WithAppProvider.displayName = "WithAppProvider(".concat(getDisplayName(WrappedComponent), ")");
    var FinalComponent = hoistStatics(WithAppProvider, WrappedComponent);
    return FinalComponent;
  };
}

function getDisplayName(WrappedComponent) {
  return WrappedComponent.displayName || WrappedComponent.name || 'Component';
}

var styles$I = {
  "DataTable": "Polaris-DataTable",
  "condensed": "Polaris-DataTable--condensed",
  "Navigation": "Polaris-DataTable__Navigation",
  "Pip": "Polaris-DataTable__Pip",
  "Pip-visible": "Polaris-DataTable__Pip--visible",
  "ScrollContainer": "Polaris-DataTable__ScrollContainer",
  "Table": "Polaris-DataTable__Table",
  "TableRow": "Polaris-DataTable__TableRow",
  "Cell": "Polaris-DataTable__Cell",
  "Cell-firstColumn": "Polaris-DataTable__Cell--firstColumn",
  "Cell-numeric": "Polaris-DataTable__Cell--numeric",
  "Cell-truncated": "Polaris-DataTable__Cell--truncated",
  "Cell-header": "Polaris-DataTable__Cell--header",
  "Cell-sortable": "Polaris-DataTable__Cell--sortable",
  "Cell-verticalAlignTop": "Polaris-DataTable__Cell--verticalAlignTop",
  "Cell-verticalAlignBottom": "Polaris-DataTable__Cell--verticalAlignBottom",
  "Cell-verticalAlignMiddle": "Polaris-DataTable__Cell--verticalAlignMiddle",
  "Cell-verticalAlignBaseline": "Polaris-DataTable__Cell--verticalAlignBaseline",
  "Icon": "Polaris-DataTable__Icon",
  "Heading": "Polaris-DataTable__Heading",
  "Heading-left": "Polaris-DataTable__Heading--left",
  "Cell-sorted": "Polaris-DataTable__Cell--sorted",
  "Cell-total": "Polaris-DataTable__Cell--total",
  "Cell-total-footer": "Polaris-DataTable--cellTotalFooter",
  "Footer": "Polaris-DataTable__Footer"
};

function Cell(_ref) {
  var content = _ref.content,
      contentType = _ref.contentType,
      firstColumn = _ref.firstColumn,
      truncate = _ref.truncate,
      header = _ref.header,
      total = _ref.total,
      totalInFooter = _ref.totalInFooter,
      sorted = _ref.sorted,
      sortable = _ref.sortable,
      sortDirection = _ref.sortDirection,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'top' : _ref$verticalAlign,
      _ref$defaultSortDirec = _ref.defaultSortDirection,
      defaultSortDirection = _ref$defaultSortDirec === void 0 ? 'ascending' : _ref$defaultSortDirec,
      onSort = _ref.onSort;
  var i18n = useI18n();
  var numeric = contentType === 'numeric';
  var className = classNames(styles$I.Cell, styles$I["Cell-".concat(variationName('verticalAlign', verticalAlign))], firstColumn && styles$I['Cell-firstColumn'], firstColumn && truncate && styles$I['Cell-truncated'], header && styles$I['Cell-header'], total && styles$I['Cell-total'], totalInFooter && styles$I['Cell-total-footer'], numeric && styles$I['Cell-numeric'], sortable && styles$I['Cell-sortable'], sorted && styles$I['Cell-sorted']);
  var headerClassName = classNames(header && styles$I.Heading, header && contentType === 'text' && styles$I['Heading-left']);
  var iconClassName = classNames(sortable && styles$I.Icon);
  var direction = sorted && sortDirection ? sortDirection : defaultSortDirection;
  var source = direction === 'descending' ? CaretDownMinor : CaretUpMinor;
  var oppositeDirection = sortDirection === 'ascending' ? 'descending' : 'ascending';
  var sortAccessibilityLabel = i18n.translate('Polaris.DataTable.sortAccessibilityLabel', {
    direction: sorted ? oppositeDirection : direction
  });
  var iconMarkup = React__default.createElement("span", {
    className: iconClassName
  }, React__default.createElement(Icon, {
    source: source,
    accessibilityLabel: sortAccessibilityLabel
  }));
  var sortableHeadingContent = React__default.createElement("button", {
    className: headerClassName,
    onClick: onSort
  }, iconMarkup, content);
  var columnHeadingContent = sortable ? sortableHeadingContent : content;
  var headingMarkup = header ? React__default.createElement("th", Object.assign({}, headerCell.props, {
    className: className,
    scope: "col",
    "aria-sort": sortDirection
  }), columnHeadingContent) : React__default.createElement("th", {
    className: className,
    scope: "row"
  }, content);
  var cellMarkup = header || firstColumn ? headingMarkup : React__default.createElement("td", {
    className: className
  }, content);
  return cellMarkup;
}

function Navigation(_ref) {
  var columnVisibilityData = _ref.columnVisibilityData,
      isScrolledFarthestLeft = _ref.isScrolledFarthestLeft,
      isScrolledFarthestRight = _ref.isScrolledFarthestRight,
      navigateTableLeft = _ref.navigateTableLeft,
      navigateTableRight = _ref.navigateTableRight;
  var i18n = useI18n();
  var pipMarkup = columnVisibilityData.map(function (column, index) {
    var className = classNames(styles$I.Pip, column.isVisible && styles$I['Pip-visible']);
    return React__default.createElement("div", {
      className: className,
      key: "pip-".concat(index)
    });
  });
  var leftA11yLabel = i18n.translate('Polaris.DataTable.navAccessibilityLabel', {
    direction: 'left'
  });
  var rightA11yLabel = i18n.translate('Polaris.DataTable.navAccessibilityLabel', {
    direction: 'right'
  });
  return React__default.createElement("div", {
    className: styles$I.Navigation
  }, React__default.createElement(Button, {
    plain: true,
    icon: ChevronLeftMinor,
    disabled: isScrolledFarthestLeft,
    accessibilityLabel: leftA11yLabel,
    onClick: navigateTableLeft
  }), pipMarkup, React__default.createElement(Button, {
    plain: true,
    icon: ChevronRightMinor,
    disabled: isScrolledFarthestRight,
    accessibilityLabel: rightA11yLabel,
    onClick: navigateTableRight
  }));
}

function measureColumn(tableData) {
  return function (column, index) {
    var firstVisibleColumnIndex = tableData.firstVisibleColumnIndex,
        tableStart = tableData.tableLeftVisibleEdge,
        tableEnd = tableData.tableRightVisibleEdge;
    var leftEdge = column.offsetLeft;
    var rightEdge = leftEdge + column.offsetWidth;
    var isVisibleLeft = isEdgeVisible(leftEdge, tableStart, tableEnd);
    var isVisibleRight = isEdgeVisible(rightEdge, tableStart, tableEnd);
    var isVisible = isVisibleLeft || isVisibleRight;

    if (isVisible) {
      tableData.firstVisibleColumnIndex = Math.min(firstVisibleColumnIndex, index);
    }

    return {
      leftEdge,
      rightEdge,
      isVisible
    };
  };
}
function isEdgeVisible(position, start, end) {
  var minVisiblePixels = 30;
  return position >= start + minVisiblePixels && position <= end - minVisiblePixels;
}
function getPrevAndCurrentColumns(tableData, columnData) {
  var firstVisibleColumnIndex = tableData.firstVisibleColumnIndex;
  var previousColumnIndex = Math.max(firstVisibleColumnIndex - 1, 0);
  var previousColumn = columnData[previousColumnIndex];
  var currentColumn = columnData[firstVisibleColumnIndex];
  return {
    previousColumn,
    currentColumn
  };
}

var DataTable =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(DataTable, _React$PureComponent);

  function DataTable(props) {
    var _this;

    _classCallCheck(this, DataTable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DataTable).call(this, props));
    _this.state = {
      condensed: false,
      columnVisibilityData: [],
      isScrolledFarthestLeft: true,
      isScrolledFarthestRight: false
    };
    _this.dataTable = React__default.createRef();
    _this.scrollContainer = React__default.createRef();
    _this.table = React__default.createRef();
    _this.handleResize = debounce(function () {
      var _assertThisInitialize = _assertThisInitialized(_this),
          table = _assertThisInitialize.table.current,
          scrollContainer = _assertThisInitialize.scrollContainer.current;

      var condensed = false;

      if (table && scrollContainer) {
        condensed = table.scrollWidth > scrollContainer.clientWidth;
      }

      _this.setState(Object.assign({
        condensed
      }, _this.calculateColumnVisibilityData(condensed)));
    });

    _this.calculateColumnVisibilityData = function (condensed) {
      var _assertThisInitialize2 = _assertThisInitialized(_this),
          table = _assertThisInitialize2.table.current,
          scrollContainer = _assertThisInitialize2.scrollContainer.current,
          dataTable = _assertThisInitialize2.dataTable.current;

      if (condensed && table && scrollContainer && dataTable) {
        var headerCells = table.querySelectorAll(headerCell.selector);
        var firstVisibleColumnIndex = headerCells.length - 1;
        var tableLeftVisibleEdge = scrollContainer.scrollLeft;
        var tableRightVisibleEdge = scrollContainer.scrollLeft + dataTable.offsetWidth;
        var tableData = {
          firstVisibleColumnIndex,
          tableLeftVisibleEdge,
          tableRightVisibleEdge
        };

        var columnVisibilityData = _toConsumableArray(headerCells).map(measureColumn(tableData));

        var lastColumn = columnVisibilityData[columnVisibilityData.length - 1];
        return Object.assign(Object.assign({
          columnVisibilityData
        }, getPrevAndCurrentColumns(tableData, columnVisibilityData)), {
          isScrolledFarthestLeft: tableLeftVisibleEdge === 0,
          isScrolledFarthestRight: lastColumn.rightEdge <= tableRightVisibleEdge
        });
      }

      return {
        columnVisibilityData: [],
        previousColumn: undefined,
        currentColumn: undefined
      };
    };

    _this.scrollListener = function () {
      _this.setState(function (prevState) {
        return Object.assign({}, _this.calculateColumnVisibilityData(prevState.condensed));
      });
    };

    _this.navigateTable = function (direction) {
      var _this$state = _this.state,
          currentColumn = _this$state.currentColumn,
          previousColumn = _this$state.previousColumn;
      var scrollContainer = _this.scrollContainer.current;

      var handleScroll = function handleScroll() {
        if (!currentColumn || !previousColumn) {
          return;
        }

        if (scrollContainer) {
          scrollContainer.scrollLeft = direction === 'right' ? currentColumn.rightEdge : previousColumn.leftEdge;
          requestAnimationFrame(function () {
            _this.setState(function (prevState) {
              return Object.assign({}, _this.calculateColumnVisibilityData(prevState.condensed));
            });
          });
        }
      };

      return handleScroll;
    };

    _this.renderHeadings = function (heading, headingIndex) {
      var _this$props = _this.props,
          sortable = _this$props.sortable,
          _this$props$truncate = _this$props.truncate,
          truncate = _this$props$truncate === void 0 ? false : _this$props$truncate,
          columnContentTypes = _this$props.columnContentTypes,
          defaultSortDirection = _this$props.defaultSortDirection,
          _this$props$initialSo = _this$props.initialSortColumnIndex,
          initialSortColumnIndex = _this$props$initialSo === void 0 ? 0 : _this$props$initialSo,
          verticalAlign = _this$props.verticalAlign;
      var _this$state2 = _this.state,
          _this$state2$sortDire = _this$state2.sortDirection,
          sortDirection = _this$state2$sortDire === void 0 ? defaultSortDirection : _this$state2$sortDire,
          _this$state2$sortedCo = _this$state2.sortedColumnIndex,
          sortedColumnIndex = _this$state2$sortedCo === void 0 ? initialSortColumnIndex : _this$state2$sortedCo;
      var sortableHeadingProps;
      var id = "heading-cell-".concat(headingIndex);

      if (sortable) {
        var isSortable = sortable[headingIndex];
        var isSorted = isSortable && sortedColumnIndex === headingIndex;
        var direction = isSorted ? sortDirection : 'none';
        sortableHeadingProps = {
          defaultSortDirection,
          sorted: isSorted,
          sortable: isSortable,
          sortDirection: direction,
          onSort: _this.defaultOnSort(headingIndex)
        };
      }

      return React__default.createElement(Cell, Object.assign({
        header: true,
        key: id,
        content: heading,
        contentType: columnContentTypes[headingIndex],
        firstColumn: headingIndex === 0,
        truncate: truncate
      }, sortableHeadingProps, {
        verticalAlign: verticalAlign
      }));
    };

    _this.renderTotals = function (total, index) {
      var id = "totals-cell-".concat(index);
      var _this$props2 = _this.props,
          _this$props2$truncate = _this$props2.truncate,
          truncate = _this$props2$truncate === void 0 ? false : _this$props2$truncate,
          verticalAlign = _this$props2.verticalAlign;
      var content;
      var contentType;

      if (index === 0) {
        content = _this.totalsRowHeading;
      }

      if (total !== '' && index > 0) {
        contentType = 'numeric';
        content = total;
      }

      var totalInFooter = _this.props.showTotalsInFooter;
      return React__default.createElement(Cell, {
        total: true,
        totalInFooter: totalInFooter,
        firstColumn: index === 0,
        key: id,
        content: content,
        contentType: contentType,
        truncate: truncate,
        verticalAlign: verticalAlign
      });
    };

    _this.defaultRenderRow = function (row, index) {
      var className = classNames(styles$I.TableRow);
      var _this$props3 = _this.props,
          columnContentTypes = _this$props3.columnContentTypes,
          _this$props3$truncate = _this$props3.truncate,
          truncate = _this$props3$truncate === void 0 ? false : _this$props3$truncate,
          verticalAlign = _this$props3.verticalAlign;
      return React__default.createElement("tr", {
        key: "row-".concat(index),
        className: className
      }, row.map(function (content, cellIndex) {
        var id = "cell-".concat(cellIndex, "-row-").concat(index);
        return React__default.createElement(Cell, {
          key: id,
          content: content,
          contentType: columnContentTypes[cellIndex],
          firstColumn: cellIndex === 0,
          truncate: truncate,
          verticalAlign: verticalAlign
        });
      }));
    };

    _this.defaultOnSort = function (headingIndex) {
      var _this$props4 = _this.props,
          onSort = _this$props4.onSort,
          _this$props4$defaultS = _this$props4.defaultSortDirection,
          defaultSortDirection = _this$props4$defaultS === void 0 ? 'ascending' : _this$props4$defaultS,
          initialSortColumnIndex = _this$props4.initialSortColumnIndex;
      var _this$state3 = _this.state,
          _this$state3$sortDire = _this$state3.sortDirection,
          sortDirection = _this$state3$sortDire === void 0 ? defaultSortDirection : _this$state3$sortDire,
          _this$state3$sortedCo = _this$state3.sortedColumnIndex,
          sortedColumnIndex = _this$state3$sortedCo === void 0 ? initialSortColumnIndex : _this$state3$sortedCo;
      var newSortDirection = defaultSortDirection;

      if (sortedColumnIndex === headingIndex) {
        newSortDirection = sortDirection === 'ascending' ? 'descending' : 'ascending';
      }

      var handleSort = function handleSort() {
        _this.setState({
          sortDirection: newSortDirection,
          sortedColumnIndex: headingIndex
        }, function () {
          if (onSort) {
            onSort(headingIndex, newSortDirection);
          }
        });
      };

      return handleSort;
    };

    var intl = props.polaris.intl;
    _this.totalsRowHeading = intl.translate('Polaris.DataTable.totalsRowHeading');
    return _this;
  }

  _createClass(DataTable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      // We need to defer the calculation in development so the styles have time to be injected.
      if (process.env.NODE_ENV === 'development') {
        setTimeout(function () {
          _this2.handleResize();
        }, 10);
      } else {
        this.handleResize();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (isEqual(prevProps, this.props)) {
        return;
      }

      this.handleResize();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props5 = this.props,
          headings = _this$props5.headings,
          totals = _this$props5.totals,
          showTotalsInFooter = _this$props5.showTotalsInFooter,
          rows = _this$props5.rows,
          footerContent = _this$props5.footerContent;
      var _this$state4 = this.state,
          condensed = _this$state4.condensed,
          columnVisibilityData = _this$state4.columnVisibilityData,
          isScrolledFarthestLeft = _this$state4.isScrolledFarthestLeft,
          isScrolledFarthestRight = _this$state4.isScrolledFarthestRight;
      var className = classNames(styles$I.DataTable, condensed && styles$I.condensed);
      var wrapperClassName = classNames(styles$I.TableWrapper, condensed && styles$I.condensed);
      var headingMarkup = React__default.createElement("tr", null, headings.map(this.renderHeadings));
      var totalsMarkup = totals ? React__default.createElement("tr", null, totals.map(this.renderTotals)) : null;
      var bodyMarkup = rows.map(this.defaultRenderRow);
      var footerMarkup = footerContent ? React__default.createElement("div", {
        className: styles$I.Footer
      }, footerContent) : null;
      var headerTotalsMarkup = !showTotalsInFooter ? totalsMarkup : null;
      var footerTotalsMarkup = showTotalsInFooter ? React__default.createElement("tfoot", null, totalsMarkup) : null;
      return React__default.createElement("div", {
        className: wrapperClassName
      }, React__default.createElement(Navigation, {
        columnVisibilityData: columnVisibilityData,
        isScrolledFarthestLeft: isScrolledFarthestLeft,
        isScrolledFarthestRight: isScrolledFarthestRight,
        navigateTableLeft: this.navigateTable('left'),
        navigateTableRight: this.navigateTable('right')
      }), React__default.createElement("div", {
        className: className,
        ref: this.dataTable
      }, React__default.createElement("div", {
        className: styles$I.ScrollContainer,
        ref: this.scrollContainer
      }, React__default.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      }), React__default.createElement(EventListener, {
        capture: true,
        event: "scroll",
        handler: this.scrollListener
      }), React__default.createElement("table", {
        className: styles$I.Table,
        ref: this.table
      }, React__default.createElement("thead", null, headingMarkup, headerTotalsMarkup), React__default.createElement("tbody", null, bodyMarkup), footerTotalsMarkup)), footerMarkup));
    }
  }]);

  return DataTable;
}(React__default.PureComponent); // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var DataTable$1 = withAppProvider()(DataTable);

function monthName(month) {
  switch (month) {
    case 0:
      return 'january';

    case 1:
      return 'february';

    case 2:
      return 'march';

    case 3:
      return 'april';

    case 4:
      return 'may';

    case 5:
      return 'june';

    case 6:
      return 'july';

    case 7:
      return 'august';

    case 8:
      return 'september';

    case 9:
      return 'october';

    case 10:
      return 'november';

    case 11:
      return 'december';
  }
}
function weekdayName(weekday) {
  switch (weekday) {
    case 0:
      return 'sunday';

    case 1:
      return 'monday';

    case 2:
      return 'tuesday';

    case 3:
      return 'wednesday';

    case 4:
      return 'thursday';

    case 5:
      return 'friday';

    case 6:
      return 'saturday';
  }
}

var styles$J = {
  "DatePicker": "Polaris-DatePicker",
  "MonthContainer": "Polaris-DatePicker__MonthContainer",
  "Month": "Polaris-DatePicker__Month",
  "Month-current": "Polaris-DatePicker__Month--current",
  "Week": "Polaris-DatePicker__Week",
  "WeekHeadings": "Polaris-DatePicker__WeekHeadings",
  "Day": "Polaris-DatePicker__Day",
  "EmptyDay": "Polaris-DatePicker__EmptyDay",
  "Day-today": "Polaris-DatePicker__Day--today",
  "Day-inRange": "Polaris-DatePicker__Day--inRange",
  "Day-selected": "Polaris-DatePicker__Day--selected",
  "Day-disabled": "Polaris-DatePicker__Day--disabled",
  "Weekday": "Polaris-DatePicker__Weekday",
  "Weekday-current": "Polaris-DatePicker__Weekday--current",
  "Header": "Polaris-DatePicker__Header",
  "Title": "Polaris-DatePicker__Title"
};

function Day(_ref) {
  var day = _ref.day,
      focused = _ref.focused,
      onClick = _ref.onClick,
      _ref$onHover = _ref.onHover,
      onHover = _ref$onHover === void 0 ? noop$6 : _ref$onHover,
      _ref$onFocus = _ref.onFocus,
      _onFocus = _ref$onFocus === void 0 ? noop$6 : _ref$onFocus,
      selected = _ref.selected,
      inRange = _ref.inRange,
      inHoveringRange = _ref.inHoveringRange,
      disabled = _ref.disabled;

  var i18n = useI18n();
  var dayNode = useRef(null);
  useEffect(function () {
    if (focused && dayNode.current) {
      dayNode.current.focus();
    }
  }, [focused]);

  if (!day) {
    return React__default.createElement("div", {
      className: styles$J.EmptyDay,
      onMouseOver: function onMouseOver() {
        return onHover(day);
      }
    });
  }

  var handleClick = onClick && !disabled ? onClick.bind(null, day) : noop$6;
  var today = isSameDay(new Date(), day);
  var className = classNames(styles$J.Day, selected && styles$J['Day-selected'], disabled && styles$J['Day-disabled'], today && styles$J['Day-today'], (inRange || inHoveringRange) && !disabled && styles$J['Day-inRange']);
  var date = day.getDate();
  var tabIndex = (focused || selected || today || date === 1) && !disabled ? 0 : -1;
  var ariaLabel = ["".concat(today ? i18n.translate('Polaris.DatePicker.today') : ''), "".concat(Months[day.getMonth()], " "), "".concat(date, " "), "".concat(day.getFullYear())].join('');
  return React__default.createElement("button", {
    onFocus: function onFocus() {
      return _onFocus(day);
    },
    type: "button",
    ref: dayNode,
    tabIndex: tabIndex,
    className: className,
    onMouseOver: function onMouseOver() {
      return onHover(day);
    },
    onClick: handleClick,
    "aria-label": ariaLabel,
    "aria-selected": selected,
    "aria-disabled": disabled,
    role: "gridcell"
  }, date);
}

function noop$6() {}

function Weekday(_ref) {
  var label = _ref.label,
      title = _ref.title,
      current = _ref.current;
  var className = classNames(styles$J.Weekday, current && styles$J['Weekday-current']);
  return React__default.createElement("div", {
    "aria-label": Weekdays[label],
    className: className
  }, title);
}

var WEEKDAYS = [Weekdays.Sunday, Weekdays.Monday, Weekdays.Tuesday, Weekdays.Wednesday, Weekdays.Thursday, Weekdays.Friday, Weekdays.Saturday];
function Month(_ref) {
  var focusedDate = _ref.focusedDate,
      selected = _ref.selected,
      hoverDate = _ref.hoverDate,
      disableDatesBefore = _ref.disableDatesBefore,
      disableDatesAfter = _ref.disableDatesAfter,
      allowRange = _ref.allowRange,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop$7 : _ref$onChange,
      _ref$onHover = _ref.onHover,
      onHover = _ref$onHover === void 0 ? noop$7 : _ref$onHover,
      _ref$onFocus = _ref.onFocus,
      onFocus = _ref$onFocus === void 0 ? noop$7 : _ref$onFocus,
      month = _ref.month,
      year = _ref.year,
      weekStartsOn = _ref.weekStartsOn;
  var i18n = useI18n();
  var isInHoveringRange = allowRange ? hoveringDateIsInRange : function () {
    return false;
  };
  var now = new Date();
  var current = now.getMonth() === month && now.getFullYear() === year;
  var className = classNames(styles$J.Title, current && styles$J['Month-current']);
  var weeks = getWeeksForMonth(month, year, weekStartsOn);
  var weekdays = getWeekdaysOrdered(weekStartsOn).map(function (weekday) {
    return React__default.createElement(Weekday, {
      key: weekday,
      title: i18n.translate("Polaris.DatePicker.daysAbbreviated.".concat(weekdayName(weekday))),
      current: current && new Date().getDay() === weekday,
      label: weekday
    });
  });

  function handleDateClick(selectedDate) {
    onChange(getNewRange(allowRange ? selected : undefined, selectedDate));
  }

  function renderWeek(day, dayIndex) {
    if (day == null) {
      var lastDayOfMonth = new Date(year, month + 1, 0);
      return React__default.createElement(Day, {
        key: dayIndex,
        onHover: onHover.bind(null, lastDayOfMonth)
      });
    }

    var disabled = disableDatesBefore && isDateBefore(day, disableDatesBefore) || disableDatesAfter && isDateAfter(day, disableDatesAfter);
    return React__default.createElement(Day, {
      focused: focusedDate != null && isSameDay(day, focusedDate),
      day: day,
      key: dayIndex,
      onFocus: onFocus,
      onClick: handleDateClick,
      onHover: onHover,
      selected: selected != null && dateIsSelected(day, selected),
      inRange: selected != null && dateIsInRange(day, selected),
      disabled: disabled,
      inHoveringRange: selected != null && hoverDate != null && isInHoveringRange(day, selected, hoverDate)
    });
  }

  var weeksMarkup = weeks.map(function (week, index) {
    return React__default.createElement("div", {
      role: "row",
      className: styles$J.Week,
      key: index
    }, week.map(renderWeek));
  });
  return React__default.createElement("div", {
    role: "grid",
    className: styles$J.Month
  }, React__default.createElement("div", {
    className: className
  }, i18n.translate("Polaris.DatePicker.months.".concat(monthName(month))), " ", year), React__default.createElement("div", {
    role: "rowheader",
    className: styles$J.WeekHeadings
  }, weekdays), weeksMarkup);
}

function noop$7() {}

function hoveringDateIsInRange(day, range, hoverEndDate) {
  if (day == null) {
    return false;
  }

  var start = range.start,
      end = range.end;
  return Boolean(isSameDay(start, end) && day > start && day <= hoverEndDate);
}

function getWeekdaysOrdered(weekStartsOn) {
  var weekDays = [].concat(WEEKDAYS);
  var restOfDays = weekDays.splice(weekStartsOn);
  return [].concat(_toConsumableArray(restOfDays), _toConsumableArray(weekDays));
}

function DatePicker(_ref) {
  var id = _ref.id,
      selected = _ref.selected,
      month = _ref.month,
      year = _ref.year,
      allowRange = _ref.allowRange,
      multiMonth = _ref.multiMonth,
      disableDatesBefore = _ref.disableDatesBefore,
      disableDatesAfter = _ref.disableDatesAfter,
      _ref$weekStartsOn = _ref.weekStartsOn,
      weekStartsOn = _ref$weekStartsOn === void 0 ? Weekdays.Sunday : _ref$weekStartsOn,
      onMonthChange = _ref.onMonthChange,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop$8 : _ref$onChange;
  var i18n = useI18n();

  var _useState = useState(undefined),
      _useState2 = _slicedToArray(_useState, 2),
      hoverDate = _useState2[0],
      setHoverDate = _useState2[1];

  var _useState3 = useState(undefined),
      _useState4 = _slicedToArray(_useState3, 2),
      focusDate = _useState4[0],
      setFocusDate = _useState4[1];

  useEffect(function () {
    setFocusDate(undefined);
  }, [selected]);
  var handleFocus = useCallback(function (date) {
    setFocusDate(date);
  }, []);
  var setFocusDateAndHandleMonthChange = useCallback(function (date) {
    if (onMonthChange) {
      onMonthChange(date.getMonth(), date.getFullYear());
    }

    setHoverDate(date);
    setFocusDate(date);
  }, [onMonthChange]);
  var handleDateSelection = useCallback(function (range) {
    var end = range.end;
    setHoverDate(end);
    setFocusDate(new Date(end));
    onChange(range);
  }, [onChange]);
  var handleMonthChangeClick = useCallback(function (month, year) {
    if (!onMonthChange) {
      return;
    }

    setFocusDate(undefined);
    onMonthChange(month, year);
  }, [onMonthChange]);
  var handleHover = useCallback(function (date) {
    setHoverDate(date);
  }, []);
  var handleKeyUp = useCallback(function (event) {
    var key = event.key;
    var range = deriveRange(selected);
    var focusedDate = focusDate || range && range.start;

    if (focusedDate == null) {
      return;
    }

    if (key === 'ArrowUp') {
      var previousWeek = new Date(focusedDate);
      previousWeek.setDate(focusedDate.getDate() - 7);

      if (!(disableDatesBefore && isDateBefore(previousWeek, disableDatesBefore))) {
        setFocusDateAndHandleMonthChange(previousWeek);
      }
    }

    if (key === 'ArrowDown') {
      var nextWeek = new Date(focusedDate);
      nextWeek.setDate(focusedDate.getDate() + 7);

      if (!(disableDatesAfter && isDateAfter(nextWeek, disableDatesAfter))) {
        setFocusDateAndHandleMonthChange(nextWeek);
      }
    }

    if (key === 'ArrowRight') {
      var tomorrow = new Date(focusedDate);
      tomorrow.setDate(focusedDate.getDate() + 1);

      if (!(disableDatesAfter && isDateAfter(tomorrow, disableDatesAfter))) {
        setFocusDateAndHandleMonthChange(tomorrow);
      }
    }

    if (key === 'ArrowLeft') {
      var yesterday = new Date(focusedDate);
      yesterday.setDate(focusedDate.getDate() - 1);

      if (!(disableDatesBefore && isDateBefore(yesterday, disableDatesBefore))) {
        setFocusDateAndHandleMonthChange(yesterday);
      }
    }
  }, [disableDatesAfter, disableDatesBefore, focusDate, selected, setFocusDateAndHandleMonthChange]);
  var showNextYear = getNextDisplayYear(month, year);
  var showNextMonth = getNextDisplayMonth(month);
  var showNextToNextYear = getNextDisplayYear(showNextMonth, showNextYear);
  var showNextToNextMonth = getNextDisplayMonth(showNextMonth);
  var showPreviousYear = getPreviousDisplayYear(month, year);
  var showPreviousMonth = getPreviousDisplayMonth(month);
  var previousMonthName = i18n.translate("Polaris.DatePicker.months.".concat(monthName(showPreviousMonth)));
  var nextMonth = multiMonth ? i18n.translate("Polaris.DatePicker.months.".concat(monthName(showNextToNextMonth))) : i18n.translate("Polaris.DatePicker.months.".concat(monthName(showNextMonth)));
  var nextYear = multiMonth ? showNextToNextYear : showNextYear;
  var secondDatePicker = multiMonth ? React__default.createElement(Month, {
    onFocus: handleFocus,
    focusedDate: focusDate,
    month: showNextMonth,
    year: showNextYear,
    selected: deriveRange(selected),
    hoverDate: hoverDate,
    onChange: handleDateSelection,
    onHover: handleHover,
    disableDatesBefore: disableDatesBefore,
    disableDatesAfter: disableDatesAfter,
    allowRange: allowRange,
    weekStartsOn: weekStartsOn
  }) : null;
  return React__default.createElement("div", {
    id: id,
    className: styles$J.DatePicker,
    onKeyDown: handleKeyDown,
    onKeyUp: handleKeyUp
  }, React__default.createElement("div", {
    className: styles$J.Header
  }, React__default.createElement(Button, {
    plain: true,
    icon: ArrowLeftMinor,
    accessibilityLabel: i18n.translate('Polaris.DatePicker.previousMonth', {
      previousMonthName,
      showPreviousYear
    }),
    onClick: function onClick() {
      return handleMonthChangeClick(showPreviousMonth, showPreviousYear);
    }
  }), React__default.createElement(Button, {
    plain: true,
    icon: ArrowRightMinor,
    accessibilityLabel: i18n.translate('Polaris.DatePicker.nextMonth', {
      nextMonth,
      nextYear
    }),
    onClick: function onClick() {
      return handleMonthChangeClick(showNextMonth, showNextYear);
    }
  })), React__default.createElement("div", {
    className: styles$J.MonthContainer
  }, React__default.createElement(Month, {
    onFocus: handleFocus,
    focusedDate: focusDate,
    month: month,
    year: year,
    selected: deriveRange(selected),
    hoverDate: hoverDate,
    onChange: handleDateSelection,
    onHover: handleHover,
    disableDatesBefore: disableDatesBefore,
    disableDatesAfter: disableDatesAfter,
    allowRange: allowRange,
    weekStartsOn: weekStartsOn
  }), secondDatePicker));
}

function noop$8() {}

function handleKeyDown(event) {
  var key = event.key;

  if (key === 'ArrowUp' || key === 'ArrowDown' || key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
}

function deriveRange(selected) {
  return selected instanceof Date ? {
    start: selected,
    end: selected
  } : selected;
}

var styles$K = {
  "DescriptionList": "Polaris-DescriptionList",
  "Term": "Polaris-DescriptionList__Term",
  "Description": "Polaris-DescriptionList__Description"
};

var getUniqueTermKey = createUniqueIDFactory("Term");
var getUniqueDescriptionKey = createUniqueIDFactory("Description");
function DescriptionList(_ref) {
  var items = _ref.items;
  var terms = items.reduce(function (allTerms, _ref2) {
    var term = _ref2.term,
        description = _ref2.description;
    return [].concat(_toConsumableArray(allTerms), [React__default.createElement("dt", {
      key: getUniqueTermKey(),
      className: styles$K.Term
    }, term), React__default.createElement("dd", {
      key: getUniqueDescriptionKey(),
      className: styles$K.Description
    }, description)]);
  }, []);
  return React__default.createElement("dl", {
    className: styles$K.DescriptionList
  }, terms);
}

var styles$L = {
  "DisplayText": "Polaris-DisplayText",
  "sizeSmall": "Polaris-DisplayText--sizeSmall",
  "sizeMedium": "Polaris-DisplayText--sizeMedium",
  "sizeLarge": "Polaris-DisplayText--sizeLarge",
  "sizeExtraLarge": "Polaris-DisplayText--sizeExtraLarge"
};

function DisplayText(_ref) {
  var _ref$element = _ref.element,
      Element = _ref$element === void 0 ? 'p' : _ref$element,
      children = _ref.children,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = classNames(styles$L.DisplayText, size && styles$L[variationName('size', size)]);
  return React__default.createElement(Element, {
    className: className
  }, children);
}

function capitalize() {
  var word = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var wordLower = word.toLowerCase();
  return wordLower.charAt(0).toUpperCase() + wordLower.slice(1);
}

/**
 * Similarly to the life-cycle method componentDidMount, useComponentDidMount
 * will be invoked after the component has mounted, and only the initial mount.
 * @param callback Defines a callback to invoke once the component has
 * initially mounted.
 * @example
 * function Playground({active}) {
 *  useComponentDidMount(() => {
 *    if (active) {
 *      console.warning(`Component has mounted.`);
 *    }
 *  });
 *
 *  return null;
 * }
 */

function useComponentDidMount(callback) {
  var isAfterInitialMount = useIsAfterInitialMount();
  var hasInvokedLifeCycle = useRef(false);

  if (isAfterInitialMount && !hasInvokedLifeCycle.current) {
    hasInvokedLifeCycle.current = true;
    return callback();
  }
}

var fileUpload = 'data:image/svg+xml;base64,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';

var imageUpload = 'data:image/svg+xml;base64,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';

var DropZoneContext = React__default.createContext({
  disabled: false,
  focused: false,
  size: 'extraLarge',
  type: 'file',
  measuring: false
});

var styles$M = {
  "FileUpload": "Polaris-DropZone-FileUpload",
  "Button": "Polaris-DropZone-FileUpload__Button",
  "globalTheming": "Polaris-DropZone-FileUpload--globalTheming",
  "disabled": "Polaris-DropZone-FileUpload--disabled",
  "focused": "Polaris-DropZone-FileUpload--focused",
  "sizeSlim": "Polaris-DropZone-FileUpload--sizeSlim",
  "ActionTitle": "Polaris-DropZone-FileUpload__ActionTitle",
  "ActionTitle-disabled": "Polaris-DropZone-FileUpload__ActionTitle--disabled",
  "ActionTitle-focused": "Polaris-DropZone-FileUpload__ActionTitle--focused",
  "Image": "Polaris-DropZone-FileUpload__Image",
  "sizeExtraLarge": "Polaris-DropZone-FileUpload--sizeExtraLarge",
  "sizeLarge": "Polaris-DropZone-FileUpload--sizeLarge"
};

function FileUpload(props) {
  var i18n = useI18n();

  var _useContext = useContext(DropZoneContext),
      size = _useContext.size,
      measuring = _useContext.measuring,
      type = _useContext.type,
      focused = _useContext.focused,
      disabled = _useContext.disabled;

  var suffix = capitalize(type);
  var _props$actionTitle = props.actionTitle,
      actionTitle = _props$actionTitle === void 0 ? i18n.translate("Polaris.DropZone.FileUpload.actionTitle".concat(suffix)) : _props$actionTitle,
      _props$actionHint = props.actionHint,
      actionHint = _props$actionHint === void 0 ? i18n.translate("Polaris.DropZone.FileUpload.actionHint".concat(suffix)) : _props$actionHint;
  var imageClasses = classNames(styles$M.Image, size && size === 'extraLarge' && styles$M.sizeExtraLarge, size && size === 'large' && styles$M.sizeLarge);
  var buttonStyles = size === 'extraLarge' || size === 'large' ? classNames(styles$M.Button, size && size !== 'extraLarge' && styles$M.slim, focused && styles$M.focused, disabled && styles$M.disabled) : null;
  var buttonMarkup = (size === 'extraLarge' || size === 'large') && buttonStyles ? React__default.createElement("div", {
    className: buttonStyles
  }, actionTitle) : null;
  var extraLargeView = size === 'extraLarge' ? React__default.createElement(Stack, {
    vertical: true
  }, type === 'file' && React__default.createElement("img", {
    className: imageClasses,
    src: fileUpload,
    alt: ""
  }), type === 'image' && React__default.createElement("img", {
    className: imageClasses,
    src: imageUpload,
    alt: ""
  }), buttonMarkup, React__default.createElement(TextStyle, {
    variation: "subdued"
  }, actionHint)) : null;
  var largeView = size === 'large' ? React__default.createElement(Stack, {
    vertical: true,
    spacing: "tight"
  }, type === 'file' && React__default.createElement("img", {
    className: imageClasses,
    src: fileUpload,
    alt: ""
  }), type === 'image' && React__default.createElement("img", {
    className: imageClasses,
    src: imageUpload,
    alt: ""
  }), buttonMarkup, React__default.createElement(Caption, null, React__default.createElement(TextStyle, {
    variation: "subdued"
  }, actionHint))) : null;
  var actionTitleClassName = classNames(styles$M.ActionTitle, focused && !disabled && styles$M['ActionTitle-focused'], disabled && styles$M['ActionTitle-disabled']);
  var actionTitleMarkup = React__default.createElement("div", {
    className: actionTitleClassName
  }, actionTitle);
  var mediumView = size === 'medium' ? React__default.createElement(Stack, {
    vertical: true,
    spacing: "tight"
  }, actionTitleMarkup, React__default.createElement(Caption, null, React__default.createElement(TextStyle, {
    variation: "subdued"
  }, actionHint))) : null;
  var smallView = size === 'small' ? React__default.createElement(Stack, {
    vertical: true,
    spacing: "tight"
  }, React__default.createElement(Icon, {
    source: DragDropMajorMonotone,
    color: "inkLightest"
  })) : null;
  var fileUploadClassName = classNames(styles$M.FileUpload, measuring && styles$M.measuring);
  return React__default.createElement("div", {
    className: fileUploadClassName
  }, smallView, mediumView, largeView, extraLargeView);
}

var dragEvents = ['dragover', 'dragenter', 'drop'];
function fileAccepted(file, accept) {
  return file.type === 'application/x-moz-file' || accepts(file, accept);
}
function getDataTransferFiles(event) {
  if (isDragEvent(event) && event.dataTransfer) {
    var dt = event.dataTransfer;

    if (dt.files && dt.files.length) {
      return Array.from(dt.files);
    } else if (dt.items && dt.items.length) {
      // Chrome is the only browser that allows to read the file list on drag
      // events and uses `items` instead of `files` in this case.
      return Array.from(dt.items);
    }
  } else if (isChangeEvent(event) && event.target.files) {
    // Return files from even when a file was selected from an upload dialog
    return Array.from(event.target.files);
  }

  return [];
}

function accepts(file, acceptedFiles) {
  if (file && acceptedFiles) {
    var fileName = file.name || '';
    var mimeType = file.type || '';
    var baseMimeType = mimeType.replace(/\/.*$/, '');
    var acceptedFilesArray = Array.isArray(acceptedFiles) ? acceptedFiles : acceptedFiles.split(',');
    return acceptedFilesArray.some(function (type) {
      var validType = type.trim();

      if (validType.startsWith('.')) {
        return fileName.toLowerCase().endsWith(validType.toLowerCase());
      } else if (validType.endsWith('/*')) {
        // This is something like a image/* mime type
        return baseMimeType === validType.replace(/\/.*$/, '');
      }

      return mimeType === validType;
    });
  }

  return true;
}

function isDragEvent(event) {
  return dragEvents.indexOf(event.type) > 0;
}

function isChangeEvent(event) {
  return Object.prototype.hasOwnProperty.call(event, 'target');
}

var styles$N = {
  "DropZone": "Polaris-DropZone",
  "hasOutline": "Polaris-DropZone--hasOutline",
  "isDisabled": "Polaris-DropZone--isDisabled",
  "focused": "Polaris-DropZone--focused",
  "isDragging": "Polaris-DropZone--isDragging",
  "sizeExtraLarge": "Polaris-DropZone--sizeExtraLarge",
  "sizeLarge": "Polaris-DropZone--sizeLarge",
  "sizeMedium": "Polaris-DropZone--sizeMedium",
  "sizeSmall": "Polaris-DropZone--sizeSmall",
  "measuring": "Polaris-DropZone--measuring",
  "Container": "Polaris-DropZone__Container",
  "Overlay": "Polaris-DropZone__Overlay",
  "hasError": "Polaris-DropZone--hasError"
};

// subcomponents so explicitly state the subcomponents in the type definition.
// Letting this be implicit works in this project but fails in projects that use
// generated *.d.ts files.

var DropZone = function DropZone(_ref) {
  var dropOnPage = _ref.dropOnPage,
      label = _ref.label,
      labelAction = _ref.labelAction,
      labelHidden = _ref.labelHidden,
      children = _ref.children,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$outline = _ref.outline,
      outline = _ref$outline === void 0 ? true : _ref$outline,
      accept = _ref.accept,
      active = _ref.active,
      _ref$overlay = _ref.overlay,
      overlay = _ref$overlay === void 0 ? true : _ref$overlay,
      _ref$allowMultiple = _ref.allowMultiple,
      allowMultiple = _ref$allowMultiple === void 0 ? true : _ref$allowMultiple,
      overlayText = _ref.overlayText,
      errorOverlayText = _ref.errorOverlayText,
      idProp = _ref.id,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'file' : _ref$type,
      onClick = _ref.onClick,
      error = _ref.error,
      openFileDialog = _ref.openFileDialog,
      onFileDialogClose = _ref.onFileDialogClose,
      customValidator = _ref.customValidator,
      onDrop = _ref.onDrop,
      onDropAccepted = _ref.onDropAccepted,
      onDropRejected = _ref.onDropRejected,
      onDragEnter = _ref.onDragEnter,
      onDragOver = _ref.onDragOver,
      onDragLeave = _ref.onDragLeave;
  var node = useRef(null);
  var dragTargets = useRef([]);
  var adjustSize = useCallback(debounce(function () {
    if (!node.current) {
      return;
    }

    var size = 'extraLarge';
    var width = node.current.getBoundingClientRect().width;

    if (width < 100) {
      size = 'small';
    } else if (width < 160) {
      size = 'medium';
    } else if (width < 300) {
      size = 'large';
    }

    setSize(size);
    measuring && setMeasuring(false);
  }, 50, {
    trailing: true
  }), []);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      dragging = _useState2[0],
      setDragging = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      internalError = _useState4[0],
      setInternalError = _useState4[1];

  var _useToggle = useToggle(false),
      focused = _useToggle.value,
      handleFocus = _useToggle.setTrue,
      handleBlur = _useToggle.setFalse;

  var _useState5 = useState(0),
      _useState6 = _slicedToArray(_useState5, 2),
      numFiles = _useState6[0],
      setNumFiles = _useState6[1];

  var _useState7 = useState('extraLarge'),
      _useState8 = _slicedToArray(_useState7, 2),
      size = _useState8[0],
      setSize = _useState8[1];

  var _useState9 = useState(true),
      _useState10 = _slicedToArray(_useState9, 2),
      measuring = _useState10[0],
      setMeasuring = _useState10[1];

  var i18n = useI18n();
  var getValidatedFiles = useCallback(function (files) {
    var acceptedFiles = [];
    var rejectedFiles = [];
    Array.from(files).forEach(function (file) {
      !fileAccepted(file, accept) || customValidator && !customValidator(file) ? rejectedFiles.push(file) : acceptedFiles.push(file);
    });

    if (!allowMultiple) {
      acceptedFiles.splice(1, acceptedFiles.length);
      rejectedFiles.push.apply(rejectedFiles, _toConsumableArray(acceptedFiles.slice(1)));
    }

    return {
      files,
      acceptedFiles,
      rejectedFiles
    };
  }, [accept, allowMultiple, customValidator]);
  var handleDrop = useCallback(function (event) {
    stopEvent(event);
    if (disabled || !allowMultiple && numFiles > 0) return;
    var fileList = getDataTransferFiles(event);

    var _getValidatedFiles = getValidatedFiles(fileList),
        files = _getValidatedFiles.files,
        acceptedFiles = _getValidatedFiles.acceptedFiles,
        rejectedFiles = _getValidatedFiles.rejectedFiles;

    dragTargets.current = [];
    setDragging(false);
    setInternalError(rejectedFiles.length > 0);
    setNumFiles(function (numFiles) {
      return numFiles + acceptedFiles.length;
    });
    onDrop && onDrop(files, acceptedFiles, rejectedFiles);
    onDropAccepted && acceptedFiles.length && onDropAccepted(acceptedFiles);
    onDropRejected && rejectedFiles.length && onDropRejected(rejectedFiles);
    event.target.value = '';
  }, [allowMultiple, disabled, getValidatedFiles, numFiles, onDrop, onDropAccepted, onDropRejected]);
  var handleDragEnter = useCallback(function (event) {
    stopEvent(event);
    if (disabled || !allowMultiple && numFiles > 0) return;
    var fileList = getDataTransferFiles(event);

    if (event.target && !dragTargets.current.includes(event.target)) {
      dragTargets.current.push(event.target);
    }

    if (dragging) return;

    var _getValidatedFiles2 = getValidatedFiles(fileList),
        rejectedFiles = _getValidatedFiles2.rejectedFiles;

    setDragging(true);
    setInternalError(rejectedFiles.length > 0);
    onDragEnter && onDragEnter();
  }, [allowMultiple, disabled, dragging, getValidatedFiles, numFiles, onDragEnter]);
  var handleDragOver = useCallback(function (event) {
    stopEvent(event);
    if (disabled || !allowMultiple && numFiles > 0) return;
    onDragOver && onDragOver();
  }, [allowMultiple, disabled, numFiles, onDragOver]);
  var handleDragLeave = useCallback(function (event) {
    event.preventDefault();
    if (disabled || !allowMultiple && numFiles > 0) return;
    dragTargets.current = dragTargets.current.filter(function (el) {
      var compareNode = dropOnPage && !isServer ? document : node.current;
      return el !== event.target && compareNode && compareNode.contains(el);
    });
    if (dragTargets.current.length > 0) return;
    setDragging(false);
    setInternalError(false);
    onDragLeave && onDragLeave();
  }, [allowMultiple, dropOnPage, disabled, numFiles, onDragLeave]);
  useEffect(function () {
    var dropNode = dropOnPage ? document : node.current;
    if (!dropNode) return;
    addEventListener(dropNode, 'drop', handleDrop);
    addEventListener(dropNode, 'dragover', handleDragOver);
    addEventListener(dropNode, 'dragenter', handleDragEnter);
    addEventListener(dropNode, 'dragleave', handleDragLeave);
    addEventListener(window, 'resize', adjustSize);
    return function () {
      removeEventListener(dropNode, 'drop', handleDrop);
      removeEventListener(dropNode, 'dragover', handleDragOver);
      removeEventListener(dropNode, 'dragenter', handleDragEnter);
      removeEventListener(dropNode, 'dragleave', handleDragLeave);
      removeEventListener(window, 'resize', adjustSize);
    };
  }, [dropOnPage, handleDrop, handleDragOver, handleDragEnter, handleDragLeave, adjustSize]);
  useComponentDidMount(function () {
    adjustSize();
  });
  var id = useUniqueId('DropZone', idProp);
  var suffix = capitalize(type);
  var overlayTextWithDefault = overlayText === undefined ? i18n.translate("Polaris.DropZone.overlayText".concat(suffix)) : overlayText;
  var errorOverlayTextWithDefault = errorOverlayText === undefined ? i18n.translate("Polaris.DropZone.errorOverlayText".concat(suffix)) : errorOverlayText;
  var inputAttributes = {
    id,
    accept,
    disabled,
    type: 'file',
    multiple: allowMultiple,
    onChange: handleDrop,
    onFocus: handleFocus,
    onBlur: handleBlur
  };
  var classes = classNames(styles$N.DropZone, outline && styles$N.hasOutline, focused && styles$N.focused, (active || dragging) && styles$N.isDragging, disabled && styles$N.isDisabled, (internalError || error) && styles$N.hasError, styles$N[variationName('size', size)], measuring && styles$N.measuring);
  var dragOverlay = (active || dragging) && (!internalError || !error) && overlay && overlayMarkup(DragDropMajorMonotone, 'indigo', overlayTextWithDefault);
  var dragErrorOverlay = dragging && (internalError || error) && overlayMarkup(CircleAlertMajorMonotone, 'red', errorOverlayTextWithDefault);
  var labelValue = label || i18n.translate('Polaris.DropZone.FileUpload.label');
  var labelHiddenValue = label ? labelHidden : true;
  var context = useMemo(function () {
    return {
      disabled,
      focused,
      size,
      type: type || 'file',
      measuring
    };
  }, [disabled, focused, measuring, size, type]);
  return React__default.createElement(DropZoneContext.Provider, {
    value: context
  }, React__default.createElement(Labelled, {
    id: id,
    label: labelValue,
    action: labelAction,
    labelHidden: labelHiddenValue
  }, React__default.createElement("div", {
    ref: node,
    className: classes,
    "aria-disabled": disabled,
    onClick: handleClick,
    onDragStart: stopEvent
  }, dragOverlay, dragErrorOverlay, React__default.createElement("div", {
    className: styles$N.Container
  }, children), React__default.createElement(VisuallyHidden, null, React__default.createElement(DropZoneInput, Object.assign({}, inputAttributes, {
    openFileDialog: openFileDialog,
    onFileDialogClose: onFileDialogClose
  }))))));

  function overlayMarkup(icon, color, text) {
    return React__default.createElement("div", {
      className: styles$N.Overlay
    }, React__default.createElement(Stack, {
      vertical: true,
      spacing: "tight"
    }, React__default.createElement(Icon, {
      source: icon,
      color: color
    }), size === 'extraLarge' && React__default.createElement(DisplayText, {
      size: "small",
      element: "p"
    }, text), (size === 'medium' || size === 'large') && React__default.createElement(Caption, null, text)));
  }

  function open() {
    var fileInputNode = node.current && node.current.querySelector("#".concat(id));
    fileInputNode && fileInputNode instanceof HTMLElement && fileInputNode.click();
  }

  function handleClick(event) {
    if (disabled || !allowMultiple && numFiles > 0) return;
    return onClick ? onClick(event) : open();
  }
};

function stopEvent(event) {
  event.preventDefault();
  event.stopPropagation();
}

DropZone.FileUpload = FileUpload; // Due to security reasons, browsers do not allow file inputs to be opened artificially.
// For example `useEffect(() => { ref.click() })`. Oddly enough react class-based components bi-pass this.

var DropZoneInput =
/*#__PURE__*/
function (_Component) {
  _inherits(DropZoneInput, _Component);

  function DropZoneInput() {
    var _this;

    _classCallCheck(this, DropZoneInput);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DropZoneInput).apply(this, arguments));
    _this.fileInputNode = React__default.createRef();

    _this.triggerFileDialog = function () {
      _this.open();

      _this.props.onFileDialogClose && _this.props.onFileDialogClose();
    };

    _this.open = function () {
      if (!_this.fileInputNode.current) return;

      _this.fileInputNode.current.click();
    };

    return _this;
  }

  _createClass(DropZoneInput, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.openFileDialog && this.triggerFileDialog();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.props.openFileDialog && this.triggerFileDialog();
    }
  }, {
    key: "render",
    value: function render() {
      var _a = this.props,
          openFileDialog = _a.openFileDialog,
          onFileDialogClose = _a.onFileDialogClose,
          inputProps = __rest(_a, ["openFileDialog", "onFileDialogClose"]);

      return React__default.createElement("input", Object.assign({}, inputProps, {
        ref: this.fileInputNode,
        autoComplete: "off"
      }));
    }
  }]);

  return DropZoneInput;
}(Component);

var emptySearch = 'data:image/svg+xml;base64,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';

var styles$O = {
  "Image": "Polaris-EmptySearchResult__Image"
};

function EmptySearchResult(_ref) {
  var title = _ref.title,
      description = _ref.description,
      withIllustration = _ref.withIllustration;
  var i18n = useI18n();
  var altText = i18n.translate('Polaris.EmptySearchResult.altText');
  var descriptionMarkup = description ? React__default.createElement("p", null, description) : null;
  var illustrationMarkup = withIllustration ? React__default.createElement(Image, {
    alt: altText,
    source: emptySearch,
    className: styles$O.Image,
    draggable: false
  }) : null;
  return React__default.createElement(Stack, {
    alignment: "center",
    vertical: true
  }, illustrationMarkup, React__default.createElement(DisplayText, {
    size: "small"
  }, title), React__default.createElement(TextStyle, {
    variation: "subdued"
  }, descriptionMarkup));
}

var styles$P = {
  "EmptyState": "Polaris-EmptyState",
  "Section": "Polaris-EmptyState__Section",
  "ImageContainer": "Polaris-EmptyState__ImageContainer",
  "DetailsContainer": "Polaris-EmptyState__DetailsContainer",
  "withinContentContainer": "Polaris-EmptyState--withinContentContainer",
  "Details": "Polaris-EmptyState__Details",
  "Image": "Polaris-EmptyState__Image",
  "Content": "Polaris-EmptyState__Content",
  "withinPage": "Polaris-EmptyState--withinPage",
  "imageContained": "Polaris-EmptyState--imageContained",
  "Actions": "Polaris-EmptyState__Actions",
  "FooterContent": "Polaris-EmptyState__FooterContent"
};

function EmptyState(_ref) {
  var children = _ref.children,
      heading = _ref.heading,
      image = _ref.image,
      largeImage = _ref.largeImage,
      imageContained = _ref.imageContained,
      action = _ref.action,
      secondaryAction = _ref.secondaryAction,
      footerContent = _ref.footerContent;
  var withinContentContainer = useContext(WithinContentContext);
  var className = classNames(styles$P.EmptyState, imageContained && styles$P.imageContained, withinContentContainer ? styles$P.withinContentContainer : styles$P.withinPage);
  var imageMarkup = largeImage ? React__default.createElement(Image, {
    alt: "",
    role: "presentation",
    className: styles$P.Image,
    source: largeImage,
    sourceSet: [{
      source: image,
      descriptor: '568w'
    }, {
      source: largeImage,
      descriptor: '1136w'
    }],
    sizes: "(max-width: 568px) 60vw"
  }) : React__default.createElement(Image, {
    role: "presentation",
    alt: "",
    className: styles$P.Image,
    source: image
  });
  var secondaryActionMarkup = secondaryAction ? buttonFrom(secondaryAction, {
    plain: true
  }) : null;
  var footerContentMarkup = footerContent ? React__default.createElement("div", {
    className: styles$P.FooterContent
  }, React__default.createElement(TextContainer, null, footerContent)) : null;
  var headingSize = withinContentContainer ? 'small' : 'medium';
  var primaryActionSize = withinContentContainer ? 'medium' : 'large';
  var primaryActionMarkup = action ? buttonFrom(action, {
    primary: true,
    size: primaryActionSize
  }) : null;
  var headingMarkup = heading ? React__default.createElement(DisplayText, {
    size: headingSize
  }, heading) : null;
  var childrenMarkup = children ? React__default.createElement("div", {
    className: styles$P.Content
  }, children) : null;
  var textContentMarkup = headingMarkup || children ? React__default.createElement(TextContainer, null, headingMarkup, childrenMarkup) : null;
  var actionsMarkup = primaryActionMarkup || secondaryActionMarkup ? React__default.createElement("div", {
    className: styles$P.Actions
  }, React__default.createElement(Stack, {
    alignment: "center"
  }, primaryActionMarkup, secondaryActionMarkup)) : null;
  var detailsMarkup = textContentMarkup || actionsMarkup || footerContentMarkup ? React__default.createElement("div", {
    className: styles$P.DetailsContainer
  }, React__default.createElement("div", {
    className: styles$P.Details
  }, textContentMarkup, actionsMarkup, footerContentMarkup)) : React__default.createElement("div", {
    className: styles$P.DetailsContainer
  });
  return React__default.createElement("div", {
    className: className
  }, React__default.createElement("div", {
    className: styles$P.Section
  }, detailsMarkup, React__default.createElement("div", {
    className: styles$P.ImageContainer
  }, imageMarkup)));
}

var styles$Q = {
  "Truncate": "Polaris-Truncate"
};

function Truncate(_ref) {
  var children = _ref.children;
  return React__default.createElement("span", {
    className: styles$Q.Truncate
  }, children);
}

var styles$R = {
  "ExceptionList": "Polaris-ExceptionList",
  "Item": "Polaris-ExceptionList__Item",
  "Icon": "Polaris-ExceptionList__Icon",
  "statusWarning": "Polaris-ExceptionList--statusWarning",
  "statusCritical": "Polaris-ExceptionList--statusCritical",
  "Bullet": "Polaris-ExceptionList__Bullet",
  "Title": "Polaris-ExceptionList__Title",
  "Description": "Polaris-ExceptionList__Description"
};

function ExceptionList(_ref) {
  var itemsList = _ref.items;
  var items = itemsList.map(function (item, index) {
    var status = item.status,
        icon = item.icon,
        title = item.title,
        description = item.description,
        _item$truncate = item.truncate,
        truncate = _item$truncate === void 0 ? false : _item$truncate;
    var itemClasses = classNames(styles$R.Item, status && styles$R[variationName('status', status)]);
    var iconMarkup = icon ? React__default.createElement(Icon, {
      source: icon
    }) : React__default.createElement("span", {
      className: styles$R.Bullet
    });
    var titleMarkup = title && React__default.createElement("span", {
      className: styles$R.Title
    }, title);
    var descriptionMarkup = description && React__default.createElement("span", {
      className: styles$R.Description
    }, description);
    var Element = truncate ? Truncate : React__default.Fragment;
    return React__default.createElement("li", {
      className: itemClasses,
      key: index
    }, React__default.createElement("span", {
      className: styles$R.Icon
    }, iconMarkup), React__default.createElement(Element, null, titleMarkup, descriptionMarkup));
  });
  return React__default.createElement("ul", {
    className: styles$R.ExceptionList
  }, items);
}

var ResourceListContext = React__default.createContext({});

var SELECT_ALL_ITEMS = 'All';

var styles$S = {
  "Tag": "Polaris-Tag",
  "disabled": "Polaris-Tag--disabled",
  "TagText": "Polaris-Tag__TagText",
  "Button": "Polaris-Tag__Button"
};

function Tag(_ref) {
  var children = _ref.children,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      onRemove = _ref.onRemove;
  var i18n = useI18n();
  var className = classNames(disabled && styles$S.disabled, styles$S.Tag);
  var ariaLabel = i18n.translate('Polaris.Tag.ariaLabel', {
    children: children || ''
  });
  return React__default.createElement("span", {
    className: className
  }, React__default.createElement("span", {
    title: children,
    className: styles$S.TagText
  }, children), React__default.createElement("button", {
    type: "button",
    "aria-label": ariaLabel,
    className: styles$S.Button,
    onClick: onRemove,
    onMouseUp: handleMouseUpByBlurring,
    disabled: disabled
  }, React__default.createElement(Icon, {
    source: CancelSmallMinor
  })));
}

var Focus =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Focus, _React$PureComponent);

  function Focus() {
    _classCallCheck(this, Focus);

    return _possibleConstructorReturn(this, _getPrototypeOf(Focus).apply(this, arguments));
  }

  _createClass(Focus, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleSelfFocus();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_a) {
      var prevChildren = _a.children,
          restPrevProps = __rest(_a, ["children"]);

      var _b = this.props,
          children = _b.children,
          restProps = __rest(_b, ["children"]);

      if (isEqual(restProps, restPrevProps)) {
        return;
      }

      this.handleSelfFocus();
    }
  }, {
    key: "handleSelfFocus",
    value: function handleSelfFocus() {
      var _this$props = this.props,
          disabled = _this$props.disabled,
          root = _this$props.root;

      if (disabled) {
        return;
      }

      if (root) {
        if (!root.querySelector('[autofocus]')) {
          focusFirstFocusableNode(root, false);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React__default.createElement(React__default.Fragment, null, children);
    }
  }]);

  return Focus;
}(React__default.PureComponent);

var TrapFocus =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TrapFocus, _React$PureComponent);

  function TrapFocus() {
    var _this;

    _classCallCheck(this, TrapFocus);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TrapFocus).apply(this, arguments));
    _this.state = {
      shouldFocusSelf: undefined
    };
    _this.focusTrapWrapper = null;

    _this.setFocusTrapWrapper = function (node) {
      _this.focusTrapWrapper = node;
    };

    _this.handleBlur = function (event) {
      var relatedTarget = event.relatedTarget;

      var _assertThisInitialize = _assertThisInitialized(_this),
          focusTrapWrapper = _assertThisInitialize.focusTrapWrapper;

      var _this$props$trapping = _this.props.trapping,
          trapping = _this$props$trapping === void 0 ? true : _this$props$trapping;

      if (relatedTarget == null || trapping === false) {
        return;
      }

      if (focusTrapWrapper && !focusTrapWrapper.contains(relatedTarget) && (!relatedTarget || !closest(relatedTarget, '[data-polaris-overlay]'))) {
        event.preventDefault();

        if (event.srcElement === findFirstFocusableNode(focusTrapWrapper)) {
          return write(function () {
            return focusLastFocusableNode(focusTrapWrapper);
          });
        }

        var firstNode = findFirstFocusableNode(focusTrapWrapper) || focusTrapWrapper;
        write(function () {
          return focusFirstFocusableNode(firstNode);
        });
      }
    };

    return _this;
  }

  _createClass(TrapFocus, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState(this.handleTrappingChange());
    }
  }, {
    key: "handleTrappingChange",
    value: function handleTrappingChange() {
      var _this$props$trapping2 = this.props.trapping,
          trapping = _this$props$trapping2 === void 0 ? true : _this$props$trapping2;

      if (this.focusTrapWrapper && this.focusTrapWrapper.contains(document.activeElement)) {
        return {
          shouldFocusSelf: false
        };
      }

      return {
        shouldFocusSelf: trapping
      };
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React__default.createElement(Focus, {
        disabled: this.shouldDisable(),
        root: this.focusTrapWrapper
      }, React__default.createElement("div", {
        ref: this.setFocusTrapWrapper
      }, React__default.createElement(EventListener, {
        event: "focusout",
        handler: this.handleBlur
      }), children));
    }
  }, {
    key: "shouldDisable",
    value: function shouldDisable() {
      var _this$props$trapping3 = this.props.trapping,
          trapping = _this$props$trapping3 === void 0 ? true : _this$props$trapping3;
      var shouldFocusSelf = this.state.shouldFocusSelf;

      if (shouldFocusSelf === undefined) {
        return true;
      }

      return shouldFocusSelf ? !trapping : !shouldFocusSelf;
    }
  }]);

  return TrapFocus;
}(React__default.PureComponent);

var styles$T = {
  "Sheet": "Polaris-Sheet",
  "Container": "Polaris-Sheet__Container",
  "Bottom": "Polaris-Sheet__Bottom",
  "enterBottom": "Polaris-Sheet--enterBottom",
  "enterBottomActive": "Polaris-Sheet--enterBottomActive",
  "exitBottom": "Polaris-Sheet--exitBottom",
  "exitBottomActive": "Polaris-Sheet--exitBottomActive",
  "Right": "Polaris-Sheet__Right",
  "enterRight": "Polaris-Sheet--enterRight",
  "enterRightActive": "Polaris-Sheet--enterRightActive",
  "exitRight": "Polaris-Sheet--exitRight",
  "exitRightActive": "Polaris-Sheet--exitRightActive"
};

var BOTTOM_CLASS_NAMES = {
  enter: classNames(styles$T.Bottom, styles$T.enterBottom),
  enterActive: classNames(styles$T.Bottom, styles$T.enterBottomActive),
  exit: classNames(styles$T.Bottom, styles$T.exitBottom),
  exitActive: classNames(styles$T.Bottom, styles$T.exitBottomActive)
};
var RIGHT_CLASS_NAMES = {
  enter: classNames(styles$T.Right, styles$T.enterRight),
  enterActive: classNames(styles$T.Right, styles$T.enterRightActive),
  exit: classNames(styles$T.Right, styles$T.exitRight),
  exitActive: classNames(styles$T.Right, styles$T.exitRightActive)
};
function Sheet(_ref) {
  var children = _ref.children,
      open = _ref.open,
      onClose = _ref.onClose,
      onEntered = _ref.onEntered,
      onExit = _ref.onExit;

  var _useMediaQuery = useMediaQuery(),
      isNavigationCollapsed = _useMediaQuery.isNavigationCollapsed;

  var container = useRef(null);
  var findDOMNode = useCallback(function () {
    return container.current;
  }, []);
  return React__default.createElement(Portal, {
    idPrefix: "sheet"
  }, React__default.createElement(CSSTransition, {
    findDOMNode: findDOMNode,
    classNames: isNavigationCollapsed ? BOTTOM_CLASS_NAMES : RIGHT_CLASS_NAMES,
    timeout: Duration.Slow,
    in: open,
    mountOnEnter: true,
    unmountOnExit: true,
    onEntered: onEntered,
    onExit: onExit
  }, React__default.createElement("div", Object.assign({
    className: styles$T.Container
  }, layer.props, overlay.props, {
    ref: container
  }), React__default.createElement(TrapFocus, {
    trapping: open
  }, React__default.createElement("div", {
    role: "dialog",
    tabIndex: -1,
    className: styles$T.Sheet
  }, children)))), React__default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    handler: onClose
  }), open && React__default.createElement(Backdrop, {
    transparent: true,
    onClick: onClose
  }));
}

var styles$U = {
  "Item": "Polaris-Filters-ConnectedFilterControl__Item",
  "Item-focused": "Polaris-Filters-ConnectedFilterControl__Item--focused",
  "ProxyButtonContainer": "Polaris-Filters-ConnectedFilterControl__ProxyButtonContainer",
  "ConnectedFilterControl": "Polaris-Filters-ConnectedFilterControl",
  "CenterContainer": "Polaris-Filters-ConnectedFilterControl__CenterContainer",
  "right": "Polaris-Filters-ConnectedFilterControl--right",
  "RightContainer": "Polaris-Filters-ConnectedFilterControl__RightContainer",
  "MoreFiltersButtonContainer": "Polaris-Filters-ConnectedFilterControl__MoreFiltersButtonContainer",
  "Wrapper": "Polaris-Filters-ConnectedFilterControl__Wrapper",
  "AuxiliaryContainer": "Polaris-Filters-ConnectedFilterControl__AuxiliaryContainer"
};

var Item$4 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.state = {
      focused: false
    };

    _this.handleBlur = function () {
      _this.setState({
        focused: false
      });
    };

    _this.handleFocus = function () {
      _this.setState({
        focused: true
      });
    };

    return _this;
  }

  _createClass(Item, [{
    key: "render",
    value: function render() {
      var focused = this.state.focused;
      var children = this.props.children;
      var className = classNames(styles$U.Item, focused && styles$U['Item-focused']);
      return React__default.createElement("div", {
        onBlur: this.handleBlur,
        onFocus: this.handleFocus,
        className: className
      }, children);
    }
  }]);

  return Item;
}(React__default.PureComponent);

var FILTER_FIELD_MIN_WIDTH = 150;
var ConnectedFilterControl =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ConnectedFilterControl, _React$Component);

  function ConnectedFilterControl() {
    var _this;

    _classCallCheck(this, ConnectedFilterControl);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ConnectedFilterControl).apply(this, arguments));
    _this.state = {
      availableWidth: 0,
      proxyButtonsWidth: {}
    };
    _this.container = React__default.createRef();
    _this.proxyButtonContainer = React__default.createRef();
    _this.moreFiltersButtonContainer = React__default.createRef();
    _this.handleResize = debounce(function () {
      _this.measureProxyButtons();

      _this.measureAvailableWidth();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });
    return _this;
  }

  _createClass(ConnectedFilterControl, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleResize();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          children = _this$props.children,
          rightPopoverableActions = _this$props.rightPopoverableActions,
          rightAction = _this$props.rightAction,
          auxiliary = _this$props.auxiliary;
      var className = classNames(styles$U.ConnectedFilterControl, rightPopoverableActions && styles$U.right);
      var rightMarkup = rightPopoverableActions ? React__default.createElement("div", {
        className: styles$U.RightContainer
      }, this.popoverFrom(this.getActionsToRender(rightPopoverableActions))) : null;
      var rightActionMarkup = rightAction ? React__default.createElement("div", {
        ref: this.moreFiltersButtonContainer,
        className: styles$U.MoreFiltersButtonContainer
      }, React__default.createElement(Item$4, null, rightAction)) : null;
      var proxyButtonMarkup = rightPopoverableActions ? React__default.createElement("div", {
        className: styles$U.ProxyButtonContainer,
        ref: this.proxyButtonContainer,
        "aria-hidden": true
      }, rightPopoverableActions.map(function (action) {
        return React__default.createElement("div", {
          key: action.key,
          "data-key": action.key
        }, _this2.activatorButtonFrom(action));
      })) : null;
      var auxMarkup = auxiliary ? React__default.createElement("div", {
        className: styles$U.AuxiliaryContainer
      }, auxiliary) : null;
      return React__default.createElement(React__default.Fragment, null, proxyButtonMarkup, React__default.createElement("div", {
        className: styles$U.Wrapper
      }, React__default.createElement("div", {
        className: className,
        ref: this.container
      }, React__default.createElement("div", {
        className: styles$U.CenterContainer
      }, React__default.createElement(Item$4, null, children)), rightMarkup, rightActionMarkup, React__default.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      })), auxMarkup));
    }
  }, {
    key: "measureProxyButtons",
    value: function measureProxyButtons() {
      if (this.proxyButtonContainer.current) {
        var proxyButtonsWidth = {}; // this number is magical, but tweaking it solved the problem of items overlapping

        var tolerance = 52;

        if (this.proxyButtonContainer.current) {
          Array.from(this.proxyButtonContainer.current.children).forEach(function (element) {
            var buttonWidth = element.getBoundingClientRect().width + tolerance;
            var buttonKey = element.dataset.key;

            if (buttonKey) {
              proxyButtonsWidth[buttonKey] = buttonWidth;
            }
          });
        }

        this.setState({
          proxyButtonsWidth
        });
      }
    }
  }, {
    key: "measureAvailableWidth",
    value: function measureAvailableWidth() {
      if (this.container.current && this.moreFiltersButtonContainer.current) {
        var containerWidth = this.container.current.getBoundingClientRect().width;
        var moreFiltersButtonWidth = this.moreFiltersButtonContainer.current.getBoundingClientRect().width;
        var filtersActionWidth = 0;
        var availableWidth = containerWidth - FILTER_FIELD_MIN_WIDTH - moreFiltersButtonWidth - filtersActionWidth;
        this.setState({
          availableWidth
        });
      }
    }
  }, {
    key: "getActionsToRender",
    value: function getActionsToRender(actions) {
      var remainingWidth = this.state.availableWidth;
      var actionsToReturn = [];

      for (var i = 0; remainingWidth > 0 && i < actions.length; i++) {
        var action = actions[i];
        var actionWidth = this.state.proxyButtonsWidth[action.key];

        if (actionWidth <= remainingWidth) {
          actionsToReturn.push(action);
          remainingWidth -= actionWidth;
        }
      }

      return actionsToReturn;
    }
  }, {
    key: "activatorButtonFrom",
    value: function activatorButtonFrom(action) {
      return React__default.createElement(Button, {
        onClick: action.onAction,
        disclosure: true,
        disabled: this.props.disabled || action.disabled,
        id: "Activator-".concat(action.key)
      }, action.content);
    }
  }, {
    key: "popoverFrom",
    value: function popoverFrom(actions) {
      var _this3 = this;

      return actions.map(function (action) {
        return React__default.createElement(Item$4, {
          key: action.key
        }, React__default.createElement(Popover, {
          active: action.popoverOpen,
          activator: _this3.activatorButtonFrom(action),
          onClose: action.onAction,
          preferredAlignment: "left",
          sectioned: true
        }, action.popoverContent));
      });
    }
  }]);

  return ConnectedFilterControl;
}(React__default.Component);

var styles$V = {
  "Filters": "Polaris-Filters",
  "FiltersContainer": "Polaris-Filters__FiltersContainer",
  "FiltersContainerHeader": "Polaris-Filters__FiltersContainerHeader",
  "FiltersDesktopContainerContent": "Polaris-Filters__FiltersDesktopContainerContent",
  "FiltersMobileContainerContent": "Polaris-Filters__FiltersMobileContainerContent",
  "FiltersContainerFooter": "Polaris-Filters__FiltersContainerFooter",
  "FiltersMobileContainerFooter": "Polaris-Filters__FiltersMobileContainerFooter",
  "EmptyFooterState": "Polaris-Filters__EmptyFooterState",
  "FilterTriggerContainer": "Polaris-Filters__FilterTriggerContainer",
  "FilterTrigger": "Polaris-Filters__FilterTrigger",
  "FilterTriggerTitle": "Polaris-Filters__FilterTriggerTitle",
  "AppliedFilterBadgeContainer": "Polaris-Filters__AppliedFilterBadgeContainer",
  "open": "Polaris-Filters--open",
  "FilterTriggerLabelContainer": "Polaris-Filters__FilterTriggerLabelContainer",
  "first": "Polaris-Filters--first",
  "last": "Polaris-Filters--last",
  "FilterNodeContainer": "Polaris-Filters__FilterNodeContainer",
  "SearchIcon": "Polaris-Filters__SearchIcon",
  "Backdrop": "Polaris-Filters__Backdrop",
  "HelpText": "Polaris-Filters__HelpText",
  "TagsContainer": "Polaris-Filters__TagsContainer"
};

var Suffix;

(function (Suffix) {
  Suffix["Filter"] = "Filter";
  Suffix["Shortcut"] = "Shortcut";
})(Suffix || (Suffix = {}));

var Filters =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Filters, _React$Component);

  function Filters() {
    var _this;

    _classCallCheck(this, Filters);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Filters).apply(this, arguments));
    _this.state = {
      open: false,
      readyForFocus: false
    };
    _this.moreFiltersButtonContainer = createRef();
    _this.focusNode = createRef();

    _this.closeFilters = function () {
      _this.setState({
        open: false
      }, function () {
        if (_this.moreFiltersButtonContainer.current) {
          focusFirstFocusableNode(_this.moreFiltersButtonContainer.current, false);
        }
      });
    };

    _this.toggleFilters = function () {
      if (_this.state.open === true) {
        _this.closeFilters();
      } else {
        _this.openFilters();
      }
    };

    _this.setReadyForFocus = function (newState) {
      return function () {
        _this.setState({
          readyForFocus: newState
        });
      };
    };

    return _this;
  }

  _createClass(Filters, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          filters = _this$props.filters,
          queryValue = _this$props.queryValue,
          onQueryBlur = _this$props.onQueryBlur,
          onQueryChange = _this$props.onQueryChange,
          onQueryFocus = _this$props.onQueryFocus,
          focused = _this$props.focused,
          onClearAll = _this$props.onClearAll,
          appliedFilters = _this$props.appliedFilters,
          _this$props$polaris = _this$props.polaris,
          intl = _this$props$polaris.intl,
          isNavigationCollapsed = _this$props$polaris.mediaQuery.isNavigationCollapsed,
          onQueryClear = _this$props.onQueryClear,
          queryPlaceholder = _this$props.queryPlaceholder,
          children = _this$props.children,
          _this$props$disabled = _this$props.disabled,
          disabled = _this$props$disabled === void 0 ? false : _this$props$disabled,
          helpText = _this$props.helpText;
      var resourceName = this.context.resourceName;
      var _this$state = this.state,
          open = _this$state.open,
          readyForFocus = _this$state.readyForFocus;
      var backdropMarkup = open ? React__default.createElement(React__default.Fragment, null, React__default.createElement(ScrollLock, null), React__default.createElement("div", {
        className: styles$V.Backdrop,
        onClick: this.closeFilters
      })) : null;
      var filtersContentMarkup = filters.map(function (filter, index) {
        var filterIsOpen = _this2.state["".concat(filter.key).concat(Suffix.Filter)] === true;
        var icon = filterIsOpen ? ChevronUpMinor : ChevronDownMinor;
        var className = classNames(styles$V.FilterTriggerContainer, filterIsOpen && styles$V.open, index === 0 && styles$V.first, filters.length !== 1 && index === filters.length - 1 && styles$V.last);

        var appliedFilterContent = _this2.getAppliedFilterContent(filter.key);

        var appliedFilterBadgeMarkup = appliedFilterContent ? React__default.createElement("div", {
          className: styles$V.AppliedFilterBadgeContainer
        }, React__default.createElement(Badge, {
          size: "small",
          status: "new"
        }, appliedFilterContent)) : null;
        var collapsibleID = "".concat(filter.key, "Collapsible");
        return React__default.createElement("div", {
          key: filter.key,
          className: className
        }, React__default.createElement("button", {
          onClick: function onClick() {
            return _this2.toggleFilter(filter.key);
          },
          className: styles$V.FilterTrigger,
          id: "".concat(filter.key, "ToggleButton"),
          type: "button",
          "aria-controls": collapsibleID,
          "aria-expanded": filterIsOpen
        }, React__default.createElement("div", {
          className: styles$V.FilterTriggerLabelContainer
        }, React__default.createElement("h2", {
          className: styles$V.FilterTriggerTitle
        }, React__default.createElement(TextStyle, {
          variation: _this2.props.disabled || filter.disabled ? VariationValue.Subdued : undefined
        }, filter.label)), React__default.createElement("span", {
          className: styles$V.FilterTriggerIcon
        }, React__default.createElement(Icon, {
          source: icon,
          color: "inkLightest"
        }))), appliedFilterBadgeMarkup), React__default.createElement(Collapsible, {
          id: collapsibleID,
          open: filterIsOpen
        }, React__default.createElement("div", {
          className: styles$V.FilterNodeContainer
        }, React__default.createElement(Focus, {
          disabled: !filterIsOpen || !readyForFocus || !open,
          root: _this2.focusNode.current
        }, _this2.generateFilterMarkup(filter)))));
      });
      var rightActionMarkup = React__default.createElement("div", {
        ref: this.moreFiltersButtonContainer
      }, React__default.createElement(Button, {
        onClick: this.toggleFilters,
        disabled: disabled
      }, intl.translate('Polaris.Filters.moreFilters')));
      var filterResourceName = resourceName || {
        singular: intl.translate('Polaris.ResourceList.defaultItemSingular'),
        plural: intl.translate('Polaris.ResourceList.defaultItemPlural')
      };
      var filtersControlMarkup = React__default.createElement(ConnectedFilterControl, {
        rightPopoverableActions: this.transformFilters(filters),
        rightAction: rightActionMarkup,
        auxiliary: children,
        disabled: disabled
      }, React__default.createElement(TextField, {
        placeholder: queryPlaceholder || intl.translate('Polaris.Filters.filter', {
          resourceName: filterResourceName.plural
        }),
        onChange: onQueryChange,
        onBlur: onQueryBlur,
        onFocus: onQueryFocus,
        value: queryValue,
        focused: focused,
        label: queryPlaceholder || intl.translate('Polaris.Filters.filter', {
          resourceName: filterResourceName.plural
        }),
        labelHidden: true,
        prefix: React__default.createElement("span", {
          className: styles$V.SearchIcon
        }, React__default.createElement(Icon, {
          source: SearchMinor
        })),
        clearButton: true,
        onClearButtonClick: onQueryClear,
        disabled: disabled
      }));
      var filtersDesktopHeaderMarkup = React__default.createElement("div", {
        className: styles$V.FiltersContainerHeader
      }, React__default.createElement(DisplayText, {
        size: "small"
      }, intl.translate('Polaris.Filters.moreFilters')), React__default.createElement(Button, {
        icon: CancelSmallMinor,
        plain: true,
        accessibilityLabel: intl.translate('Polaris.Filters.cancel'),
        onClick: this.closeFilters
      }));
      var filtersMobileHeaderMarkup = React__default.createElement("div", {
        className: styles$V.FiltersContainerHeader
      }, React__default.createElement(Button, {
        icon: CancelSmallMinor,
        plain: true,
        accessibilityLabel: intl.translate('Polaris.Filters.cancel'),
        onClick: this.closeFilters
      }), React__default.createElement(DisplayText, {
        size: "small"
      }, intl.translate('Polaris.Filters.moreFilters')), React__default.createElement(Button, {
        onClick: this.closeFilters,
        primary: true
      }, intl.translate('Polaris.Filters.done')));
      var filtersDesktopFooterMarkup = React__default.createElement("div", {
        className: styles$V.FiltersContainerFooter
      }, React__default.createElement(Button, {
        onClick: onClearAll,
        disabled: !this.hasAppliedFilters()
      }, intl.translate('Polaris.Filters.clearAllFilters')), React__default.createElement(Button, {
        onClick: this.closeFilters,
        primary: true
      }, intl.translate('Polaris.Filters.done')));
      var filtersMobileFooterMarkup = React__default.createElement("div", {
        className: styles$V.FiltersMobileContainerFooter
      }, this.hasAppliedFilters() ? React__default.createElement(Button, {
        onClick: onClearAll,
        fullWidth: true
      }, intl.translate('Polaris.Filters.clearAllFilters')) : React__default.createElement("div", {
        className: styles$V.EmptyFooterState
      }, React__default.createElement(TextStyle, {
        variation: "subdued"
      }, React__default.createElement("p", null, intl.translate('Polaris.Filters.noFiltersApplied')))));
      var tagsMarkup = appliedFilters && appliedFilters.length ? React__default.createElement("div", {
        className: styles$V.TagsContainer
      }, appliedFilters.map(function (filter) {
        return React__default.createElement(Tag, {
          key: filter.key,
          onRemove: function onRemove() {
            filter.onRemove(filter.key);
          },
          disabled: disabled
        }, filter.label);
      })) : null;
      var filtersContainerMarkup = isNavigationCollapsed ? React__default.createElement(Sheet, {
        open: open,
        onClose: this.closeFilters,
        onEntered: this.setReadyForFocus(true),
        onExit: this.setReadyForFocus(false)
      }, filtersMobileHeaderMarkup, React__default.createElement(Scrollable, {
        className: styles$V.FiltersMobileContainerContent,
        shadow: true
      }, filtersContentMarkup, filtersMobileFooterMarkup)) : React__default.createElement(Sheet, {
        open: open,
        onClose: this.closeFilters,
        onEntered: this.setReadyForFocus(true),
        onExit: this.setReadyForFocus(false)
      }, React__default.createElement("div", {
        className: styles$V.FiltersContainer
      }, filtersDesktopHeaderMarkup, React__default.createElement(Scrollable, {
        className: styles$V.FiltersDesktopContainerContent,
        shadow: true
      }, filtersContentMarkup), filtersDesktopFooterMarkup));
      var helpTextMarkup = helpText ? React__default.createElement("div", {
        id: "FiltersHelpText",
        className: styles$V.HelpText
      }, React__default.createElement(TextStyle, {
        variation: "subdued"
      }, helpText)) : null;
      return React__default.createElement("div", {
        className: styles$V.Filters
      }, filtersControlMarkup, filtersContainerMarkup, tagsMarkup, helpTextMarkup, backdropMarkup, React__default.createElement(KeypressListener, {
        keyCode: Key.Escape,
        handler: this.closeFilters
      }));
    }
  }, {
    key: "hasAppliedFilters",
    value: function hasAppliedFilters() {
      var _this$props2 = this.props,
          appliedFilters = _this$props2.appliedFilters,
          queryValue = _this$props2.queryValue;
      var filtersApplied = Boolean(appliedFilters && appliedFilters.length > 0);
      var queryApplied = Boolean(queryValue && queryValue !== '');
      return filtersApplied || queryApplied;
    }
  }, {
    key: "getAppliedFilterContent",
    value: function getAppliedFilterContent(key) {
      var appliedFilters = this.props.appliedFilters;

      if (!appliedFilters) {
        return undefined;
      }

      var filter = appliedFilters.find(function (filter) {
        return filter.key === key;
      });
      return filter == null ? undefined : filter.label;
    }
  }, {
    key: "getAppliedFilterRemoveHandler",
    value: function getAppliedFilterRemoveHandler(key) {
      var appliedFilters = this.props.appliedFilters;

      if (!appliedFilters) {
        return undefined;
      }

      var filter = appliedFilters.find(function (filter) {
        return filter.key === key;
      });
      return filter == null ? undefined : filter.onRemove;
    }
  }, {
    key: "openFilters",
    value: function openFilters() {
      this.setState({
        open: true
      });
    }
  }, {
    key: "openFilter",
    value: function openFilter(key) {
      this.setState({
        ["".concat(key).concat(Suffix.Filter)]: true
      });
    }
  }, {
    key: "closeFilter",
    value: function closeFilter(key) {
      this.setState({
        ["".concat(key).concat(Suffix.Filter)]: false
      });
    }
  }, {
    key: "toggleFilter",
    value: function toggleFilter(key) {
      if (this.state["".concat(key).concat(Suffix.Filter)] === true) {
        this.closeFilter(key);
      } else {
        this.openFilter(key);
      }
    }
  }, {
    key: "openFilterShortcut",
    value: function openFilterShortcut(key) {
      this.setState({
        ["".concat(key).concat(Suffix.Shortcut)]: true
      });
    }
  }, {
    key: "closeFilterShortcut",
    value: function closeFilterShortcut(key) {
      this.setState({
        ["".concat(key).concat(Suffix.Shortcut)]: false
      });
    }
  }, {
    key: "toggleFilterShortcut",
    value: function toggleFilterShortcut(key) {
      if (this.state["".concat(key).concat(Suffix.Shortcut)] === true) {
        this.closeFilterShortcut(key);
      } else {
        this.openFilterShortcut(key);
      }
    }
  }, {
    key: "transformFilters",
    value: function transformFilters(filters) {
      var _this3 = this;

      var transformedActions = [];
      getShortcutFilters(filters).forEach(function (filter) {
        var key = filter.key,
            label = filter.label,
            disabled = filter.disabled;
        transformedActions.push({
          popoverContent: _this3.generateFilterMarkup(filter),
          popoverOpen: _this3.state["".concat(key).concat(Suffix.Shortcut)],
          key,
          content: label,
          disabled,
          onAction: function onAction() {
            return _this3.toggleFilterShortcut(key);
          }
        });
      });
      return transformedActions;
    }
  }, {
    key: "generateFilterMarkup",
    value: function generateFilterMarkup(filter) {
      var intl = this.props.polaris.intl;
      var removeCallback = this.getAppliedFilterRemoveHandler(filter.key);
      var removeHandler = removeCallback == null ? undefined : function () {
        removeCallback(filter.key);
      };
      return React__default.createElement("div", {
        ref: this.focusNode
      }, React__default.createElement(Stack, {
        vertical: true,
        spacing: "tight"
      }, filter.filter, React__default.createElement(Button, {
        plain: true,
        disabled: removeHandler == null,
        onClick: removeHandler,
        accessibilityLabel: intl.translate('Polaris.Filters.clearLabel', {
          filterName: filter.label
        })
      }, intl.translate('Polaris.Filters.clear'))));
    }
  }]);

  return Filters;
}(React__default.Component);

Filters.contextType = ResourceListContext;

function getShortcutFilters(filters) {
  return filters.filter(function (filter) {
    return filter.shortcut === true;
  });
} // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var Filters$1 = withAppProvider()(Filters);

var styles$W = {
  "FooterHelp": "Polaris-FooterHelp",
  "Content": "Polaris-FooterHelp__Content",
  "Icon": "Polaris-FooterHelp__Icon",
  "Text": "Polaris-FooterHelp__Text"
};

function FooterHelp(_ref) {
  var children = _ref.children;
  return React__default.createElement("div", {
    className: styles$W.FooterHelp
  }, React__default.createElement("div", {
    className: styles$W.Content
  }, React__default.createElement("div", {
    className: styles$W.Icon
  }, React__default.createElement(Icon, {
    source: QuestionMarkMajorTwotone,
    color: "teal",
    backdrop: true
  })), React__default.createElement("div", {
    className: styles$W.Text
  }, children)));
}

function Form(_ref) {
  var acceptCharset = _ref.acceptCharset,
      action = _ref.action,
      autoComplete = _ref.autoComplete,
      children = _ref.children,
      encType = _ref.encType,
      _ref$implicitSubmit = _ref.implicitSubmit,
      implicitSubmit = _ref$implicitSubmit === void 0 ? true : _ref$implicitSubmit,
      _ref$method = _ref.method,
      method = _ref$method === void 0 ? 'post' : _ref$method,
      name = _ref.name,
      noValidate = _ref.noValidate,
      _ref$preventDefault = _ref.preventDefault,
      preventDefault = _ref$preventDefault === void 0 ? true : _ref$preventDefault,
      target = _ref.target,
      onSubmit = _ref.onSubmit;
  var i18n = useI18n();
  var handleSubmit = useCallback(function (event) {
    if (!preventDefault) {
      return;
    }

    event.preventDefault();
    onSubmit(event);
  }, [onSubmit, preventDefault]);
  var autoCompleteInputs = normalizeAutoComplete$1(autoComplete);
  var submitMarkup = implicitSubmit ? React__default.createElement(VisuallyHidden, null, React__default.createElement("button", {
    type: "submit",
    "aria-hidden": "true",
    tabIndex: -1
  }, i18n.translate('Polaris.Common.submit'))) : null;
  return React__default.createElement("form", {
    acceptCharset: acceptCharset,
    action: action,
    autoComplete: autoCompleteInputs,
    encType: encType,
    method: method,
    name: name,
    noValidate: noValidate,
    target: target,
    onSubmit: handleSubmit
  }, children, submitMarkup);
}

function normalizeAutoComplete$1(autoComplete) {
  if (autoComplete == null) {
    return autoComplete;
  }

  return autoComplete ? 'on' : 'off';
}

var styles$X = {
  "FormLayout": "Polaris-FormLayout",
  "Title": "Polaris-FormLayout__Title",
  "Items": "Polaris-FormLayout__Items",
  "HelpText": "Polaris-FormLayout__HelpText",
  "Item": "Polaris-FormLayout__Item",
  "grouped": "Polaris-FormLayout--grouped",
  "condensed": "Polaris-FormLayout--condensed"
};

function Item$5(props) {
  return React__default.createElement("div", {
    className: styles$X.Item
  }, props.children);
}

function Group(_ref) {
  var children = _ref.children,
      condensed = _ref.condensed,
      title = _ref.title,
      helpText = _ref.helpText;
  var className = classNames(condensed ? styles$X.condensed : styles$X.grouped);
  var id = useUniqueId('FormLayoutGroup');
  var helpTextElement = null;
  var helpTextID;
  var titleElement = null;
  var titleID;

  if (helpText) {
    helpTextID = "".concat(id, "HelpText");
    helpTextElement = React__default.createElement("div", {
      id: helpTextID,
      className: styles$X.HelpText
    }, helpText);
  }

  if (title) {
    titleID = "".concat(id, "Title");
    titleElement = React__default.createElement("div", {
      id: titleID,
      className: styles$X.Title
    }, title);
  }

  var itemsMarkup = React__default.Children.map(children, function (child) {
    return wrapWithComponent(child, Item$5, {});
  });
  return React__default.createElement("div", {
    role: "group",
    className: className,
    "aria-labelledby": titleID,
    "aria-describedby": helpTextID
  }, titleElement, React__default.createElement("div", {
    className: styles$X.Items
  }, itemsMarkup), helpTextElement);
}

var FormLayout =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(FormLayout, _React$PureComponent);

  function FormLayout() {
    _classCallCheck(this, FormLayout);

    return _possibleConstructorReturn(this, _getPrototypeOf(FormLayout).apply(this, arguments));
  }

  _createClass(FormLayout, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React__default.createElement("div", {
        className: styles$X.FormLayout
      }, React__default.Children.map(children, wrapChildren));
    }
  }]);

  return FormLayout;
}(React__default.PureComponent);
FormLayout.Group = Group;

function wrapChildren(child, index) {
  if (isElementOfType(child, Group)) {
    return child;
  }

  var props = {
    key: index
  };
  return wrapWithComponent(child, Item$5, props);
}

function setRootProperty(name, value, node) {
  if (document == null) {
    return;
  }

  var styleNode = node && node instanceof HTMLElement ? node : document.documentElement;
  styleNode && styleNode.style.setProperty(name, value);
}

var styles$Y = {
  "Toast": "Polaris-Frame-Toast",
  "Action": "Polaris-Frame-Toast__Action",
  "error": "Polaris-Frame-Toast--error",
  "CloseButton": "Polaris-Frame-Toast__CloseButton"
};

var DEFAULT_TOAST_DURATION = 5000;
var DEFAULT_TOAST_DURATION_WITH_ACTION = 10000;
function Toast(_ref) {
  var content = _ref.content,
      onDismiss = _ref.onDismiss,
      duration = _ref.duration,
      error = _ref.error,
      action = _ref.action;
  useEffect(function () {
    var timeoutDuration = duration || DEFAULT_TOAST_DURATION;

    if (action && !duration) {
      timeoutDuration = DEFAULT_TOAST_DURATION_WITH_ACTION;
    } else if (action && duration && duration < DEFAULT_TOAST_DURATION_WITH_ACTION) {
      // eslint-disable-next-line no-console
      console.log('Toast with action should persist for at least 10,000 milliseconds to give the merchant enough time to act on it.');
    }

    var timer = setTimeout(onDismiss, timeoutDuration);
    return function () {
      clearTimeout(timer);
    };
  }, [action, duration, onDismiss]);
  var dismissMarkup = React__default.createElement("button", {
    type: "button",
    className: styles$Y.CloseButton,
    onClick: onDismiss
  }, React__default.createElement(Icon, {
    source: MobileCancelMajorMonotone
  }));
  var actionMarkup = action ? React__default.createElement("div", {
    className: styles$Y.Action
  }, React__default.createElement(Button, {
    plain: true,
    monochrome: true,
    onClick: action.onAction
  }, action.content)) : null;
  var className = classNames(styles$Y.Toast, error && styles$Y.error);
  return React__default.createElement(ThemeProvider, {
    theme: {
      colorScheme: 'inverse'
    }
  }, React__default.createElement("div", {
    className: className
  }, React__default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    handler: onDismiss
  }), content, actionMarkup, dismissMarkup));
}

/**
 * A replacement for React.useCallback that'll allow for custom and deep compares.
 * @see {@link https://reactjs.org/docs/hooks-reference.html#usecallback}
 * @param callback Accepts a callback that's forwarded to React.useCallback
 * @param dependencies A dependency array similar to React.useCallback however it utilizes a deep compare
 * @param customCompare Opportunity to provide a custom compare function
 * @returns A memoized callback
 * @example
 * const Child = memo(function Child({onClick}) {
 *   console.log('Child has rendered.');
 *   return <button onClick={onClick}>Click me</button>;
 * });
 *
 * function ComponentExample() {
 *   const [timesClicked, setTimesClicked] = useState(0);
 *
 *   const handleClick = useDeepCallback(() => {
 *     setTimesClicked((timesClicked) => timesClicked + 1);
 *     // New reference every render
 *   }, [{}]);
 *
 *   return (
 *     <Fragment>
 *       <div>Times clicked: {timesClicked}</div>
 *       <Child onClick={handleClick} />
 *     </Fragment>
 *   );
 * }
 */

function useDeepCallback(callback, dependencies, customCompare) {
  return useCallback(callback, useDeepCompareRef(dependencies, customCompare));
}

var styles$Z = {
  "ToastManager": "Polaris-Frame-ToastManager",
  "ToastWrapper": "Polaris-Frame-ToastManager__ToastWrapper",
  "ToastWrapper-enter": "Polaris-Frame-ToastManager__ToastWrapper--enter",
  "ToastWrapper-exit": "Polaris-Frame-ToastManager__ToastWrapper--exit",
  "ToastWrapper-enter-done": "Polaris-Frame-ToastManager--toastWrapperEnterDone"
};

var ToastManager = memo(function ToastManager(_ref) {
  var toastMessages = _ref.toastMessages;
  var toastNodes = [];
  var updateToasts = useDeepCallback(function () {
    var targetInPos = 0;
    toastMessages.forEach(function (_, index) {
      var currentToast = toastNodes[index];
      if (!currentToast.current) return;
      targetInPos += currentToast.current.clientHeight;
      currentToast.current.style.setProperty('--toast-translate-y-in', "-".concat(targetInPos, "px"));
      currentToast.current.style.setProperty('--toast-translate-y-out', "".concat(-targetInPos + 150, "px"));
    });
  }, [toastMessages, toastNodes]);
  useDeepEffect(function () {
    updateToasts();
  }, [toastMessages]);
  var toastsMarkup = toastMessages.map(function (toast, index) {
    var toastNode = createRef();
    toastNodes[index] = toastNode;
    return React__default.createElement(CSSTransition, {
      findDOMNode: findDOMNode(index),
      key: toast.id,
      timeout: {
        enter: 0,
        exit: 400
      },
      classNames: toastClasses
    }, React__default.createElement("div", {
      ref: toastNode
    }, React__default.createElement(Toast, toast)));
  });
  return React__default.createElement(Portal, {
    idPrefix: "toast-manager"
  }, React__default.createElement(EventListener, {
    event: "resize",
    handler: updateToasts
  }), React__default.createElement("div", {
    className: styles$Z.ToastManager,
    "aria-live": "polite"
  }, React__default.createElement(TransitionGroup, {
    component: null
  }, toastsMarkup)));

  function findDOMNode(index) {
    return function () {
      return toastNodes[index].current;
    };
  }
});
var toastClasses = {
  enter: classNames(styles$Z.ToastWrapper, styles$Z['ToastWrapper-enter']),
  enterDone: classNames(styles$Z.ToastWrapper, styles$Z['ToastWrapper-enter-done']),
  exit: classNames(styles$Z.ToastWrapper, styles$Z['ToastWrapper-exit'])
};

var styles$_ = {
  "Loading": "Polaris-Frame-Loading",
  "Level": "Polaris-Frame-Loading__Level"
};

var INITIAL_STEP = 10;
var STUCK_THRESHOLD = 99;
var Loading =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Loading, _React$Component);

  function Loading() {
    var _this;

    _classCallCheck(this, Loading);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Loading).apply(this, arguments));
    _this.state = {
      progress: 0,
      step: INITIAL_STEP,
      animation: null
    };
    _this.ariaValuenow = debounce(function () {
      var progress = _this.state.progress;
      return Math.floor(progress / 10) * 10;
    }, 15);
    return _this;
  }

  _createClass(Loading, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.increment();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var animation = this.state.animation;

      if (animation != null) {
        cancelAnimationFrame(animation);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var progress = this.state.progress;
      var customStyles = {
        transform: "scaleX(".concat(Math.floor(progress) / 100, ")")
      };
      var ariaValuenow = this.ariaValuenow();
      return React__default.createElement("div", {
        className: styles$_.Loading
      }, React__default.createElement("div", {
        className: styles$_.Level,
        style: customStyles,
        "aria-valuenow": ariaValuenow,
        "aria-valuemin": 0,
        "aria-valuemax": 100,
        role: "progressbar"
      }));
    }
  }, {
    key: "increment",
    value: function increment() {
      var _this2 = this;

      var _this$state = this.state,
          progress = _this$state.progress,
          step = _this$state.step;

      if (progress >= STUCK_THRESHOLD) {
        return;
      }

      var animation = requestAnimationFrame(function () {
        return _this2.increment();
      });
      this.setState({
        progress: Math.min(progress + step, 100),
        step: Math.pow(INITIAL_STEP, -(progress / 25)),
        animation
      });
    }
  }]);

  return Loading;
}(React__default.Component);

function isObject(value) {
  var type = typeof value;
  return value != null && (type === TypeOf.Object || type === TypeOf.Function);
}

function pluckDeep(obj, key) {
  if (!obj) {
    return null;
  }

  var keys = Object.keys(obj);

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var currKey = _keys[_i];

    if (currKey === key) {
      return obj[key];
    }

    if (isObject(obj[currKey])) {
      var plucked = pluckDeep(obj[currKey], key);

      if (plucked) {
        return plucked;
      }
    }
  }

  return null;
}

function getWidth() {
  var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var defaultWidth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var key = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'width';
  var width = typeof value === 'number' ? value : pluckDeep(value, key);
  return width ? "".concat(width, "px") : "".concat(defaultWidth, "px");
}

function generateRedirect(appBridge, url) {
  var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'APP';
  var external = arguments.length > 3 ? arguments[3] : undefined;

  if (url == null) {
    return undefined;
  }

  var redirect = Redirect.create(appBridge);
  var payload = external === true ? {
    url,
    newContext: true
  } : url;
  return function () {
    redirect.dispatch(redirectAction(target, external), payload);
  };
}

function redirectAction(target, external) {
  if (external === true) {
    return Redirect.Action.REMOTE;
  }

  return Redirect.Action[target];
}

function transformActions(appBridge, _ref) {
  var primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions,
      actionGroups = _ref.actionGroups;
  var primary = transformPrimaryAction(appBridge, primaryAction);
  var secondary = [].concat(_toConsumableArray(transformSecondaryActions(appBridge, secondaryActions)), _toConsumableArray(transformActionGroups(appBridge, actionGroups)));
  return {
    primary,
    secondary
  };
}

function transformAction(appBridge, action) {
  var style = action.destructive === true ? Button$1.Style.Danger : undefined;
  var button = Button$1.create(appBridge, {
    label: action.content || '',
    disabled: action.disabled,
    style
  });

  if (action.onAction) {
    button.subscribe(Button$1.Action.CLICK, action.onAction);
  }

  var redirect = generateRedirect(appBridge, action.url, action.target, action.external);

  if (redirect != null) {
    button.subscribe(Button$1.Action.CLICK, redirect);
  }

  return button;
}

function transformPrimaryAction(appBridge, primaryAction) {
  if (primaryAction == null) {
    return undefined;
  }

  var primary = transformAction(appBridge, primaryAction);
  return primary;
}

function transformSecondaryActions(appBridge) {
  var secondaryActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var secondary = _toConsumableArray(secondaryActions.map(function (secondaryAction) {
    return transformAction(appBridge, secondaryAction);
  }));

  return secondary;
}

function transformActionGroups(appBridge) {
  var actionGroups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var buttonGroups = _toConsumableArray(actionGroups.map(function (group) {
    var buttons = group.actions.map(function (groupAction) {
      return transformAction(appBridge, groupAction);
    });
    return ButtonGroup$1.create(appBridge, {
      label: group.title,
      buttons
    });
  }));

  return buttonGroups;
}

function pickValueAndLength(obj, key) {
  var keyPaths = key.split('.');
  var value = obj;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = keyPaths[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var _key = _step.value;

      if (!Object.prototype.hasOwnProperty.call(value, _key)) {
        return null;
      }

      value = value[_key];
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return {
    keyPaths,
    value
  };
}

function pick(obj) {
  var _ref;

  for (var _len = arguments.length, keyPaths = new Array(_len > 1 ? _len - 1 : 0), _key2 = 1; _key2 < _len; _key2++) {
    keyPaths[_key2 - 1] = arguments[_key2];
  }

  var flattenedKeypaths = (_ref = []).concat.apply(_ref, keyPaths);

  if (obj == null || flattenedKeypaths.length === 0) return {};
  return flattenedKeypaths.reduce(function (acc, key) {
    if (typeof key !== TypeOf.String || Object.prototype.hasOwnProperty.call(obj, key)) {
      return Object.assign(Object.assign({}, acc), {
        [key]: obj[key]
      });
    }

    var pickedValues = pickValueAndLength(obj, key);

    if (pickedValues === null) {
      return acc;
    }

    var keyPaths = pickedValues.keyPaths,
        value = pickedValues.value;
    var len = keyPaths.length;
    var innerObject = {
      [keyPaths[--len]]: value
    };

    while (len--) {
      innerObject = {
        [keyPaths[len]]: innerObject
      };
    }

    return Object.assign(Object.assign({}, acc), innerObject);
  }, {});
}

var styles$$ = {
  "Container": "Polaris-Modal-Dialog__Container",
  "Modal": "Polaris-Modal-Dialog__Modal",
  "limitHeight": "Polaris-Modal-Dialog--limitHeight",
  "sizeLarge": "Polaris-Modal-Dialog--sizeLarge",
  "animateFadeUp": "Polaris-Modal-Dialog--animateFadeUp",
  "entering": "Polaris-Modal-Dialog--entering",
  "exiting": "Polaris-Modal-Dialog--exiting",
  "exited": "Polaris-Modal-Dialog--exited",
  "entered": "Polaris-Modal-Dialog--entered"
};

function Dialog(_a) {
  var instant = _a.instant,
      labelledBy = _a.labelledBy,
      children = _a.children,
      onClose = _a.onClose,
      onExited = _a.onExited,
      onEntered = _a.onEntered,
      large = _a.large,
      limitHeight = _a.limitHeight,
      props = __rest(_a, ["instant", "labelledBy", "children", "onClose", "onExited", "onEntered", "large", "limitHeight"]);

  var containerNode = useRef(null);
  var findDOMNode = useCallback(function () {
    return containerNode.current;
  }, []);
  var classes = classNames(styles$$.Modal, large && styles$$.sizeLarge, limitHeight && styles$$.limitHeight);
  var TransitionChild = instant ? Transition : FadeUp;
  return React__default.createElement(TransitionChild, Object.assign({}, props, {
    findDOMNode: findDOMNode,
    mountOnEnter: true,
    unmountOnExit: true,
    timeout: durationBase,
    onEntered: onEntered,
    onExited: onExited
  }), React__default.createElement("div", {
    className: styles$$.Container,
    "data-polaris-layer": true,
    "data-polaris-overlay": true,
    ref: containerNode
  }, React__default.createElement(TrapFocus, null, React__default.createElement("div", {
    className: classes,
    role: "dialog",
    "aria-labelledby": labelledBy,
    tabIndex: -1
  }, React__default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    handler: onClose
  }), children))));
}
var fadeUpClasses = {
  appear: classNames(styles$$.animateFadeUp, styles$$.entering),
  appearActive: classNames(styles$$.animateFadeUp, styles$$.entered),
  enter: classNames(styles$$.animateFadeUp, styles$$.entering),
  enterActive: classNames(styles$$.animateFadeUp, styles$$.entered),
  exit: classNames(styles$$.animateFadeUp, styles$$.exiting),
  exitActive: classNames(styles$$.animateFadeUp, styles$$.exited)
};

function FadeUp(_a) {
  var children = _a.children,
      props = __rest(_a, ["children"]);

  return React__default.createElement(CSSTransition, Object.assign({}, props, {
    classNames: fadeUpClasses
  }), children);
}

var styles$10 = {
  "Footer": "Polaris-Modal-Footer",
  "FooterContent": "Polaris-Modal-Footer__FooterContent"
};

function Footer(_ref) {
  var primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions,
      children = _ref.children;
  var primaryActionButton = primaryAction && buttonsFrom(primaryAction, {
    primary: true
  }) || null;
  var secondaryActionButtons = secondaryActions && buttonsFrom(secondaryActions) || null;
  var actions = primaryActionButton || secondaryActionButtons ? React__default.createElement(ButtonGroup, null, secondaryActionButtons, primaryActionButton) : null;
  return React__default.createElement("div", {
    className: styles$10.Footer
  }, React__default.createElement("div", {
    className: styles$10.FooterContent
  }, React__default.createElement(Stack, {
    alignment: "center"
  }, React__default.createElement(Stack.Item, {
    fill: true
  }, children), actions)));
}

var styles$11 = {
  "CloseButton": "Polaris-Modal-CloseButton",
  "withoutTitle": "Polaris-Modal-CloseButton--withoutTitle"
};

function CloseButton(_ref) {
  var _ref$title = _ref.title,
      title = _ref$title === void 0 ? true : _ref$title,
      onClick = _ref.onClick;
  var i18n = useI18n();
  var className = classNames(styles$11.CloseButton, !title && styles$11.withoutTitle);
  return React__default.createElement("button", {
    onClick: onClick,
    className: className,
    "aria-label": i18n.translate('Polaris.Common.close')
  }, React__default.createElement(Icon, {
    source: MobileCancelMajorMonotone,
    color: "inkLighter"
  }));
}

var styles$12 = {
  "Header": "Polaris-Modal-Header",
  "Title": "Polaris-Modal-Header__Title"
};

function Header$1(_ref) {
  var id = _ref.id,
      children = _ref.children,
      onClose = _ref.onClose;
  return React__default.createElement("div", {
    className: styles$12.Header
  }, React__default.createElement("div", {
    id: id,
    className: styles$12.Title
  }, React__default.createElement(DisplayText, {
    element: "h2",
    size: "small"
  }, children)), React__default.createElement(CloseButton, {
    onClick: onClose
  }));
}

var styles$13 = {
  "Section": "Polaris-Modal-Section",
  "subdued": "Polaris-Modal-Section--subdued",
  "flush": "Polaris-Modal-Section--flush"
};

function Section$3(_ref) {
  var children = _ref.children,
      _ref$flush = _ref.flush,
      flush = _ref$flush === void 0 ? false : _ref$flush,
      _ref$subdued = _ref.subdued,
      subdued = _ref$subdued === void 0 ? false : _ref$subdued;
  var className = classNames(styles$13.Section, flush && styles$13.flush, subdued && styles$13.subdued);
  return React__default.createElement("section", {
    className: className
  }, children);
}

var styles$14 = {
  "BodyWrapper": "Polaris-Modal__BodyWrapper",
  "Body": "Polaris-Modal__Body",
  "IFrame": "Polaris-Modal__IFrame",
  "Spinner": "Polaris-Modal__Spinner"
};

var IFRAME_LOADING_HEIGHT = 200;
var DEFAULT_IFRAME_CONTENT_HEIGHT = 400;
var getUniqueID$1 = createUniqueIDFactory('modal-header');
var APP_BRIDGE_PROPS = ['title', 'size', 'message', 'src', 'primaryAction', 'secondaryActions'];

var Modal =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Modal, _React$Component);

  function Modal() {
    var _this;

    _classCallCheck(this, Modal);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Modal).apply(this, arguments));
    _this.focusReturnPointNode = null;
    _this.state = {
      iframeHeight: IFRAME_LOADING_HEIGHT
    };
    _this.headerId = getUniqueID$1();

    _this.handleEntered = function () {
      var onTransitionEnd = _this.props.onTransitionEnd;

      if (onTransitionEnd) {
        onTransitionEnd();
      }
    };

    _this.handleExited = function () {
      _this.setState({
        iframeHeight: IFRAME_LOADING_HEIGHT
      });

      if (_this.focusReturnPointNode) {
        write(function () {
          return _this.focusReturnPointNode && focusFirstFocusableNode(_this.focusReturnPointNode, false);
        });
      }
    };

    _this.handleIFrameLoad = function (evt) {
      var iframe = evt.target;

      if (iframe && iframe.contentWindow) {
        try {
          _this.setState({
            iframeHeight: iframe.contentWindow.document.body.scrollHeight
          });
        } catch (_a) {
          _this.setState({
            iframeHeight: DEFAULT_IFRAME_CONTENT_HEIGHT
          });
        }
      }

      var onIFrameLoad = _this.props.onIFrameLoad;

      if (onIFrameLoad != null) {
        onIFrameLoad(evt);
      }
    };

    return _this;
  }

  _createClass(Modal, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.polaris.appBridge == null) {
        return;
      } // eslint-disable-next-line no-console


      console.warn('Deprecation: Using `Modal` in an embedded app is deprecated and will be removed in v5.0. Use `Modal` from `@shopify/app-bridge-react` instead: https://help.shopify.com/en/api/embedded-apps/app-bridge/react-components/modal');
      var transformProps = this.transformProps();

      if (transformProps) {
        this.appBridgeModal = Modal$2.create(this.props.polaris.appBridge, transformProps);
      }

      if (this.appBridgeModal) {
        this.appBridgeModal.subscribe(Modal$2.Action.CLOSE, this.props.onClose);
      }

      var open = this.props.open;

      if (open) {
        this.focusReturnPointNode = document.activeElement;
        this.appBridgeModal && this.appBridgeModal.dispatch(Modal$2.Action.OPEN);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.polaris.appBridge == null || this.appBridgeModal == null) {
        return;
      }

      var open = this.props.open;
      var wasOpen = prevProps.open;
      var transformedProps = this.transformProps();
      var prevAppBridgeProps = pick(prevProps, APP_BRIDGE_PROPS);
      var currentAppBridgeProps = pick(this.props, APP_BRIDGE_PROPS);

      if (!isEqual(prevAppBridgeProps, currentAppBridgeProps) && transformedProps) {
        if (isIframeModal(transformedProps)) {
          this.appBridgeModal.set(transformedProps);
        } else {
          this.appBridgeModal.set(transformedProps);
        }
      }

      if (wasOpen !== open) {
        if (open) {
          this.appBridgeModal.dispatch(Modal$2.Action.OPEN);
        } else {
          this.appBridgeModal.dispatch(Modal$2.Action.CLOSE);
        }
      }

      if (!wasOpen && open) {
        this.focusReturnPointNode = document.activeElement;
      } else if (wasOpen && !open && this.focusReturnPointNode != null && document.contains(this.focusReturnPointNode)) {
        this.focusReturnPointNode.focus();
        this.focusReturnPointNode = null;
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.props.polaris.appBridge == null || this.appBridgeModal == null) {
        return;
      }

      this.appBridgeModal.unsubscribe();
    }
  }, {
    key: "render",
    value: function render() {
      if (this.props.polaris.appBridge != null) {
        return null;
      }

      var _this$props = this.props,
          children = _this$props.children,
          title = _this$props.title,
          src = _this$props.src,
          iFrameName = _this$props.iFrameName,
          open = _this$props.open,
          instant = _this$props.instant,
          sectioned = _this$props.sectioned,
          loading = _this$props.loading,
          large = _this$props.large,
          limitHeight = _this$props.limitHeight,
          onClose = _this$props.onClose,
          footer = _this$props.footer,
          primaryAction = _this$props.primaryAction,
          secondaryActions = _this$props.secondaryActions,
          intl = _this$props.polaris.intl,
          onScrolledToBottom = _this$props.onScrolledToBottom;
      var iframeHeight = this.state.iframeHeight;
      var iframeTitle = intl.translate('Polaris.Modal.iFrameTitle');
      var dialog;
      var backdrop;

      if (open) {
        var footerMarkup = !footer && !primaryAction && !secondaryActions ? null : React__default.createElement(Footer, {
          primaryAction: primaryAction,
          secondaryActions: secondaryActions
        }, footer);
        var content = sectioned ? wrapWithComponent(children, Section$3, {}) : children;
        var body = loading ? React__default.createElement("div", {
          className: styles$14.Spinner
        }, React__default.createElement(Spinner, null)) : content;
        var bodyMarkup = src ? React__default.createElement("iframe", {
          name: iFrameName,
          title: iframeTitle,
          src: src,
          className: styles$14.IFrame,
          onLoad: this.handleIFrameLoad,
          style: {
            height: "".concat(iframeHeight, "px")
          }
        }) : React__default.createElement(Scrollable, {
          shadow: true,
          className: styles$14.Body,
          onScrolledToBottom: onScrolledToBottom
        }, body);
        var headerMarkup = title ? React__default.createElement(Header$1, {
          id: this.headerId,
          onClose: onClose
        }, title) : React__default.createElement(CloseButton, {
          onClick: onClose,
          title: false
        });
        var labelledBy = title ? this.headerId : undefined;
        dialog = React__default.createElement(Dialog, {
          instant: instant,
          labelledBy: labelledBy,
          onClose: onClose,
          onEntered: this.handleEntered,
          onExited: this.handleExited,
          large: large,
          limitHeight: limitHeight
        }, headerMarkup, React__default.createElement("div", {
          className: styles$14.BodyWrapper
        }, bodyMarkup), footerMarkup);
        backdrop = React__default.createElement(Backdrop, null);
      }

      var animated = !instant;
      return React__default.createElement(WithinContentContext.Provider, {
        value: true
      }, React__default.createElement(Portal, {
        idPrefix: "modal"
      }, React__default.createElement(TransitionGroup, {
        appear: animated,
        enter: animated,
        exit: animated
      }, dialog), backdrop));
    }
  }, {
    key: "transformProps",
    value: function transformProps() {
      var _this$props2 = this.props,
          title = _this$props2.title,
          size = _this$props2.size,
          message = _this$props2.message,
          src = _this$props2.src,
          primaryAction = _this$props2.primaryAction,
          secondaryActions = _this$props2.secondaryActions,
          polaris = _this$props2.polaris;
      var appBridge = polaris.appBridge;
      if (!appBridge) return;
      var safeTitle = typeof title === 'string' ? title : undefined;
      var safeSize = size != null ? Modal$2.Size[size] : undefined;
      var srcPayload = {};

      if (src != null) {
        if (/^https?:\/\//.test(src)) {
          srcPayload.url = src;
        } else {
          srcPayload.path = src;
        }
      }

      return Object.assign(Object.assign({
        title: safeTitle,
        message,
        size: safeSize
      }, srcPayload), {
        footer: {
          buttons: transformActions(appBridge, {
            primaryAction,
            secondaryActions
          })
        }
      });
    }
  }]);

  return Modal;
}(React__default.Component);

Modal.Section = Section$3;

function isIframeModal(options) {
  return typeof options.url === 'string' || typeof options.path === 'string';
} // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var Modal$1 = withAppProvider()(Modal);

function DiscardConfirmationModal(_ref) {
  var open = _ref.open,
      onDiscard = _ref.onDiscard,
      onCancel = _ref.onCancel;
  var i18n = useI18n();
  return React__default.createElement(Modal$1, {
    title: i18n.translate('Polaris.DiscardConfirmationModal.title'),
    open: open,
    onClose: onCancel,
    primaryAction: {
      content: i18n.translate('Polaris.DiscardConfirmationModal.primaryAction'),
      destructive: true,
      onAction: onDiscard
    },
    secondaryActions: [{
      content: i18n.translate('Polaris.DiscardConfirmationModal.secondaryAction'),
      onAction: onCancel
    }],
    sectioned: true
  }, i18n.translate('Polaris.DiscardConfirmationModal.message'));
}

var styles$15 = {
  "ContextualSaveBar": "Polaris-Frame-ContextualSaveBar",
  "LogoContainer": "Polaris-Frame-ContextualSaveBar__LogoContainer",
  "Contents": "Polaris-Frame-ContextualSaveBar__Contents",
  "Message": "Polaris-Frame-ContextualSaveBar__Message",
  "ActionContainer": "Polaris-Frame-ContextualSaveBar__ActionContainer",
  "Action": "Polaris-Frame-ContextualSaveBar__Action"
};

function ContextualSaveBar$1(_ref) {
  var alignContentFlush = _ref.alignContentFlush,
      message = _ref.message,
      saveAction = _ref.saveAction,
      discardAction = _ref.discardAction;
  var i18n = useI18n();

  var _useTheme = useTheme(),
      logo = _useTheme.logo;

  var _useToggle = useToggle(false),
      discardConfirmationModalVisible = _useToggle.value,
      toggleDiscardConfirmationModal = _useToggle.toggle,
      closeDiscardConfirmationModal = _useToggle.setFalse;

  var handleDiscardAction = useCallback(function () {
    if (discardAction && discardAction.onAction) {
      discardAction.onAction();
    }

    closeDiscardConfirmationModal();
  }, [closeDiscardConfirmationModal, discardAction]);
  var discardActionContent = discardAction && discardAction.content ? discardAction.content : i18n.translate('Polaris.ContextualSaveBar.discard');
  var discardActionHandler;

  if (discardAction && discardAction.discardConfirmationModal) {
    discardActionHandler = toggleDiscardConfirmationModal;
  } else if (discardAction) {
    discardActionHandler = discardAction.onAction;
  }

  var discardConfirmationModalMarkup = discardAction && discardAction.onAction && discardAction.discardConfirmationModal && React__default.createElement(DiscardConfirmationModal, {
    open: discardConfirmationModalVisible,
    onCancel: toggleDiscardConfirmationModal,
    onDiscard: handleDiscardAction
  });
  var discardActionMarkup = discardAction && React__default.createElement(Button, {
    url: discardAction.url,
    onClick: discardActionHandler,
    loading: discardAction.loading,
    disabled: discardAction.disabled,
    accessibilityLabel: discardAction.content
  }, discardActionContent);
  var saveActionContent = saveAction && saveAction.content ? saveAction.content : i18n.translate('Polaris.ContextualSaveBar.save');
  var saveActionMarkup = saveAction && React__default.createElement(Button, {
    primary: true,
    url: saveAction.url,
    onClick: saveAction.onAction,
    loading: saveAction.loading,
    disabled: saveAction.disabled,
    accessibilityLabel: saveAction.content
  }, saveActionContent);
  var width = getWidth(logo, 104);
  var imageMarkup = logo && React__default.createElement(Image, {
    style: {
      width
    },
    source: logo.contextualSaveBarSource || '',
    alt: ""
  });
  var logoMarkup = alignContentFlush ? null : React__default.createElement("div", {
    className: styles$15.LogoContainer,
    style: {
      width
    }
  }, imageMarkup);
  return React__default.createElement(React__default.Fragment, null, React__default.createElement("div", {
    className: styles$15.ContextualSaveBar
  }, logoMarkup, React__default.createElement("div", {
    className: styles$15.Contents
  }, React__default.createElement("h2", {
    className: styles$15.Message
  }, message), React__default.createElement("div", {
    className: styles$15.ActionContainer
  }, React__default.createElement(Stack, {
    spacing: "tight",
    wrap: false
  }, discardActionMarkup, saveActionMarkup)))), discardConfirmationModalMarkup);
}

var styles$16 = {
  "startFade": "Polaris-Frame-CSSAnimation--startFade",
  "endFade": "Polaris-Frame-CSSAnimation--endFade"
};

var AnimationType;

(function (AnimationType) {
  AnimationType["Fade"] = "fade";
})(AnimationType || (AnimationType = {}));

var TransitionStatus$1;

(function (TransitionStatus) {
  TransitionStatus["Entering"] = "entering";
  TransitionStatus["Entered"] = "entered";
  TransitionStatus["Exiting"] = "exiting";
  TransitionStatus["Exited"] = "exited";
})(TransitionStatus$1 || (TransitionStatus$1 = {}));

function CSSAnimation(_ref) {
  var inProp = _ref.in,
      className = _ref.className,
      type = _ref.type,
      children = _ref.children;

  var _useState = useState(inProp ? TransitionStatus$1.Entering : TransitionStatus$1.Exited),
      _useState2 = _slicedToArray(_useState, 2),
      transitionStatus = _useState2[0],
      setTransitionStatus = _useState2[1];

  var isMounted = useRef(false);
  var node = useRef(null);
  useEffect(function () {
    if (!isMounted.current) return;
    transitionStatus === TransitionStatus$1.Entering && changeTransitionStatus(TransitionStatus$1.Entered);
  }, [transitionStatus]);
  useEffect(function () {
    if (!isMounted.current) return;
    inProp && changeTransitionStatus(TransitionStatus$1.Entering);
    !inProp && changeTransitionStatus(TransitionStatus$1.Exiting);
  }, [inProp]);
  useEffect(function () {
    isMounted.current = true;
  }, []);
  var wrapperClassName = classNames(className, styles$16[variationName('start', type)], inProp && styles$16[variationName('end', type)]);
  var content = transitionStatus === TransitionStatus$1.Exited && !inProp ? null : children;
  return React__default.createElement("div", {
    className: wrapperClassName,
    ref: node,
    onTransitionEnd: handleTransitionEnd
  }, content);

  function handleTransitionEnd() {
    transitionStatus === TransitionStatus$1.Exiting && changeTransitionStatus(TransitionStatus$1.Exited);
  }

  function changeTransitionStatus(transitionStatus) {
    setTransitionStatus(transitionStatus); // Forcing a reflow to enable the animation

    if (transitionStatus === TransitionStatus$1.Entering) node.current && node.current.getBoundingClientRect();
  }
}

var styles$17 = {
  "Frame": "Polaris-Frame",
  "Navigation": "Polaris-Frame__Navigation",
  "Navigation-enter": "Polaris-Frame__Navigation--enter",
  "Navigation-enterActive": "Polaris-Frame__Navigation--enterActive",
  "Navigation-exit": "Polaris-Frame__Navigation--exit",
  "Navigation-exitActive": "Polaris-Frame__Navigation--exitActive",
  "NavigationDismiss": "Polaris-Frame__NavigationDismiss",
  "Navigation-visible": "Polaris-Frame__Navigation--visible",
  "TopBar": "Polaris-Frame__TopBar",
  "ContextualSaveBar": "Polaris-Frame__ContextualSaveBar",
  "Main": "Polaris-Frame__Main",
  "hasNav": "Polaris-Frame--hasNav",
  "hasTopBar": "Polaris-Frame--hasTopBar",
  "Content": "Polaris-Frame__Content",
  "GlobalRibbonContainer": "Polaris-Frame__GlobalRibbonContainer",
  "LoadingBar": "Polaris-Frame__LoadingBar",
  "Skip": "Polaris-Frame__Skip",
  "focused": "Polaris-Frame--focused",
  "SkipAnchor": "Polaris-Frame__SkipAnchor",
  "globalTheming": "Polaris-Frame--globalTheming"
};

var GLOBAL_RIBBON_CUSTOM_PROPERTY = '--global-ribbon-height';
var APP_FRAME_MAIN = 'AppFrameMain';
var APP_FRAME_MAIN_ANCHOR_TARGET = 'AppFrameMainContent';
var APP_FRAME_NAV = 'AppFrameNav';
var APP_FRAME_TOP_BAR = 'AppFrameTopBar';
var APP_FRAME_LOADING_BAR = 'AppFrameLoadingBar';

var Frame =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Frame, _React$PureComponent);

  function Frame() {
    var _this;

    _classCallCheck(this, Frame);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Frame).apply(this, arguments));
    _this.state = {
      skipFocused: false,
      globalRibbonHeight: 0,
      loadingStack: 0,
      toastMessages: [],
      showContextualSaveBar: false
    };
    _this.contextualSaveBar = null;
    _this.globalRibbonContainer = null;
    _this.navigationNode = createRef();
    _this.skipToMainContentTargetNode = _this.props.skipToContentTarget || React__default.createRef();

    _this.setGlobalRibbonHeight = function () {
      var _assertThisInitialize = _assertThisInitialized(_this),
          globalRibbonContainer = _assertThisInitialize.globalRibbonContainer;

      if (globalRibbonContainer) {
        _this.setState({
          globalRibbonHeight: globalRibbonContainer.offsetHeight
        }, _this.setGlobalRibbonRootProperty);
      }
    };

    _this.setGlobalRibbonRootProperty = function () {
      var globalRibbonHeight = _this.state.globalRibbonHeight;
      setRootProperty(GLOBAL_RIBBON_CUSTOM_PROPERTY, "".concat(globalRibbonHeight, "px"), null);
    };

    _this.showToast = function (toast) {
      _this.setState(function (_ref) {
        var toastMessages = _ref.toastMessages;
        var hasToastById = toastMessages.find(function (_ref2) {
          var id = _ref2.id;
          return id === toast.id;
        }) != null;
        return {
          toastMessages: hasToastById ? toastMessages : [].concat(_toConsumableArray(toastMessages), [toast])
        };
      });
    };

    _this.hideToast = function (_ref3) {
      var id = _ref3.id;

      _this.setState(function (_ref4) {
        var toastMessages = _ref4.toastMessages;
        return {
          toastMessages: toastMessages.filter(function (_ref5) {
            var toastId = _ref5.id;
            return id !== toastId;
          })
        };
      });
    };

    _this.setContextualSaveBar = function (props) {
      var showContextualSaveBar = _this.state.showContextualSaveBar;
      _this.contextualSaveBar = Object.assign({}, props);

      if (showContextualSaveBar === true) {
        _this.forceUpdate();
      } else {
        _this.setState({
          showContextualSaveBar: true
        });
      }
    };

    _this.removeContextualSaveBar = function () {
      _this.contextualSaveBar = null;

      _this.setState({
        showContextualSaveBar: false
      });
    };

    _this.startLoading = function () {
      _this.setState(function (_ref6) {
        var loadingStack = _ref6.loadingStack;
        return {
          loadingStack: loadingStack + 1
        };
      });
    };

    _this.stopLoading = function () {
      _this.setState(function (_ref7) {
        var loadingStack = _ref7.loadingStack;
        return {
          loadingStack: Math.max(0, loadingStack - 1)
        };
      });
    };

    _this.handleResize = function () {
      if (_this.props.globalRibbon) {
        _this.setGlobalRibbonHeight();
      }
    };

    _this.handleFocus = function () {
      _this.setState({
        skipFocused: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        skipFocused: false
      });
    };

    _this.handleClick = function () {
      _this.skipToMainContentTargetNode.current && _this.skipToMainContentTargetNode.current.focus();
    };

    _this.handleNavigationDismiss = function () {
      var onNavigationDismiss = _this.props.onNavigationDismiss;

      if (onNavigationDismiss != null) {
        onNavigationDismiss();
      }
    };

    _this.setGlobalRibbonContainer = function (node) {
      _this.globalRibbonContainer = node;
    };

    _this.handleNavKeydown = function (event) {
      var key = event.key;

      if (key === 'Escape') {
        _this.handleNavigationDismiss();
      }
    };

    _this.findNavigationNode = function () {
      return _this.navigationNode.current;
    };

    return _this;
  }

  _createClass(Frame, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleResize();

      if (this.props.globalRibbon) {
        return;
      }

      this.setGlobalRibbonRootProperty();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.globalRibbon !== prevProps.globalRibbon) {
        this.setGlobalRibbonHeight();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          skipFocused = _this$state.skipFocused,
          loadingStack = _this$state.loadingStack,
          toastMessages = _this$state.toastMessages,
          showContextualSaveBar = _this$state.showContextualSaveBar;
      var _this$props = this.props,
          children = _this$props.children,
          navigation = _this$props.navigation,
          topBar = _this$props.topBar,
          globalRibbon = _this$props.globalRibbon,
          _this$props$showMobil = _this$props.showMobileNavigation,
          showMobileNavigation = _this$props$showMobil === void 0 ? false : _this$props$showMobil,
          skipToContentTarget = _this$props.skipToContentTarget,
          _this$props$polaris = _this$props.polaris,
          intl = _this$props$polaris.intl,
          isNavigationCollapsed = _this$props$polaris.mediaQuery.isNavigationCollapsed;
      var navClassName = classNames(styles$17.Navigation, showMobileNavigation && styles$17['Navigation-visible']);
      var mobileNavHidden = isNavigationCollapsed && !showMobileNavigation;
      var mobileNavShowing = isNavigationCollapsed && showMobileNavigation;
      var tabIndex = mobileNavShowing ? 0 : -1;
      var navigationMarkup = navigation ? React__default.createElement(TrapFocus, {
        trapping: mobileNavShowing
      }, React__default.createElement(CSSTransition, {
        findDOMNode: this.findNavigationNode,
        appear: isNavigationCollapsed,
        exit: isNavigationCollapsed,
        in: showMobileNavigation,
        timeout: durationSlow,
        classNames: navTransitionClasses
      }, React__default.createElement("div", {
        ref: this.navigationNode,
        className: navClassName,
        onKeyDown: this.handleNavKeydown,
        id: APP_FRAME_NAV,
        key: "NavContent",
        hidden: mobileNavHidden
      }, navigation, React__default.createElement("button", {
        type: "button",
        className: styles$17.NavigationDismiss,
        onClick: this.handleNavigationDismiss,
        "aria-hidden": mobileNavHidden || !isNavigationCollapsed && !showMobileNavigation,
        "aria-label": intl.translate('Polaris.Frame.Navigation.closeMobileNavigationLabel'),
        tabIndex: tabIndex
      }, React__default.createElement(Icon, {
        source: MobileCancelMajorMonotone,
        color: "white"
      }))))) : null;
      var loadingMarkup = loadingStack > 0 ? React__default.createElement("div", {
        className: styles$17.LoadingBar,
        id: APP_FRAME_LOADING_BAR
      }, React__default.createElement(Loading, null)) : null;
      var contextualSaveBarMarkup = React__default.createElement(CSSAnimation, {
        in: showContextualSaveBar,
        className: styles$17.ContextualSaveBar,
        type: AnimationType.Fade
      }, React__default.createElement(ContextualSaveBar$1, this.contextualSaveBar));
      var topBarMarkup = topBar ? React__default.createElement("div", Object.assign({
        className: styles$17.TopBar
      }, layer.props, dataPolarisTopBar.props, {
        id: APP_FRAME_TOP_BAR
      }), topBar) : null;
      var globalRibbonMarkup = globalRibbon ? React__default.createElement("div", {
        className: styles$17.GlobalRibbonContainer,
        ref: this.setGlobalRibbonContainer
      }, globalRibbon) : null;
      var skipClassName = classNames(styles$17.Skip, skipFocused && styles$17.focused);
      var skipTarget = skipToContentTarget ? skipToContentTarget.current && skipToContentTarget.current.id || '' : APP_FRAME_MAIN_ANCHOR_TARGET;
      var skipMarkup = React__default.createElement("div", {
        className: skipClassName
      }, React__default.createElement("a", {
        href: "#".concat(skipTarget),
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onClick: this.handleClick,
        className: styles$17.SkipAnchor
      }, intl.translate('Polaris.Frame.skipToContent')));
      var navigationAttributes = navigation ? {
        'data-has-navigation': true
      } : {};
      var frameClassName = classNames(styles$17.Frame, navigation && styles$17.hasNav, topBar && styles$17.hasTopBar);
      var navigationOverlayMarkup = showMobileNavigation && isNavigationCollapsed ? React__default.createElement(Backdrop, {
        belowNavigation: true,
        onClick: this.handleNavigationDismiss,
        onTouchStart: this.handleNavigationDismiss
      }) : null;
      var skipToMainContentTarget = skipToContentTarget ? null : // eslint-disable-next-line jsx-a11y/anchor-is-valid
      React__default.createElement("a", {
        id: APP_FRAME_MAIN_ANCHOR_TARGET,
        ref: this.skipToMainContentTargetNode,
        tabIndex: -1
      });
      var context = {
        showToast: this.showToast,
        hideToast: this.hideToast,
        startLoading: this.startLoading,
        stopLoading: this.stopLoading,
        setContextualSaveBar: this.setContextualSaveBar,
        removeContextualSaveBar: this.removeContextualSaveBar
      };
      return React__default.createElement(FrameContext.Provider, {
        value: context
      }, React__default.createElement("div", Object.assign({
        className: frameClassName
      }, layer.props, navigationAttributes), skipMarkup, topBarMarkup, navigationMarkup, contextualSaveBarMarkup, loadingMarkup, navigationOverlayMarkup, React__default.createElement("main", {
        className: styles$17.Main,
        id: APP_FRAME_MAIN,
        "data-has-global-ribbon": Boolean(globalRibbon)
      }, skipToMainContentTarget, React__default.createElement("div", {
        className: styles$17.Content
      }, children)), React__default.createElement(ToastManager, {
        toastMessages: toastMessages
      }), globalRibbonMarkup, React__default.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      })));
    }
  }]);

  return Frame;
}(React__default.PureComponent);

var navTransitionClasses = {
  enter: classNames(styles$17['Navigation-enter']),
  enterActive: classNames(styles$17['Navigation-enterActive']),
  enterDone: classNames(styles$17['Navigation-enterActive']),
  exit: classNames(styles$17['Navigation-exit']),
  exitActive: classNames(styles$17['Navigation-exitActive'])
}; // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export

var Frame$1 = withAppProvider()(Frame);

var styles$18 = {
  "Indicator": "Polaris-Indicator",
  "pulseIndicator": "Polaris-Indicator--pulseIndicator",
  "bounce": "Polaris-Indicator--bounce",
  "pulse": "Polaris-Indicator--pulse"
};

function Indicator(_ref) {
  var _ref$pulse = _ref.pulse,
      pulse = _ref$pulse === void 0 ? true : _ref$pulse;
  var className = classNames(styles$18.Indicator, pulse && styles$18.pulseIndicator);
  return React__default.createElement("span", {
    className: className
  });
}

var styles$19 = {
  "KeyboardKey": "Polaris-KeyboardKey"
};

function KeyboardKey(_ref) {
  var children = _ref.children;
  var key = children || '';
  key = key.length > 1 ? key.toLowerCase() : key.toUpperCase();
  return React__default.createElement("kbd", {
    className: styles$19.KeyboardKey
  }, key);
}

var styles$1a = {
  "Layout": "Polaris-Layout",
  "Section": "Polaris-Layout__Section",
  "Section-secondary": "Polaris-Layout__Section--secondary",
  "Section-fullWidth": "Polaris-Layout__Section--fullWidth",
  "Section-oneHalf": "Polaris-Layout__Section--oneHalf",
  "Section-oneThird": "Polaris-Layout__Section--oneThird",
  "AnnotatedSection": "Polaris-Layout__AnnotatedSection",
  "AnnotationWrapper": "Polaris-Layout__AnnotationWrapper",
  "AnnotationContent": "Polaris-Layout__AnnotationContent",
  "Annotation": "Polaris-Layout__Annotation",
  "AnnotationDescription": "Polaris-Layout__AnnotationDescription"
};

function AnnotatedSection(props) {
  var children = props.children,
      title = props.title,
      description = props.description;
  var descriptionMarkup = typeof description === 'string' ? React__default.createElement("p", null, description) : description;
  return React__default.createElement("div", {
    className: styles$1a.AnnotatedSection
  }, React__default.createElement("div", {
    className: styles$1a.AnnotationWrapper
  }, React__default.createElement("div", {
    className: styles$1a.Annotation
  }, React__default.createElement(TextContainer, null, React__default.createElement(Heading, null, title), descriptionMarkup && React__default.createElement("div", {
    className: styles$1a.AnnotationDescription
  }, descriptionMarkup))), React__default.createElement("div", {
    className: styles$1a.AnnotationContent
  }, children)));
}

function Section$4(_ref) {
  var children = _ref.children,
      secondary = _ref.secondary,
      fullWidth = _ref.fullWidth,
      oneHalf = _ref.oneHalf,
      oneThird = _ref.oneThird;
  var className = classNames(styles$1a.Section, secondary && styles$1a['Section-secondary'], fullWidth && styles$1a['Section-fullWidth'], oneHalf && styles$1a['Section-oneHalf'], oneThird && styles$1a['Section-oneThird']);
  return React__default.createElement("div", {
    className: className
  }, children);
}

var Layout =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Layout, _React$Component);

  function Layout() {
    _classCallCheck(this, Layout);

    return _possibleConstructorReturn(this, _getPrototypeOf(Layout).apply(this, arguments));
  }

  _createClass(Layout, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          sectioned = _this$props.sectioned;
      var content = sectioned ? React__default.createElement(Section$4, null, children) : children;
      return React__default.createElement("div", {
        className: styles$1a.Layout
      }, content);
    }
  }]);

  return Layout;
}(React__default.Component);
Layout.AnnotatedSection = AnnotatedSection;
Layout.Section = Section$4;

var styles$1b = {
  "Link": "Polaris-Link",
  "IconLockup": "Polaris-Link__IconLockup",
  "IconLayout": "Polaris-Link__IconLayout",
  "monochrome": "Polaris-Link--monochrome"
};

function Link(_ref) {
  var url = _ref.url,
      children = _ref.children,
      onClick = _ref.onClick,
      external = _ref.external,
      id = _ref.id,
      monochrome = _ref.monochrome;
  var i18n = useI18n();
  var childrenMarkup = children;

  if (external && typeof children === 'string') {
    var iconLabel = i18n.translate('Polaris.Common.newWindowAccessibilityHint');
    childrenMarkup = React__default.createElement(React__default.Fragment, null, children, React__default.createElement("span", {
      className: styles$1b.IconLockup
    }, React__default.createElement("span", {
      className: styles$1b.IconLayout
    }, React__default.createElement(Icon, {
      accessibilityLabel: iconLabel,
      source: ExternalSmallMinor
    }))));
  }

  return React__default.createElement(BannerContext.Consumer, null, function (BannerContext) {
    var shouldBeMonochrome = monochrome || BannerContext;
    var className = classNames(styles$1b.Link, shouldBeMonochrome && styles$1b.monochrome);
    return url ? React__default.createElement(UnstyledLink, {
      onClick: onClick,
      className: className,
      url: url,
      external: external,
      id: id
    }, childrenMarkup) : React__default.createElement("button", {
      type: "button",
      onClick: onClick,
      className: className,
      id: id
    }, childrenMarkup);
  });
}

var styles$1c = {
  "List": "Polaris-List",
  "typeNumber": "Polaris-List--typeNumber",
  "Item": "Polaris-List__Item"
};

function Item$6(_ref) {
  var children = _ref.children;
  return React__default.createElement("li", {
    className: styles$1c.Item
  }, children);
}

var List =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(List, _React$PureComponent);

  function List() {
    _classCallCheck(this, List);

    return _possibleConstructorReturn(this, _getPrototypeOf(List).apply(this, arguments));
  }

  _createClass(List, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          _this$props$type = _this$props.type,
          type = _this$props$type === void 0 ? 'bullet' : _this$props$type;
      var className = classNames(styles$1c.List, type && styles$1c[variationName('type', type)]);
      var ListElement = type === 'bullet' ? 'ul' : 'ol';
      return React__default.createElement(ListElement, {
        className: className
      }, children);
    }
  }]);

  return List;
}(React__default.PureComponent);
List.Item = Item$6;

var Loading$1 = React__default.memo(function Loading() {
  var appBridgeLoading = useRef();
  var appBridge = useAppBridge();

  var _useFrame = useFrame(),
      startLoading = _useFrame.startLoading,
      stopLoading = _useFrame.stopLoading;

  useEffect(function () {
    if (appBridge == null) {
      startLoading();
    } else {
      // eslint-disable-next-line no-console
      console.warn('Deprecation: Using `Loading` in an embedded app is deprecated and will be removed in v5.0. Use `Loading` from `@shopify/app-bridge-react` instead: https://help.shopify.com/en/api/embedded-apps/app-bridge/react-components/loading');
      appBridgeLoading.current = Loading$2.create(appBridge);
      appBridgeLoading.current.dispatch(Loading$2.Action.START);
    }

    return function () {
      if (appBridge == null) {
        stopLoading();
      } else {
        appBridgeLoading.current && appBridgeLoading.current.dispatch(Loading$2.Action.STOP);
      }
    };
  }, [appBridge, startLoading, stopLoading]);
  return null;
});

var NavigationContext = React__default.createContext({
  location: ''
});

var styles$1d = {
  "Navigation": "Polaris-Navigation",
  "UserMenu": "Polaris-Navigation__UserMenu",
  "ContextControl": "Polaris-Navigation__ContextControl",
  "PrimaryNavigation": "Polaris-Navigation__PrimaryNavigation",
  "Item": "Polaris-Navigation__Item",
  "Icon": "Polaris-Navigation__Icon",
  "Item-selected": "Polaris-Navigation__Item--selected",
  "Item-disabled": "Polaris-Navigation__Item--disabled",
  "Badge": "Polaris-Navigation__Badge",
  "subNavigationActive": "Polaris-Navigation--subNavigationActive",
  "ListItem": "Polaris-Navigation__ListItem",
  "RollupSection": "Polaris-Navigation__RollupSection",
  "SecondaryNavigation": "Polaris-Navigation__SecondaryNavigation",
  "fade-in": "Polaris-Navigation__fade--in",
  "ListItem-hasAction": "Polaris-Navigation__ListItem--hasAction",
  "ItemWrapper": "Polaris-Navigation__ItemWrapper",
  "Text": "Polaris-Navigation__Text",
  "SecondaryAction": "Polaris-Navigation__SecondaryAction",
  "List": "Polaris-Navigation__List",
  "Section": "Polaris-Navigation__Section",
  "Section-fill": "Polaris-Navigation__Section--fill",
  "Section-withSeparator": "Polaris-Navigation__Section--withSeparator",
  "SectionHeading": "Polaris-Navigation__SectionHeading",
  "Action": "Polaris-Navigation__Action",
  "RollupToggle": "Polaris-Navigation__RollupToggle",
  "Indicator": "Polaris-Navigation__Indicator"
};

function Secondary(_ref) {
  var children = _ref.children,
      expanded = _ref.expanded;
  var id = useUniqueId('SecondaryNavigation');
  return React__default.createElement(Collapsible, {
    id: id,
    open: expanded
  }, React__default.createElement("ul", {
    className: styles$1d.List
  }, children));
}

var MatchState;

(function (MatchState) {
  MatchState[MatchState["MatchForced"] = 0] = "MatchForced";
  MatchState[MatchState["MatchUrl"] = 1] = "MatchUrl";
  MatchState[MatchState["MatchPaths"] = 2] = "MatchPaths";
  MatchState[MatchState["Excluded"] = 3] = "Excluded";
  MatchState[MatchState["NoMatch"] = 4] = "NoMatch";
})(MatchState || (MatchState = {}));

function Item$7(_ref) {
  var url = _ref.url,
      icon = _ref.icon,
      label = _ref.label,
      _ref$subNavigationIte = _ref.subNavigationItems,
      subNavigationItems = _ref$subNavigationIte === void 0 ? [] : _ref$subNavigationIte,
      secondaryAction = _ref.secondaryAction,
      disabled = _ref.disabled,
      onClick = _ref.onClick,
      accessibilityLabel = _ref.accessibilityLabel,
      selectedOverride = _ref.selected,
      badge = _ref.badge,
      isNew = _ref.new,
      matches = _ref.matches,
      exactMatch = _ref.exactMatch,
      matchPaths = _ref.matchPaths,
      excludePaths = _ref.excludePaths;
  var i18n = useI18n();

  var _useMediaQuery = useMediaQuery(),
      isNavigationCollapsed = _useMediaQuery.isNavigationCollapsed;

  var _useContext = useContext(NavigationContext),
      location = _useContext.location,
      onNavigationDismiss = _useContext.onNavigationDismiss;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  useEffect(function () {
    if (!isNavigationCollapsed && expanded) {
      setExpanded(false);
    }
  }, [expanded, isNavigationCollapsed]);
  var tabIndex = disabled ? -1 : 0;
  var hasNewChild = subNavigationItems.filter(function (subNavigationItem) {
    return subNavigationItem.new;
  }).length > 0;
  var indicatorMarkup = hasNewChild ? React__default.createElement("span", {
    className: styles$1d.Indicator
  }, React__default.createElement(Indicator, {
    pulse: true
  })) : null;
  var iconMarkup = icon ? React__default.createElement("div", {
    className: styles$1d.Icon
  }, React__default.createElement(Icon, {
    source: icon
  })) : null;
  var badgeMarkup = null;

  if (isNew) {
    badgeMarkup = React__default.createElement(Badge, {
      status: "new",
      size: "small"
    }, i18n.translate('Polaris.Badge.STATUS_LABELS.new'));
  } else if (typeof badge === 'string') {
    badgeMarkup = React__default.createElement(Badge, {
      status: "new",
      size: "small"
    }, badge);
  } else {
    badgeMarkup = badge;
  }

  var wrappedBadgeMarkup = badgeMarkup == null ? null : React__default.createElement("div", {
    className: styles$1d.Badge
  }, badgeMarkup);
  var itemContentMarkup = React__default.createElement(Fragment, null, iconMarkup, React__default.createElement("span", {
    className: styles$1d.Text
  }, label, indicatorMarkup), wrappedBadgeMarkup);

  if (url == null) {
    var _className = classNames(styles$1d.Item, disabled && styles$1d['Item-disabled']);

    return React__default.createElement("li", {
      className: styles$1d.ListItem
    }, React__default.createElement("button", {
      type: "button",
      className: _className,
      disabled: disabled,
      "aria-disabled": disabled,
      "aria-label": accessibilityLabel,
      onClick: getClickHandler(onClick)
    }, itemContentMarkup));
  }

  var secondaryActionMarkup = secondaryAction && React__default.createElement(UnstyledLink, {
    external: true,
    url: secondaryAction.url,
    className: styles$1d.SecondaryAction,
    tabIndex: tabIndex,
    "aria-disabled": disabled,
    "aria-label": secondaryAction.accessibilityLabel
  }, React__default.createElement(Icon, {
    source: secondaryAction.icon
  }));
  var matchState = matchStateForItem({
    url,
    matches,
    exactMatch,
    matchPaths,
    excludePaths
  }, location);
  var matchingSubNavigationItems = subNavigationItems.filter(function (item) {
    var subMatchState = matchStateForItem(item, location);
    return subMatchState === MatchState.MatchForced || subMatchState === MatchState.MatchUrl || subMatchState === MatchState.MatchPaths;
  });
  var childIsActive = matchingSubNavigationItems.length > 0;
  var selected = selectedOverride == null ? matchState === MatchState.MatchForced || matchState === MatchState.MatchUrl || matchState === MatchState.MatchPaths : selectedOverride;
  var showExpanded = selected || expanded || childIsActive;
  var itemClassName = classNames(styles$1d.Item, disabled && styles$1d['Item-disabled'], selected && subNavigationItems.length === 0 && styles$1d['Item-selected'], showExpanded && styles$1d.subNavigationActive);
  var secondaryNavigationMarkup = null;

  if (subNavigationItems.length > 0 && showExpanded) {
    var longestMatch = matchingSubNavigationItems.sort(function (_ref2, _ref3) {
      var firstUrl = _ref2.url;
      var secondUrl = _ref3.url;
      return secondUrl.length - firstUrl.length;
    })[0];
    secondaryNavigationMarkup = React__default.createElement("div", {
      className: styles$1d.SecondaryNavigation
    }, React__default.createElement(Secondary, {
      expanded: showExpanded
    }, subNavigationItems.map(function (item) {
      var label = item.label,
          rest = __rest(item, ["label"]);

      return React__default.createElement(Item$7, Object.assign({}, rest, {
        key: label,
        label: label,
        matches: item === longestMatch,
        onClick: onNavigationDismiss
      }));
    })));
  }

  var className = classNames(styles$1d.ListItem, secondaryAction && styles$1d['ListItem-hasAction']);
  return React__default.createElement("li", {
    className: className
  }, React__default.createElement("div", {
    className: styles$1d.ItemWrapper
  }, React__default.createElement(UnstyledLink, {
    url: url,
    className: itemClassName,
    tabIndex: tabIndex,
    "aria-disabled": disabled,
    "aria-label": accessibilityLabel,
    onClick: getClickHandler(onClick)
  }, itemContentMarkup), secondaryActionMarkup), secondaryNavigationMarkup);

  function getClickHandler(onClick) {
    return function (event) {
      var currentTarget = event.currentTarget;

      if (currentTarget.getAttribute('href') === location) {
        event.preventDefault();
      }

      if (subNavigationItems && subNavigationItems.length > 0 && isNavigationCollapsed) {
        event.preventDefault();
        setExpanded(!expanded);
      } else if (onNavigationDismiss) {
        onNavigationDismiss();

        if (onClick && onClick !== onNavigationDismiss) {
          onClick();
        }

        return;
      }

      if (onClick) {
        onClick();
      }
    };
  }
}
function isNavigationItemActive(navigationItem, currentPath) {
  var matchState = matchStateForItem(navigationItem, currentPath);
  var matchingSubNavigationItems = navigationItem.subNavigationItems && navigationItem.subNavigationItems.filter(function (item) {
    var subMatchState = matchStateForItem(item, currentPath);
    return subMatchState === MatchState.MatchForced || subMatchState === MatchState.MatchUrl || subMatchState === MatchState.MatchPaths;
  });
  var childIsActive = matchingSubNavigationItems && matchingSubNavigationItems.length > 0;
  var selected = matchState === MatchState.MatchForced || matchState === MatchState.MatchUrl || matchState === MatchState.MatchPaths;
  return selected || childIsActive;
}

function normalizePathname(pathname) {
  var barePathname = pathname.split('?')[0].split('#')[0];
  return barePathname.endsWith('/') ? barePathname : "".concat(barePathname, "/");
}

function safeEqual(location, path) {
  return normalizePathname(location) === normalizePathname(path);
}

function safeStartsWith(location, path) {
  return normalizePathname(location).startsWith(normalizePathname(path));
}

function matchStateForItem(_ref4, location) {
  var url = _ref4.url,
      matches = _ref4.matches,
      exactMatch = _ref4.exactMatch,
      matchPaths = _ref4.matchPaths,
      excludePaths = _ref4.excludePaths;

  if (url == null) {
    return MatchState.NoMatch;
  }

  if (matches) {
    return MatchState.MatchForced;
  }

  if (matches === false || excludePaths && excludePaths.some(function (path) {
    return safeStartsWith(location, path);
  })) {
    return MatchState.Excluded;
  }

  if (matchPaths && matchPaths.some(function (path) {
    return safeStartsWith(location, path);
  })) {
    return MatchState.MatchPaths;
  }

  var matchesUrl = exactMatch ? safeEqual(location, url) : safeStartsWith(location, url);
  return matchesUrl ? MatchState.MatchUrl : MatchState.NoMatch;
}

var createAdditionalItemsId = createUniqueIDFactory('AdditionalItems');
var Section$5 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Section, _React$Component);

  function Section() {
    var _this;

    _classCallCheck(this, Section);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Section).apply(this, arguments));
    _this.state = {
      expanded: false
    };
    _this.animationFrame = null;

    _this.toggleViewAll = function () {
      _this.setState(function (_ref) {
        var expanded = _ref.expanded;
        return {
          expanded: !expanded
        };
      });
    };

    return _this;
  }

  _createClass(Section, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.animationFrame) {
        cancelAnimationFrame(this.animationFrame);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          title = _this$props.title,
          fill = _this$props.fill,
          action = _this$props.action,
          items = _this$props.items,
          rollup = _this$props.rollup,
          separator = _this$props.separator;
      var expanded = this.state.expanded;
      var className = classNames(styles$1d.Section, separator && styles$1d['Section-withSeparator'], fill && styles$1d['Section-fill']);
      var actionMarkup = action && React__default.createElement("button", {
        type: "button",
        className: styles$1d.Action,
        "aria-label": action.accessibilityLabel,
        onClick: action.onClick
      }, React__default.createElement(Icon, {
        source: action.icon
      }));
      var sectionHeadingMarkup = title && React__default.createElement("li", {
        className: styles$1d.SectionHeading
      }, React__default.createElement("span", {
        className: styles$1d.Text
      }, title), actionMarkup);
      var itemsMarkup = items.map(function (item) {
        var onClick = item.onClick,
            label = item.label,
            subNavigationItems = item.subNavigationItems,
            rest = __rest(item, ["onClick", "label", "subNavigationItems"]);

        var hasSubNavItems = subNavigationItems != null && subNavigationItems.length > 0;
        return React__default.createElement(Item$7, Object.assign({}, rest, {
          key: label,
          label: label,
          subNavigationItems: subNavigationItems,
          onClick: _this2.handleClick(onClick, hasSubNavItems)
        }));
      });
      var toggleClassName = classNames(styles$1d.Item, styles$1d.RollupToggle);
      var ariaLabel = rollup && (expanded ? rollup.hide : rollup.view);
      var toggleRollup = rollup && items.length > rollup.after && React__default.createElement("div", {
        className: styles$1d.ListItem,
        key: "List Item"
      }, React__default.createElement("button", {
        type: "button",
        className: toggleClassName,
        onClick: this.toggleViewAll,
        "aria-label": ariaLabel
      }, React__default.createElement("span", {
        className: styles$1d.Icon
      }, React__default.createElement(Icon, {
        source: HorizontalDotsMinor
      }))));
      var activeItemIndex = items.findIndex(function (item) {
        if (!rollup) {
          return false;
        }

        return rollup.activePath === item.url || item.url && rollup.activePath.startsWith(item.url) || (item.subNavigationItems ? item.subNavigationItems.some(function (_ref2) {
          var itemUrl = _ref2.url;
          return rollup.activePath.startsWith(itemUrl);
        }) : false);
      });
      var sectionItems = rollup ? itemsMarkup.slice(0, rollup.after) : itemsMarkup;
      var additionalItems = rollup ? itemsMarkup.slice(rollup.after) : [];

      if (rollup && activeItemIndex !== -1 && activeItemIndex > rollup.after - 1) {
        sectionItems.push.apply(sectionItems, _toConsumableArray(additionalItems.splice(activeItemIndex - rollup.after, 1)));
      }

      var additionalItemsId = createAdditionalItemsId();
      var activeItemsMarkup = rollup && additionalItems.length > 0 && React__default.createElement("li", {
        className: styles$1d.RollupSection
      }, React__default.createElement(Collapsible, {
        id: additionalItemsId,
        open: expanded
      }, React__default.createElement("ul", {
        className: styles$1d.List
      }, additionalItems)), toggleRollup);
      return React__default.createElement("ul", {
        className: className
      }, sectionHeadingMarkup, sectionItems, activeItemsMarkup);
    }
  }, {
    key: "handleClick",
    value: function handleClick(onClick, hasSubNavItems) {
      var _this3 = this;

      return function () {
        if (onClick) {
          onClick();
        }

        if (_this3.animationFrame) {
          cancelAnimationFrame(_this3.animationFrame);
        }

        if (!hasSubNavItems || !navigationBarCollapsed().matches) {
          _this3.animationFrame = requestAnimationFrame(function () {
            return _this3.setState({
              expanded: false
            });
          });
        }
      };
    }
  }]);

  return Section;
}(React__default.Component);

var Navigation$1 =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Navigation, _React$Component);

  function Navigation() {
    _classCallCheck(this, Navigation);

    return _possibleConstructorReturn(this, _getPrototypeOf(Navigation).apply(this, arguments));
  }

  _createClass(Navigation, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          contextControl = _this$props.contextControl,
          location = _this$props.location,
          onDismiss = _this$props.onDismiss;
      var contextControlMarkup = contextControl && React__default.createElement("div", {
        className: styles$1d.ContextControl
      }, contextControl);
      var context = {
        location,
        onNavigationDismiss: onDismiss
      };
      return React__default.createElement(NavigationContext.Provider, {
        value: context
      }, React__default.createElement(WithinContentContext.Provider, {
        value: true
      }, React__default.createElement("nav", {
        className: styles$1d.Navigation
      }, contextControlMarkup, React__default.createElement(Scrollable, {
        className: styles$1d.PrimaryNavigation
      }, children))));
    }
  }]);

  return Navigation;
}(React__default.Component);
Navigation$1.Item = Item$7;
Navigation$1.Section = Section$5;

var EditableTarget;

(function (EditableTarget) {
  EditableTarget["Input"] = "INPUT";
  EditableTarget["Textarea"] = "TEXTAREA";
  EditableTarget["Select"] = "SELECT";
  EditableTarget["ContentEditable"] = "contenteditable";
})(EditableTarget || (EditableTarget = {}));

function isInputFocused() {
  if (document == null || document.activeElement == null) {
    return false;
  }

  var tagName = document.activeElement.tagName;
  return tagName === EditableTarget.Input || tagName === EditableTarget.Textarea || tagName === EditableTarget.Select || document.activeElement.hasAttribute(EditableTarget.ContentEditable);
}

var styles$1e = {
  "Tooltip": "Polaris-Tooltip",
  "measuring": "Polaris-Tooltip--measuring",
  "positionedAbove": "Polaris-Tooltip--positionedAbove",
  "light": "Polaris-Tooltip--light",
  "Wrapper": "Polaris-Tooltip__Wrapper",
  "Content": "Polaris-Tooltip__Content",
  "Label": "Polaris-Tooltip__Label"
};

var TooltipOverlay =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TooltipOverlay, _React$PureComponent);

  function TooltipOverlay() {
    var _this;

    _classCallCheck(this, TooltipOverlay);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TooltipOverlay).apply(this, arguments));

    _this.renderOverlay = function () {
      var _this$props = _this.props,
          active = _this$props.active,
          activator = _this$props.activator,
          _this$props$preferred = _this$props.preferredPosition,
          preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred;
      return React__default.createElement(PositionedOverlay, {
        active: active,
        activator: activator,
        preferredPosition: preferredPosition,
        render: _this.renderTooltip
      });
    };

    _this.renderTooltip = function (overlayDetails) {
      var measuring = overlayDetails.measuring,
          desiredHeight = overlayDetails.desiredHeight,
          positioning = overlayDetails.positioning;
      var _this$props2 = _this.props,
          id = _this$props2.id,
          children = _this$props2.children,
          light = _this$props2.light;
      var containerClassName = classNames(styles$1e.Tooltip, light && styles$1e.light, measuring && styles$1e.measuring, positioning === 'above' && styles$1e.positionedAbove);
      var contentStyles = measuring ? undefined : {
        minHeight: desiredHeight
      };
      return React__default.createElement("div", Object.assign({
        className: containerClassName
      }, layer.props), React__default.createElement("div", {
        className: styles$1e.Wrapper
      }, React__default.createElement("div", {
        id: id,
        role: "tooltip",
        className: styles$1e.Content,
        style: contentStyles
      }, children)));
    };

    return _this;
  }

  _createClass(TooltipOverlay, [{
    key: "render",
    value: function render() {
      var markup = this.props.active ? this.renderOverlay() : null;
      return markup;
    }
  }]);

  return TooltipOverlay;
}(React__default.PureComponent);

var getUniqueID$2 = createUniqueIDFactory('TooltipContent');
var Tooltip =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Tooltip, _React$PureComponent);

  function Tooltip() {
    var _this;

    _classCallCheck(this, Tooltip);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Tooltip).apply(this, arguments));
    _this.state = {
      active: Boolean(_this.props.active),
      activatorNode: null
    };
    _this.id = getUniqueID$2();
    _this.activatorContainer = null;
    _this.mouseEntered = false;

    _this.setActivator = function (node) {
      if (node == null) {
        _this.activatorContainer = null;

        _this.setState({
          activatorNode: null
        });

        return;
      }

      _this.setState({
        activatorNode: node.firstElementChild
      });

      _this.activatorContainer = node;
    };

    _this.handleFocus = function () {
      _this.setState({
        active: true
      });
    };

    _this.handleBlur = function () {
      _this.setState({
        active: false
      });
    };

    _this.handleMouseEnter = function () {
      _this.mouseEntered = true;

      _this.setState({
        active: true
      });
    };

    _this.handleMouseLeave = function () {
      _this.mouseEntered = false;

      _this.setState({
        active: false
      });
    }; // https://github.com/facebook/react/issues/10109
    // Mouseenter event not triggered when cursor moves from disabled button


    _this.handleMouseEnterFix = function () {
      !_this.mouseEntered && _this.handleMouseEnter();
    };

    return _this;
  }

  _createClass(Tooltip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setAccessibilityAttributes();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.setAccessibilityAttributes();
    }
  }, {
    key: "render",
    value: function render() {
      var id = this.id;
      var _this$props = this.props,
          children = _this$props.children,
          content = _this$props.content,
          light = _this$props.light,
          _this$props$preferred = _this$props.preferredPosition,
          preferredPosition = _this$props$preferred === void 0 ? 'below' : _this$props$preferred,
          _this$props$activator = _this$props.activatorWrapper,
          WrapperComponent = _this$props$activator === void 0 ? 'span' : _this$props$activator;
      var _this$state = this.state,
          active = _this$state.active,
          activatorNode = _this$state.activatorNode;
      var portal = activatorNode ? React__default.createElement(Portal, {
        idPrefix: "tooltip"
      }, React__default.createElement(TooltipOverlay, {
        id: id,
        preferredPosition: preferredPosition,
        activator: activatorNode,
        active: active,
        onClose: noop$9,
        light: light
      }, React__default.createElement("div", {
        className: styles$1e.Label
      }, content))) : null;
      return React__default.createElement(WrapperComponent, {
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onMouseLeave: this.handleMouseLeave,
        onMouseOver: this.handleMouseEnterFix,
        ref: this.setActivator
      }, children, portal);
    }
  }, {
    key: "setAccessibilityAttributes",
    value: function setAccessibilityAttributes() {
      var activatorContainer = this.activatorContainer,
          id = this.id;

      if (activatorContainer == null) {
        return;
      }

      var firstFocusable = findFirstFocusableNode(activatorContainer);
      var accessibilityNode = firstFocusable || activatorContainer;
      accessibilityNode.tabIndex = 0;
      accessibilityNode.setAttribute('aria-describedby', id);
    }
  }]);

  return Tooltip;
}(React__default.PureComponent);

function noop$9() {}

var styles$1f = {
  "Pagination": "Polaris-Pagination",
  "plain": "Polaris-Pagination--plain",
  "Button": "Polaris-Pagination__Button",
  "PreviousButton": "Polaris-Pagination__PreviousButton",
  "NextButton": "Polaris-Pagination__NextButton",
  "Label": "Polaris-Pagination__Label"
};

function Pagination(_ref) {
  var hasNext = _ref.hasNext,
      hasPrevious = _ref.hasPrevious,
      nextURL = _ref.nextURL,
      previousURL = _ref.previousURL,
      onNext = _ref.onNext,
      onPrevious = _ref.onPrevious,
      nextTooltip = _ref.nextTooltip,
      previousTooltip = _ref.previousTooltip,
      nextKeys = _ref.nextKeys,
      previousKeys = _ref.previousKeys,
      plain = _ref.plain,
      accessibilityLabel = _ref.accessibilityLabel,
      label = _ref.label;
  var i18n = useI18n();
  var node = React__default.createRef();
  var navLabel = accessibilityLabel || i18n.translate('Polaris.Pagination.pagination');
  var className = classNames(styles$1f.Pagination, plain && styles$1f.plain);
  var previousClassName = classNames(styles$1f.Button, !label && styles$1f.PreviousButton);
  var nextClassName = classNames(styles$1f.Button, !label && styles$1f.NextButton);
  var previousButton = previousURL ? React__default.createElement(UnstyledLink, {
    className: previousClassName,
    url: previousURL,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": i18n.translate('Polaris.Pagination.previous'),
    id: "previousURL"
  }, React__default.createElement(Icon, {
    source: ArrowLeftMinor
  })) : React__default.createElement("button", {
    onClick: onPrevious,
    type: "button",
    onMouseUp: handleMouseUpByBlurring,
    className: previousClassName,
    "aria-label": i18n.translate('Polaris.Pagination.previous'),
    disabled: !hasPrevious
  }, React__default.createElement(Icon, {
    source: ArrowLeftMinor
  }));
  var nextButton = nextURL ? React__default.createElement(UnstyledLink, {
    className: nextClassName,
    url: nextURL,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": i18n.translate('Polaris.Pagination.next'),
    id: "nextURL"
  }, React__default.createElement(Icon, {
    source: ArrowRightMinor
  })) : React__default.createElement("button", {
    onClick: onNext,
    type: "button",
    onMouseUp: handleMouseUpByBlurring,
    className: nextClassName,
    "aria-label": i18n.translate('Polaris.Pagination.next'),
    disabled: !hasNext
  }, React__default.createElement(Icon, {
    source: ArrowRightMinor
  }));
  var constructedPrevious = previousTooltip && hasPrevious ? React__default.createElement(Tooltip, {
    content: previousTooltip
  }, previousButton) : previousButton;
  var constructedNext = nextTooltip && hasNext ? React__default.createElement(Tooltip, {
    content: nextTooltip
  }, nextButton) : nextButton;
  var previousButtonEvents = previousKeys && (previousURL || onPrevious) && hasPrevious && previousKeys.map(function (key) {
    return React__default.createElement(KeypressListener, {
      key: key,
      keyCode: key,
      handler: previousURL ? handleCallback(clickPaginationLink('previousURL', node)) : handleCallback(onPrevious)
    });
  });
  var nextButtonEvents = nextKeys && (nextURL || onNext) && hasNext && nextKeys.map(function (key) {
    return React__default.createElement(KeypressListener, {
      key: key,
      keyCode: key,
      handler: nextURL ? handleCallback(clickPaginationLink('nextURL', node)) : handleCallback(onNext)
    });
  });
  var labelTextMarkup = hasNext && hasPrevious ? React__default.createElement(TextStyle, null, label) : React__default.createElement(TextStyle, {
    variation: "subdued"
  }, label);
  var labelMarkup = label ? React__default.createElement("div", {
    className: styles$1f.Label,
    "aria-live": "polite"
  }, labelTextMarkup) : null;
  return React__default.createElement("nav", {
    className: className,
    "aria-label": navLabel,
    ref: node
  }, previousButtonEvents, constructedPrevious, labelMarkup, nextButtonEvents, constructedNext);
}

function clickPaginationLink(id, node) {
  return function () {
    if (node.current == null) {
      return;
    }

    var link = node.current.querySelector("#".concat(id));

    if (link) {
      link.click();
    }
  };
}

function handleCallback(fn) {
  return function () {
    if (isInputFocused()) {
      return;
    }

    fn();
  };
}

var styles$1g = {
  "Title": "Polaris-Header-Title",
  "SubTitle": "Polaris-Header-Title__SubTitle",
  "hasThumbnail": "Polaris-Header-Title--hasThumbnail",
  "TitleAndSubtitleWrapper": "Polaris-Header-Title__TitleAndSubtitleWrapper",
  "TitleWithMetadataWrapper": "Polaris-Header-Title__TitleWithMetadataWrapper",
  "TitleMetadata": "Polaris-Header-Title__TitleMetadata"
};

function Title(_ref) {
  var title = _ref.title,
      subtitle = _ref.subtitle,
      titleMetadata = _ref.titleMetadata,
      thumbnail = _ref.thumbnail;
  var titleMarkup = title ? createElement("div", {
    className: styles$1g.Title
  }, createElement(DisplayText, {
    size: "large",
    element: "h1"
  }, title)) : null;
  var titleMetadataMarkup = titleMetadata ? createElement("div", {
    className: styles$1g.TitleMetadata
  }, titleMetadata) : null;
  var wrappedTitleMarkup = titleMetadata ? createElement("div", {
    className: styles$1g.TitleWithMetadataWrapper
  }, titleMarkup, titleMetadataMarkup) : titleMarkup;
  var subtitleMarkup = subtitle ? createElement("div", {
    className: styles$1g.SubTitle
  }, createElement("p", null, subtitle)) : null;
  var thumbnailMarkup = thumbnail ? createElement("div", null, thumbnail) : null;
  var pageTitleClassName = thumbnail ? classNames(styles$1g.hasThumbnail) : undefined;
  return createElement("div", {
    className: pageTitleClassName
  }, thumbnailMarkup, createElement("div", {
    className: styles$1g.TitleAndSubtitleWrapper
  }, wrappedTitleMarkup, subtitleMarkup));
}

var styles$1h = {
  "Header": "Polaris-Page-Header",
  "separator": "Polaris-Page-Header--separator",
  "titleHidden": "Polaris-Page-Header--titleHidden",
  "Navigation": "Polaris-Page-Header__Navigation",
  "hasActionMenu": "Polaris-Page-Header--hasActionMenu",
  "mobileView": "Polaris-Page-Header--mobileView",
  "BreadcrumbWrapper": "Polaris-Page-Header__BreadcrumbWrapper",
  "PaginationWrapper": "Polaris-Page-Header__PaginationWrapper",
  "MainContent": "Polaris-Page-Header__MainContent",
  "TitleActionMenuWrapper": "Polaris-Page-Header__TitleActionMenuWrapper",
  "hasNavigation": "Polaris-Page-Header--hasNavigation",
  "PrimaryActionWrapper": "Polaris-Page-Header__PrimaryActionWrapper",
  "ActionMenuWrapper": "Polaris-Page-Header__ActionMenuWrapper"
};

function Header$2(_ref) {
  var title = _ref.title,
      subtitle = _ref.subtitle,
      titleMetadata = _ref.titleMetadata,
      thumbnail = _ref.thumbnail,
      _ref$titleHidden = _ref.titleHidden,
      titleHidden = _ref$titleHidden === void 0 ? false : _ref$titleHidden,
      separator = _ref.separator,
      primaryAction = _ref.primaryAction,
      pagination = _ref.pagination,
      _ref$breadcrumbs = _ref.breadcrumbs,
      breadcrumbs = _ref$breadcrumbs === void 0 ? [] : _ref$breadcrumbs,
      _ref$secondaryActions = _ref.secondaryActions,
      secondaryActions = _ref$secondaryActions === void 0 ? [] : _ref$secondaryActions,
      _ref$actionGroups = _ref.actionGroups,
      actionGroups = _ref$actionGroups === void 0 ? [] : _ref$actionGroups;

  var _useMediaQuery = useMediaQuery(),
      isNavigationCollapsed = _useMediaQuery.isNavigationCollapsed;

  var breadcrumbMarkup = breadcrumbs.length > 0 ? React__default.createElement("div", {
    className: styles$1h.BreadcrumbWrapper
  }, React__default.createElement(Breadcrumbs, {
    breadcrumbs: breadcrumbs
  })) : null;
  var paginationMarkup = pagination && !isNavigationCollapsed ? React__default.createElement("div", {
    className: styles$1h.PaginationWrapper
  }, React__default.createElement(Pagination, Object.assign({}, pagination, {
    plain: true
  }))) : null;
  var navigationMarkup = breadcrumbMarkup || paginationMarkup ? React__default.createElement("div", {
    className: styles$1h.Navigation
  }, breadcrumbMarkup, paginationMarkup) : null;
  var pageTitleMarkup = React__default.createElement(Title, {
    title: title,
    subtitle: subtitle,
    titleMetadata: titleMetadata,
    thumbnail: thumbnail
  });
  var primary = primaryAction && (primaryAction.primary === undefined ? true : primaryAction.primary);
  var primaryActionMarkup = primaryAction ? React__default.createElement("div", {
    className: styles$1h.PrimaryActionWrapper
  }, buttonsFrom(primaryAction, {
    primary
  })) : null;
  var actionMenuMarkup = secondaryActions.length > 0 || hasGroupsWithActions(actionGroups) ? React__default.createElement("div", {
    className: styles$1h.ActionMenuWrapper
  }, React__default.createElement(ActionMenu, {
    actions: secondaryActions,
    groups: actionGroups,
    rollup: isNavigationCollapsed
  })) : null;
  var headerClassNames = classNames(styles$1h.Header, titleHidden && styles$1h.titleHidden, separator && styles$1h.separator, navigationMarkup && styles$1h.hasNavigation, actionMenuMarkup && styles$1h.hasActionMenu, isNavigationCollapsed && styles$1h.mobileView);
  return React__default.createElement("div", {
    className: headerClassNames
  }, navigationMarkup, React__default.createElement("div", {
    className: styles$1h.MainContent
  }, React__default.createElement("div", {
    className: styles$1h.TitleActionMenuWrapper
  }, pageTitleMarkup, actionMenuMarkup), primaryActionMarkup));
}

var styles$1i = {
  "Page": "Polaris-Page",
  "fullWidth": "Polaris-Page--fullWidth",
  "narrowWidth": "Polaris-Page--narrowWidth",
  "Content": "Polaris-Page__Content"
};

var APP_BRIDGE_PROPS$1 = ['title', 'breadcrumbs', 'secondaryActions', 'actionGroups', 'primaryAction'];

var Page =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Page, _React$PureComponent);

  function Page() {
    _classCallCheck(this, Page);

    return _possibleConstructorReturn(this, _getPrototypeOf(Page).apply(this, arguments));
  }

  _createClass(Page, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.delegateToAppbridge() === false || !this.props.polaris.appBridge) {
        return;
      }

      var transformedProps = this.transformProps();
      if (!transformedProps) return; // eslint-disable-next-line no-console

      console.warn('Deprecation: Using `Page` to render an embedded app title bar is deprecated and will be removed in v5.0. Use `TitleBar` from `@shopify/app-bridge-react` instead: https://help.shopify.com/en/api/embedded-apps/app-bridge/react-components/titlebar');
      this.titlebar = TitleBar.create(this.props.polaris.appBridge, transformedProps);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.titlebar == null || this.delegateToAppbridge() === false) {
        return;
      }

      var prevAppBridgeProps = pick(prevProps, APP_BRIDGE_PROPS$1);
      var currentAppBridgeProps = pick(this.props, APP_BRIDGE_PROPS$1);

      if (!isEqual(prevAppBridgeProps, currentAppBridgeProps)) {
        var transformedProps = this.transformProps();
        if (!transformedProps) return;
        this.titlebar.unsubscribe();
        this.titlebar.set(transformedProps);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.titlebar == null || this.delegateToAppbridge() === false) {
        return;
      }

      this.titlebar.unsubscribe();
    }
  }, {
    key: "render",
    value: function render() {
      var _a = this.props,
          children = _a.children,
          fullWidth = _a.fullWidth,
          narrowWidth = _a.narrowWidth,
          singleColumn = _a.singleColumn,
          rest = __rest(_a, ["children", "fullWidth", "narrowWidth", "singleColumn"]);

      if (singleColumn) {
        // eslint-disable-next-line no-console
        console.warn('Deprecation: The singleColumn prop has been renamed to narrowWidth to better represents its use and will be removed in v5.0.');
      }

      var className = classNames(styles$1i.Page, fullWidth && styles$1i.fullWidth, (narrowWidth || singleColumn) && styles$1i.narrowWidth);
      var headerMarkup = this.delegateToAppbridge() || this.hasHeaderContent() === false ? null : React__default.createElement(Header$2, rest);
      return React__default.createElement("div", {
        className: className
      }, headerMarkup, React__default.createElement("div", {
        className: styles$1i.Content
      }, children));
    }
  }, {
    key: "delegateToAppbridge",
    value: function delegateToAppbridge() {
      var _this$props = this.props,
          appBridge = _this$props.polaris.appBridge,
          _this$props$forceRend = _this$props.forceRender,
          forceRender = _this$props$forceRend === void 0 ? false : _this$props$forceRend;
      return appBridge != null && forceRender === false;
    }
  }, {
    key: "hasHeaderContent",
    value: function hasHeaderContent() {
      var _this$props2 = this.props,
          title = _this$props2.title,
          primaryAction = _this$props2.primaryAction,
          secondaryActions = _this$props2.secondaryActions,
          actionGroups = _this$props2.actionGroups,
          breadcrumbs = _this$props2.breadcrumbs;
      return title != null && title !== '' || primaryAction != null || secondaryActions != null && secondaryActions.length > 0 || actionGroups != null && actionGroups.length > 0 || breadcrumbs != null && breadcrumbs.length > 0;
    }
  }, {
    key: "transformProps",
    value: function transformProps() {
      var appBridge = this.props.polaris.appBridge;
      if (!appBridge) return;
      var _this$props3 = this.props,
          title = _this$props3.title,
          primaryAction = _this$props3.primaryAction,
          secondaryActions = _this$props3.secondaryActions,
          actionGroups = _this$props3.actionGroups;
      return {
        title,
        buttons: transformActions(appBridge, {
          primaryAction,
          secondaryActions,
          actionGroups
        }),
        breadcrumbs: this.transformBreadcrumbs()
      };
    }
  }, {
    key: "transformBreadcrumbs",
    value: function transformBreadcrumbs() {
      var appBridge = this.props.polaris.appBridge;
      if (!appBridge) return;
      var breadcrumbs = this.props.breadcrumbs;

      if (breadcrumbs != null && breadcrumbs.length > 0) {
        var breadcrumb = breadcrumbs[breadcrumbs.length - 1];
        var button = Button$1.create(appBridge, {
          label: breadcrumb.content || ''
        });
        var callback = !('url' in breadcrumb) ? breadcrumb.onAction : generateRedirect(appBridge, breadcrumb.url, breadcrumb.target);

        if (callback != null) {
          button.subscribe(Button$1.Action.CLICK, callback);
        }

        return button;
      } else {
        return undefined;
      }
    }
  }]);

  return Page;
}(React__default.PureComponent); // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var Page$1 = withAppProvider()(Page);

var styles$1j = {
  "PageActions": "Polaris-PageActions"
};

function PageActions(_ref) {
  var primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions;
  var primaryActionMarkup = primaryAction ? buttonsFrom(primaryAction, {
    primary: true
  }) : null;
  var secondaryActionsMarkup = secondaryActions ? React__default.createElement(ButtonGroup, null, buttonsFrom(secondaryActions)) : null;
  var distribution = secondaryActionsMarkup ? 'equalSpacing' : 'trailing';
  return React__default.createElement("div", {
    className: styles$1j.PageActions
  }, React__default.createElement(Stack, {
    distribution: distribution,
    spacing: "tight"
  }, secondaryActionsMarkup, primaryActionMarkup));
}

var defaultMediaQuery = {
  isNavigationCollapsed: false
};
function PolarisTestProvider(_ref) {
  var strict = _ref.strict,
      children = _ref.children,
      i18n = _ref.i18n,
      appBridge = _ref.appBridge,
      link = _ref.link,
      _ref$theme = _ref.theme,
      theme = _ref$theme === void 0 ? {} : _ref$theme,
      mediaQuery = _ref.mediaQuery,
      _ref$features = _ref.features,
      features = _ref$features === void 0 ? {} : _ref$features,
      frame = _ref.frame;
  var Wrapper = strict ? React__default.StrictMode : React__default.Fragment;
  var intl = new I18n(i18n || {});
  var scrollLockManager = new ScrollLockManager();
  var stickyManager = new StickyManager();
  var uniqueIdFactory = new UniqueIdFactory(globalIdGeneratorFactory); // This typing is odd, but as appBridge is deprecated and going away in v5
  // I'm not that worried about it

  var appBridgeApp = appBridge;
  var _features$unstableGlo = features.unstableGlobalTheming,
      unstableGlobalTheming = _features$unstableGlo === void 0 ? false : _features$unstableGlo;
  var customProperties = unstableGlobalTheming ? buildCustomProperties(Object.assign(Object.assign({}, theme), {
    colorScheme: DefaultColorScheme
  }), unstableGlobalTheming) : undefined;
  var mergedTheme = buildThemeContext(theme, customProperties);
  var mergedFrame = createFrameContext(frame);
  var mergedMediaQuery = merge(defaultMediaQuery, mediaQuery);
  return React__default.createElement(Wrapper, null, React__default.createElement(FeaturesContext.Provider, {
    value: features
  }, React__default.createElement(I18nContext.Provider, {
    value: intl
  }, React__default.createElement(ScrollLockManagerContext.Provider, {
    value: scrollLockManager
  }, React__default.createElement(StickyManagerContext.Provider, {
    value: stickyManager
  }, React__default.createElement(UniqueIdFactoryContext.Provider, {
    value: uniqueIdFactory
  }, React__default.createElement(AppBridgeContext.Provider, {
    value: appBridgeApp
  }, React__default.createElement(LinkContext.Provider, {
    value: link
  }, React__default.createElement(ThemeContext.Provider, {
    value: mergedTheme
  }, React__default.createElement(MediaQueryContext.Provider, {
    value: mergedMediaQuery
  }, React__default.createElement(FrameContext.Provider, {
    value: mergedFrame
  }, children)))))))))));
}

function noop$a() {}

function createFrameContext() {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref2$showToast = _ref2.showToast,
      showToast = _ref2$showToast === void 0 ? noop$a : _ref2$showToast,
      _ref2$hideToast = _ref2.hideToast,
      hideToast = _ref2$hideToast === void 0 ? noop$a : _ref2$hideToast,
      _ref2$setContextualSa = _ref2.setContextualSaveBar,
      setContextualSaveBar = _ref2$setContextualSa === void 0 ? noop$a : _ref2$setContextualSa,
      _ref2$removeContextua = _ref2.removeContextualSaveBar,
      removeContextualSaveBar = _ref2$removeContextua === void 0 ? noop$a : _ref2$removeContextua,
      _ref2$startLoading = _ref2.startLoading,
      startLoading = _ref2$startLoading === void 0 ? noop$a : _ref2$startLoading,
      _ref2$stopLoading = _ref2.stopLoading,
      stopLoading = _ref2$stopLoading === void 0 ? noop$a : _ref2$stopLoading;

  return {
    showToast,
    hideToast,
    setContextualSaveBar,
    removeContextualSaveBar,
    startLoading,
    stopLoading
  };
}

var styles$1k = {
  "ProgressBar": "Polaris-ProgressBar",
  "sizeSmall": "Polaris-ProgressBar--sizeSmall",
  "sizeMedium": "Polaris-ProgressBar--sizeMedium",
  "sizeLarge": "Polaris-ProgressBar--sizeLarge",
  "Indicator": "Polaris-ProgressBar__Indicator",
  "fillup": "Polaris-ProgressBar--fillup",
  "Progress": "Polaris-ProgressBar__Progress",
  "Label": "Polaris-ProgressBar__Label"
};

function ProgressBar(_ref) {
  var _ref$progress = _ref.progress,
      progress = _ref$progress === void 0 ? 0 : _ref$progress,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var i18n = useI18n();
  var className = classNames(styles$1k.ProgressBar, size && styles$1k[variationName('size', size)]);
  var warningMessage = i18n.translate(progress < 0 ? 'Polaris.ProgressBar.negativeWarningMessage' : 'Polaris.ProgressBar.exceedWarningMessage', {
    progress
  });
  var parsedProgress = parseProgress(progress, warningMessage);
  return React__default.createElement("div", {
    className: className
  }, React__default.createElement("progress", {
    className: styles$1k.Progress,
    value: parsedProgress,
    max: "100"
  }), React__default.createElement("div", {
    className: styles$1k.Indicator,
    style: {
      width: "".concat(parsedProgress, "%")
    }
  }, React__default.createElement("span", {
    className: styles$1k.Label
  }, parsedProgress, "%")));
}

function parseProgress(progress, warningMessage) {
  var progressWidth;

  if (progress < 0) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(warningMessage);
    }

    progressWidth = 0;
  } else if (progress > 100) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(warningMessage);
    }

    progressWidth = 100;
  } else {
    progressWidth = progress;
  }

  return progressWidth;
}

function invertNumber(number) {
  if (Math.sign(number) === 1) {
    return -Math.abs(number);
  } else if (Math.sign(number) === -1) {
    return Math.abs(number);
  } else {
    return 0;
  }
}

var CSS_VAR_PREFIX = '--Polaris-RangeSlider-';
var RangeSliderDefault;

(function (RangeSliderDefault) {
  RangeSliderDefault[RangeSliderDefault["Min"] = 0] = "Min";
  RangeSliderDefault[RangeSliderDefault["Max"] = 100] = "Max";
  RangeSliderDefault[RangeSliderDefault["Step"] = 1] = "Step";
})(RangeSliderDefault || (RangeSliderDefault = {}));

var styles$1l = {
  "Wrapper": "Polaris-RangeSlider-DualThumb__Wrapper",
  "TrackWrapper": "Polaris-RangeSlider-DualThumb__TrackWrapper",
  "disabled": "Polaris-RangeSlider-DualThumb--disabled",
  "Track": "Polaris-RangeSlider-DualThumb__Track",
  "error": "Polaris-RangeSlider-DualThumb--error",
  "Thumbs": "Polaris-RangeSlider-DualThumb__Thumbs",
  "Prefix": "Polaris-RangeSlider-DualThumb__Prefix",
  "Suffix": "Polaris-RangeSlider-DualThumb__Suffix",
  "Output": "Polaris-RangeSlider-DualThumb__Output",
  "OutputBubble": "Polaris-RangeSlider-DualThumb__OutputBubble",
  "OutputText": "Polaris-RangeSlider-DualThumb__OutputText"
};

var Control;

(function (Control) {
  Control[Control["Lower"] = 0] = "Lower";
  Control[Control["Upper"] = 1] = "Upper";
})(Control || (Control = {}));

var THUMB_SIZE = 24;
var DualThumb =
/*#__PURE__*/
function (_React$Component) {
  _inherits(DualThumb, _React$Component);

  function DualThumb() {
    var _this;

    _classCallCheck(this, DualThumb);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DualThumb).apply(this, arguments));
    _this.state = {
      value: sanitizeValue(_this.props.value, _this.props.min, _this.props.max, _this.props.step),
      trackWidth: 0,
      trackLeft: 0
    };
    _this.track = React__default.createRef();
    _this.trackWrapper = React__default.createRef();
    _this.thumbLower = React__default.createRef();
    _this.thumbUpper = React__default.createRef();
    _this.setTrackPosition = debounce(function () {
      if (_this.track.current) {
        var _this$track$current$g = _this.track.current.getBoundingClientRect(),
            width = _this$track$current$g.width,
            left = _this$track$current$g.left;

        var adjustedTrackWidth = width - THUMB_SIZE;
        var adjustedTrackLeft = left + THUMB_SIZE / 2;

        _this.setState({
          trackWidth: adjustedTrackWidth,
          trackLeft: adjustedTrackLeft
        });
      }
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });

    _this.handleMouseDownThumbLower = function (event) {
      if (event.button !== 0 || _this.props.disabled) return;
      registerMouseMoveHandler(_this.handleMouseMoveThumbLower);
      event.stopPropagation();
    };

    _this.handleMouseMoveThumbLower = function (event) {
      var valueUpper = _this.state.value[1];

      _this.setValue([_this.actualXPosition(event.clientX), valueUpper], Control.Upper);
    };

    _this.handleTouchStartThumbLower = function (event) {
      if (_this.props.disabled) return;
      registerTouchMoveHandler(_this.handleTouchMoveThumbLower);
      event.stopPropagation();
    };

    _this.handleTouchMoveThumbLower = function (event) {
      event.preventDefault();
      var valueUpper = _this.state.value[1];

      _this.setValue([_this.actualXPosition(event.touches[0].clientX), valueUpper], Control.Upper);
    };

    _this.handleMouseDownThumbUpper = function (event) {
      if (event.button !== 0 || _this.props.disabled) return;
      registerMouseMoveHandler(_this.handleMouseMoveThumbUpper);
      event.stopPropagation();
    };

    _this.handleMouseMoveThumbUpper = function (event) {
      var valueLower = _this.state.value[0];

      _this.setValue([valueLower, _this.actualXPosition(event.clientX)], Control.Lower);
    };

    _this.handleTouchStartThumbUpper = function (event) {
      if (_this.props.disabled) return;
      registerTouchMoveHandler(_this.handleTouchMoveThumbUpper);
      event.stopPropagation();
    };

    _this.handleTouchMoveThumbUpper = function (event) {
      event.preventDefault();
      var valueLower = _this.state.value[0];

      _this.setValue([valueLower, _this.actualXPosition(event.touches[0].clientX)], Control.Lower);
    };

    _this.handleKeypressLower = function (event) {
      if (_this.props.disabled) return;

      var _assertThisInitialize = _assertThisInitialized(_this),
          incrementValueLower = _assertThisInitialize.incrementValueLower,
          decrementValueLower = _assertThisInitialize.decrementValueLower;

      var handlerMap = {
        [Key.UpArrow]: incrementValueLower,
        [Key.RightArrow]: incrementValueLower,
        [Key.DownArrow]: decrementValueLower,
        [Key.LeftArrow]: decrementValueLower
      };
      var handler = handlerMap[event.keyCode];

      if (handler != null) {
        event.preventDefault();
        event.stopPropagation();
        handler();
      }
    };

    _this.handleKeypressUpper = function (event) {
      if (_this.props.disabled) return;

      var _assertThisInitialize2 = _assertThisInitialized(_this),
          incrementValueUpper = _assertThisInitialize2.incrementValueUpper,
          decrementValueUpper = _assertThisInitialize2.decrementValueUpper;

      var handlerMap = {
        [Key.UpArrow]: incrementValueUpper,
        [Key.RightArrow]: incrementValueUpper,
        [Key.DownArrow]: decrementValueUpper,
        [Key.LeftArrow]: decrementValueUpper
      };
      var handler = handlerMap[event.keyCode];

      if (handler != null) {
        event.preventDefault();
        event.stopPropagation();
        handler();
      }
    };

    _this.incrementValueLower = function () {
      _this.setValue([_this.state.value[0] + _this.props.step, _this.state.value[1]], Control.Upper);
    };

    _this.decrementValueLower = function () {
      _this.setValue([_this.state.value[0] - _this.props.step, _this.state.value[1]], Control.Upper);
    };

    _this.incrementValueUpper = function () {
      _this.setValue([_this.state.value[0], _this.state.value[1] + _this.props.step], Control.Lower);
    };

    _this.decrementValueUpper = function () {
      _this.setValue([_this.state.value[0], _this.state.value[1] - _this.props.step], Control.Lower);
    };

    _this.dispatchValue = function () {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          id = _this$props.id;
      var value = _this.state.value;
      onChange(value, id);
    };

    _this.setValue = function (dirtyValue, control) {
      var _assertThisInitialize3 = _assertThisInitialized(_this),
          _assertThisInitialize4 = _assertThisInitialize3.props,
          min = _assertThisInitialize4.min,
          max = _assertThisInitialize4.max,
          step = _assertThisInitialize4.step,
          value = _assertThisInitialize3.state.value;

      var sanitizedValue = sanitizeValue(dirtyValue, min, max, step, control);

      if (isEqual(sanitizedValue, value) === false) {
        _this.setState({
          value: sanitizedValue
        }, _this.dispatchValue);
      }
    };

    _this.handleMouseDownTrack = function (event) {
      if (event.button !== 0 || _this.props.disabled) return;
      event.preventDefault();

      var clickXPosition = _this.actualXPosition(event.clientX);

      var value = _this.state.value;
      var distanceFromLowerThumb = Math.abs(value[0] - clickXPosition);
      var distanceFromUpperThumb = Math.abs(value[1] - clickXPosition);

      if (distanceFromLowerThumb <= distanceFromUpperThumb) {
        _this.setValue([clickXPosition, value[1]], Control.Upper);

        registerMouseMoveHandler(_this.handleMouseMoveThumbLower);

        if (_this.thumbLower.current != null) {
          _this.thumbLower.current.focus();
        }
      } else {
        _this.setValue([value[0], clickXPosition], Control.Lower);

        registerMouseMoveHandler(_this.handleMouseMoveThumbUpper);

        if (_this.thumbUpper.current != null) {
          _this.thumbUpper.current.focus();
        }
      }
    };

    _this.handleTouchStartTrack = function (event) {
      if (_this.props.disabled) return;
      event.preventDefault();

      var clickXPosition = _this.actualXPosition(event.touches[0].clientX);

      var value = _this.state.value;
      var distanceFromLowerThumb = Math.abs(value[0] - clickXPosition);
      var distanceFromUpperThumb = Math.abs(value[1] - clickXPosition);

      if (distanceFromLowerThumb <= distanceFromUpperThumb) {
        _this.setValue([clickXPosition, value[1]], Control.Upper);

        registerTouchMoveHandler(_this.handleTouchMoveThumbLower);

        if (_this.thumbLower.current != null) {
          _this.thumbLower.current.focus();
        }
      } else {
        _this.setValue([value[0], clickXPosition], Control.Lower);

        registerTouchMoveHandler(_this.handleTouchMoveThumbUpper);

        if (_this.thumbUpper.current != null) {
          _this.thumbUpper.current.focus();
        }
      }
    };

    _this.actualXPosition = function (dirtyXPosition) {
      if (_this.track.current) {
        var _this$props2 = _this.props,
            min = _this$props2.min,
            max = _this$props2.max;
        var _this$state = _this.state,
            trackLeft = _this$state.trackLeft,
            trackWidth = _this$state.trackWidth;
        var relativeX = dirtyXPosition - trackLeft;
        var percentageOfTrack = relativeX / trackWidth;
        return percentageOfTrack * (max - min);
      } else {
        return 0;
      }
    };

    return _this;
  }

  _createClass(DualThumb, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setTrackPosition();

      if (this.trackWrapper.current != null) {
        addEventListener(this.trackWrapper.current, 'touchstart', this.handleTouchStartTrack, {
          passive: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.trackWrapper.current != null) {
        removeEventListener(this.trackWrapper.current, 'touchstart', this.handleTouchStartTrack);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          id = _this$props3.id,
          min = _this$props3.min,
          max = _this$props3.max,
          prefix = _this$props3.prefix,
          suffix = _this$props3.suffix,
          disabled = _this$props3.disabled,
          output = _this$props3.output,
          error = _this$props3.error,
          onFocus = _this$props3.onFocus,
          onBlur = _this$props3.onBlur,
          label = _this$props3.label,
          labelAction = _this$props3.labelAction,
          labelHidden = _this$props3.labelHidden,
          helpText = _this$props3.helpText;
      var value = this.state.value;
      var idLower = id;
      var idUpper = "".concat(id, "Upper");
      var describedBy = [];

      if (error) {
        describedBy.push("".concat(id, "Error"));
      }

      var ariaDescribedBy = describedBy.length ? describedBy.join(' ') : undefined;
      var trackWrapperClassName = classNames(styles$1l.TrackWrapper, error && styles$1l.error, disabled && styles$1l.disabled);
      var thumbLowerClassName = classNames(styles$1l.Thumbs, styles$1l.ThumbLower, disabled && styles$1l.disabled);
      var thumbUpperClassName = classNames(styles$1l.Thumbs, styles$1l.ThumbUpper, disabled && styles$1l.disabled);
      var trackWidth = this.state.trackWidth;
      var range = max - min;
      var leftPositionThumbLower = value[0] / range * trackWidth;
      var leftPositionThumbUpper = value[1] / range * trackWidth;
      var outputLowerClassName = classNames(styles$1l.Output, styles$1l.OutputLower);
      var outputMarkupLower = !disabled && output ? React__default.createElement("output", {
        htmlFor: idLower,
        className: outputLowerClassName,
        style: {
          left: "".concat(leftPositionThumbLower, "px")
        }
      }, React__default.createElement("div", {
        className: styles$1l.OutputBubble
      }, React__default.createElement("span", {
        className: styles$1l.OutputText
      }, value[0]))) : null;
      var outputUpperClassName = classNames(styles$1l.Output, styles$1l.OutputUpper);
      var outputMarkupUpper = !disabled && output ? React__default.createElement("output", {
        htmlFor: idUpper,
        className: outputUpperClassName,
        style: {
          left: "".concat(leftPositionThumbUpper, "px")
        }
      }, React__default.createElement("div", {
        className: styles$1l.OutputBubble
      }, React__default.createElement("span", {
        className: styles$1l.OutputText
      }, value[1]))) : null;
      var cssVars = {
        ["".concat(CSS_VAR_PREFIX, "progress-lower")]: "".concat(leftPositionThumbLower, "px"),
        ["".concat(CSS_VAR_PREFIX, "progress-upper")]: "".concat(leftPositionThumbUpper, "px")
      };
      var prefixMarkup = prefix && React__default.createElement("div", {
        className: styles$1l.Prefix
      }, prefix);
      var suffixMarkup = suffix && React__default.createElement("div", {
        className: styles$1l.Suffix
      }, suffix);
      return React__default.createElement(React__default.Fragment, null, React__default.createElement(Labelled, {
        id: id,
        label: label,
        error: error,
        action: labelAction,
        labelHidden: labelHidden,
        helpText: helpText
      }, React__default.createElement("div", {
        className: styles$1l.Wrapper
      }, prefixMarkup, React__default.createElement("div", {
        className: trackWrapperClassName,
        onMouseDown: this.handleMouseDownTrack,
        ref: this.trackWrapper
      }, React__default.createElement("div", {
        className: styles$1l.Track,
        style: cssVars,
        ref: this.track
      }), React__default.createElement("button", {
        id: idLower,
        className: thumbLowerClassName,
        style: {
          left: "".concat(leftPositionThumbLower, "px")
        },
        role: "slider",
        "aria-disabled": disabled,
        "aria-valuemin": min,
        "aria-valuemax": max,
        "aria-valuenow": value[0],
        "aria-invalid": Boolean(error),
        "aria-describedby": ariaDescribedBy,
        "aria-labelledby": labelID(id),
        onFocus: onFocus,
        onBlur: onBlur,
        onKeyDown: this.handleKeypressLower,
        onMouseDown: this.handleMouseDownThumbLower,
        onTouchStart: this.handleTouchStartThumbLower,
        ref: this.thumbLower
      }), outputMarkupLower, React__default.createElement("button", {
        id: idUpper,
        className: thumbUpperClassName,
        style: {
          left: "".concat(leftPositionThumbUpper, "px")
        },
        role: "slider",
        "aria-disabled": disabled,
        "aria-valuemin": min,
        "aria-valuemax": max,
        "aria-valuenow": value[1],
        "aria-invalid": Boolean(error),
        "aria-describedby": ariaDescribedBy,
        "aria-labelledby": labelID(id),
        onFocus: onFocus,
        onBlur: onBlur,
        onKeyDown: this.handleKeypressUpper,
        onMouseDown: this.handleMouseDownThumbUpper,
        onTouchStart: this.handleTouchStartThumbUpper,
        ref: this.thumbUpper
      }), outputMarkupUpper), suffixMarkup)), React__default.createElement(EventListener, {
        event: "resize",
        handler: this.setTrackPosition
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      var min = props.min,
          step = props.step,
          max = props.max,
          value = props.value,
          onChange = props.onChange,
          id = props.id;
      var prevValue = state.prevValue;

      if (isEqual(prevValue, value)) {
        return null;
      }

      var sanitizedValue = sanitizeValue(value, min, max, step);

      if (!isEqual(value, sanitizedValue)) {
        onChange(sanitizedValue, id);
      }

      return {
        prevValue: value,
        value: sanitizedValue
      };
    }
  }]);

  return DualThumb;
}(React__default.Component);

function registerMouseMoveHandler(handler) {
  addEventListener(document, 'mousemove', handler);
  addEventListener(document, 'mouseup', function () {
    removeEventListener(document, 'mousemove', handler);
  }, {
    once: true
  });
}

function registerTouchMoveHandler(handler) {
  var removeHandler = function removeHandler() {
    removeEventListener(document, 'touchmove', handler);
    removeEventListener(document, 'touchend', removeHandler);
    removeEventListener(document, 'touchcancel', removeHandler);
  };

  addEventListener(document, 'touchmove', handler, {
    passive: false
  });
  addEventListener(document, 'touchend', removeHandler, {
    once: true
  });
  addEventListener(document, 'touchcancel', removeHandler, {
    once: true
  });
}

function sanitizeValue(value, min, max, step) {
  var control = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : Control.Upper;
  var upperValue = inBoundsUpper(roundedToStep(value[1]));
  var lowerValue = inBoundsLower(roundedToStep(value[0]));
  var maxLowerValue = upperValue - step;
  var minUpperValue = lowerValue + step;

  if (control === Control.Upper && lowerValue > maxLowerValue) {
    lowerValue = maxLowerValue;
  } else if (control === Control.Lower && upperValue < minUpperValue) {
    upperValue = minUpperValue;
  }

  return [lowerValue, upperValue];

  function inBoundsUpper(value) {
    var lowerMin = min + step;

    if (value < lowerMin) {
      return lowerMin;
    } else if (value > max) {
      return max;
    } else {
      return value;
    }
  }

  function inBoundsLower(value) {
    var upperMax = max - step;

    if (value < min) {
      return min;
    } else if (value > upperMax) {
      return upperMax;
    } else {
      return value;
    }
  }

  function roundedToStep(value) {
    return Math.round(value / step) * step;
  }
}

function clamp(number, min, max) {
  if (number < min) return min;
  if (number > max) return max;
  return number;
}

var styles$1m = {
  "SingleThumb": "Polaris-RangeSlider-SingleThumb",
  "disabled": "Polaris-RangeSlider-SingleThumb--disabled",
  "InputWrapper": "Polaris-RangeSlider-SingleThumb__InputWrapper",
  "Prefix": "Polaris-RangeSlider-SingleThumb__Prefix",
  "Suffix": "Polaris-RangeSlider-SingleThumb__Suffix",
  "Input": "Polaris-RangeSlider-SingleThumb__Input",
  "error": "Polaris-RangeSlider-SingleThumb--error",
  "RangeSlider": "Polaris-RangeSlider-SingleThumb__RangeSlider",
  "Output": "Polaris-RangeSlider-SingleThumb__Output",
  "OutputBubble": "Polaris-RangeSlider-SingleThumb__OutputBubble",
  "OutputText": "Polaris-RangeSlider-SingleThumb__OutputText"
};

function SingleThumb(props) {
  var id = props.id,
      error = props.error,
      helpText = props.helpText,
      value = props.value,
      min = props.min,
      max = props.max,
      disabled = props.disabled,
      output = props.output,
      prefix = props.prefix,
      suffix = props.suffix,
      label = props.label,
      labelAction = props.labelAction,
      labelHidden = props.labelHidden,
      step = props.step,
      onBlur = props.onBlur,
      onFocus = props.onFocus;
  var clampedValue = clamp(value, min, max);
  var describedBy = [];

  if (error) {
    describedBy.push("".concat(id, "Error"));
  }

  if (helpText) {
    describedBy.push(helpTextID(id));
  }

  var ariaDescribedBy = describedBy.length ? describedBy.join(' ') : undefined;
  var sliderProgress = (clampedValue - min) * 100 / (max - min);
  var outputFactor = invertNumber((sliderProgress - 50) / 100);
  var cssVars = {
    ["".concat(CSS_VAR_PREFIX, "min")]: min,
    ["".concat(CSS_VAR_PREFIX, "max")]: max,
    ["".concat(CSS_VAR_PREFIX, "current")]: clampedValue,
    ["".concat(CSS_VAR_PREFIX, "progress")]: "".concat(sliderProgress, "%"),
    ["".concat(CSS_VAR_PREFIX, "output-factor")]: "".concat(outputFactor)
  };
  var outputMarkup = !disabled && output && React__default.createElement("output", {
    htmlFor: id,
    className: styles$1m.Output
  }, React__default.createElement("div", {
    className: styles$1m.OutputBubble
  }, React__default.createElement("span", {
    className: styles$1m.OutputText
  }, clampedValue)));
  var prefixMarkup = prefix && React__default.createElement("div", {
    className: styles$1m.Prefix
  }, prefix);
  var suffixMarkup = suffix && React__default.createElement("div", {
    className: styles$1m.Suffix
  }, suffix);
  var className = classNames(styles$1m.SingleThumb, error && styles$1m.error, disabled && styles$1m.disabled);
  return React__default.createElement(Labelled, {
    id: id,
    label: label,
    error: error,
    action: labelAction,
    labelHidden: labelHidden,
    helpText: helpText
  }, React__default.createElement("div", {
    className: className,
    style: cssVars
  }, prefixMarkup, React__default.createElement("div", {
    className: styles$1m.InputWrapper
  }, React__default.createElement("input", {
    type: "range",
    className: styles$1m.Input,
    id: id,
    name: id,
    min: min,
    max: max,
    step: step,
    value: clampedValue,
    disabled: disabled,
    onChange: handleChange,
    onFocus: onFocus,
    onBlur: onBlur,
    "aria-valuemin": min,
    "aria-valuemax": max,
    "aria-valuenow": clampedValue,
    "aria-invalid": Boolean(error),
    "aria-describedby": ariaDescribedBy
  }), outputMarkup), suffixMarkup));

  function handleChange(event) {
    var onChange = props.onChange;
    onChange && onChange(parseFloat(event.currentTarget.value), id);
  }
}

function RangeSlider(_a) {
  var _a$min = _a.min,
      min = _a$min === void 0 ? RangeSliderDefault.Min : _a$min,
      _a$max = _a.max,
      max = _a$max === void 0 ? RangeSliderDefault.Max : _a$max,
      _a$step = _a.step,
      step = _a$step === void 0 ? RangeSliderDefault.Step : _a$step,
      value = _a.value,
      rest = __rest(_a, ["min", "max", "step", "value"]);

  var id = useUniqueId('RangeSlider');
  var sharedProps = Object.assign({
    id,
    min,
    max,
    step
  }, rest);
  return isDualThumb(value) ? React__default.createElement(DualThumb, Object.assign({
    value: value
  }, sharedProps)) : React__default.createElement(SingleThumb, Object.assign({
    value: value
  }, sharedProps));
}

function isDualThumb(value) {
  return Array.isArray(value);
}

var styles$1n = {
  "CheckboxWrapper": "Polaris-ResourceItem__CheckboxWrapper",
  "ResourceItem": "Polaris-ResourceItem",
  "persistActions": "Polaris-ResourceItem--persistActions",
  "Actions": "Polaris-ResourceItem__Actions",
  "selected": "Polaris-ResourceItem--selected",
  "focused": "Polaris-ResourceItem--focused",
  "focusedInner": "Polaris-ResourceItem--focusedInner",
  "Link": "Polaris-ResourceItem__Link",
  "Button": "Polaris-ResourceItem__Button",
  "Container": "Polaris-ResourceItem__Container",
  "Owned": "Polaris-ResourceItem__Owned",
  "Handle": "Polaris-ResourceItem__Handle",
  "selectMode": "Polaris-ResourceItem--selectMode",
  "selectable": "Polaris-ResourceItem--selectable",
  "Media": "Polaris-ResourceItem__Media",
  "Content": "Polaris-ResourceItem__Content",
  "Disclosure": "Polaris-ResourceItem__Disclosure"
};

var getUniqueCheckboxID = createUniqueIDFactory('ResourceListItemCheckbox');
var getUniqueOverlayID = createUniqueIDFactory('ResourceListItemOverlay');

var BaseResourceItem =
/*#__PURE__*/
function (_React$Component) {
  _inherits(BaseResourceItem, _React$Component);

  function BaseResourceItem() {
    var _this;

    _classCallCheck(this, BaseResourceItem);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BaseResourceItem).apply(this, arguments));
    _this.state = {
      actionsMenuVisible: false,
      focused: false,
      focusedInner: false,
      selected: isSelected(_this.props.id, _this.props.context.selectedItems)
    };
    _this.node = null;
    _this.checkboxId = getUniqueCheckboxID();
    _this.overlayId = getUniqueOverlayID();
    _this.buttonOverlay = React__default.createRef();

    _this.setNode = function (node) {
      _this.node = node;
    };

    _this.handleFocus = function (event) {
      if (event.target === _this.buttonOverlay.current || _this.node && event.target === _this.node.querySelector("#".concat(_this.overlayId))) {
        _this.setState({
          focused: true,
          focusedInner: false
        });
      } else if (_this.node && _this.node.contains(event.target)) {
        _this.setState({
          focused: true,
          focusedInner: true
        });
      }
    };

    _this.handleBlur = function (_ref) {
      var relatedTarget = _ref.relatedTarget;

      if (_this.node && relatedTarget instanceof Element && _this.node.contains(relatedTarget)) {
        return;
      }

      _this.setState({
        focused: false,
        focusedInner: false
      });
    };

    _this.handleLargerSelectionArea = function (event) {
      stopPropagation$1(event);

      _this.handleSelection(!_this.state.selected, event.nativeEvent.shiftKey);
    };

    _this.handleSelection = function (value, shiftKey) {
      var _this$props = _this.props,
          id = _this$props.id,
          sortOrder = _this$props.sortOrder,
          onSelectionChange = _this$props.context.onSelectionChange;

      if (id == null || onSelectionChange == null) {
        return;
      }

      _this.setState({
        focused: value,
        focusedInner: value
      });

      onSelectionChange(value, id, sortOrder, shiftKey);
    };

    _this.handleClick = function (event) {
      stopPropagation$1(event);
      var _this$props2 = _this.props,
          id = _this$props2.id,
          onClick = _this$props2.onClick,
          url = _this$props2.url,
          selectMode = _this$props2.context.selectMode;
      var _event$nativeEvent = event.nativeEvent,
          ctrlKey = _event$nativeEvent.ctrlKey,
          metaKey = _event$nativeEvent.metaKey;

      var anchor = _this.node && _this.node.querySelector('a');

      if (selectMode) {
        _this.handleLargerSelectionArea(event);

        return;
      }

      if (anchor === event.target) {
        return;
      }

      if (onClick) {
        onClick(id);
      }

      if (url && (ctrlKey || metaKey)) {
        window.open(url, '_blank');
        return;
      }

      if (url && anchor) {
        anchor.click();
      }
    }; // This fires onClick when there is a URL on the item


    _this.handleKeyUp = function (event) {
      var _this$props3 = _this.props,
          _this$props3$onClick = _this$props3.onClick,
          onClick = _this$props3$onClick === void 0 ? noop$b : _this$props3$onClick,
          selectMode = _this$props3.context.selectMode;
      var key = event.key;

      if (key === 'Enter' && _this.props.url && !selectMode) {
        onClick();
      }
    };

    _this.handleActionsClick = function () {
      _this.setState(function (_ref2) {
        var actionsMenuVisible = _ref2.actionsMenuVisible;
        return {
          actionsMenuVisible: !actionsMenuVisible
        };
      });
    };

    _this.handleCloseRequest = function () {
      _this.setState({
        actionsMenuVisible: false
      });
    };

    return _this;
  }

  _createClass(BaseResourceItem, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      var _a = nextProps.context,
          nextSelectedItems = _a.selectedItems,
          restNextContext = __rest(_a, ["selectedItems"]),
          restNextProps = __rest(nextProps, ["context"]);

      var _b = this.props,
          _c = _b.context,
          selectedItems = _c.selectedItems,
          restContext = __rest(_c, ["selectedItems"]),
          restProps = __rest(_b, ["context"]);

      var nextSelectMode = nextProps.context.selectMode;
      return !isEqual(this.state, nextState) || this.props.context.selectMode !== nextSelectMode || !nextProps.context.selectMode && (!isEqual(restProps, restNextProps) || !isEqual(restContext, restNextContext));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          children = _this$props4.children,
          url = _this$props4.url,
          external = _this$props4.external,
          media = _this$props4.media,
          shortcutActions = _this$props4.shortcutActions,
          ariaControls = _this$props4.ariaControls,
          ariaExpanded = _this$props4.ariaExpanded,
          _this$props4$persistA = _this$props4.persistActions,
          persistActions = _this$props4$persistA === void 0 ? false : _this$props4$persistA,
          accessibilityLabel = _this$props4.accessibilityLabel,
          name = _this$props4.name,
          _this$props4$context = _this$props4.context,
          selectable = _this$props4$context.selectable,
          selectMode = _this$props4$context.selectMode,
          loading = _this$props4$context.loading,
          resourceName = _this$props4$context.resourceName,
          i18n = _this$props4.i18n;
      var _this$state = this.state,
          actionsMenuVisible = _this$state.actionsMenuVisible,
          focused = _this$state.focused,
          focusedInner = _this$state.focusedInner,
          selected = _this$state.selected;
      var ownedMarkup = null;
      var handleMarkup = null;
      var mediaMarkup = media ? React__default.createElement("div", {
        className: styles$1n.Media
      }, media) : null;

      if (selectable) {
        var checkboxAccessibilityLabel = name || accessibilityLabel || i18n.translate('Polaris.Common.checkbox');
        handleMarkup = React__default.createElement("div", {
          className: styles$1n.Handle,
          onClick: this.handleLargerSelectionArea
        }, React__default.createElement("div", {
          onClick: stopPropagation$1,
          className: styles$1n.CheckboxWrapper
        }, React__default.createElement("div", {
          onChange: this.handleLargerSelectionArea
        }, React__default.createElement(Checkbox$1, {
          id: this.checkboxId,
          label: checkboxAccessibilityLabel,
          labelHidden: true,
          checked: selected,
          disabled: loading
        }))));
      }

      if (media || selectable) {
        ownedMarkup = React__default.createElement("div", {
          className: styles$1n.Owned
        }, handleMarkup, mediaMarkup);
      }

      var className = classNames(styles$1n.ResourceItem, focused && styles$1n.focused, selectable && styles$1n.selectable, selected && styles$1n.selected, selectMode && styles$1n.selectMode, persistActions && styles$1n.persistActions, focusedInner && styles$1n.focusedInner);
      var actionsMarkup = null;
      var disclosureMarkup = null;

      if (shortcutActions && !loading) {
        if (persistActions) {
          actionsMarkup = React__default.createElement("div", {
            className: styles$1n.Actions,
            onClick: stopPropagation$1
          }, React__default.createElement(ButtonGroup, null, buttonsFrom(shortcutActions, {
            plain: true
          })));
          var disclosureAccessibilityLabel = name ? i18n.translate('Polaris.ResourceList.Item.actionsDropdownLabel', {
            accessibilityLabel: name
          }) : i18n.translate('Polaris.ResourceList.Item.actionsDropdown');
          disclosureMarkup = React__default.createElement("div", {
            className: styles$1n.Disclosure,
            onClick: stopPropagation$1
          }, React__default.createElement(Popover, {
            activator: React__default.createElement(Button, {
              accessibilityLabel: disclosureAccessibilityLabel,
              onClick: this.handleActionsClick,
              plain: true,
              icon: HorizontalDotsMinor
            }),
            onClose: this.handleCloseRequest,
            active: actionsMenuVisible
          }, React__default.createElement(ActionList, {
            items: shortcutActions
          })));
        } else {
          actionsMarkup = React__default.createElement("div", {
            className: styles$1n.Actions,
            onClick: stopPropagation$1
          }, React__default.createElement(ButtonGroup, {
            segmented: true
          }, buttonsFrom(shortcutActions, {
            size: 'slim'
          })));
        }
      }

      var content = children ? React__default.createElement("div", {
        className: styles$1n.Content
      }, children) : null;
      var containerMarkup = React__default.createElement("div", {
        className: styles$1n.Container,
        id: this.props.id
      }, ownedMarkup, content, actionsMarkup, disclosureMarkup);
      var tabIndex = loading ? -1 : 0;
      var ariaLabel = accessibilityLabel || i18n.translate('Polaris.ResourceList.Item.viewItem', {
        itemName: name || resourceName && resourceName.singular || ''
      });
      var accessibleMarkup = url ? React__default.createElement(UnstyledLink, {
        "aria-describedby": this.props.id,
        "aria-label": ariaLabel,
        className: styles$1n.Link,
        url: url,
        external: external,
        tabIndex: tabIndex,
        id: this.overlayId
      }) : React__default.createElement("button", {
        className: styles$1n.Button,
        "aria-label": ariaLabel,
        "aria-controls": ariaControls,
        "aria-expanded": ariaExpanded,
        onClick: this.handleClick,
        tabIndex: tabIndex,
        ref: this.buttonOverlay
      });
      return React__default.createElement("div", {
        ref: this.setNode,
        className: className,
        onClick: this.handleClick,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onKeyUp: this.handleKeyUp,
        "data-href": url
      }, accessibleMarkup, containerMarkup);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var selected = isSelected(nextProps.id, nextProps.context.selectedItems);

      if (prevState.selected === selected) {
        return null;
      }

      return {
        selected
      };
    }
  }]);

  return BaseResourceItem;
}(React__default.Component);

function noop$b() {}

function stopPropagation$1(event) {
  event.stopPropagation();
}

function isSelected(id, selectedItems) {
  return Boolean(selectedItems && (Array.isArray(selectedItems) && selectedItems.includes(id) || selectedItems === SELECT_ALL_ITEMS));
}

function ResourceItem(props) {
  return React__default.createElement(BaseResourceItem, Object.assign({}, props, {
    context: useContext(ResourceListContext),
    i18n: useI18n()
  }));
}

var Sticky =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Sticky, _React$Component);

  function Sticky() {
    var _this;

    _classCallCheck(this, Sticky);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Sticky).apply(this, arguments));
    _this.state = {
      isSticky: false,
      style: {}
    };
    _this.placeHolderNode = null;
    _this.stickyNode = null;

    _this.setPlaceHolderNode = function (node) {
      _this.placeHolderNode = node;
    };

    _this.setStickyNode = function (node) {
      _this.stickyNode = node;
    };

    _this.handlePositioning = function (stick) {
      var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var left = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var isSticky = _this.state.isSticky;

      if (stick && !isSticky || !stick && isSticky) {
        _this.adjustPlaceHolderNode(stick);

        _this.setState({
          isSticky: !isSticky
        });
      }

      var style = stick ? {
        position: 'fixed',
        top,
        left,
        width
      } : {};

      _this.setState({
        style
      });
    };

    _this.adjustPlaceHolderNode = function (add) {
      if (_this.placeHolderNode && _this.stickyNode) {
        _this.placeHolderNode.style.paddingBottom = add ? "".concat(getRectForNode(_this.stickyNode).height, "px") : '0px';
      }
    };

    return _this;
  }

  _createClass(Sticky, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          boundingElement = _this$props.boundingElement,
          _this$props$offset = _this$props.offset,
          offset = _this$props$offset === void 0 ? false : _this$props$offset,
          _this$props$disableWh = _this$props.disableWhenStacked,
          disableWhenStacked = _this$props$disableWh === void 0 ? false : _this$props$disableWh,
          stickyManager = _this$props.polaris.stickyManager;
      if (!this.stickyNode || !this.placeHolderNode) return;
      stickyManager.registerStickyItem({
        stickyNode: this.stickyNode,
        placeHolderNode: this.placeHolderNode,
        handlePositioning: this.handlePositioning,
        offset,
        boundingElement,
        disableWhenStacked
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var stickyManager = this.props.polaris.stickyManager;
      if (!this.stickyNode) return;
      stickyManager.unregisterStickyItem(this.stickyNode);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
          style = _this$state.style,
          isSticky = _this$state.isSticky;
      var children = this.props.children;
      var childrenContent = isFunction(children) ? children(isSticky) : children;
      return React__default.createElement("div", null, React__default.createElement("div", {
        ref: this.setPlaceHolderNode
      }), React__default.createElement("div", {
        ref: this.setStickyNode,
        style: style
      }, childrenContent));
    }
  }]);

  return Sticky;
}(React__default.Component);

function isFunction(arg) {
  return typeof arg === 'function';
} // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var Sticky$1 = withAppProvider()(Sticky);

var styles$1o = {
  "Select": "Polaris-Select",
  "disabled": "Polaris-Select--disabled",
  "Content": "Polaris-Select__Content",
  "InlineLabel": "Polaris-Select__InlineLabel",
  "Icon": "Polaris-Select__Icon",
  "Backdrop": "Polaris-Select__Backdrop",
  "error": "Polaris-Select--error",
  "Input": "Polaris-Select__Input",
  "placeholder": "Polaris-Select--placeholder",
  "SelectedOption": "Polaris-Select__SelectedOption"
};

var PLACEHOLDER_VALUE = '';
function Select(_ref) {
  var optionsProp = _ref.options,
      label = _ref.label,
      labelAction = _ref.labelAction,
      labelHiddenProp = _ref.labelHidden,
      labelInline = _ref.labelInline,
      disabled = _ref.disabled,
      helpText = _ref.helpText,
      placeholder = _ref.placeholder,
      idProp = _ref.id,
      name = _ref.name,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? PLACEHOLDER_VALUE : _ref$value,
      error = _ref.error,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur;
  var id = useUniqueId('Select', idProp);
  var labelHidden = labelInline ? true : labelHiddenProp;
  var className = classNames(styles$1o.Select, error && styles$1o.error, disabled && styles$1o.disabled);
  var handleChange = onChange ? function (event) {
    return onChange(event.currentTarget.value, id);
  } : undefined;
  var describedBy = [];

  if (helpText) {
    describedBy.push(helpTextID(id));
  }

  if (error) {
    describedBy.push("".concat(id, "Error"));
  }

  var options = optionsProp || [];
  var normalizedOptions = options.map(normalizeOption);

  if (placeholder) {
    normalizedOptions = [{
      label: placeholder,
      value: PLACEHOLDER_VALUE,
      disabled: true
    }].concat(_toConsumableArray(normalizedOptions));
  }

  var inlineLabelMarkup = labelInline && React__default.createElement("span", {
    className: styles$1o.InlineLabel
  }, label);
  var selectedOption = getSelectedOption(normalizedOptions, value);
  var contentMarkup = React__default.createElement("div", {
    className: styles$1o.Content,
    "aria-hidden": true,
    "aria-disabled": disabled
  }, inlineLabelMarkup, React__default.createElement("span", {
    className: styles$1o.SelectedOption
  }, selectedOption), React__default.createElement("span", {
    className: styles$1o.Icon
  }, React__default.createElement(Icon, {
    source: ArrowUpDownMinor
  })));
  var optionsMarkup = normalizedOptions.map(renderOption);
  return React__default.createElement(Labelled, {
    id: id,
    label: label,
    error: error,
    action: labelAction,
    labelHidden: labelHidden,
    helpText: helpText
  }, React__default.createElement("div", {
    className: className
  }, React__default.createElement("select", {
    id: id,
    name: name,
    value: value,
    className: styles$1o.Input,
    disabled: disabled,
    onFocus: onFocus,
    onBlur: onBlur,
    onChange: handleChange,
    "aria-invalid": Boolean(error),
    "aria-describedby": describedBy.length ? describedBy.join(' ') : undefined
  }, optionsMarkup), contentMarkup, React__default.createElement("div", {
    className: styles$1o.Backdrop
  })));
}

function isString(option) {
  return typeof option === 'string';
}

function isGroup(option) {
  return option.options != null;
}

function normalizeStringOption(option) {
  return {
    label: option,
    value: option
  };
}
/**
 * Converts a string option (and each string option in a Group) into
 * an Option object.
 */


function normalizeOption(option) {
  if (isString(option)) {
    return normalizeStringOption(option);
  } else if (isGroup(option)) {
    var title = option.title,
        options = option.options;
    return {
      title,
      options: options.map(function (option) {
        return isString(option) ? normalizeStringOption(option) : option;
      })
    };
  }

  return option;
}
/**
 * Gets the text to display in the UI, for the currently selected option
 */


function getSelectedOption(options, value) {
  var flatOptions = flattenOptions(options);
  var selectedOption = flatOptions.find(function (option) {
    return value === option.value;
  });

  if (selectedOption === undefined) {
    // Get the first visible option (not the hidden placeholder)
    selectedOption = flatOptions.find(function (option) {
      return !option.hidden;
    });
  }

  return selectedOption ? selectedOption.label : '';
}
/**
 * Ungroups an options array
 */


function flattenOptions(options) {
  var flatOptions = [];
  options.forEach(function (optionOrGroup) {
    if (isGroup(optionOrGroup)) {
      flatOptions = flatOptions.concat(optionOrGroup.options);
    } else {
      flatOptions.push(optionOrGroup);
    }
  });
  return flatOptions;
}

function renderSingleOption(option) {
  var value = option.value,
      label = option.label,
      rest = __rest(option, ["value", "label"]);

  return React__default.createElement("option", Object.assign({
    key: value,
    value: value
  }, rest), label);
}

function renderOption(optionOrGroup) {
  if (isGroup(optionOrGroup)) {
    var title = optionOrGroup.title,
        options = optionOrGroup.options;
    return React__default.createElement("optgroup", {
      label: title,
      key: title
    }, options.map(renderSingleOption));
  }

  return renderSingleOption(optionOrGroup);
}

var styles$1p = {
  "CheckableButton": "Polaris-ResourceList-CheckableButton",
  "globalTheming": "Polaris-ResourceList-CheckableButton--globalTheming",
  "CheckableButton-selectMode": "Polaris-ResourceList-CheckableButton__CheckableButton--selectMode",
  "CheckableButton-measuring": "Polaris-ResourceList-CheckableButton__CheckableButton--measuring",
  "CheckableButton-plain": "Polaris-ResourceList-CheckableButton__CheckableButton--plain",
  "CheckableButton-selected": "Polaris-ResourceList-CheckableButton__CheckableButton--selected",
  "Checkbox": "Polaris-ResourceList-CheckableButton__Checkbox",
  "Label": "Polaris-ResourceList-CheckableButton__Label"
};

function CheckableButton(_ref) {
  var accessibilityLabel = _ref.accessibilityLabel,
      _ref$label = _ref.label,
      label = _ref$label === void 0 ? '' : _ref$label,
      onToggleAll = _ref.onToggleAll,
      selected = _ref.selected,
      selectMode = _ref.selectMode,
      plain = _ref.plain,
      measuring = _ref.measuring,
      disabled = _ref.disabled,
      smallScreen = _ref.smallScreen;
  var checkBoxRef = useRef(null);

  var _useFeatures = useFeatures(),
      _useFeatures$unstable = _useFeatures.unstableGlobalTheming,
      unstableGlobalTheming = _useFeatures$unstable === void 0 ? false : _useFeatures$unstable;

  var _React$useContext = React__default.useContext(ResourceListContext),
      registerCheckableButtons = _React$useContext.registerCheckableButtons;

  var currentKey = 'bulkLg';

  if (plain) {
    currentKey = 'plain';
  } else if (smallScreen) {
    currentKey = 'bulkSm';
  }

  useEffect(function () {
    if (checkBoxRef.current && registerCheckableButtons) {
      registerCheckableButtons(currentKey, checkBoxRef.current);
    }
  }, [currentKey, registerCheckableButtons]);
  var className = plain ? classNames(styles$1p.CheckableButton, styles$1p['CheckableButton-plain'], unstableGlobalTheming && styles$1p.globalTheming) : classNames(styles$1p.CheckableButton, unstableGlobalTheming && styles$1p.globalTheming, selectMode && styles$1p['CheckableButton-selectMode'], selected && styles$1p['CheckableButton-selected'], measuring && styles$1p['CheckableButton-measuring']);
  return React__default.createElement("div", {
    className: className,
    onClick: onToggleAll
  }, React__default.createElement("div", {
    className: styles$1p.Checkbox
  }, React__default.createElement(Checkbox$1, {
    label: accessibilityLabel,
    labelHidden: true,
    checked: selected,
    disabled: disabled,
    onChange: onToggleAll,
    ref: checkBoxRef
  })), React__default.createElement("span", {
    className: styles$1p.Label
  }, label));
}

var styles$1q = {
  "Group": "Polaris-ResourceList-BulkActions__Group",
  "Group-measuring": "Polaris-ResourceList-BulkActions__Group--measuring",
  "Group-entering": "Polaris-ResourceList-BulkActions__Group--entering",
  "Group-exiting": "Polaris-ResourceList-BulkActions__Group--exiting",
  "Group-entered": "Polaris-ResourceList-BulkActions__Group--entered",
  "Group-exited": "Polaris-ResourceList-BulkActions__Group--exited",
  "Group-smallScreen": "Polaris-ResourceList-BulkActions__Group--smallScreen",
  "Group-largeScreen": "Polaris-ResourceList-BulkActions__Group--largeScreen",
  "ButtonGroupWrapper": "Polaris-ResourceList-BulkActions__ButtonGroupWrapper",
  "BulkActionButton": "Polaris-ResourceList-BulkActions__BulkActionButton",
  "CheckableContainer": "Polaris-ResourceList-BulkActions__CheckableContainer",
  "disabled": "Polaris-ResourceList-BulkActions--disabled",
  "globalTheming": "Polaris-ResourceList-BulkActions--globalTheming",
  "PaginatedSelectAll": "Polaris-ResourceList-BulkActions__PaginatedSelectAll",
  "Slide": "Polaris-ResourceList-BulkActions__Slide",
  "Slide-appear": "Polaris-ResourceList-BulkActions__Slide--appear",
  "Slide-enter": "Polaris-ResourceList-BulkActions__Slide--enter",
  "Slide-exit": "Polaris-ResourceList-BulkActions__Slide--exit",
  "Slide-appearing": "Polaris-ResourceList-BulkActions__Slide--appearing",
  "Slide-entering": "Polaris-ResourceList-BulkActions__Slide--entering"
};

var BulkActionButton =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(BulkActionButton, _React$PureComponent);

  function BulkActionButton() {
    var _this;

    _classCallCheck(this, BulkActionButton);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BulkActionButton).apply(this, arguments));
    _this.bulkActionButton = createRef();
    return _this;
  }

  _createClass(BulkActionButton, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var handleMeasurement = this.props.handleMeasurement;

      if (handleMeasurement && this.bulkActionButton.current) {
        var width = this.bulkActionButton.current.getBoundingClientRect().width;
        handleMeasurement(width);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          url = _this$props.url,
          external = _this$props.external,
          onAction = _this$props.onAction,
          content = _this$props.content,
          disclosure = _this$props.disclosure,
          accessibilityLabel = _this$props.accessibilityLabel,
          disabled = _this$props.disabled;
      return React__default.createElement("div", {
        className: styles$1q.BulkActionButton,
        ref: this.bulkActionButton
      }, React__default.createElement(Button, {
        external: external,
        url: url,
        "aria-label": accessibilityLabel,
        onClick: onAction,
        disabled: disabled,
        disclosure: disclosure
      }, content));
    }
  }]);

  return BulkActionButton;
}(React__default.PureComponent);

var MAX_PROMOTED_ACTIONS = 2;
var slideClasses = {
  appear: classNames(styles$1q.Slide, styles$1q['Slide-appear']),
  appearActive: classNames(styles$1q.Slide, styles$1q['Slide-appearing']),
  enter: classNames(styles$1q.Slide, styles$1q['Slide-enter']),
  enterActive: classNames(styles$1q.Slide, styles$1q['Slide-entering']),
  exit: classNames(styles$1q.Slide, styles$1q['Slide-exit'])
};

var BulkActions =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(BulkActions, _React$PureComponent);

  function BulkActions() {
    var _this;

    _classCallCheck(this, BulkActions);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(BulkActions).apply(this, arguments));
    _this.state = {
      smallScreenPopoverVisible: false,
      largeScreenPopoverVisible: false,
      containerWidth: 0,
      measuring: true
    };
    _this.containerNode = null;
    _this.largeScreenButtonsNode = null;
    _this.moreActionsNode = null;
    _this.checkableWrapperNode = createRef();
    _this.largeScreenGroupNode = createRef();
    _this.smallScreenGroupNode = createRef();
    _this.promotedActionsWidths = [];
    _this.bulkActionsWidth = 0;
    _this.addedMoreActionsWidthForMeasuring = 0;
    _this.handleResize = debounce(function () {
      var _this$state = _this.state,
          smallScreenPopoverVisible = _this$state.smallScreenPopoverVisible,
          largeScreenPopoverVisible = _this$state.largeScreenPopoverVisible;

      if (_this.containerNode) {
        var containerWidth = _this.containerNode.getBoundingClientRect().width;

        if (containerWidth > 0) {
          _this.setState({
            containerWidth
          });
        }
      }

      if (smallScreenPopoverVisible || largeScreenPopoverVisible) {
        _this.setState({
          smallScreenPopoverVisible: false,
          largeScreenPopoverVisible: false
        });
      }
    }, 50, {
      trailing: true
    });

    _this.setLargeScreenButtonsNode = function (node) {
      _this.largeScreenButtonsNode = node;
    };

    _this.setContainerNode = function (node) {
      _this.containerNode = node;
    };

    _this.setMoreActionsNode = function (node) {
      _this.moreActionsNode = node;
    };

    _this.setSelectMode = function (val) {
      var onSelectModeToggle = _this.props.onSelectModeToggle;

      if (onSelectModeToggle) {
        onSelectModeToggle(val);
      }
    };

    _this.toggleSmallScreenPopover = function () {
      _this.setState(function (_ref) {
        var smallScreenPopoverVisible = _ref.smallScreenPopoverVisible;
        return {
          smallScreenPopoverVisible: !smallScreenPopoverVisible
        };
      });
    };

    _this.toggleLargeScreenPopover = function () {
      _this.setState(function (_ref2) {
        var largeScreenPopoverVisible = _ref2.largeScreenPopoverVisible;
        return {
          largeScreenPopoverVisible: !largeScreenPopoverVisible
        };
      });
    };

    _this.handleMeasurement = function (width) {
      var measuring = _this.state.measuring;

      if (measuring) {
        _this.promotedActionsWidths.push(width);
      }
    };

    _this.findLargeScreenGroupNode = function () {
      return _this.largeScreenGroupNode.current;
    };

    _this.findCheckableWrapperNode = function () {
      return _this.checkableWrapperNode.current;
    };

    _this.findSmallScreenGroupNode = function () {
      return _this.smallScreenGroupNode.current;
    };

    return _this;
  }

  _createClass(BulkActions, [{
    key: "numberOfPromotedActionsToRender",
    value: function numberOfPromotedActionsToRender() {
      var promotedActions = this.props.promotedActions;
      var _this$state2 = this.state,
          containerWidth = _this$state2.containerWidth,
          measuring = _this$state2.measuring;

      if (!promotedActions) {
        return 0;
      }

      if (containerWidth >= this.bulkActionsWidth || measuring) {
        return promotedActions.length;
      }

      var sufficientSpace = false;
      var counter = promotedActions.length - 1;
      var totalWidth = 0;

      while (!sufficientSpace && counter >= 0) {
        totalWidth += this.promotedActionsWidths[counter];
        var widthWithRemovedAction = this.bulkActionsWidth - totalWidth + this.addedMoreActionsWidthForMeasuring;

        if (containerWidth >= widthWithRemovedAction) {
          sufficientSpace = true;
        } else {
          counter--;
        }
      }

      return counter;
    }
  }, {
    key: "hasActions",
    value: function hasActions() {
      var _this$props = this.props,
          promotedActions = _this$props.promotedActions,
          actions = _this$props.actions;
      return Boolean(promotedActions && promotedActions.length > 0 || actions && actions.length > 0);
    }
  }, {
    key: "actionSections",
    value: function actionSections() {
      var actions = this.props.actions;

      if (!actions || actions.length === 0) {
        return;
      }

      if (instanceOfBulkActionListSectionArray(actions)) {
        return actions;
      }

      if (instanceOfBulkActionArray(actions)) {
        return [{
          items: actions
        }];
      }
    } // eslint-disable-next-line @typescript-eslint/member-ordering

  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props2 = this.props,
          actions = _this$props2.actions,
          promotedActions = _this$props2.promotedActions;

      if (promotedActions && !actions && this.moreActionsNode) {
        this.addedMoreActionsWidthForMeasuring = this.moreActionsNode.getBoundingClientRect().width;
      }

      this.bulkActionsWidth = this.largeScreenButtonsNode ? this.largeScreenButtonsNode.getBoundingClientRect().width - this.addedMoreActionsWidthForMeasuring : 0;

      if (this.containerNode) {
        this.setState({
          containerWidth: this.containerNode.getBoundingClientRect().width,
          measuring: false
        });
      }
    } // eslint-disable-next-line @typescript-eslint/member-ordering

  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props3 = this.props,
          selectMode = _this$props3.selectMode,
          accessibilityLabel = _this$props3.accessibilityLabel,
          _this$props3$label = _this$props3.label,
          label = _this$props3$label === void 0 ? '' : _this$props3$label,
          onToggleAll = _this$props3.onToggleAll,
          selected = _this$props3.selected,
          smallScreen = _this$props3.smallScreen,
          disabled = _this$props3.disabled,
          promotedActions = _this$props3.promotedActions,
          _this$props3$paginate = _this$props3.paginatedSelectAllText,
          paginatedSelectAllText = _this$props3$paginate === void 0 ? null : _this$props3$paginate,
          paginatedSelectAllAction = _this$props3.paginatedSelectAllAction,
          intl = _this$props3.polaris.intl;
      var actionSections = this.actionSections();

      if (promotedActions && promotedActions.length > MAX_PROMOTED_ACTIONS) {
        // eslint-disable-next-line no-console
        console.warn(intl.translate('Polaris.ResourceList.BulkActions.warningMessage', {
          maxPromotedActions: MAX_PROMOTED_ACTIONS
        }));
      }

      var _this$state3 = this.state,
          smallScreenPopoverVisible = _this$state3.smallScreenPopoverVisible,
          largeScreenPopoverVisible = _this$state3.largeScreenPopoverVisible,
          measuring = _this$state3.measuring;
      var paginatedSelectAllActionMarkup = paginatedSelectAllAction ? React__default.createElement(Button, {
        onClick: paginatedSelectAllAction.onAction,
        plain: true,
        disabled: disabled
      }, paginatedSelectAllAction.content) : null;
      var paginatedSelectAllTextMarkup = paginatedSelectAllText && paginatedSelectAllAction ? React__default.createElement("span", {
        "aria-live": "polite"
      }, paginatedSelectAllText) : paginatedSelectAllText;
      var paginatedSelectAllMarkup = paginatedSelectAllActionMarkup || paginatedSelectAllTextMarkup ? React__default.createElement("div", {
        className: styles$1q.PaginatedSelectAll
      }, paginatedSelectAllTextMarkup, " ", paginatedSelectAllActionMarkup) : null;
      var cancelButton = React__default.createElement(Button, {
        onClick: this.setSelectMode.bind(this, false),
        disabled: disabled
      }, intl.translate('Polaris.Common.cancel'));
      var numberOfPromotedActionsToRender = this.numberOfPromotedActionsToRender();
      var allActionsPopover = this.hasActions() ? React__default.createElement("div", {
        className: styles$1q.Popover,
        ref: this.setMoreActionsNode
      }, React__default.createElement(Popover, {
        active: smallScreenPopoverVisible,
        activator: React__default.createElement(BulkActionButton, {
          disclosure: true,
          onAction: this.toggleSmallScreenPopover,
          content: intl.translate('Polaris.ResourceList.BulkActions.actionsActivatorLabel'),
          disabled: disabled
        }),
        onClose: this.toggleSmallScreenPopover
      }, React__default.createElement(ActionList, {
        items: promotedActions,
        sections: actionSections,
        onActionAnyItem: this.toggleSmallScreenPopover
      }))) : null;
      var promotedActionsMarkup = promotedActions && numberOfPromotedActionsToRender > 0 ? _toConsumableArray(promotedActions).slice(0, numberOfPromotedActionsToRender).map(function (action, index) {
        return React__default.createElement(BulkActionButton, Object.assign({
          disabled: disabled
        }, action, {
          key: index,
          handleMeasurement: _this2.handleMeasurement
        }));
      }) : null;
      var rolledInPromotedActions = promotedActions && numberOfPromotedActionsToRender < promotedActions.length ? _toConsumableArray(promotedActions).slice(numberOfPromotedActionsToRender) : [];
      var activatorLabel = !promotedActions || promotedActions && numberOfPromotedActionsToRender === 0 && !measuring ? intl.translate('Polaris.ResourceList.BulkActions.actionsActivatorLabel') : intl.translate('Polaris.ResourceList.BulkActions.moreActionsActivatorLabel');
      var combinedActions = [];

      if (actionSections && rolledInPromotedActions.length > 0) {
        combinedActions = [{
          items: rolledInPromotedActions
        }].concat(_toConsumableArray(actionSections));
      } else if (actionSections) {
        combinedActions = actionSections;
      } else if (rolledInPromotedActions.length > 0) {
        combinedActions = [{
          items: rolledInPromotedActions
        }];
      }

      var actionsPopover = actionSections || rolledInPromotedActions.length > 0 || measuring ? React__default.createElement("div", {
        className: styles$1q.Popover,
        ref: this.setMoreActionsNode
      }, React__default.createElement(Popover, {
        active: largeScreenPopoverVisible,
        activator: React__default.createElement(BulkActionButton, {
          disclosure: true,
          onAction: this.toggleLargeScreenPopover,
          content: activatorLabel,
          disabled: disabled
        }),
        onClose: this.toggleLargeScreenPopover
      }, React__default.createElement(ActionList, {
        sections: combinedActions,
        onActionAnyItem: this.toggleLargeScreenPopover
      }))) : null;
      var checkableButtonProps = {
        accessibilityLabel,
        label,
        selected,
        selectMode,
        onToggleAll,
        measuring,
        disabled
      };
      var smallScreenGroup = smallScreen ? React__default.createElement(Transition, {
        timeout: 0,
        in: selectMode,
        key: "smallGroup",
        findDOMNode: this.findSmallScreenGroupNode
      }, function (status) {
        var smallScreenGroupClassName = classNames(styles$1q.Group, styles$1q['Group-smallScreen'], styles$1q["Group-".concat(status)]);
        return React__default.createElement("div", {
          className: smallScreenGroupClassName,
          ref: _this2.smallScreenGroupNode
        }, React__default.createElement("div", {
          className: styles$1q.ButtonGroupWrapper
        }, React__default.createElement(ButtonGroup, {
          segmented: true
        }, React__default.createElement(CSSTransition, {
          findDOMNode: _this2.findCheckableWrapperNode,
          in: selectMode,
          timeout: durationBase,
          classNames: slideClasses,
          appear: !selectMode
        }, React__default.createElement("div", {
          className: styles$1q.CheckableContainer,
          ref: _this2.checkableWrapperNode
        }, React__default.createElement(CheckableButton, Object.assign({}, checkableButtonProps, {
          smallScreen: true
        })))), allActionsPopover, cancelButton)), paginatedSelectAllMarkup);
      }) : null;
      var largeGroupContent = promotedActionsMarkup || actionsPopover ? React__default.createElement(ButtonGroup, {
        segmented: true
      }, React__default.createElement(CheckableButton, checkableButtonProps), promotedActionsMarkup, actionsPopover) : React__default.createElement(CheckableButton, checkableButtonProps);
      var largeScreenGroup = smallScreen ? null : React__default.createElement(Transition, {
        timeout: 0,
        in: selectMode,
        key: "largeGroup",
        findDOMNode: this.findLargeScreenGroupNode
      }, function (status) {
        var largeScreenGroupClassName = classNames(styles$1q.Group, styles$1q['Group-largeScreen'], !measuring && styles$1q["Group-".concat(status)], measuring && styles$1q['Group-measuring']);
        return React__default.createElement("div", {
          className: largeScreenGroupClassName,
          ref: _this2.largeScreenGroupNode
        }, React__default.createElement(EventListener, {
          event: "resize",
          handler: _this2.handleResize
        }), React__default.createElement("div", {
          className: styles$1q.ButtonGroupWrapper,
          ref: _this2.setLargeScreenButtonsNode
        }, largeGroupContent), paginatedSelectAllMarkup);
      });
      return React__default.createElement("div", {
        ref: this.setContainerNode
      }, smallScreenGroup, largeScreenGroup);
    }
  }]);

  return BulkActions;
}(React__default.PureComponent);

function instanceOfBulkActionListSectionArray(actions) {
  var validList = actions.filter(function (action) {
    return action.items;
  });
  return actions.length === validList.length;
}

function instanceOfBulkActionArray(actions) {
  var validList = actions.filter(function (action) {
    return !action.items;
  });
  return actions.length === validList.length;
} // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var BulkActions$1 = withAppProvider()(BulkActions);

var styles$1r = {
  "DateTextField": "Polaris-FilterControl-DateSelector__DateTextField",
  "DatePicker": "Polaris-FilterControl-DateSelector__DatePicker"
};

var VALID_DATE_REGEX = /^\d{4}-\d{1,2}-\d{1,2}$/;
var DateFilterOption;

(function (DateFilterOption) {
  DateFilterOption["PastWeek"] = "past_week";
  DateFilterOption["PastMonth"] = "past_month";
  DateFilterOption["PastQuarter"] = "past_quarter";
  DateFilterOption["PastYear"] = "past_year";
  DateFilterOption["ComingWeek"] = "coming_week";
  DateFilterOption["ComingMonth"] = "coming_month";
  DateFilterOption["ComingQuarter"] = "coming_quarter";
  DateFilterOption["ComingYear"] = "coming_year";
  DateFilterOption["OnOrBefore"] = "on_or_before";
  DateFilterOption["OnOrAfter"] = "on_or_after";
})(DateFilterOption || (DateFilterOption = {}));

var DateSelector = memo(function DateSelector(_ref) {
  var filterValue = _ref.filterValue,
      filterKey = _ref.filterKey,
      filterMinKey = _ref.filterMinKey,
      filterMaxKey = _ref.filterMaxKey,
      dateOptionType = _ref.dateOptionType,
      onFilterValueChange = _ref.onFilterValueChange,
      onFilterKeyChange = _ref.onFilterKeyChange;
  var now = new Date();
  var i18n = useI18n();
  var initialConsumerFilterKey = useRef(filterKey);

  var _useState = useState(now.getMonth()),
      _useState2 = _slicedToArray(_useState, 2),
      datePickerMonth = _useState2[0],
      setDatePickerMonth = _useState2[1];

  var _useState3 = useState(now.getFullYear()),
      _useState4 = _slicedToArray(_useState3, 2),
      datePickerYear = _useState4[0],
      setDatePickerYear = _useState4[1];

  var _useState5 = useState(),
      _useState6 = _slicedToArray(_useState5, 2),
      selectedDate = _useState6[0],
      setSelectedDate = _useState6[1];

  var _useState7 = useState(),
      _useState8 = _slicedToArray(_useState7, 2),
      userInputDate = _useState8[0],
      setUserInputDate = _useState8[1];

  var _useState9 = useState(),
      _useState10 = _slicedToArray(_useState9, 2),
      userInputDateError = _useState10[0],
      setUserInputDateError = _useState10[1];

  var dateTextFieldValue = getDateTextFieldValue();
  var handleDateFieldChange = useCallback(function (value) {
    if (value.length === 0) {
      setSelectedDate(undefined);
      onFilterValueChange(undefined);
    }

    if (userInputDateError && isValidDate(value)) {
      setUserInputDateError(undefined);
    }

    setUserInputDate(value);
  }, [onFilterValueChange, userInputDateError]);
  var handleDateChanged = useCallback(function (date) {
    if (!date) {
      return;
    }

    onFilterValueChange(stripTimeFromISOString(formatDateForLocalTimezone(date)));
  }, [onFilterValueChange]);
  var handleDateBlur = useCallback(function () {
    if (!dateTextFieldValue || !isValidDate(dateTextFieldValue)) {
      setSelectedDate(undefined);
      setUserInputDateError(i18n.translate('Polaris.ResourceList.DateSelector.dateValueError'));
      onFilterValueChange(undefined);
      return;
    }

    if (!userInputDate) {
      return;
    }

    var formattedDateForTimezone = new Date(formatDateForLocalTimezone(new Date(userInputDate)));
    setSelectedDate(formattedDateForTimezone);
    setDatePickerMonth(formattedDateForTimezone.getMonth());
    setDatePickerYear(formattedDateForTimezone.getFullYear());
    setUserInputDate(undefined);
    setUserInputDateError(undefined);
    handleDateChanged(formattedDateForTimezone);
  }, [dateTextFieldValue, handleDateChanged, i18n, onFilterValueChange, userInputDate]);
  var handleDateFilterOptionsChange = useCallback(function (newOption) {
    if (!initialConsumerFilterKey.current) {
      return;
    }

    if (newOption === DateFilterOption.OnOrBefore) {
      onFilterKeyChange(filterMaxKey);
      onFilterValueChange(selectedDate ? stripTimeFromISOString(formatDateForLocalTimezone(selectedDate)) : undefined);
      return;
    }

    if (newOption === DateFilterOption.OnOrAfter) {
      onFilterKeyChange(filterMinKey);
      onFilterValueChange(selectedDate ? stripTimeFromISOString(formatDateForLocalTimezone(selectedDate)) : undefined);
      return;
    }

    onFilterKeyChange(initialConsumerFilterKey.current);
    onFilterValueChange(newOption);
  }, [filterMaxKey, filterMinKey, initialConsumerFilterKey, onFilterKeyChange, onFilterValueChange, selectedDate]);
  var handleDatePickerChange = useCallback(function (_ref2) {
    var nextDate = _ref2.end;
    var date = new Date(nextDate);
    setSelectedDate(date);
    setUserInputDate(undefined);
    setUserInputDateError(undefined);
    handleDateChanged(date);
  }, [handleDateChanged]);
  var handleDatePickerMonthChange = useCallback(function (month, year) {
    setDatePickerMonth(month);
    setDatePickerYear(year);
  }, []);
  var dateFilterOption = getDateFilterOption(filterValue, filterKey, filterMinKey, filterMaxKey);
  var showDatePredicate = dateFilterOption === DateFilterOption.OnOrBefore || dateFilterOption === DateFilterOption.OnOrAfter;
  var datePredicateMarkup = showDatePredicate && React__default.createElement(React__default.Fragment, null, React__default.createElement("div", {
    className: styles$1r.DateTextField
  }, React__default.createElement(TextField, {
    label: i18n.translate('Polaris.ResourceList.DateSelector.dateValueLabel'),
    placeholder: i18n.translate('Polaris.ResourceList.DateSelector.dateValuePlaceholder'),
    value: dateTextFieldValue,
    error: userInputDateError,
    prefix: React__default.createElement(Icon, {
      source: CalendarMinor,
      color: "skyDark"
    }),
    autoComplete: false,
    onChange: handleDateFieldChange,
    onBlur: handleDateBlur
  })), React__default.createElement("div", {
    className: styles$1r.DatePicker
  }, React__default.createElement(DatePicker, {
    selected: selectedDate,
    month: datePickerMonth,
    year: datePickerYear,
    onChange: handleDatePickerChange,
    onMonthChange: handleDatePickerMonthChange
  })));
  var dateOptionTypes = {
    past: [].concat(_toConsumableArray(getDatePastOptions()), _toConsumableArray(getDateComparatorOptions())),
    future: [].concat(_toConsumableArray(getDateFutureOptions()), _toConsumableArray(getDateComparatorOptions())),
    full: [].concat(_toConsumableArray(getDatePastOptions()), _toConsumableArray(getDateFutureOptions()), _toConsumableArray(getDateComparatorOptions()))
  };
  return React__default.createElement(React__default.Fragment, null, React__default.createElement(Select, {
    label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.dateFilterLabel'),
    labelHidden: true,
    options: dateOptionType ? dateOptionTypes[dateOptionType] : dateOptionTypes.full,
    placeholder: i18n.translate('Polaris.ResourceList.FilterValueSelector.selectFilterValuePlaceholder'),
    value: dateFilterOption,
    onChange: handleDateFilterOptionsChange
  }), datePredicateMarkup);

  function getDateComparatorOptions() {
    return [{
      value: DateFilterOption.OnOrBefore,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.OnOrBefore')
    }, {
      value: DateFilterOption.OnOrAfter,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.OnOrAfter')
    }];
  }

  function getDatePastOptions() {
    return [{
      value: DateFilterOption.PastWeek,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastWeek')
    }, {
      value: DateFilterOption.PastMonth,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastMonth')
    }, {
      value: DateFilterOption.PastQuarter,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastQuarter')
    }, {
      value: DateFilterOption.PastYear,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.PastYear')
    }];
  }

  function getDateFutureOptions() {
    return [{
      value: DateFilterOption.ComingWeek,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingWeek')
    }, {
      value: DateFilterOption.ComingMonth,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingMonth')
    }, {
      value: DateFilterOption.ComingQuarter,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingQuarter')
    }, {
      value: DateFilterOption.ComingYear,
      label: i18n.translate('Polaris.ResourceList.DateSelector.SelectOptions.ComingYear')
    }];
  }

  function getDateTextFieldValue() {
    if (!userInputDate && !selectedDate) {
      return undefined;
    }

    if (userInputDate !== undefined) {
      return userInputDate;
    }

    if (selectedDate) {
      return stripTimeFromISOString(formatDateForLocalTimezone(selectedDate));
    }
  }
});

function isValidDate(date) {
  if (!date) {
    return false;
  }

  return VALID_DATE_REGEX.test(date) && !isNaN(new Date(date).getTime());
}

function getDateFilterOption(filterValue, filterKey, filterMinKey, filterMaxKey) {
  if (filterKey === filterMaxKey) {
    return DateFilterOption.OnOrBefore;
  }

  if (filterKey === filterMinKey) {
    return DateFilterOption.OnOrAfter;
  }

  return filterValue;
}

function stripTimeFromISOString(ISOString) {
  return ISOString.slice(0, 10);
}

function formatDateForLocalTimezone(date) {
  var timezoneOffset = date.getTimezoneOffset();
  var timezoneOffsetMs = timezoneOffset * 60 * 1000;
  var isFringeTimezone = timezoneOffset === -720 || timezoneOffset === 720;
  var formattedDate = new Date();

  if (isFringeTimezone && date.getHours() !== 0) {
    return date.toISOString();
  }

  var newTime = timezoneOffset > -1 ? date.getTime() + timezoneOffsetMs : date.getTime() - timezoneOffsetMs;
  formattedDate.setTime(newTime);
  return formattedDate.toISOString();
}

var FilterType;

(function (FilterType) {
  FilterType[FilterType["Select"] = 0] = "Select";
  FilterType[FilterType["TextField"] = 1] = "TextField";
  FilterType[FilterType["DateSelector"] = 2] = "DateSelector";
})(FilterType || (FilterType = {}));

/**
 * Returns a MutatableRefObject containing a boolean value that
 * represents a components mounted status.
 * @returns MutableRefObject<boolean> The mounted status
 */

function useIsMountedRef() {
  var isMounted = useRef(false);
  useEffect(function () {
    isMounted.current = true;
    return function () {
      isMounted.current = false;
    };
  }, []);
  return isMounted;
}

function FilterValueSelector(_ref) {
  var filter = _ref.filter,
      filterKey = _ref.filterKey,
      value = _ref.value,
      onChange = _ref.onChange,
      onFilterKeyChange = _ref.onFilterKeyChange;
  var i18n = useI18n();
  var isMounted = useIsMountedRef();
  var operatorText = filter.operatorText,
      type = filter.type,
      label = filter.label;
  var showOperatorOptions = type !== FilterType.DateSelector && operatorText && typeof operatorText !== 'string';
  var handleOperatorOptionChange = useCallback(function (operatorKey) {
    onFilterKeyChange(operatorKey);

    if (!value) {
      return;
    }

    onChange(value);
  }, [onChange, onFilterKeyChange, value]);

  if (showOperatorOptions && operatorText.length !== 0 && !isMounted.current) {
    handleOperatorOptionChange(operatorText[0].key);
  }

  var operatorOptionsMarkup = showOperatorOptions ? React__default.createElement(Select, {
    label: label,
    labelHidden: true,
    options: buildOperatorOptions(operatorText),
    value: filterKey,
    onChange: handleOperatorOptionChange
  }) : null;
  var selectedFilterLabel = typeof operatorText === 'string' ? operatorText : '';

  switch (filter.type) {
    case FilterType.Select:
      return React__default.createElement(Stack, {
        vertical: true
      }, operatorOptionsMarkup, React__default.createElement(Select, {
        label: selectedFilterLabel,
        options: filter.options,
        placeholder: i18n.translate('Polaris.ResourceList.FilterValueSelector.selectFilterValuePlaceholder'),
        value: value,
        onChange: onChange
      }));

    case FilterType.TextField:
      return React__default.createElement(Stack, {
        vertical: true
      }, operatorOptionsMarkup, React__default.createElement(TextField, {
        label: selectedFilterLabel,
        value: value,
        type: filter.textFieldType,
        onChange: onChange
      }));

    case FilterType.DateSelector:
      return React__default.createElement(DateSelector, {
        dateOptionType: filter.dateOptionType,
        filterValue: value,
        filterKey: filterKey,
        filterMinKey: filter.minKey,
        filterMaxKey: filter.maxKey,
        onFilterValueChange: onChange,
        onFilterKeyChange: onFilterKeyChange
      });

    default:
      return null;
  }
}

function buildOperatorOptions(operatorText) {
  if (!operatorText || typeof operatorText === 'string') {
    return [];
  }

  return operatorText.map(function (_ref2) {
    var key = _ref2.key,
        optionLabel = _ref2.optionLabel;
    return {
      value: key,
      label: optionLabel
    };
  });
}

function FilterCreator(_ref) {
  var filters = _ref.filters,
      resourceName = _ref.resourceName,
      disabled = _ref.disabled,
      onAddFilter = _ref.onAddFilter;

  var _useToggle = useToggle(false),
      popoverActive = _useToggle.value,
      togglePopoverActive = _useToggle.toggle,
      setPopoverActiveFalse = _useToggle.setFalse;

  var _useState = useState(),
      _useState2 = _slicedToArray(_useState, 2),
      selectedFilter = _useState2[0],
      setSelectedFilter = _useState2[1];

  var _useState3 = useState(),
      _useState4 = _slicedToArray(_useState3, 2),
      selectedFilterKey = _useState4[0],
      setSelectedFilterKey = _useState4[1];

  var _useState5 = useState(),
      _useState6 = _slicedToArray(_useState5, 2),
      selectedFilterValue = _useState6[0],
      setSelectedFilterValue = _useState6[1];

  var i18n = useI18n();
  var node = useRef(null);
  var canAddFilter = Boolean(selectedFilter && selectedFilterKey && selectedFilterValue);
  var handleButtonFocus = useCallback(function () {
    var event = arguments.length <= 0 ? undefined : arguments[0];

    if (!node.current && event) {
      // https://github.com/DefinitelyTyped/DefinitelyTyped/issues/31065
      node.current = event.target;
    }
  }, []);
  var handleFilterKeyChange = useCallback(function (filterKey) {
    var foundFilter = filters.find(function (filter) {
      var minKey = filter.minKey,
          maxKey = filter.maxKey,
          operatorText = filter.operatorText;

      if (minKey || maxKey) {
        return filter.key === filterKey || minKey === filterKey || maxKey === filterKey;
      }

      if (operatorText && typeof operatorText !== 'string') {
        return filter.key === filterKey || operatorText.filter(function (_ref2) {
          var key = _ref2.key;
          return key === filterKey;
        }).length === 1;
      }

      return filter.key === filterKey;
    });

    if (!foundFilter) {
      return;
    }

    setSelectedFilter(foundFilter);
    setSelectedFilterKey(filterKey);
    setSelectedFilterValue(undefined);
  }, [filters]);
  var handleFilterValueChange = useCallback(function (value) {
    setSelectedFilterValue(value);
  }, []);
  var handleAddFilter = useCallback(function () {
    if (!onAddFilter || !canAddFilter || !selectedFilterKey) {
      return;
    }

    onAddFilter({
      key: selectedFilterKey,
      value: selectedFilterValue || ''
    });
    setPopoverActiveFalse();
    setSelectedFilter(undefined);
    setSelectedFilterValue(undefined);

    if (node.current != null) {
      node.current.focus();
    }
  }, [canAddFilter, onAddFilter, selectedFilterKey, selectedFilterValue, setPopoverActiveFalse]);
  var activator = React__default.createElement(Button, {
    onClick: togglePopoverActive,
    disclosure: true,
    disabled: disabled,
    onFocus: handleButtonFocus
  }, i18n.translate('Polaris.ResourceList.FilterCreator.filterButtonLabel'));
  var filterOptions = filters.map(function (_ref3) {
    var key = _ref3.key,
        label = _ref3.label;
    return {
      value: key,
      label
    };
  });
  var filterValueSelectionMarkup = selectedFilter ? React__default.createElement(FilterValueSelector, {
    filter: selectedFilter,
    filterKey: selectedFilterKey,
    value: selectedFilterValue,
    onFilterKeyChange: handleFilterKeyChange,
    onChange: handleFilterValueChange
  }) : null;
  var addFilterButtonMarkup = selectedFilter ? React__default.createElement(Button, {
    onClick: handleAddFilter,
    disabled: !canAddFilter
  }, i18n.translate('Polaris.ResourceList.FilterCreator.addFilterButtonLabel')) : null;
  return React__default.createElement(Popover, {
    active: popoverActive,
    activator: activator,
    onClose: togglePopoverActive,
    sectioned: true,
    fullHeight: true
  }, React__default.createElement(Form, {
    onSubmit: handleAddFilter
  }, React__default.createElement(FormLayout, null, React__default.createElement(Select, {
    label: i18n.translate('Polaris.ResourceList.FilterCreator.showAllWhere', {
      resourceNamePlural: resourceName.plural.toLocaleLowerCase()
    }),
    placeholder: i18n.translate('Polaris.ResourceList.FilterCreator.selectFilterKeyPlaceholder'),
    options: filterOptions,
    onChange: handleFilterKeyChange,
    value: selectedFilter && selectedFilter.key
  }), filterValueSelectionMarkup, addFilterButtonMarkup)));
}

var styles$1s = {
  "AppliedFilters": "Polaris-ResourceList-FilterControl__AppliedFilters",
  "AppliedFilter": "Polaris-ResourceList-FilterControl__AppliedFilter"
};

/** @deprecated Use <Filters /> instead. */

function FilterControl(_ref) {
  var searchValue = _ref.searchValue,
      _ref$appliedFilters = _ref.appliedFilters,
      appliedFilters = _ref$appliedFilters === void 0 ? [] : _ref$appliedFilters,
      additionalAction = _ref.additionalAction,
      _ref$focused = _ref.focused,
      focused = _ref$focused === void 0 ? false : _ref$focused,
      _ref$filters = _ref.filters,
      filters = _ref$filters === void 0 ? [] : _ref$filters,
      placeholder = _ref.placeholder,
      onSearchBlur = _ref.onSearchBlur,
      onSearchChange = _ref.onSearchChange,
      onFiltersChange = _ref.onFiltersChange;
  // eslint-disable-next-line no-console
  console.warn('Deprecation: <FilterControl /> is deprecated. Use <Filters /> instead.');
  var i18n = useI18n();

  var _React$useContext = React__default.useContext(ResourceListContext),
      selectMode = _React$useContext.selectMode,
      resourceName = _React$useContext.resourceName;

  var filterResourceName = resourceName || {
    singular: i18n.translate('Polaris.ResourceList.defaultItemSingular'),
    plural: i18n.translate('Polaris.ResourceList.defaultItemPlural')
  };
  var handleAddFilter = React__default.useCallback(function (newFilter) {
    if (!onFiltersChange) {
      return;
    }

    var foundFilter = appliedFilters.find(function (appliedFilter) {
      return idFromFilter(appliedFilter) === idFromFilter(newFilter);
    });

    if (foundFilter) {
      return;
    }

    var newAppliedFilters = [].concat(_toConsumableArray(appliedFilters), [newFilter]);
    onFiltersChange(newAppliedFilters);
  }, [onFiltersChange, appliedFilters]);
  var handleRemoveFilter = React__default.useCallback(function (filterId) {
    if (!onFiltersChange) {
      return;
    }

    var foundIndex = appliedFilters.findIndex(function (appliedFilter) {
      return idFromFilter(appliedFilter) === filterId;
    });
    var newAppliedFilters = foundIndex >= 0 ? [].concat(_toConsumableArray(appliedFilters.slice(0, foundIndex)), _toConsumableArray(appliedFilters.slice(foundIndex + 1, appliedFilters.length))) : _toConsumableArray(appliedFilters);
    onFiltersChange(newAppliedFilters);
  }, [appliedFilters, onFiltersChange]);
  var getRemoveFilterCallback = React__default.useCallback(function (filterId) {
    return function () {
      handleRemoveFilter(filterId);
    };
  }, [handleRemoveFilter]);
  var textFieldLabel = placeholder ? placeholder : i18n.translate('Polaris.ResourceList.FilterControl.textFieldLabel', {
    resourceNamePlural: filterResourceName.plural.toLocaleLowerCase()
  });

  if (additionalAction) {
    additionalAction.disabled = selectMode;
  }

  var additionalActionButton = additionalAction && buttonsFrom(additionalAction) || null;
  var filterCreatorMarkup = filters.length > 0 ? React__default.createElement(FilterCreator, {
    resourceName: filterResourceName,
    filters: filters,
    onAddFilter: handleAddFilter,
    disabled: selectMode
  }) : null;
  var appliedFiltersMarkup = appliedFilters.map(function (appliedFilter) {
    var activeFilterLabel = getFilterLabel(appliedFilter);
    var filterId = idFromFilter(appliedFilter);
    return React__default.createElement("li", {
      className: styles$1s.AppliedFilter,
      key: filterId
    }, React__default.createElement(Tag, {
      onRemove: getRemoveFilterCallback(filterId),
      disabled: selectMode
    }, activeFilterLabel));
  });
  var appliedFiltersWrapper = appliedFilters.length > 0 ? React__default.createElement("ul", {
    className: styles$1s.AppliedFilters
  }, appliedFiltersMarkup) : null;
  return React__default.createElement(FormLayout, null, React__default.createElement(TextField, {
    connectedLeft: filterCreatorMarkup,
    connectedRight: additionalActionButton,
    label: textFieldLabel,
    labelHidden: true,
    placeholder: textFieldLabel,
    prefix: React__default.createElement(Icon, {
      source: SearchMinor,
      color: "skyDark"
    }),
    value: searchValue,
    onChange: onSearchChange,
    onBlur: onSearchBlur,
    focused: focused,
    disabled: selectMode
  }), appliedFiltersWrapper);

  function getFilterLabel(appliedFilter) {
    var key = appliedFilter.key,
        value = appliedFilter.value,
        label = appliedFilter.label;

    if (label) {
      return label;
    }

    var filter = filters.find(function (filter) {
      var minKey = filter.minKey,
          maxKey = filter.maxKey,
          operatorText = filter.operatorText;

      if (minKey || maxKey) {
        return filter.key === key || minKey === key || maxKey === key;
      }

      if (operatorText && typeof operatorText !== 'string') {
        return filter.key === key || operatorText.filter(function (_ref2) {
          var operatorKey = _ref2.key;
          return operatorKey === key;
        }).length === 1;
      }

      return filter.key === key;
    });

    if (!filter) {
      return value;
    }

    var filterOperatorLabel = findOperatorLabel(filter, appliedFilter);
    var filterLabelByType = findFilterLabelByType(filter, appliedFilter);

    if (!filterOperatorLabel) {
      return "".concat(filter.label, " ").concat(filterLabelByType);
    }

    return "".concat(filter.label, " ").concat(filterOperatorLabel, " ").concat(filterLabelByType);
  }

  function findFilterLabelByType(filter, appliedFilter) {
    var appliedFilterValue = appliedFilter.value;

    if (filter.type === FilterType.Select) {
      var foundFilterOption = filter.options.find(function (option) {
        return typeof option === 'string' ? option === appliedFilterValue : option.value === appliedFilterValue;
      });

      if (foundFilterOption) {
        return typeof foundFilterOption === 'string' ? foundFilterOption : foundFilterOption.label;
      }
    }

    if (filter.type === FilterType.DateSelector) {
      if (filter.key === appliedFilter.key) {
        var filterLabelKey = "Polaris.ResourceList.DateSelector.FilterLabelForValue.".concat(appliedFilter.value);
        return i18n.translationKeyExists(filterLabelKey) ? i18n.translate(filterLabelKey) : appliedFilter.value;
      }

      if (appliedFilter.key === filter.maxKey) {
        return i18n.translate('Polaris.ResourceList.DateSelector.FilterLabelForValue.on_or_before', {
          date: formatDateForLabelDisplay(appliedFilter.value)
        });
      }

      if (appliedFilter.key === filter.minKey) {
        return i18n.translate('Polaris.ResourceList.DateSelector.FilterLabelForValue.on_or_after', {
          date: formatDateForLabelDisplay(appliedFilter.value)
        });
      }
    }

    return appliedFilterValue;
  }
}

function idFromFilter(appliedFilter) {
  return "".concat(appliedFilter.key, "-").concat(appliedFilter.value);
}

function formatDateForLabelDisplay(date) {
  if (isNaN(new Date(date).getTime())) {
    return date;
  }

  return new Date(date.replace(/-/g, '/')).toLocaleDateString();
}

function findOperatorLabel(filter, appliedFilter) {
  var operatorText = filter.operatorText;

  if (filter.type === FilterType.DateSelector && (appliedFilter.key === filter.minKey || appliedFilter.key === filter.maxKey)) {
    return '';
  }

  if (!operatorText || typeof operatorText === 'string') {
    return operatorText;
  }

  var appliedOperator = operatorText.find(function (operator) {
    return operator.key === appliedFilter.key;
  });

  if (appliedOperator) {
    return appliedOperator.filterLabel || appliedOperator.optionLabel;
  }
}

var styles$1t = {
  "FiltersWrapper": "Polaris-ResourceList__FiltersWrapper",
  "ResourceList": "Polaris-ResourceList",
  "HeaderOuterWrapper": "Polaris-ResourceList__HeaderOuterWrapper",
  "HeaderWrapper-disabled": "Polaris-ResourceList__HeaderWrapper--disabled",
  "HeaderWrapper-overlay": "Polaris-ResourceList__HeaderWrapper--overlay",
  "HeaderWrapper": "Polaris-ResourceList__HeaderWrapper",
  "HeaderWrapper-isSticky": "Polaris-ResourceList__HeaderWrapper--isSticky",
  "HeaderContentWrapper": "Polaris-ResourceList__HeaderContentWrapper",
  "HeaderWrapper-inSelectMode": "Polaris-ResourceList__HeaderWrapper--inSelectMode",
  "SortWrapper": "Polaris-ResourceList__SortWrapper",
  "AlternateToolWrapper": "Polaris-ResourceList__AlternateToolWrapper",
  "HeaderWrapper-hasSelect": "Polaris-ResourceList__HeaderWrapper--hasSelect",
  "HeaderWrapper-hasAlternateTool": "Polaris-ResourceList__HeaderWrapper--hasAlternateTool",
  "HeaderWrapper-hasSort": "Polaris-ResourceList__HeaderWrapper--hasSort",
  "HeaderTitleWrapper": "Polaris-ResourceList__HeaderTitleWrapper",
  "BulkActionsWrapper": "Polaris-ResourceList__BulkActionsWrapper",
  "CheckableButtonWrapper": "Polaris-ResourceList__CheckableButtonWrapper",
  "SelectButtonWrapper": "Polaris-ResourceList__SelectButtonWrapper",
  "EmptySearchResultWrapper": "Polaris-ResourceList__EmptySearchResultWrapper",
  "ResourceListWrapper": "Polaris-ResourceList__ResourceListWrapper",
  "ItemWrapper": "Polaris-ResourceList__ItemWrapper",
  "ItemWrapper-isLoading": "Polaris-ResourceList__ItemWrapper--isLoading",
  "SpinnerContainer": "Polaris-ResourceList__SpinnerContainer",
  "LoadingOverlay": "Polaris-ResourceList__LoadingOverlay",
  "DisabledPointerEvents": "Polaris-ResourceList__DisabledPointerEvents",
  "disableTextSelection": "Polaris-ResourceList--disableTextSelection"
};

var SMALL_SCREEN_WIDTH = 458;
var SMALL_SPINNER_HEIGHT = 28;
var LARGE_SPINNER_HEIGHT = 45;

var ResourceList =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ResourceList, _React$Component);

  function ResourceList(props) {
    var _this;

    _classCallCheck(this, ResourceList);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ResourceList).call(this, props));
    _this.listRef = React__default.createRef();
    _this.handleResize = debounce(function () {
      var selectedItems = _this.props.selectedItems;
      var _this$state = _this.state,
          selectMode = _this$state.selectMode,
          smallScreen = _this$state.smallScreen;
      var newSmallScreen = isSmallScreen();

      if (selectedItems && selectedItems.length === 0 && selectMode && !newSmallScreen) {
        _this.handleSelectMode(false);
      }

      if (smallScreen !== newSmallScreen) {
        _this.setState({
          smallScreen: newSmallScreen
        });
      }
    }, 50, {
      leading: true,
      trailing: true,
      maxWait: 50
    });

    _this.setLoadingPosition = function () {
      if (_this.listRef.current != null) {
        if (typeof window === 'undefined') {
          return;
        }

        var overlay = _this.listRef.current.getBoundingClientRect();

        var viewportHeight = Math.max(document.documentElement ? document.documentElement.clientHeight : 0, window.innerHeight || 0);
        var overflow = viewportHeight - overlay.height;
        var spinnerHeight = _this.props.items.length === 1 ? SMALL_SPINNER_HEIGHT : LARGE_SPINNER_HEIGHT;
        var spinnerPosition = overflow > 0 ? (overlay.height - spinnerHeight) / 2 : (viewportHeight - overlay.top - spinnerHeight) / 2;

        _this.setState({
          loadingPosition: spinnerPosition
        });
      }
    };

    _this.handleSelectAllItemsInStore = function () {
      var _this$props = _this.props,
          onSelectionChange = _this$props.onSelectionChange,
          selectedItems = _this$props.selectedItems,
          items = _this$props.items,
          _this$props$idForItem = _this$props.idForItem,
          idForItem = _this$props$idForItem === void 0 ? defaultIdForItem : _this$props$idForItem;
      var newlySelectedItems = selectedItems === SELECT_ALL_ITEMS ? getAllItemsOnPage(items, idForItem) : SELECT_ALL_ITEMS;

      if (onSelectionChange) {
        onSelectionChange(newlySelectedItems);
      }
    };

    _this.renderItem = function (item, index) {
      var _this$props2 = _this.props,
          renderItem = _this$props2.renderItem,
          _this$props2$idForIte = _this$props2.idForItem,
          idForItem = _this$props2$idForIte === void 0 ? defaultIdForItem : _this$props2$idForIte;
      var id = idForItem(item, index);
      return React__default.createElement("li", {
        key: id,
        className: styles$1t.ItemWrapper
      }, renderItem(item, id, index));
    };

    _this.handleMultiSelectionChange = function (lastSelected, currentSelected, resolveItemId) {
      var min = Math.min(lastSelected, currentSelected);
      var max = Math.max(lastSelected, currentSelected);
      return _this.props.items.slice(min, max + 1).map(resolveItemId);
    };

    _this.handleCheckableButtonRegistration = function (key, button) {
      _this.setState(function (_ref) {
        var checkableButtons = _ref.checkableButtons;
        return {
          checkableButtons: new Map(checkableButtons).set(key, button)
        };
      });
    };

    _this.handleSelectionChange = function (selected, id, sortOrder, shiftKey) {
      var _this$props3 = _this.props,
          onSelectionChange = _this$props3.onSelectionChange,
          selectedItems = _this$props3.selectedItems,
          items = _this$props3.items,
          _this$props3$idForIte = _this$props3.idForItem,
          idForItem = _this$props3$idForIte === void 0 ? defaultIdForItem : _this$props3$idForIte,
          resolveItemId = _this$props3.resolveItemId;
      var lastSelected = _this.state.lastSelected;

      if (selectedItems == null || onSelectionChange == null) {
        return;
      }

      var newlySelectedItems = selectedItems === SELECT_ALL_ITEMS ? getAllItemsOnPage(items, idForItem) : _toConsumableArray(selectedItems);

      if (sortOrder !== undefined) {
        _this.setState({
          lastSelected: sortOrder
        });
      }

      var selectedIds = [id];

      if (shiftKey && lastSelected != null && sortOrder !== undefined && resolveItemId) {
        selectedIds = _this.handleMultiSelectionChange(lastSelected, sortOrder, resolveItemId);
      }

      newlySelectedItems = _toConsumableArray(new Set([].concat(_toConsumableArray(newlySelectedItems), _toConsumableArray(selectedIds))));

      if (!selected) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = selectedIds[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var selectedId = _step.value;
            newlySelectedItems.splice(newlySelectedItems.indexOf(selectedId), 1);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return != null) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }

      if (newlySelectedItems.length === 0 && !isSmallScreen()) {
        _this.handleSelectMode(false);
      } else if (newlySelectedItems.length > 0) {
        _this.handleSelectMode(true);
      }

      if (onSelectionChange) {
        onSelectionChange(newlySelectedItems);
      }
    };

    _this.handleSelectMode = function (selectMode) {
      var onSelectionChange = _this.props.onSelectionChange;

      _this.setState({
        selectMode
      });

      if (!selectMode && onSelectionChange) {
        onSelectionChange([]);
      }
    };

    _this.handleToggleAll = function () {
      var _this$props4 = _this.props,
          onSelectionChange = _this$props4.onSelectionChange,
          selectedItems = _this$props4.selectedItems,
          items = _this$props4.items,
          _this$props4$idForIte = _this$props4.idForItem,
          idForItem = _this$props4$idForIte === void 0 ? defaultIdForItem : _this$props4$idForIte;
      var checkableButtons = _this.state.checkableButtons;
      var newlySelectedItems = [];

      if (Array.isArray(selectedItems) && selectedItems.length === items.length || selectedItems === SELECT_ALL_ITEMS) {
        newlySelectedItems = [];
      } else {
        newlySelectedItems = items.map(function (item, index) {
          var id = idForItem(item, index);
          return id;
        });
      }

      if (newlySelectedItems.length === 0 && !isSmallScreen()) {
        _this.handleSelectMode(false);
      } else if (newlySelectedItems.length > 0) {
        _this.handleSelectMode(true);
      }

      var checkbox;

      if (isSmallScreen()) {
        checkbox = checkableButtons.get('bulkSm');
      } else if (newlySelectedItems.length === 0) {
        checkbox = checkableButtons.get('plain');
      } else {
        checkbox = checkableButtons.get('bulkLg');
      }

      if (onSelectionChange) {
        onSelectionChange(newlySelectedItems);
      } // setTimeout ensures execution after the Transition on BulkActions


      setTimeout(function () {
        checkbox && checkbox.focus();
      }, 0);
    };

    var selectedItems = props.selectedItems,
        intl = props.polaris.intl;
    _this.defaultResourceName = {
      singular: intl.translate('Polaris.ResourceList.defaultItemSingular'),
      plural: intl.translate('Polaris.ResourceList.defaultItemPlural')
    }; // eslint-disable-next-line react/state-in-constructor

    _this.state = {
      selectMode: Boolean(selectedItems && selectedItems.length > 0),
      loadingPosition: 0,
      lastSelected: null,
      smallScreen: isSmallScreen(),
      checkableButtons: new Map()
    };
    return _this;
  }

  _createClass(ResourceList, [{
    key: "selectable",
    value: function selectable() {
      var _this$props5 = this.props,
          promotedBulkActions = _this$props5.promotedBulkActions,
          bulkActions = _this$props5.bulkActions,
          selectable = _this$props5.selectable;
      return Boolean(promotedBulkActions && promotedBulkActions.length > 0 || bulkActions && bulkActions.length > 0 || selectable);
    }
  }, {
    key: "bulkSelectState",
    value: function bulkSelectState() {
      var _this$props6 = this.props,
          selectedItems = _this$props6.selectedItems,
          items = _this$props6.items;
      var selectState = 'indeterminate';

      if (!selectedItems || Array.isArray(selectedItems) && selectedItems.length === 0) {
        selectState = false;
      } else if (selectedItems === SELECT_ALL_ITEMS || Array.isArray(selectedItems) && selectedItems.length === items.length) {
        selectState = true;
      }

      return selectState;
    }
  }, {
    key: "headerTitle",
    value: function headerTitle() {
      var _this$props7 = this.props,
          _this$props7$resource = _this$props7.resourceName,
          resourceName = _this$props7$resource === void 0 ? this.defaultResourceName : _this$props7$resource,
          items = _this$props7.items,
          intl = _this$props7.polaris.intl,
          loading = _this$props7.loading,
          totalItemsCount = _this$props7.totalItemsCount;
      var itemsCount = items.length;
      var resource = !loading && (!totalItemsCount && itemsCount === 1 || totalItemsCount === 1) ? resourceName.singular : resourceName.plural;

      if (loading) {
        return intl.translate('Polaris.ResourceList.loading', {
          resource
        });
      } else if (totalItemsCount) {
        return intl.translate('Polaris.ResourceList.showingTotalCount', {
          itemsCount,
          totalItemsCount,
          resource
        });
      } else {
        return intl.translate('Polaris.ResourceList.showing', {
          itemsCount,
          resource
        });
      }
    }
  }, {
    key: "bulkActionsLabel",
    value: function bulkActionsLabel() {
      var _this$props8 = this.props,
          _this$props8$selected = _this$props8.selectedItems,
          selectedItems = _this$props8$selected === void 0 ? [] : _this$props8$selected,
          items = _this$props8.items,
          intl = _this$props8.polaris.intl;
      var selectedItemsCount = selectedItems === SELECT_ALL_ITEMS ? "".concat(items.length, "+") : selectedItems.length;
      return intl.translate('Polaris.ResourceList.selected', {
        selectedItemsCount
      });
    }
  }, {
    key: "bulkActionsAccessibilityLabel",
    value: function bulkActionsAccessibilityLabel() {
      var _this$props9 = this.props,
          _this$props9$resource = _this$props9.resourceName,
          resourceName = _this$props9$resource === void 0 ? this.defaultResourceName : _this$props9$resource,
          _this$props9$selected = _this$props9.selectedItems,
          selectedItems = _this$props9$selected === void 0 ? [] : _this$props9$selected,
          items = _this$props9.items,
          intl = _this$props9.polaris.intl;
      var selectedItemsCount = selectedItems.length;
      var totalItemsCount = items.length;
      var allSelected = selectedItemsCount === totalItemsCount;

      if (totalItemsCount === 1 && allSelected) {
        return intl.translate('Polaris.ResourceList.a11yCheckboxDeselectAllSingle', {
          resourceNameSingular: resourceName.singular
        });
      } else if (totalItemsCount === 1) {
        return intl.translate('Polaris.ResourceList.a11yCheckboxSelectAllSingle', {
          resourceNameSingular: resourceName.singular
        });
      } else if (allSelected) {
        return intl.translate('Polaris.ResourceList.a11yCheckboxDeselectAllMultiple', {
          itemsLength: items.length,
          resourceNamePlural: resourceName.plural
        });
      } else {
        return intl.translate('Polaris.ResourceList.a11yCheckboxSelectAllMultiple', {
          itemsLength: items.length,
          resourceNamePlural: resourceName.plural
        });
      }
    }
  }, {
    key: "paginatedSelectAllText",
    value: function paginatedSelectAllText() {
      var _this$props10 = this.props,
          hasMoreItems = _this$props10.hasMoreItems,
          selectedItems = _this$props10.selectedItems,
          items = _this$props10.items,
          _this$props10$resourc = _this$props10.resourceName,
          resourceName = _this$props10$resourc === void 0 ? this.defaultResourceName : _this$props10$resourc,
          intl = _this$props10.polaris.intl;

      if (!this.selectable() || !hasMoreItems) {
        return;
      }

      if (selectedItems === SELECT_ALL_ITEMS) {
        return intl.translate('Polaris.ResourceList.allItemsSelected', {
          itemsLength: items.length,
          resourceNamePlural: resourceName.plural
        });
      }
    }
  }, {
    key: "paginatedSelectAllAction",
    value: function paginatedSelectAllAction() {
      var _this$props11 = this.props,
          hasMoreItems = _this$props11.hasMoreItems,
          selectedItems = _this$props11.selectedItems,
          items = _this$props11.items,
          _this$props11$resourc = _this$props11.resourceName,
          resourceName = _this$props11$resourc === void 0 ? this.defaultResourceName : _this$props11$resourc,
          intl = _this$props11.polaris.intl;

      if (!this.selectable() || !hasMoreItems) {
        return;
      }

      var actionText = selectedItems === SELECT_ALL_ITEMS ? intl.translate('Polaris.Common.undo') : intl.translate('Polaris.ResourceList.selectAllItems', {
        itemsLength: items.length,
        resourceNamePlural: resourceName.plural
      });
      return {
        content: actionText,
        onAction: this.handleSelectAllItemsInStore
      };
    }
  }, {
    key: "emptySearchResultText",
    value: function emptySearchResultText() {
      var _this$props12 = this.props,
          intl = _this$props12.polaris.intl,
          _this$props12$resourc = _this$props12.resourceName,
          resourceName = _this$props12$resourc === void 0 ? this.defaultResourceName : _this$props12$resourc;
      return {
        title: intl.translate('Polaris.ResourceList.emptySearchResultTitle', {
          resourceNamePlural: resourceName.plural
        }),
        description: intl.translate('Polaris.ResourceList.emptySearchResultDescription')
      };
    } // eslint-disable-next-line @typescript-eslint/member-ordering

  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.forceUpdate();

      if (this.props.loading) {
        this.setLoadingPosition();
      }
    } // eslint-disable-next-line @typescript-eslint/member-ordering

  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref2) {
      var prevLoading = _ref2.loading,
          prevItems = _ref2.items,
          prevSelectedItems = _ref2.selectedItems;
      var _this$props13 = this.props,
          selectedItems = _this$props13.selectedItems,
          loading = _this$props13.loading;

      if (this.listRef.current && this.itemsExist() && !this.itemsExist(prevItems)) {
        this.forceUpdate();
      }

      if (loading && !prevLoading) {
        this.setLoadingPosition();
      }

      if (selectedItems && selectedItems.length > 0 && !this.state.selectMode) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          selectMode: true
        });
        return;
      }

      if (prevSelectedItems && prevSelectedItems.length > 0 && (!selectedItems || selectedItems.length === 0) && !isSmallScreen()) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          selectMode: false
        });
      }
    } // eslint-disable-next-line @typescript-eslint/member-ordering

  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props14 = this.props,
          items = _this$props14.items,
          promotedBulkActions = _this$props14.promotedBulkActions,
          bulkActions = _this$props14.bulkActions,
          filterControl = _this$props14.filterControl,
          loading = _this$props14.loading,
          _this$props14$showHea = _this$props14.showHeader,
          showHeader = _this$props14$showHea === void 0 ? false : _this$props14$showHea,
          sortOptions = _this$props14.sortOptions,
          sortValue = _this$props14.sortValue,
          alternateTool = _this$props14.alternateTool,
          selectedItems = _this$props14.selectedItems,
          _this$props14$resourc = _this$props14.resourceName,
          resourceName = _this$props14$resourc === void 0 ? this.defaultResourceName : _this$props14$resourc,
          onSortChange = _this$props14.onSortChange,
          intl = _this$props14.polaris.intl;
      var _this$state2 = this.state,
          selectMode = _this$state2.selectMode,
          loadingPosition = _this$state2.loadingPosition,
          smallScreen = _this$state2.smallScreen;
      var filterControlMarkup = filterControl ? React__default.createElement("div", {
        className: styles$1t.FiltersWrapper
      }, filterControl) : null;
      var bulkActionsMarkup = this.selectable() ? React__default.createElement("div", {
        className: styles$1t.BulkActionsWrapper
      }, React__default.createElement(BulkActions$1, {
        label: this.bulkActionsLabel(),
        accessibilityLabel: this.bulkActionsAccessibilityLabel(),
        selected: this.bulkSelectState(),
        onToggleAll: this.handleToggleAll,
        selectMode: selectMode,
        onSelectModeToggle: this.handleSelectMode,
        promotedActions: promotedBulkActions,
        paginatedSelectAllAction: this.paginatedSelectAllAction(),
        paginatedSelectAllText: this.paginatedSelectAllText(),
        actions: bulkActions,
        disabled: loading,
        smallScreen: smallScreen
      })) : null;
      var sortingSelectMarkup = sortOptions && sortOptions.length > 0 && !alternateTool ? React__default.createElement("div", {
        className: styles$1t.SortWrapper
      }, React__default.createElement(Select, {
        label: intl.translate('Polaris.ResourceList.sortingLabel'),
        labelInline: !smallScreen,
        labelHidden: smallScreen,
        options: sortOptions,
        onChange: onSortChange,
        value: sortValue,
        disabled: selectMode
      })) : null;
      var alternateToolMarkup = alternateTool && !sortingSelectMarkup ? React__default.createElement("div", {
        className: styles$1t.AlternateToolWrapper
      }, alternateTool) : null;
      var headerTitleMarkup = React__default.createElement("div", {
        className: styles$1t.HeaderTitleWrapper
      }, this.headerTitle());
      var selectButtonMarkup = this.selectable() ? React__default.createElement("div", {
        className: styles$1t.SelectButtonWrapper
      }, React__default.createElement(Button, {
        disabled: selectMode,
        icon: EnableSelectionMinor,
        onClick: this.handleSelectMode.bind(this, true)
      }, intl.translate('Polaris.ResourceList.selectButtonText'))) : null;
      var checkableButtonMarkup = this.selectable() ? React__default.createElement("div", {
        className: styles$1t.CheckableButtonWrapper
      }, React__default.createElement(CheckableButton, {
        accessibilityLabel: this.bulkActionsAccessibilityLabel(),
        label: this.headerTitle(),
        onToggleAll: this.handleToggleAll,
        plain: true,
        disabled: loading
      })) : null;
      var needsHeader = this.selectable() || sortOptions && sortOptions.length > 0 || alternateTool;
      var headerWrapperOverlay = loading ? React__default.createElement("div", {
        className: styles$1t['HeaderWrapper-overlay']
      }) : null;
      var showEmptyState = filterControl && !this.itemsExist() && !loading;
      var headerMarkup = !showEmptyState && (showHeader || needsHeader) && this.listRef.current && React__default.createElement("div", {
        className: styles$1t.HeaderOuterWrapper
      }, React__default.createElement(Sticky$1, {
        boundingElement: this.listRef.current
      }, function (isSticky) {
        var headerClassName = classNames(styles$1t.HeaderWrapper, sortOptions && sortOptions.length > 0 && !alternateTool && styles$1t['HeaderWrapper-hasSort'], alternateTool && styles$1t['HeaderWrapper-hasAlternateTool'], _this2.selectable() && styles$1t['HeaderWrapper-hasSelect'], loading && styles$1t['HeaderWrapper-disabled'], _this2.selectable() && selectMode && styles$1t['HeaderWrapper-inSelectMode'], isSticky && styles$1t['HeaderWrapper-isSticky']);
        return React__default.createElement("div", {
          className: headerClassName
        }, React__default.createElement(EventListener, {
          event: "resize",
          handler: _this2.handleResize
        }), headerWrapperOverlay, React__default.createElement("div", {
          className: styles$1t.HeaderContentWrapper
        }, headerTitleMarkup, checkableButtonMarkup, alternateToolMarkup, sortingSelectMarkup, selectButtonMarkup), bulkActionsMarkup);
      }));
      var emptyStateMarkup = showEmptyState ? React__default.createElement("div", {
        className: styles$1t.EmptySearchResultWrapper
      }, React__default.createElement(EmptySearchResult, Object.assign({}, this.emptySearchResultText(), {
        withIllustration: true
      }))) : null;
      var defaultTopPadding = 8;
      var topPadding = loadingPosition > 0 ? loadingPosition : defaultTopPadding;
      var spinnerStyle = {
        paddingTop: "".concat(topPadding, "px")
      };
      var spinnerSize = items.length < 2 ? 'small' : 'large';
      var loadingOverlay = loading ? React__default.createElement(React__default.Fragment, null, React__default.createElement("div", {
        className: styles$1t.SpinnerContainer,
        style: spinnerStyle
      }, React__default.createElement(Spinner, {
        size: spinnerSize,
        accessibilityLabel: "Items are loading"
      })), React__default.createElement("div", {
        className: styles$1t.LoadingOverlay
      })) : null;
      var className = classNames(styles$1t.ItemWrapper, loading && styles$1t['ItemWrapper-isLoading']);
      var loadingWithoutItemsMarkup = loading && !this.itemsExist() ? React__default.createElement("div", {
        className: className,
        tabIndex: -1
      }, loadingOverlay) : null;
      var resourceListClassName = classNames(styles$1t.ResourceList, loading && styles$1t.disabledPointerEvents, selectMode && styles$1t.disableTextSelection);
      var listMarkup = this.itemsExist() ? React__default.createElement("ul", {
        className: resourceListClassName,
        ref: this.listRef,
        "aria-live": "polite",
        "aria-busy": loading
      }, loadingOverlay, items.map(this.renderItem)) : emptyStateMarkup;
      var context = {
        selectable: this.selectable(),
        selectedItems,
        selectMode,
        resourceName,
        loading,
        onSelectionChange: this.handleSelectionChange,
        registerCheckableButtons: this.handleCheckableButtonRegistration
      };
      return React__default.createElement(ResourceListContext.Provider, {
        value: context
      }, React__default.createElement("div", {
        className: styles$1t.ResourceListWrapper
      }, filterControlMarkup, headerMarkup, listMarkup, loadingWithoutItemsMarkup));
    }
  }, {
    key: "itemsExist",
    value: function itemsExist(items) {
      return (items || this.props.items).length > 0;
    }
  }]);

  return ResourceList;
}(React__default.Component);

ResourceList.Item = ResourceItem; // eslint-disable-next-line import/no-deprecated

ResourceList.FilterControl = FilterControl;

function getAllItemsOnPage(items, idForItem) {
  return items.map(function (item, index) {
    return idForItem(item, index);
  });
}

function defaultIdForItem(item, index) {
  return Object.prototype.hasOwnProperty.call(item, 'id') ? item.id : index.toString();
}

function isSmallScreen() {
  return typeof window === 'undefined' ? false : window.innerWidth < SMALL_SCREEN_WIDTH;
} // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var ResourceList$1 = withAppProvider()(ResourceList);

/** @deprecated Use `ResourcePicker` from `@shopify/app-bridge-react` instead. */

var ResourcePicker =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(ResourcePicker, _React$PureComponent);

  function ResourcePicker() {
    var _this;

    _classCallCheck(this, ResourcePicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ResourcePicker).apply(this, arguments));
    _this.focusReturnPoint = null;
    return _this;
  }

  _createClass(ResourcePicker, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      // eslint-disable-next-line no-console
      console.warn('Deprecation: `ResourcePicker` is deprecated and will be removed in v5.0. Use `ResourcePicker` from `@shopify/app-bridge-react` instead: https://help.shopify.com/en/api/embedded-apps/app-bridge/react-components/resourcepicker');

      if (this.props.polaris.appBridge == null) {
        return;
      }

      var _this$props = this.props,
          open = _this$props.open,
          resourceType = _this$props.resourceType,
          initialQuery = _this$props.initialQuery,
          _this$props$showHidde = _this$props.showHidden,
          showHidden = _this$props$showHidde === void 0 ? true : _this$props$showHidde,
          _this$props$allowMult = _this$props.allowMultiple,
          allowMultiple = _this$props$allowMult === void 0 ? true : _this$props$allowMult,
          _this$props$showVaria = _this$props.showVariants,
          showVariants = _this$props$showVaria === void 0 ? true : _this$props$showVaria,
          onSelection = _this$props.onSelection,
          onCancel = _this$props.onCancel;
      var appBridge = this.props.polaris.appBridge;
      this.appBridgeResourcePicker = ResourcePicker$2.create(appBridge, {
        resourceType: ResourcePicker$2.ResourceType[resourceType],
        options: {
          initialQuery,
          showHidden,
          selectMultiple: allowMultiple,
          showVariants
        }
      });

      if (onSelection != null) {
        this.appBridgeResourcePicker.subscribe(ResourcePicker$2.Action.SELECT, function (_ref) {
          var selection = _ref.selection;
          onSelection({
            selection
          });
        });
      }

      if (onCancel != null) {
        this.appBridgeResourcePicker.subscribe(ResourcePicker$2.Action.CANCEL, onCancel);
      }

      if (open) {
        this.focusReturnPoint = document.activeElement;
        this.appBridgeResourcePicker.dispatch(ResourcePicker$2.Action.OPEN);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.appBridgeResourcePicker == null) {
        return;
      }

      var _this$props2 = this.props,
          open = _this$props2.open,
          initialQuery = _this$props2.initialQuery,
          _this$props2$showHidd = _this$props2.showHidden,
          showHidden = _this$props2$showHidd === void 0 ? false : _this$props2$showHidd,
          _this$props2$allowMul = _this$props2.allowMultiple,
          allowMultiple = _this$props2$allowMul === void 0 ? true : _this$props2$allowMul,
          _this$props2$showVari = _this$props2.showVariants,
          showVariants = _this$props2$showVari === void 0 ? true : _this$props2$showVari,
          onSelection = _this$props2.onSelection,
          onCancel = _this$props2.onCancel;
      var wasOpen = prevProps.open;

      var prevAppBridge = prevProps.polaris.appBridge,
          prevResourcePickerProps = __rest(prevProps, ["polaris"]);

      var _a = this.props,
          appBridge = _a.polaris.appBridge,
          resourcePickerProps = __rest(_a, ["polaris"]);

      if (!isEqual(prevResourcePickerProps, resourcePickerProps) || !isEqual(prevAppBridge, appBridge)) {
        this.appBridgeResourcePicker.set({
          initialQuery,
          showHidden,
          selectMultiple: allowMultiple,
          showVariants
        });
      }

      this.appBridgeResourcePicker.unsubscribe();

      if (onSelection != null) {
        this.appBridgeResourcePicker.subscribe(ResourcePicker$2.Action.SELECT, function (_ref2) {
          var selection = _ref2.selection;
          onSelection({
            selection
          });
        });
      }

      if (onCancel != null) {
        this.appBridgeResourcePicker.subscribe(ResourcePicker$2.Action.CANCEL, onCancel);
      }

      if (wasOpen !== open) {
        if (open) {
          this.appBridgeResourcePicker.dispatch(ResourcePicker$2.Action.OPEN);
        } else {
          this.appBridgeResourcePicker.dispatch(ResourcePicker$2.Action.CLOSE);
        }
      }

      if (!wasOpen && open) {
        this.focusReturnPoint = document.activeElement;
      } else if (wasOpen && !open && this.focusReturnPoint != null && document.contains(this.focusReturnPoint)) {
        this.focusReturnPoint.focus();
        this.focusReturnPoint = null;
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.appBridgeResourcePicker == null) {
        return;
      }

      this.appBridgeResourcePicker.unsubscribe();
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return ResourcePicker;
}(React__default.PureComponent); // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var ResourcePicker$1 = withAppProvider()(ResourcePicker);

function SettingToggle(_ref) {
  var enabled = _ref.enabled,
      action = _ref.action,
      children = _ref.children;
  var actionMarkup = action ? buttonFrom(action, {
    primary: !enabled
  }) : null;
  return React__default.createElement(Card, {
    sectioned: true
  }, React__default.createElement(SettingAction, {
    action: actionMarkup
  }, children));
}

var styles$1u = {
  "SkeletonBodyTextContainer": "Polaris-SkeletonBodyText__SkeletonBodyTextContainer",
  "SkeletonBodyText": "Polaris-SkeletonBodyText"
};

function SkeletonBodyText(_ref) {
  var _ref$lines = _ref.lines,
      lines = _ref$lines === void 0 ? 3 : _ref$lines;
  var bodyTextLines = [];

  for (var i = 0; i < lines; i++) {
    bodyTextLines.push(React__default.createElement("div", {
      className: styles$1u.SkeletonBodyText,
      key: i
    }));
  }

  return React__default.createElement("div", {
    className: styles$1u.SkeletonBodyTextContainer
  }, bodyTextLines);
}

var styles$1v = {
  "DisplayText": "Polaris-SkeletonDisplayText__DisplayText",
  "sizeSmall": "Polaris-SkeletonDisplayText--sizeSmall",
  "sizeMedium": "Polaris-SkeletonDisplayText--sizeMedium",
  "sizeLarge": "Polaris-SkeletonDisplayText--sizeLarge",
  "sizeExtraLarge": "Polaris-SkeletonDisplayText--sizeExtraLarge"
};

function SkeletonDisplayText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = classNames(styles$1v.DisplayText, size && styles$1v[variationName('size', size)]);
  return React__default.createElement("div", {
    className: className
  });
}

var styles$1w = {
  "Page": "Polaris-SkeletonPage__Page",
  "fullWidth": "Polaris-SkeletonPage--fullWidth",
  "narrowWidth": "Polaris-SkeletonPage--narrowWidth",
  "Content": "Polaris-SkeletonPage__Content",
  "Header": "Polaris-SkeletonPage__Header",
  "Header-hasSecondaryActions": "Polaris-SkeletonPage__Header--hasSecondaryActions",
  "BreadcrumbAction": "Polaris-SkeletonPage__BreadcrumbAction",
  "TitleAndPrimaryAction": "Polaris-SkeletonPage__TitleAndPrimaryAction",
  "Title": "Polaris-SkeletonPage__Title",
  "PrimaryAction": "Polaris-SkeletonPage__PrimaryAction",
  "Actions": "Polaris-SkeletonPage__Actions",
  "Action": "Polaris-SkeletonPage__Action"
};

function SkeletonPage(_ref) {
  var children = _ref.children,
      fullWidth = _ref.fullWidth,
      narrowWidth = _ref.narrowWidth,
      singleColumn = _ref.singleColumn,
      primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      breadcrumbs = _ref.breadcrumbs;

  if (singleColumn) {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: The singleColumn prop has been renamed to narrowWidth to better represents its use and will be removed in v5.0.');
  }

  var i18n = useI18n();
  var appBridge = useAppBridge();
  var className = classNames(styles$1w.Page, fullWidth && styles$1w.fullWidth, (narrowWidth || singleColumn) && styles$1w.narrowWidth);
  var headerClassName = classNames(styles$1w.Header, breadcrumbs && styles$1w['Header-hasBreadcrumbs'], secondaryActions && styles$1w['Header-hasSecondaryActions']);
  var titleMarkup = title !== null ? renderTitle(title) : null;
  var primaryActionMarkup = primaryAction ? React__default.createElement("div", {
    className: styles$1w.PrimaryAction
  }, React__default.createElement(SkeletonDisplayText, {
    size: "large"
  })) : null;
  var secondaryActionsMarkup = secondaryActions ? renderSecondaryActions(secondaryActions) : null;
  var breadcrumbMarkup = breadcrumbs ? React__default.createElement("div", {
    className: styles$1w.BreadcrumbAction,
    style: {
      width: 60
    }
  }, React__default.createElement(SkeletonBodyText, {
    lines: 1
  })) : null;
  var headerMarkup = !appBridge ? React__default.createElement("div", {
    className: headerClassName
  }, breadcrumbMarkup, React__default.createElement("div", {
    className: styles$1w.TitleAndPrimaryAction
  }, titleMarkup, primaryActionMarkup), secondaryActionsMarkup) : null;
  return React__default.createElement("div", {
    className: className,
    role: "status",
    "aria-label": i18n.translate('Polaris.SkeletonPage.loadingLabel')
  }, headerMarkup, React__default.createElement("div", {
    className: styles$1w.Content
  }, children));
}

function renderSecondaryActions(actionCount) {
  var actions = [];

  for (var i = 0; i < actionCount; i++) {
    var width = Math.round(Math.random() * 40 + 60);
    actions.push(React__default.createElement("div", {
      className: styles$1w.Action,
      style: {
        width
      },
      key: i
    }, React__default.createElement(SkeletonBodyText, {
      lines: 1
    })));
  }

  return React__default.createElement("div", {
    className: styles$1w.Actions
  }, actions);
}

function renderTitle(title) {
  var titleContent = title === '' ? React__default.createElement(SkeletonDisplayText, {
    size: "large"
  }) : React__default.createElement(DisplayText, {
    size: "large",
    element: "h1"
  }, title);
  return React__default.createElement("div", {
    className: styles$1w.Title
  }, titleContent);
}

var styles$1x = {
  "SkeletonThumbnail": "Polaris-SkeletonThumbnail",
  "sizeSmall": "Polaris-SkeletonThumbnail--sizeSmall",
  "sizeMedium": "Polaris-SkeletonThumbnail--sizeMedium",
  "sizeLarge": "Polaris-SkeletonThumbnail--sizeLarge"
};

function SkeletonThumbnail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = classNames(styles$1x.SkeletonThumbnail, size && styles$1x[variationName('size', size)]);
  return React__default.createElement("div", {
    className: className
  });
}

function getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth) {
  var sumTabWidths = tabWidths.reduce(function (sum, width) {
    return sum + width;
  }, 0);
  var arrayOfTabIndices = tabs.map(function (_, index) {
    return index;
  });
  var visibleTabs = [];
  var hiddenTabs = [];

  if (containerWidth > sumTabWidths) {
    visibleTabs.push.apply(visibleTabs, _toConsumableArray(arrayOfTabIndices));
  } else {
    visibleTabs.push(selected);
    var tabListWidth = tabWidths[selected];
    arrayOfTabIndices.forEach(function (currentTabIndex) {
      if (currentTabIndex !== selected) {
        var currentTabWidth = tabWidths[currentTabIndex];

        if (tabListWidth + currentTabWidth > containerWidth - disclosureWidth) {
          hiddenTabs.push(currentTabIndex);
          return;
        }

        visibleTabs.push(currentTabIndex);
        tabListWidth += currentTabWidth;
      }
    });
  }

  return {
    visibleTabs,
    hiddenTabs
  };
}

var styles$1y = {
  "Tabs": "Polaris-Tabs",
  "fitted": "Polaris-Tabs--fitted",
  "TabContainer": "Polaris-Tabs__TabContainer",
  "Tab": "Polaris-Tabs__Tab",
  "Title": "Polaris-Tabs__Title",
  "fillSpace": "Polaris-Tabs--fillSpace",
  "Tab-selected": "Polaris-Tabs__Tab--selected",
  "Panel": "Polaris-Tabs__Panel",
  "Panel-hidden": "Polaris-Tabs__Panel--hidden",
  "List": "Polaris-Tabs__List",
  "Item": "Polaris-Tabs__Item",
  "DisclosureTab": "Polaris-Tabs__DisclosureTab",
  "DisclosureTab-visible": "Polaris-Tabs__DisclosureTab--visible",
  "DisclosureActivator": "Polaris-Tabs__DisclosureActivator",
  "TabMeasurer": "Polaris-Tabs__TabMeasurer"
};

var Item$8 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Item, _React$PureComponent);

  function Item() {
    var _this;

    _classCallCheck(this, Item);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Item).apply(this, arguments));
    _this.focusedNode = null;

    _this.setFocusedNode = function (node) {
      _this.focusedNode = node;
    };

    return _this;
  }

  _createClass(Item, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var focusedNode = this.focusedNode;
      var focused = this.props.focused;

      if (focusedNode && focusedNode instanceof HTMLElement && focused) {
        focusedNode.focus();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var focusedNode = this.focusedNode;
      var focused = this.props.focused;

      if (focusedNode && focusedNode instanceof HTMLElement && focused) {
        focusedNode.focus();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          panelID = _this$props.panelID,
          children = _this$props.children,
          url = _this$props.url,
          accessibilityLabel = _this$props.accessibilityLabel,
          _this$props$onClick = _this$props.onClick,
          onClick = _this$props$onClick === void 0 ? noop$c : _this$props$onClick;
      var sharedProps = {
        id,
        ref: this.setFocusedNode,
        onClick,
        className: styles$1y.Item,
        'aria-controls': panelID,
        'aria-selected': false,
        'aria-label': accessibilityLabel
      };
      var markup = url ? React__default.createElement(UnstyledLink, Object.assign({}, sharedProps, {
        url: url
      }), children) : React__default.createElement("button", Object.assign({}, sharedProps, {
        type: "button"
      }), children);
      return React__default.createElement("li", null, markup);
    }
  }]);

  return Item;
}(React__default.PureComponent);

function noop$c() {}

var List$1 =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(List, _React$PureComponent);

  function List() {
    var _this;

    _classCallCheck(this, List);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(List).apply(this, arguments));

    _this.handleKeypress = function (event) {
      var _this$props$onKeyPres = _this.props.onKeyPress,
          onKeyPress = _this$props$onKeyPres === void 0 ? noop$d : _this$props$onKeyPres;
      onKeyPress(event);
    };

    return _this;
  }

  _createClass(List, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          focusIndex = _this$props.focusIndex,
          disclosureTabs = _this$props.disclosureTabs,
          _this$props$onClick = _this$props.onClick,
          onClick = _this$props$onClick === void 0 ? noop$d : _this$props$onClick;
      var tabs = disclosureTabs.map(function (_a, index) {
        var id = _a.id,
            content = _a.content,
            tabProps = __rest(_a, ["id", "content"]);

        return React__default.createElement(Item$8, Object.assign({}, tabProps, {
          key: id,
          id: id,
          focused: index === focusIndex,
          onClick: onClick.bind(null, id)
        }), content);
      });
      return React__default.createElement("ul", {
        className: styles$1y.List,
        onKeyDown: handleKeyDown$1,
        onKeyUp: this.handleKeypress
      }, tabs);
    }
  }]);

  return List;
}(React__default.PureComponent);

function noop$d() {}

function handleKeyDown$1(event) {
  var key = event.key;

  if (key === 'ArrowUp' || key === 'ArrowDown' || key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
}

function Panel(_ref) {
  var hidden = _ref.hidden,
      id = _ref.id,
      tabID = _ref.tabID,
      children = _ref.children;
  var className = classNames(styles$1y.Panel, hidden && styles$1y['Panel-hidden']);
  return React__default.createElement("div", {
    className: className,
    id: id,
    role: "tabpanel",
    "aria-labelledby": tabID,
    tabIndex: -1
  }, children);
}

function Tab(_ref) {
  var id = _ref.id,
      focused = _ref.focused,
      siblingTabHasFocus = _ref.siblingTabHasFocus,
      children = _ref.children,
      onClick = _ref.onClick,
      selected = _ref.selected,
      url = _ref.url,
      panelID = _ref.panelID,
      measuring = _ref.measuring,
      accessibilityLabel = _ref.accessibilityLabel;
  var wasSelected = useRef(selected);
  var panelFocused = useRef(false);
  var node = useRef(null); // A tab can start selected when it is moved from the disclosure dropdown
  // into the main list, so we need to send focus from the tab to the panel
  // on mount and update

  useEffect(function () {
    if (measuring) {
      return;
    } // Because of timing issues with the render, we may still have the old,
    // in-disclosure version of the tab that has focus. Check for this
    // as a second indicator of focus


    var itemHadFocus = focused || document.activeElement && document.activeElement.id === id; // If we just check for selected, the panel for the active tab will
    // be focused on page load, which we don’t want

    if (itemHadFocus && selected && panelID != null && !panelFocused.current) {
      focusPanelID(panelID);
      panelFocused.current = true;
    }

    if (selected && !wasSelected.current && panelID != null) {
      focusPanelID(panelID);
    } else if (focused && node.current != null) {
      focusFirstFocusableNode(node.current);
    }

    wasSelected.current = selected;
  }, [focused, id, measuring, panelID, selected]);
  var handleClick = onClick && onClick.bind(null, id);
  var className = classNames(styles$1y.Tab, selected && styles$1y['Tab-selected']);
  var tabIndex;

  if (selected && !siblingTabHasFocus && !measuring) {
    tabIndex = 0;
  } else if (focused && !measuring) {
    tabIndex = 0;
  } else {
    tabIndex = -1;
  }

  var markup = url ? React__default.createElement(UnstyledLink, {
    id: id,
    url: url,
    role: "tab",
    tabIndex: tabIndex,
    onClick: handleClick,
    className: className,
    "aria-selected": selected,
    "aria-controls": panelID,
    "aria-label": accessibilityLabel,
    onMouseUp: handleMouseUpByBlurring
  }, React__default.createElement("span", {
    className: styles$1y.Title
  }, children)) : React__default.createElement("button", {
    id: id,
    role: "tab",
    type: "button",
    tabIndex: tabIndex,
    className: className,
    onClick: handleClick,
    "aria-selected": selected,
    "aria-controls": panelID,
    "aria-label": accessibilityLabel,
    onMouseUp: handleMouseUpByBlurring
  }, React__default.createElement("span", {
    className: styles$1y.Title
  }, children));
  return React__default.createElement("li", {
    className: styles$1y.TabContainer,
    ref: node
  }, markup);
}

function focusPanelID(panelID) {
  var panel = document.getElementById(panelID);

  if (panel) {
    panel.focus({
      preventScroll: true
    });
  }
}

var TabMeasurer =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(TabMeasurer, _React$PureComponent);

  function TabMeasurer() {
    var _this;

    _classCallCheck(this, TabMeasurer);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TabMeasurer).apply(this, arguments));
    _this.containerNode = React__default.createRef();
    _this.animationFrame = null;

    _this.handleMeasurement = function () {
      if (_this.animationFrame) {
        cancelAnimationFrame(_this.animationFrame);
      }

      _this.animationFrame = requestAnimationFrame(function () {
        if (!_this.containerNode.current) {
          return;
        }

        var handleMeasurement = _this.props.handleMeasurement;
        var containerWidth = _this.containerNode.current.offsetWidth;
        var hiddenTabNodes = _this.containerNode.current.children;
        var hiddenTabNodesArray = Array.from(hiddenTabNodes);
        var hiddenTabWidths = hiddenTabNodesArray.map(function (node) {
          return node.getBoundingClientRect().width;
        });
        var disclosureWidth = hiddenTabWidths.pop();
        handleMeasurement({
          containerWidth,
          disclosureWidth,
          hiddenTabWidths
        });
      });
    };

    return _this;
  }

  _createClass(TabMeasurer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.handleMeasurement();

      if (process.env.NODE_ENV === 'development') {
        // We need to defer the calculation in development so the
        // styles have time to be injected.
        setTimeout(this.handleMeasurement, 0);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tabs !== this.props.tabs) {
        this.handleMeasurement();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          selected = _this$props.selected,
          tabs = _this$props.tabs,
          activator = _this$props.activator,
          tabToFocus = _this$props.tabToFocus,
          siblingTabHasFocus = _this$props.siblingTabHasFocus;
      var tabsMarkup = tabs.map(function (tab, index) {
        return React__default.createElement(Tab, {
          measuring: true,
          key: "".concat(index).concat(tab.id, "Hidden"),
          id: "".concat(tab.id, "Measurer"),
          siblingTabHasFocus: siblingTabHasFocus,
          focused: index === tabToFocus,
          selected: index === selected,
          onClick: noop$e,
          url: tab.url
        }, tab.content);
      });
      var classname = classNames(styles$1y.Tabs, styles$1y.TabMeasurer);
      return React__default.createElement("div", {
        className: classname,
        ref: this.containerNode
      }, React__default.createElement(EventListener, {
        event: "resize",
        handler: this.handleMeasurement
      }), tabsMarkup, activator);
    }
  }]);

  return TabMeasurer;
}(React__default.PureComponent);

function noop$e() {}

var Tabs =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Tabs, _React$PureComponent);

  function Tabs() {
    var _this;

    _classCallCheck(this, Tabs);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Tabs).apply(this, arguments));
    _this.state = {
      disclosureWidth: 0,
      containerWidth: Infinity,
      tabWidths: [],
      visibleTabs: [],
      hiddenTabs: [],
      showDisclosure: false,
      tabToFocus: -1
    };

    _this.handleKeyPress = function (event) {
      var _this$state = _this.state,
          tabToFocus = _this$state.tabToFocus,
          visibleTabs = _this$state.visibleTabs,
          hiddenTabs = _this$state.hiddenTabs,
          showDisclosure = _this$state.showDisclosure;
      var key = event.key;
      var tabsArrayInOrder = showDisclosure ? visibleTabs.concat(hiddenTabs) : _toConsumableArray(visibleTabs);
      var newFocus = tabsArrayInOrder.indexOf(tabToFocus);

      if (key === 'ArrowRight' || key === 'ArrowDown') {
        newFocus += 1;

        if (newFocus === tabsArrayInOrder.length) {
          newFocus = 0;
        }
      }

      if (key === 'ArrowLeft' || key === 'ArrowUp') {
        if (newFocus === -1 || newFocus === 0) {
          newFocus = tabsArrayInOrder.length - 1;
        } else {
          newFocus -= 1;
        }
      }

      _this.setState({
        tabToFocus: tabsArrayInOrder[newFocus]
      });
    };

    _this.renderTabMarkup = function (tab, index) {
      var selected = _this.props.selected;
      var tabToFocus = _this.state.tabToFocus;
      return React__default.createElement(Tab, {
        key: "".concat(index, "-").concat(tab.id),
        id: tab.id,
        siblingTabHasFocus: tabToFocus > -1,
        focused: index === tabToFocus,
        selected: index === selected,
        onClick: _this.handleTabClick,
        panelID: tab.panelID || "".concat(tab.id, "-panel"),
        accessibilityLabel: tab.accessibilityLabel,
        url: tab.url
      }, tab.content);
    };

    _this.handleFocus = function (event) {
      var _this$props = _this.props,
          selected = _this$props.selected,
          tabs = _this$props.tabs; // If we are explicitly focusing a non-selected tab, this focuses it

      var target = event.target;

      if (target.classList.contains(styles$1y.Tab) || target.classList.contains(styles$1y.Item)) {
        var tabToFocus = -1;
        tabs.every(function (tab, index) {
          if (tab.id === target.id) {
            tabToFocus = index;
            return false;
          }

          return true;
        });

        _this.setState({
          tabToFocus
        });

        return;
      }

      if (target.classList.contains(styles$1y.DisclosureActivator)) {
        return;
      } // If we are coming in from somewhere other than another tab, focus the
      // selected tab, and the focus (click) is not on the disclosure activator,
      // focus the selected tab


      if (!event.relatedTarget) {
        _this.setState({
          tabToFocus: selected
        });

        return;
      }

      var relatedTarget = event.relatedTarget;

      if (!relatedTarget.classList.contains(styles$1y.Tab) && !relatedTarget.classList.contains(styles$1y.Item) && !relatedTarget.classList.contains(styles$1y.DisclosureActivator)) {
        _this.setState({
          tabToFocus: selected
        });
      }
    };

    _this.handleBlur = function (event) {
      // If we blur and the target is not another tab, forget the focus position
      if (event.relatedTarget == null) {
        _this.setState({
          tabToFocus: -1
        });

        return;
      }

      var target = event.relatedTarget; // If we are going to anywhere other than another tab, lose the last focused tab

      if (!target.classList.contains(styles$1y.Tab) && !target.classList.contains(styles$1y.Item)) {
        _this.setState({
          tabToFocus: -1
        });
      }
    };

    _this.handleDisclosureActivatorClick = function () {
      _this.setState(function (_ref) {
        var showDisclosure = _ref.showDisclosure;
        return {
          showDisclosure: !showDisclosure
        };
      });
    };

    _this.handleClose = function () {
      _this.setState({
        showDisclosure: false
      });
    };

    _this.handleMeasurement = function (measurements) {
      var _this$props2 = _this.props,
          tabs = _this$props2.tabs,
          selected = _this$props2.selected;
      var tabToFocus = _this.state.tabToFocus;
      var tabWidths = measurements.hiddenTabWidths,
          containerWidth = measurements.containerWidth,
          disclosureWidth = measurements.disclosureWidth;

      var _getVisibleAndHiddenT = getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth),
          visibleTabs = _getVisibleAndHiddenT.visibleTabs,
          hiddenTabs = _getVisibleAndHiddenT.hiddenTabs;

      _this.setState({
        tabToFocus: tabToFocus === -1 ? -1 : selected,
        visibleTabs,
        hiddenTabs,
        disclosureWidth,
        containerWidth,
        tabWidths
      });
    };

    _this.handleTabClick = function (id) {
      var _this$props3 = _this.props,
          tabs = _this$props3.tabs,
          _this$props3$onSelect = _this$props3.onSelect,
          onSelect = _this$props3$onSelect === void 0 ? noop$f : _this$props3$onSelect;
      var tab = tabs.find(function (aTab) {
        return aTab.id === id;
      });

      if (tab == null) {
        return;
      }

      var selectedIndex = tabs.indexOf(tab);
      onSelect(selectedIndex);
    };

    return _this;
  }

  _createClass(Tabs, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props4 = this.props,
          tabs = _this$props4.tabs,
          selected = _this$props4.selected,
          fitted = _this$props4.fitted,
          children = _this$props4.children,
          intl = _this$props4.polaris.intl;
      var _this$state2 = this.state,
          tabToFocus = _this$state2.tabToFocus,
          visibleTabs = _this$state2.visibleTabs,
          hiddenTabs = _this$state2.hiddenTabs,
          showDisclosure = _this$state2.showDisclosure;
      var disclosureTabs = hiddenTabs.map(function (tabIndex) {
        return tabs[tabIndex];
      });
      var panelMarkup = children ? tabs.map(function (_tab, index) {
        return selected === index ? React__default.createElement(Panel, {
          id: tabs[index].panelID || "".concat(tabs[index].id, "-panel"),
          tabID: tabs[index].id,
          key: tabs[index].id
        }, children) : React__default.createElement(Panel, {
          id: tabs[index].panelID || "".concat(tabs[index].id, "-panel"),
          tabID: tabs[index].id,
          key: tabs[index].id,
          hidden: true
        });
      }) : null;
      var tabsMarkup = visibleTabs.sort(function (tabA, tabB) {
        return tabA - tabB;
      }).map(function (tabIndex) {
        return _this2.renderTabMarkup(tabs[tabIndex], tabIndex);
      });
      var disclosureActivatorVisible = visibleTabs.length < tabs.length;
      var classname = classNames(styles$1y.Tabs, fitted && styles$1y.fitted, disclosureActivatorVisible && styles$1y.fillSpace);
      var disclosureTabClassName = classNames(styles$1y.DisclosureTab, disclosureActivatorVisible && styles$1y['DisclosureTab-visible']);
      var activator = React__default.createElement("button", {
        type: "button",
        className: styles$1y.DisclosureActivator,
        onClick: this.handleDisclosureActivatorClick,
        "aria-label": intl.translate('Polaris.Tabs.toggleTabsLabel')
      }, React__default.createElement("span", {
        className: styles$1y.Title
      }, React__default.createElement(Icon, {
        source: HorizontalDotsMinor
      })));
      return React__default.createElement("div", null, React__default.createElement("ul", {
        role: "tablist",
        className: classname,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur,
        onKeyDown: handleKeyDown$2,
        onKeyUp: this.handleKeyPress
      }, tabsMarkup, React__default.createElement("li", {
        className: disclosureTabClassName
      }, React__default.createElement(Popover, {
        preferredPosition: "below",
        activator: activator,
        active: disclosureActivatorVisible && showDisclosure,
        onClose: this.handleClose
      }, React__default.createElement(List$1, {
        focusIndex: hiddenTabs.indexOf(tabToFocus),
        disclosureTabs: disclosureTabs,
        onClick: this.handleTabClick,
        onKeyPress: this.handleKeyPress
      })))), React__default.createElement(TabMeasurer, {
        tabToFocus: tabToFocus,
        activator: activator,
        selected: selected,
        tabs: tabs,
        siblingTabHasFocus: tabToFocus > -1,
        handleMeasurement: this.handleMeasurement
      }), panelMarkup);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var disclosureWidth = prevState.disclosureWidth,
          tabWidths = prevState.tabWidths,
          containerWidth = prevState.containerWidth;

      var _getVisibleAndHiddenT2 = getVisibleAndHiddenTabIndices(nextProps.tabs, nextProps.selected, disclosureWidth, tabWidths, containerWidth),
          visibleTabs = _getVisibleAndHiddenT2.visibleTabs,
          hiddenTabs = _getVisibleAndHiddenT2.hiddenTabs;

      return {
        visibleTabs,
        hiddenTabs,
        selected: nextProps.selected
      };
    }
  }]);

  return Tabs;
}(React__default.PureComponent);

function noop$f() {}

function handleKeyDown$2(event) {
  var key = event.key;

  if (key === 'ArrowUp' || key === 'ArrowDown' || key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
} // Use named export once withAppProvider is refactored away
// eslint-disable-next-line import/no-default-export


var Tabs$1 = withAppProvider()(Tabs);

var styles$1z = {
  "Thumbnail": "Polaris-Thumbnail",
  "sizeSmall": "Polaris-Thumbnail--sizeSmall",
  "sizeMedium": "Polaris-Thumbnail--sizeMedium",
  "sizeLarge": "Polaris-Thumbnail--sizeLarge",
  "Image": "Polaris-Thumbnail__Image"
};

function Thumbnail(_ref) {
  var source = _ref.source,
      alt = _ref.alt,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'medium' : _ref$size;
  var className = classNames(styles$1z.Thumbnail, size && styles$1z[variationName('size', size)]);
  return React__default.createElement("span", {
    className: className
  }, React__default.createElement(Image, {
    alt: alt,
    source: source,
    className: styles$1z.Image
  }));
}

var Toast$1 = React__default.memo(function Toast(props) {
  var id = useUniqueId('Toast');
  var appBridgeToast = useRef();

  var _useFrame = useFrame(),
      showToast = _useFrame.showToast,
      hideToast = _useFrame.hideToast;

  var appBridge = useAppBridge();
  useDeepEffect(function () {
    var error = props.error,
        content = props.content,
        _props$duration = props.duration,
        duration = _props$duration === void 0 ? DEFAULT_TOAST_DURATION : _props$duration,
        onDismiss = props.onDismiss;

    if (appBridge == null) {
      showToast(Object.assign({
        id
      }, props));
    } else {
      // eslint-disable-next-line no-console
      console.warn('Deprecation: Using `Toast` in an embedded app is deprecated and will be removed in v5.0. Use `Toast` from `@shopify/app-bridge-react` instead: https://help.shopify.com/en/api/embedded-apps/app-bridge/react-components/toast');
      appBridgeToast.current = Toast$2.create(appBridge, {
        message: content,
        duration,
        isError: error
      });
      appBridgeToast.current.subscribe(Toast$2.Action.CLEAR, onDismiss);
      appBridgeToast.current.dispatch(Toast$2.Action.SHOW);
    }

    return function () {
      if (appBridge == null) {
        hideToast({
          id
        });
      } else if (appBridgeToast.current != null) {
        appBridgeToast.current.unsubscribe();
      }
    };
  }, [appBridge, props]);
  return null;
});

var styles$1A = {
  "Search": "Polaris-TopBar-Search",
  "visible": "Polaris-TopBar-Search--visible",
  "Overlay": "Polaris-TopBar-Search__Overlay"
};

var Search =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(Search, _React$PureComponent);

  function Search() {
    var _this;

    _classCallCheck(this, Search);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Search).apply(this, arguments));
    _this.node = React__default.createRef();

    _this.handleDismiss = function (_ref) {
      var target = _ref.target;
      var onDismiss = _this.props.onDismiss;

      if (onDismiss != null && target === _this.node.current) {
        onDismiss();
      }
    };

    return _this;
  }

  _createClass(Search, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          visible = _this$props.visible,
          children = _this$props.children;
      var searchClassName = classNames(styles$1A.Search, visible && styles$1A.visible);
      return React__default.createElement("div", {
        ref: this.node,
        className: searchClassName,
        onClick: this.handleDismiss
      }, React__default.createElement("div", {
        className: styles$1A.Overlay
      }, children));
    }
  }]);

  return Search;
}(React__default.PureComponent);

var styles$1B = {
  "SearchField": "Polaris-TopBar-SearchField",
  "focused": "Polaris-TopBar-SearchField--focused",
  "Input": "Polaris-TopBar-SearchField__Input",
  "Backdrop": "Polaris-TopBar-SearchField__Backdrop",
  "Icon": "Polaris-TopBar-SearchField__Icon",
  "Clear": "Polaris-TopBar-SearchField__Clear",
  "toLightBackground": "Polaris-TopBar-SearchField--toLightBackground"
};

function SearchField(_ref) {
  var value = _ref.value,
      focused = _ref.focused,
      active = _ref.active,
      placeholder = _ref.placeholder,
      onChange = _ref.onChange,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      onCancel = _ref.onCancel;
  var i18n = useI18n();
  var input = useRef(null);
  var searchId = useUniqueId('SearchField');
  var handleChange = useCallback(function (_ref2) {
    var currentTarget = _ref2.currentTarget;
    onChange(currentTarget.value);
  }, [onChange]);
  var handleFocus = useCallback(function () {
    return onFocus && onFocus();
  }, [onFocus]);
  var handleBlur = useCallback(function () {
    return onBlur && onBlur();
  }, [onBlur]);
  var handleClear = useCallback(function () {
    onCancel && onCancel();

    if (!input.current) {
      return;
    }

    input.current.value = '';
    onChange('');
    input.current.focus();
  }, [onCancel, onChange]);
  useEffect(function () {
    if (!input.current) {
      return;
    }

    if (focused) {
      input.current.focus();
    } else {
      input.current.blur();
    }
  }, [focused]);
  var clearMarkup = value !== '' && React__default.createElement("button", {
    type: "button",
    "aria-label": i18n.translate('Polaris.TopBar.SearchField.clearButtonLabel'),
    className: styles$1B.Clear,
    onClick: handleClear
  }, React__default.createElement(Icon, {
    source: CircleCancelMinor
  }));
  var className = classNames(styles$1B.SearchField, (focused || active) && styles$1B.focused);
  return React__default.createElement("div", {
    className: className,
    onFocus: handleFocus,
    onBlur: handleBlur
  }, React__default.createElement(VisuallyHidden, null, React__default.createElement("label", {
    htmlFor: searchId
  }, i18n.translate('Polaris.TopBar.SearchField.search'))), React__default.createElement("input", {
    id: searchId,
    className: styles$1B.Input,
    placeholder: placeholder,
    type: "search",
    autoCapitalize: "off",
    autoComplete: "off",
    autoCorrect: "off",
    ref: input,
    value: value,
    onChange: handleChange,
    onKeyDown: preventDefault
  }), React__default.createElement("span", {
    className: styles$1B.Icon
  }, React__default.createElement(Icon, {
    source: SearchMinor
  })), clearMarkup, React__default.createElement("div", {
    className: styles$1B.Backdrop
  }));
}

function preventDefault(event) {
  if (event.key === 'Enter') {
    event.preventDefault();
  }
}

var styles$1C = {
  "MessageIndicatorWrapper": "Polaris-MessageIndicator__MessageIndicatorWrapper",
  "MessageIndicator": "Polaris-MessageIndicator"
};

function MessageIndicator(_ref) {
  var children = _ref.children,
      active = _ref.active;
  var indicatorMarkup = active && React__default.createElement("div", {
    className: styles$1C.MessageIndicator
  });
  return React__default.createElement("div", {
    className: styles$1C.MessageIndicatorWrapper
  }, indicatorMarkup, children);
}

var styles$1D = {
  "Section": "Polaris-Menu-Message__Section"
};

function Message(_ref) {
  var title = _ref.title,
      description = _ref.description,
      action = _ref.action,
      link = _ref.link,
      badge = _ref.badge;
  var badgeMarkup = badge && React__default.createElement(Badge, {
    status: badge.status
  }, badge.content);
  var to = link.to,
      linkContent = link.content;
  var onClick = action.onClick,
      actionContent = action.content;
  return React__default.createElement("div", {
    className: styles$1D.Section
  }, React__default.createElement(Popover.Section, null, React__default.createElement(Stack, {
    vertical: true,
    spacing: "tight"
  }, React__default.createElement(TextContainer, null, React__default.createElement(Heading, null, title, badgeMarkup), React__default.createElement("p", null, description)), React__default.createElement(Link, {
    url: to
  }, linkContent), React__default.createElement(Button, {
    plain: true,
    onClick: onClick
  }, actionContent))));
}

var styles$1E = {
  "ActivatorWrapper": "Polaris-TopBar-Menu__ActivatorWrapper",
  "Activator": "Polaris-TopBar-Menu__Activator",
  "Section": "Polaris-TopBar-Menu__Section"
};

function Menu(props) {
  var actions = props.actions,
      onOpen = props.onOpen,
      onClose = props.onClose,
      open = props.open,
      activatorContent = props.activatorContent,
      message = props.message;
  var badgeProps = message && message.badge && {
    content: message.badge.content,
    status: message.badge.status
  };
  var messageMarkup = message && React__default.createElement(Message, {
    title: message.title,
    description: message.description,
    action: {
      onClick: message.action.onClick,
      content: message.action.content
    },
    link: {
      to: message.link.to,
      content: message.link.content
    },
    badge: badgeProps
  });
  var isFullHeight = Boolean(message);
  return React__default.createElement(Popover, {
    activator: React__default.createElement("div", {
      className: styles$1E.ActivatorWrapper
    }, React__default.createElement("button", {
      type: "button",
      className: styles$1E.Activator,
      onClick: onOpen
    }, activatorContent)),
    active: open,
    onClose: onClose,
    fixed: true,
    fullHeight: isFullHeight
  }, React__default.createElement(ActionList, {
    onActionAnyItem: onClose,
    sections: actions
  }), messageMarkup);
}

var styles$1F = {
  "Details": "Polaris-TopBar-UserMenu__Details",
  "Name": "Polaris-TopBar-UserMenu__Name",
  "Detail": "Polaris-TopBar-UserMenu__Detail"
};

function UserMenu(_ref) {
  var name = _ref.name,
      detail = _ref.detail,
      avatar = _ref.avatar,
      initials = _ref.initials,
      actions = _ref.actions,
      message = _ref.message,
      onToggle = _ref.onToggle,
      open = _ref.open;
  var showIndicator = Boolean(message);
  var activatorContentMarkup = React__default.createElement(React__default.Fragment, null, React__default.createElement(MessageIndicator, {
    active: showIndicator
  }, React__default.createElement(Avatar, {
    size: "small",
    source: avatar,
    initials: initials && initials.replace(' ', '')
  })), React__default.createElement("span", {
    className: styles$1F.Details
  }, React__default.createElement("p", {
    className: styles$1F.Name
  }, name), React__default.createElement("p", {
    className: styles$1F.Detail
  }, detail)));
  return React__default.createElement(Menu, {
    activatorContent: activatorContentMarkup,
    open: open,
    onOpen: onToggle,
    onClose: onToggle,
    actions: actions,
    message: message
  });
}

var styles$1G = {
  "TopBar": "Polaris-TopBar",
  "LogoContainer": "Polaris-TopBar__LogoContainer",
  "ContextControl": "Polaris-TopBar__ContextControl",
  "Logo": "Polaris-TopBar__Logo",
  "LogoLink": "Polaris-TopBar__LogoLink",
  "NavigationIcon": "Polaris-TopBar__NavigationIcon",
  "focused": "Polaris-TopBar--focused",
  "Contents": "Polaris-TopBar__Contents",
  "SearchField": "Polaris-TopBar__SearchField",
  "SecondaryMenu": "Polaris-TopBar__SecondaryMenu"
};

// subcomponents so explicitly state the subcomponents in the type definition.
// Letting this be implicit works in this project but fails in projects that use
// generated *.d.ts files.

var TopBar = function TopBar(_ref) {
  var showNavigationToggle = _ref.showNavigationToggle,
      userMenu = _ref.userMenu,
      searchResults = _ref.searchResults,
      searchField = _ref.searchField,
      secondaryMenu = _ref.secondaryMenu,
      searchResultsVisible = _ref.searchResultsVisible,
      onNavigationToggle = _ref.onNavigationToggle,
      onSearchResultsDismiss = _ref.onSearchResultsDismiss,
      contextControl = _ref.contextControl;
  var i18n = useI18n();

  var _useTheme = useTheme(),
      logo = _useTheme.logo;

  var _useToggle = useToggle(false),
      focused = _useToggle.value,
      forceTrueFocused = _useToggle.setTrue,
      forceFalseFocused = _useToggle.setFalse;

  var className = classNames(styles$1G.NavigationIcon, focused && styles$1G.focused);
  var navigationButtonMarkup = showNavigationToggle ? React__default.createElement("button", {
    type: "button",
    className: className,
    onClick: onNavigationToggle,
    onFocus: forceTrueFocused,
    onBlur: forceFalseFocused,
    "aria-label": i18n.translate('Polaris.TopBar.toggleMenuLabel')
  }, React__default.createElement(Icon, {
    source: MobileHamburgerMajorMonotone,
    color: "white"
  })) : null;
  var width = getWidth(logo, 104);
  var contextMarkup;

  if (contextControl) {
    contextMarkup = React__default.createElement("div", {
      className: styles$1G.ContextControl
    }, contextControl);
  } else if (logo) {
    contextMarkup = React__default.createElement("div", {
      className: styles$1G.LogoContainer
    }, React__default.createElement(UnstyledLink, {
      url: logo.url || '',
      className: styles$1G.LogoLink,
      style: {
        width
      }
    }, React__default.createElement(Image, {
      source: logo.topBarSource || '',
      alt: logo.accessibilityLabel || '',
      className: styles$1G.Logo,
      style: {
        width
      }
    })));
  }

  var searchResultsMarkup = searchResults && searchResultsVisible ? React__default.createElement(Search, {
    visible: searchResultsVisible,
    onDismiss: onSearchResultsDismiss
  }, searchResults) : null;
  var searchMarkup = searchField ? React__default.createElement(React__default.Fragment, null, searchField, searchResultsMarkup) : null;
  return React__default.createElement("div", {
    className: styles$1G.TopBar
  }, navigationButtonMarkup, contextMarkup, React__default.createElement("div", {
    className: styles$1G.Contents
  }, React__default.createElement("div", {
    className: styles$1G.SearchField
  }, searchMarkup), React__default.createElement("div", {
    className: styles$1G.SecondaryMenu
  }, secondaryMenu), userMenu));
};
TopBar.Menu = Menu;
TopBar.SearchField = SearchField;
TopBar.UserMenu = UserMenu;

/* eslint-enable @typescript-eslint/camelcase */

export { AccountConnection, ActionList, ActionMenu, AppBridgeContext, AppProvider, Autocomplete, Avatar, Backdrop, Badge, Banner, Breadcrumbs, Button, ButtonGroup, CalloutCard, Caption, Card, Checkbox$1 as Checkbox, ChoiceList, Collapsible, ColorPicker, Connected, ContextualSaveBar, DATA_ATTRIBUTE, DEFAULT_TOAST_DURATION, DEFAULT_TOAST_DURATION_WITH_ACTION, DataTable$1 as DataTable, DatePicker, DescriptionList, DisplayText, DropZone, EmptySearchResult, EmptyState, EventListener, ExceptionList, FilterType, Filters$1 as Filters, Focus, FooterHelp, Form, FormLayout, Frame$1 as Frame, Heading, Icon, Image, Indicator, InlineError, Key, KeyboardKey, KeypressListener, Label, Labelled, Layout, Link, List, Loading$1 as Loading, Modal$1 as Modal, Navigation$1 as Navigation, OptionList, Page$1 as Page, PageActions, Pagination, PolarisTestProvider, Popover, CloseSource as PopoverCloseSource, Portal, ProgressBar, RadioButton, RangeSlider, ResourceItem, ResourceList$1 as ResourceList, ResourcePicker$1 as ResourcePicker, ScrollLock, Scrollable, Select, SettingToggle, Sheet, SkeletonBodyText, SkeletonDisplayText, SkeletonPage, SkeletonThumbnail, Spinner, Stack, Sticky$1 as Sticky, Subheading, Tabs$1 as Tabs, Tag, TextContainer, TextField, TextStyle, ThemeProvider, Thumbnail, Toast$1 as Toast, Tooltip, TopBar, TrapFocus, Truncate, TypeOf, DefaultThemeColors as UNSTABLE_DefaultThemeColors, Tokens as UNSTABLE_Tokens, buildColors as UNSTABLE_buildColors, roleVariants as UNSTABLE_roleVariants, toCssCustomPropertySyntax as UNSTABLE_toCssCustomPropertySyntax, UnstyledLink, VisuallyHidden, ScrollLockManagerContext as _SECRET_INTERNAL_SCROLL_LOCK_MANAGER_CONTEXT, WithinContentContext as _SECRET_INTERNAL_WITHIN_CONTENT_CONTEXT, buttonFrom, buttonsFrom, errorTextID, hsbToHex, hsbToRgb, hslToRgb, isNavigationItemActive, rgbString, rgbToHex, rgbToHsb, rgbToHsl, rgbaString };
