import React from 'react';
import { ActionListSection, ComplexAction, MenuGroupDescriptor } from '../../types';
export interface ActionMenuProps {
    /** Collection of page-level secondary actions */
    actions?: ComplexAction[];
    /** Collection of page-level action groups */
    groups?: MenuGroupDescriptor[];
    /** Roll up all actions into a Popover > ActionList */
    rollup?: boolean;
}
interface State {
    activeMenuGroup?: string;
}
export declare class ActionMenu extends React.PureComponent<ActionMenuProps, State> {
    state: State;
    render(): JSX.Element | null;
    private renderActions;
    private handleMenuGroupToggle;
    private handleMenuGroupClose;
}
export declare function hasGroupsWithActions(groups?: ActionMenuProps['groups']): boolean;
export declare function convertGroupToSection({ title, actions, }: MenuGroupDescriptor): ActionListSection;
export {};
