/// <reference types="react" />
export declare type Status = 'success' | 'info' | 'attention' | 'warning' | 'new';
export declare type Progress = 'incomplete' | 'partiallyComplete' | 'complete';
export declare type Size = 'small' | 'medium';
export interface BadgeProps {
    /** The content to display inside the badge. */
    children?: string;
    /** Set the color of the badge for the given status. */
    status?: Status;
    /** Render a pip showing the progress of a given task. */
    progress?: Progress;
    /**
     * Medium or small size. Use `small` only in the main navigation of an app frame.
     * @default 'medium'
     */
    size?: Size;
}
export declare const PROGRESS_LABELS: {
    [key in Progress]: Progress;
};
export declare const STATUS_LABELS: {
    [key in Status]: Status;
};
export declare function Badge({ children, status, progress, size, }: BadgeProps): JSX.Element;
