import React from 'react';
export interface CollapsibleProps {
    /** Assign a unique ID to the collapsible. For accessibility, pass this ID as the value of the triggering component’s aria-controls prop. */
    id: string;
    /** Toggle whether the collapsible is expanded or not. */
    open: boolean;
    /** The content to display inside the collapsible. */
    children?: React.ReactNode;
}
export declare type AnimationState = 'idle' | 'measuring' | 'closingStart' | 'closing' | 'openingStart' | 'opening';
interface State {
    height?: number | null;
    animationState: AnimationState;
    open: boolean;
}
declare const ParentCollapsibleExpandingContext: React.Context<boolean>;
declare class Collapsible extends React.Component<CollapsibleProps, State> {
    static contextType: React.Context<boolean>;
    static getDerivedStateFromProps({ open: willOpen }: CollapsibleProps, { open, animationState: prevAnimationState }: State): {
        animationState: AnimationState;
        open: boolean;
    };
    context: React.ContextType<typeof ParentCollapsibleExpandingContext>;
    state: State;
    private node;
    private heightNode;
    componentDidUpdate({ open: wasOpen }: CollapsibleProps): void;
    render(): JSX.Element;
    private handleTransitionEnd;
}
declare const _default: React.ComponentClass<CollapsibleProps, any> & typeof Collapsible;
export default _default;
