import React from 'react';
export interface SourceSet {
    source: string;
    descriptor?: string;
}
export declare type CrossOrigin = 'anonymous' | 'use-credentials' | '' | undefined;
export interface ImageProps extends React.HTMLProps<HTMLImageElement> {
    alt: string;
    source: string;
    sourceSet?: SourceSet[];
    onLoad?(): void;
    onError?(): void;
}
export declare function Image({ sourceSet, source, crossOrigin, ...rest }: ImageProps): JSX.Element;
