import React from 'react';
import { Action, Error } from '../../types';
import { LabelProps, labelID } from '../Label';
export { Action, labelID };
export interface LabelledProps {
    /** A unique identifier for the label */
    id: LabelProps['id'];
    /** Text for the label */
    label: string;
    /** Error to display beneath the label */
    error?: Error | boolean;
    /** An action */
    action?: Action;
    /** Additional hint text to display */
    helpText?: React.ReactNode;
    /** Content to display inside the connected */
    children?: React.ReactNode;
    /** Visually hide the label */
    labelHidden?: boolean;
}
export declare function Labelled({ id, label, error, action, helpText, children, labelHidden, ...rest }: LabelledProps): JSX.Element;
export declare function errorID(id: string): string;
export declare function helpTextID(id: string): string;
