import React from 'react';
import { IconProps } from '../../types';
import { AvatarProps } from '../Avatar';
import { ThumbnailProps } from '../Thumbnail';
export interface OptionDescriptor {
    /** Value of the option */
    value: string;
    /** Display label for the option */
    label: React.ReactNode;
    /** Whether the option is disabled or not */
    disabled?: boolean;
    /** Whether the option is active or not */
    active?: boolean;
    /** Unique identifier for the option */
    id?: string;
    /** Media to display to the left of the option content */
    media?: React.ReactElement<IconProps | ThumbnailProps | AvatarProps>;
}
export interface SectionDescriptor {
    /** Collection of options within the section */
    options: OptionDescriptor[];
    /** Section title */
    title?: string;
}
export interface OptionListProps {
    /** A unique identifier for the option list */
    id?: string;
    /** List title */
    title?: string;
    /** Collection of options to be listed */
    options?: OptionDescriptor[];
    /** Defines a specific role attribute for the list itself */
    role?: string;
    /** Defines a specific role attribute for each option in the list */
    optionRole?: string;
    /** Sections containing a header and related options */
    sections?: SectionDescriptor[];
    /** The selected options */
    selected: string[];
    /** Allow more than one option to be selected */
    allowMultiple?: boolean;
    /** Callback when selection is changed */
    onChange(selected: string[]): void;
}
export declare function OptionList({ options, sections, title, selected, allowMultiple, role, optionRole, onChange, id: idProp, }: OptionListProps): JSX.Element;
