/// <reference types="react" />
import { ComplexAction, MenuGroupDescriptor } from '../../../../types';
import { BreadcrumbsProps } from '../../../Breadcrumbs';
import { PaginationDescriptor } from '../../../Pagination';
import { HeaderPrimaryAction } from '../../types';
import { TitleProps } from './components';
export interface HeaderProps extends TitleProps {
    /** Visually hide the title (stand-alone app use only) */
    titleHidden?: boolean;
    /** Adds a border to the bottom of the page header (stand-alone app use only) */
    separator?: boolean;
    /** Primary page-level action */
    primaryAction?: HeaderPrimaryAction;
    /** Page-level pagination (stand-alone app use only) */
    pagination?: PaginationDescriptor;
    /** Collection of breadcrumbs */
    breadcrumbs?: BreadcrumbsProps['breadcrumbs'];
    /** Collection of secondary page-level actions */
    secondaryActions?: ComplexAction[];
    /** Collection of page-level groups of secondary actions */
    actionGroups?: MenuGroupDescriptor[];
}
export declare function Header({ title, subtitle, titleMetadata, thumbnail, titleHidden, separator, primaryAction, pagination, breadcrumbs, secondaryActions, actionGroups, }: HeaderProps): JSX.Element;
