import React, { AriaAttributes } from 'react';
import { PreferredPosition, PreferredAlignment } from '../PositionedOverlay';
import { CloseSource, Pane, Section } from './components';
export { CloseSource };
export interface PopoverProps {
    /** The content to display inside the popover */
    children?: React.ReactNode;
    /** The preferred direction to open the popover */
    preferredPosition?: PreferredPosition;
    /** The preferred alignment of the popover relative to its activator */
    preferredAlignment?: PreferredAlignment;
    /** Show or hide the Popover */
    active: boolean;
    /** The element to activate the Popover */
    activator: React.ReactElement;
    /**
     * The element type to wrap the activator with
     * @default 'div'
     */
    activatorWrapper?: string;
    /** Prevent automatic focus of the first field on activation */
    preventAutofocus?: boolean;
    /** Automatically add wrap content in a section */
    sectioned?: boolean;
    /** Allow popover to stretch to the full width of its activator */
    fullWidth?: boolean;
    /** Allow popover to stretch to fit content vertically */
    fullHeight?: boolean;
    /** Allow popover content to determine the overlay width and height */
    fluidContent?: boolean;
    /** Remains in a fixed position */
    fixed?: boolean;
    /** Used to illustrate the type of popover element */
    ariaHaspopup?: AriaAttributes['aria-haspopup'];
    /** Callback when popover is closed */
    onClose(source: CloseSource): void;
}
export declare const Popover: React.FunctionComponent<PopoverProps> & {
    Pane: typeof Pane;
    Section: typeof Section;
};
