import React from 'react';
import { PreferredPosition, PreferredAlignment } from '../../../PositionedOverlay';
export declare enum CloseSource {
    Click = 0,
    EscapeKeypress = 1,
    FocusOut = 2,
    ScrollOut = 3
}
declare enum TransitionStatus {
    Entering = "entering",
    Entered = "entered",
    Exiting = "exiting",
    Exited = "exited"
}
export interface PopoverOverlayProps {
    children?: React.ReactNode;
    fullWidth?: boolean;
    fullHeight?: boolean;
    fluidContent?: boolean;
    preferredPosition?: PreferredPosition;
    preferredAlignment?: PreferredAlignment;
    active: boolean;
    id: string;
    activator: HTMLElement;
    preventAutofocus?: boolean;
    sectioned?: boolean;
    fixed?: boolean;
    onClose(source: CloseSource): void;
}
interface State {
    transitionStatus: TransitionStatus;
}
export declare class PopoverOverlay extends React.PureComponent<PopoverOverlayProps, State> {
    state: State;
    private contentNode;
    private enteringTimer?;
    private exitingTimer?;
    changeTransitionStatus(transitionStatus: TransitionStatus, cb?: () => void): void;
    componentDidMount(): void;
    componentDidUpdate(oldProps: PopoverOverlayProps): void;
    componentWillUnmount(): void;
    render(): JSX.Element | null;
    private clearTransitionTimeout;
    private focusContent;
    private renderPopover;
    private handleClick;
    private handleScrollOut;
    private handleEscape;
    private handleFocusFirstItem;
    private handleFocusLastItem;
}
export {};
