import React from 'react';
import { Rect } from '@shopify/javascript-utilities/geometry';
import { PreferredPosition, PreferredAlignment } from './utilities/math';
export { PreferredPosition, PreferredAlignment };
export declare type Positioning = 'above' | 'below';
export interface OverlayDetails {
    left: number;
    desiredHeight: number;
    positioning: Positioning;
    measuring: boolean;
    activatorRect: Rect;
}
export interface PositionedOverlayProps {
    active: boolean;
    activator: HTMLElement;
    preferredPosition?: PreferredPosition;
    preferredAlignment?: PreferredAlignment;
    fullWidth?: boolean;
    fixed?: boolean;
    classNames?: string;
    render(overlayDetails: OverlayDetails): React.ReactNode;
    onScrollOut?(): void;
}
interface State {
    measuring: boolean;
    activatorRect: Rect;
    left: number;
    top: number;
    height: number;
    width: number | null;
    positioning: Positioning;
    zIndex: number | null;
    outsideScrollableContainer: boolean;
    lockPosition: boolean;
}
export declare class PositionedOverlay extends React.PureComponent<PositionedOverlayProps, State> {
    state: State;
    private overlay;
    private scrollableContainer;
    private observer;
    constructor(props: PositionedOverlayProps);
    componentDidMount(): void;
    componentWillUnmount(): void;
    componentDidUpdate(): void;
    render(): JSX.Element;
    private overlayDetails;
    private setOverlay;
    private handleMeasurement;
}
export declare function intersectionWithViewport(rect: Rect, viewport?: Rect): Rect;
