import React from 'react';
import { RangeSliderProps, DualValue } from '../../types';
interface State {
    value: DualValue;
    trackWidth: number;
    trackLeft: number;
    prevValue?: DualValue;
}
export interface DualThumbProps extends RangeSliderProps {
    value: DualValue;
    id: string;
    min: number;
    max: number;
    step: number;
}
export declare class DualThumb extends React.Component<DualThumbProps, State> {
    static getDerivedStateFromProps(props: DualThumbProps, state: State): {
        prevValue: DualValue;
        value: DualValue;
    } | null;
    state: State;
    private track;
    private trackWrapper;
    private thumbLower;
    private thumbUpper;
    private setTrackPosition;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
    private handleMouseDownThumbLower;
    private handleMouseMoveThumbLower;
    private handleTouchStartThumbLower;
    private handleTouchMoveThumbLower;
    private handleMouseDownThumbUpper;
    private handleMouseMoveThumbUpper;
    private handleTouchStartThumbUpper;
    private handleTouchMoveThumbUpper;
    private handleKeypressLower;
    private handleKeypressUpper;
    private incrementValueLower;
    private decrementValueLower;
    private incrementValueUpper;
    private decrementValueUpper;
    private dispatchValue;
    private setValue;
    private handleMouseDownTrack;
    private handleTouchStartTrack;
    private actualXPosition;
}
export {};
