import React from 'react';
import { useI18n } from '../../utilities/i18n';
import { DisableableAction } from '../../types';
import { AvatarProps } from '../Avatar';
import { ThumbnailProps } from '../Thumbnail';
import { ResourceListContext } from '../../utilities/resource-list';
export declare type ExceptionStatus = 'neutral' | 'warning' | 'critical';
export declare type MediaSize = 'small' | 'medium' | 'large';
export declare type MediaType = 'avatar' | 'thumbnail';
export interface BaseProps {
    /** Visually hidden text for screen readers used for item link*/
    accessibilityLabel?: string;
    /** Individual item name used by various text labels */
    name?: string;
    /** Id of the element the item onClick controls */
    ariaControls?: string;
    /** Tells screen reader the controlled element is expanded */
    ariaExpanded?: boolean;
    /** Unique identifier for the item */
    id: string;
    /** Content for the media area at the left of the item, usually an Avatar or Thumbnail */
    media?: React.ReactElement<AvatarProps | ThumbnailProps>;
    /** Makes the shortcut actions always visible */
    persistActions?: boolean;
    /** 1 or 2 shortcut actions; must be available on the page linked to by url */
    shortcutActions?: DisableableAction[];
    /** The order the item is rendered */
    sortOrder?: number;
    /** URL for the resource’s details page (required unless onClick is provided) */
    url?: string;
    /** Allows url to open in a new tab */
    external?: boolean;
    /** Callback when clicked (required if url is omitted) */
    onClick?(id?: string): void;
    /** Content for the details area */
    children?: React.ReactNode;
}
export interface PropsWithUrl extends BaseProps {
    url: string;
    onClick?(id?: string): void;
}
export interface PropsWithClick extends BaseProps {
    url?: string;
    onClick(id?: string): void;
}
export declare type ResourceItemProps = PropsWithUrl | PropsWithClick;
interface PropsFromWrapper {
    context: React.ContextType<typeof ResourceListContext>;
    i18n: ReturnType<typeof useI18n>;
}
export declare type CombinedProps = PropsFromWrapper & (PropsWithUrl | PropsWithClick);
export declare function ResourceItem(props: ResourceItemProps): JSX.Element;
export {};
