import React from 'react';
export declare const BOTTOM_CLASS_NAMES: {
    enter: string;
    enterActive: string;
    exit: string;
    exitActive: string;
};
export declare const RIGHT_CLASS_NAMES: {
    enter: string;
    enterActive: string;
    exit: string;
    exitActive: string;
};
export interface SheetProps {
    /** Whether or not the sheet is open */
    open: boolean;
    /** The child elements to render in the sheet */
    children: React.ReactNode;
    /** Callback when the backdrop is clicked or `ESC` is pressed */
    onClose(): void;
    /** Callback when the sheet has completed entering */
    onEntered?(): void;
    /** Callback when the sheet has started to exit */
    onExit?(): void;
}
export declare function Sheet({ children, open, onClose, onEntered, onExit, }: SheetProps): JSX.Element;
