/// <reference types="hoist-non-react-statics" />
import React from 'react';
import { WithAppProviderProps } from '../../utilities/with-app-provider';
import { TabDescriptor } from './types';
export interface TabsProps {
    /** Content to display in tabs */
    children?: React.ReactNode;
    /** Index of selected tab */
    selected: number;
    /** List of tabs */
    tabs: TabDescriptor[];
    /** Fit tabs to container */
    fitted?: boolean;
    /** Callback when tab is selected */
    onSelect?(selectedTabIndex: number): void;
}
declare type CombinedProps = TabsProps & WithAppProviderProps;
interface State {
    disclosureWidth: number;
    tabWidths: number[];
    visibleTabs: number[];
    hiddenTabs: number[];
    containerWidth: number;
    showDisclosure: boolean;
    tabToFocus: number;
}
declare class Tabs extends React.PureComponent<CombinedProps, State> {
    static getDerivedStateFromProps(nextProps: TabsProps, prevState: State): {
        visibleTabs: number[];
        hiddenTabs: number[];
        selected: number;
    };
    state: State;
    render(): JSX.Element;
    private handleKeyPress;
    private renderTabMarkup;
    private handleFocus;
    private handleBlur;
    private handleDisclosureActivatorClick;
    private handleClose;
    private handleMeasurement;
    private handleTabClick;
}
declare const _default: React.FunctionComponent<TabsProps> & import("hoist-non-react-statics").NonReactStatics<(React.ComponentClass<CombinedProps, any> & typeof Tabs) | (React.FunctionComponent<CombinedProps> & typeof Tabs), {}>;
export default _default;
