import React from 'react';
export declare type Variation = 'positive' | 'negative' | 'strong' | 'subdued' | 'code';
export declare enum VariationValue {
    Positive = "positive",
    Negative = "negative",
    Strong = "strong",
    Subdued = "subdued",
    Code = "code"
}
export interface TextStyleProps {
    /** Give text additional visual meaning */
    variation?: Variation;
    /** The content that should get the intended styling */
    children?: React.ReactNode;
}
export declare function TextStyle({ variation, children }: TextStyleProps): JSX.Element;
