import React from 'react';
import { ThemeConfig, ColorScheme } from '../../utilities/theme';
declare type Inverse = 'inverse';
declare type Discard<T, K extends keyof T> = Pick<T, Exclude<keyof T, K>>;
interface ThemeProviderThemeConfig extends Discard<ThemeConfig, 'colorScheme'> {
    colorScheme?: ColorScheme | Inverse;
}
interface ThemeProviderProps {
    /** Custom logos and colors provided to select components */
    theme: ThemeProviderThemeConfig;
    /** The content to display */
    children?: React.ReactNode;
}
export declare function ThemeProvider({ theme: themeConfig, children, }: ThemeProviderProps): JSX.Element;
export {};
