/// <reference types="react" />
export declare type Color = 'white' | 'black' | 'skyLighter' | 'skyLight' | 'sky' | 'skyDark' | 'inkLightest' | 'inkLighter' | 'inkLight' | 'ink' | 'blueLighter' | 'blueLight' | 'blue' | 'blueDark' | 'blueDarker' | 'indigoLighter' | 'indigoLight' | 'indigo' | 'indigoDark' | 'indigoDarker' | 'tealLighter' | 'tealLight' | 'teal' | 'tealDark' | 'tealDarker' | 'greenLighter' | 'green' | 'greenDark' | 'yellowLighter' | 'yellow' | 'yellowDark' | 'orange' | 'redLighter' | 'red' | 'redDark' | 'purple';
export declare type IconSource = React.SFC<React.SVGProps<SVGSVGElement>> | 'placeholder' | string;
export interface IconProps {
    /** The SVG contents to display in the icon (icons should fit in a 20 × 20 pixel viewBox) */
    source: IconSource;
    /** Set the color for the SVG fill */
    color?: Color;
    /** Show a backdrop behind the icon */
    backdrop?: boolean;
    /** Descriptive text to be read to screenreaders */
    accessibilityLabel?: string;
}
export declare type HeadingTagName = 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'p';
export declare type AppBridgeTarget = 'ADMIN_PATH' | 'REMOTE' | 'APP';
export declare type Error = string | React.ReactElement | (string | React.ReactElement)[];
export interface BaseAction {
    /** A unique identifier for the action */
    id?: string;
    /** Content the action displays */
    content?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** A destination to link to, rendered in the action */
    url?: string;
    /** Forces url to open in a new tab */
    external?: boolean;
    /** Callback when an action takes place */
    onAction?(): void;
    /** Callback when mouse enter */
    onMouseEnter?(): void;
    /** Callback when element is touched */
    onTouchStart?(): void;
}
export interface Action extends BaseAction {
}
export interface AnimationProps {
    in?: boolean;
}
export interface BaseLinkAction {
    /** A unique identifier for the action */
    id?: string;
    /** Content the action displays */
    content?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** A destination to link to */
    url: string;
}
export interface AppBridgeActionTarget {
    /**
     * Where to display the target link
     * @default 'APP'
     * @embeddedAppOnly
     */
    target?: AppBridgeTarget;
}
export interface LinkAction extends BaseLinkAction, AppBridgeActionTarget {
}
export interface BadgeAction {
    badge?: {
        status: 'new';
        content: string;
    };
}
export interface BaseCallbackAction {
    /** A unique identifier for the action */
    id?: string;
    /** Content the action displays */
    content?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** Callback when an action takes place */
    onAction(): void;
}
export interface CallbackAction extends BaseCallbackAction {
}
export interface DisableableAction extends Action {
    /** Should the action be disabled */
    disabled?: boolean;
}
export interface DestructableAction extends Action {
    /** Destructive action */
    destructive?: boolean;
}
export interface AppBridgeAction extends Action, DisableableAction, DestructableAction, AppBridgeActionTarget {
}
export interface IconableAction extends Action {
    /** Source of the icon */
    icon?: IconProps['source'];
}
export interface LoadableAction extends Action {
    /** Should a spinner be displayed */
    loading?: boolean;
}
export interface ActionListItemDescriptor extends IconableAction, DisableableAction, BadgeAction, DestructableAction, AppBridgeAction {
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** Additional hint text to display with item */
    helpText?: string;
    /** Image source */
    image?: string;
    /**  Add an ellipsis suffix to action content */
    ellipsis?: boolean;
    /** Whether the action is active or not */
    active?: boolean;
    /** Defines a role for the action */
    role?: string;
}
export interface ActionListSection {
    /** Section title */
    title?: string;
    /** Collection of action items for the list */
    items: ActionListItemDescriptor[];
}
export interface ComplexAction extends Action, DisableableAction, DestructableAction, AppBridgeAction, IconableAction, LoadableAction {
}
export interface MenuGroupDescriptor extends BadgeAction {
    /** Menu group title */
    title: string;
    /** List of actions */
    actions: ActionListItemDescriptor[];
    /** Icon to display */
    icon?: IconableAction['icon'];
    /** Action details */
    details?: React.ReactNode;
    /** Callback when any action takes place */
    onActionAnyItem?: ActionListItemDescriptor['onAction'];
}
export declare enum Key {
    Backspace = 8,
    Tab = 9,
    Enter = 13,
    Shift = 16,
    Ctrl = 17,
    Alt = 18,
    Pause = 19,
    CapsLock = 20,
    Escape = 27,
    Space = 32,
    PageUp = 33,
    PageDown = 34,
    End = 35,
    Home = 36,
    LeftArrow = 37,
    UpArrow = 38,
    RightArrow = 39,
    DownArrow = 40,
    Insert = 45,
    Delete = 46,
    Key0 = 48,
    Key1 = 49,
    Key2 = 50,
    Key3 = 51,
    Key4 = 52,
    Key5 = 53,
    Key6 = 54,
    Key7 = 55,
    Key8 = 56,
    Key9 = 57,
    KeyA = 65,
    KeyB = 66,
    KeyC = 67,
    KeyD = 68,
    KeyE = 69,
    KeyF = 70,
    KeyG = 71,
    KeyH = 72,
    KeyI = 73,
    KeyJ = 74,
    KeyK = 75,
    KeyL = 76,
    KeyM = 77,
    KeyN = 78,
    KeyO = 79,
    KeyP = 80,
    KeyQ = 81,
    KeyR = 82,
    KeyS = 83,
    KeyT = 84,
    KeyU = 85,
    KeyV = 86,
    KeyW = 87,
    KeyX = 88,
    KeyY = 89,
    KeyZ = 90,
    LeftMeta = 91,
    RightMeta = 92,
    Select = 93,
    Numpad0 = 96,
    Numpad1 = 97,
    Numpad2 = 98,
    Numpad3 = 99,
    Numpad4 = 100,
    Numpad5 = 101,
    Numpad6 = 102,
    Numpad7 = 103,
    Numpad8 = 104,
    Numpad9 = 105,
    Multiply = 106,
    Add = 107,
    Subtract = 109,
    Decimal = 110,
    Divide = 111,
    F1 = 112,
    F2 = 113,
    F3 = 114,
    F4 = 115,
    F5 = 116,
    F6 = 117,
    F7 = 118,
    F8 = 119,
    F9 = 120,
    F10 = 121,
    F11 = 122,
    F12 = 123,
    NumLock = 144,
    ScrollLock = 145,
    Semicolon = 186,
    Equals = 187,
    Comma = 188,
    Dash = 189,
    Period = 190,
    ForwardSlash = 191,
    GraveAccent = 192,
    OpenBracket = 219,
    BackSlash = 220,
    CloseBracket = 221,
    SingleQuote = 222
}
export declare enum TypeOf {
    Undefined = "undefined",
    Object = "object",
    Boolean = "boolean",
    Number = "number",
    String = "string",
    Symbol = "symbol",
    Function = "function"
}
export interface GeneralObject {
    [key: string]: any;
}
export declare type DeepPartial<T> = {
    [P in keyof T]?: T[P] extends (infer U)[] ? DeepPartial<U>[] : T[P] extends ReadonlyArray<infer U> ? ReadonlyArray<DeepPartial<U>> : DeepPartial<T[P]>;
};
export declare type EffectCallback = () => void | (() => void | undefined);
export declare type DependencyList = ReadonlyArray<unknown>;
export declare type Comparator = (a: DependencyList, b: DependencyList) => boolean;
export interface CheckboxHandles {
    focus(): void;
}
