"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
function compose() {
    var wrappingFunctions = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        wrappingFunctions[_i] = arguments[_i];
    }
    return function wrapComponent(OriginalComponent) {
        var result = wrappingFunctions.reduceRight(function (component, wrappingFunction) {
            return wrappingFunction(component);
        }, OriginalComponent);
        return hoist_non_react_statics_1.default(result, OriginalComponent);
    };
}
exports.default = compose;
