'use strict';
var alphabet = require('./alphabet');

function isShortId(id) {
    if (!id || typeof id !== 'string' || id.length < 6 ) {
        return false;
    }

    var characters = alphabet.characters();
    var invalidCharacters = id.split('').map(function(char){
        if (characters.indexOf(char) === -1) {
            return char;
        }
    }).join('').split('').join('');

    return invalidCharacters.length === 0;
}

module.exports = isShortId;
