/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
import { resolveIcon } from './resolveIcon';
export class Icon {
  constructor() {
    this.size = undefined;
    this.color = undefined;
    this.name = undefined;
    this.src = undefined;
    this.svgContent = undefined;
  }
  connectedCallback() {
    this.loadIconContent();
  }
  async loadIconContent() {
    this.svgContent = await resolveIcon(this);
  }
  render() {
    const style = {};
    if (this.color) {
      style['color'] = `var(--theme-${this.color})`;
    }
    if (this.name && !this.svgContent) {
      const iconName = this.name;
      return (h(Host, { style: style, class: {
          ['size-12']: this.size === '12',
          ['size-16']: this.size === '16',
          ['size-24']: this.size === '24',
          ['size-32']: this.size === '32',
        } }, h("i", { class: {
          'glyph': true,
          [`glyph-${iconName}`]: true,
          'glyph-12': this.size === '12',
          'glyph-16': this.size === '16',
          'glyph-24': this.size === '24',
          'glyph-32': this.size === '32',
        } })));
    }
    return (h(Host, { style: style, class: {
        ['size-12']: this.size === '12',
        ['size-16']: this.size === '16',
        ['size-24']: this.size === '24',
        ['size-32']: this.size === '32',
      } }, this.svgContent ? (h("div", { class: 'svg-container', innerHTML: this.svgContent })) : (h("span", { class: "skeleton-box", style: {
        width: '100%',
        height: '100%',
      } }))));
  }
  static get is() { return "ix-icon"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["icon.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["icon.css"]
    };
  }
  static get properties() {
    return {
      "size": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "'12' | '16' | '24' | '32'",
          "resolved": "\"12\" | \"16\" | \"24\" | \"32\"",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Size of the icon"
        },
        "attribute": "size",
        "reflect": false
      },
      "color": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Color of the icon"
        },
        "attribute": "color",
        "reflect": false
      },
      "name": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Use one of our defined icon names e.g. `copy`\n\nhttps://ix.siemens.io/docs/icon-library/icons\n\nor the import variant\n\n```\nimport { rocket } from '@siemens/ix-icons/icons';\n\n<ix-icon name={rocket}></ix-icon>\n```"
        },
        "attribute": "name",
        "reflect": true
      },
      "src": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [{
              "name": "internal",
              "text": undefined
            }],
          "text": "Path to load external SVG. All color properties\nwill be overwritten by `--theme-color-std-text`\n\nhttps://ix.siemens.io/docs/theming/colors"
        },
        "attribute": "src",
        "reflect": false
      }
    };
  }
  static get states() {
    return {
      "svgContent": {}
    };
  }
  static get watchers() {
    return [{
        "propName": "src",
        "methodName": "loadIconContent"
      }, {
        "propName": "name",
        "methodName": "loadIconContent"
      }];
  }
}
//# sourceMappingURL=icon.js.map
