export const isSvgDataUrl = (url) => {
  if (!url) {
    return false;
  }
  if (typeof url !== 'string') {
    return false;
  }
  return url.startsWith('data:image/svg+xml');
};
let parser = null;
function parseSVGDataContent(content) {
  if (typeof window['DOMParser'] === 'undefined') {
    console.warn('DOMParser not supported by your browser.');
    return;
  }
  if (parser === null) {
    parser = new window['DOMParser']();
  }
  const svgDocument = parser.parseFromString(content, 'text/html');
  const svgElement = svgDocument.querySelector('svg');
  if (!svgElement) {
    throw Error('No valid svg data provided');
  }
  return svgElement.outerHTML;
}
async function fetchSVG(url) {
  const response = await fetch(url);
  const responseText = await response.text();
  if (!response.ok) {
    console.error(responseText);
    return '';
  }
  return parseSVGDataContent(responseText);
}
export async function resolveIcon(icon) {
  const { src, name } = icon;
  if (name) {
    if (isSvgDataUrl(name)) {
      return parseSVGDataContent(name);
    }
    //Fallback return undefined to render web font icon
    return;
  }
  if (!src) {
    return '';
  }
  if (isSvgDataUrl(src)) {
    return parseSVGDataContent(src);
  }
  return fetchSVG(src);
}
//# sourceMappingURL=resolveIcon.js.map
