export declare class Icon {
  /**
   * Size of the icon
   */
  size: '12' | '16' | '24' | '32';
  /**
   * Color of the icon
   */
  color: string;
  /**
   * Use one of our defined icon names e.g. `copy`
   *
   * https://ix.siemens.io/docs/icon-library/icons
   *
   * or the import variant
   *
   * ```
   * import { rocket } from '@siemens/ix-icons/icons';
   *
   * <ix-icon name={rocket}></ix-icon>
   * ```
   */
  name: string;
  /**
   * Path to load external SVG. All color properties
   * will be overwritten by `--theme-color-std-text`
   *
   * https://ix.siemens.io/docs/theming/colors
   *
   * @internal
   */
  src?: string;
  svgContent?: string;
  connectedCallback(): void;
  loadIconContent(): Promise<void>;
  render(): any;
}
