/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
import { iconMissingSymbol } from './icons';
import { parseSVGDataContent, resolveIcon } from './resolveIcon';
export class Icon {
  constructor() {
    this.size = undefined;
    this.color = undefined;
    this.name = undefined;
    this.svgContent = undefined;
  }
  connectedCallback() {
    this.loadIconContent();
  }
  async loadIconContent() {
    try {
      this.svgContent = await resolveIcon(this);
    }
    catch (error) {
      this.svgContent = parseSVGDataContent(iconMissingSymbol);
    }
  }
  render() {
    const style = {};
    if (this.color) {
      style['color'] = `var(--theme-${this.color})`;
    }
    return (h(Host, { style: style, class: {
        ['size-12']: this.size === '12',
        ['size-16']: this.size === '16',
        ['size-24']: this.size === '24',
        ['size-32']: this.size === '32',
      } }, h("div", { class: 'svg-container', innerHTML: this.svgContent })));
  }
  static get is() { return "ix-icon"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["icon.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["icon.css"]
    };
  }
  static get properties() {
    return {
      "size": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "'12' | '16' | '24' | '32'",
          "resolved": "\"12\" | \"16\" | \"24\" | \"32\"",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Size of the icon"
        },
        "attribute": "size",
        "reflect": false
      },
      "color": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Color of the icon"
        },
        "attribute": "color",
        "reflect": false
      },
      "name": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "IxIcons",
          "resolved": "\"log\" | \"screenshot\" | \"filter\" | \"map\" | \"info\" | \"error\" | \"success\" | \"copy\" | \"document\" | \"code\" | \"details\" | \"label\" | \"link\" | \"script\" | \"table\" | \"circle\" | \"ellipse\" | \"image\" | \"polygon\" | \"stop\" | \"text\" | \"download\" | \"about\" | \"replace\" | \"import\" | \"history\" | \"location\" | \"screen\" | \"close\" | \"print\" | (string & {}) | \"about-filled\" | \"add-application\" | \"add-circle-filled\" | \"add-circle\" | \"add-document-note\" | \"add-eye-filled\" | \"add-eye\" | \"add-task-list\" | \"add-task\" | \"add-user-filled\" | \"add-user\" | \"add\" | \"ai\" | \"alarm-bell-cancelled-filled\" | \"alarm-bell-cancelled\" | \"alarm-bell-filled\" | \"alarm-bell\" | \"alarm-clock-filled\" | \"alarm-clock\" | \"alarm-filled\" | \"alarm\" | \"analyze\" | \"anomaly-found\" | \"anomaly\" | \"app-menu\" | \"application-screen\" | \"applications\" | \"apps\" | \"arrow-diagonal-bottom-left\" | \"arrow-diagonal-bottom-right\" | \"arrow-diagonal-top-left\" | \"arrow-diagonal-top-right\" | \"arrow-down-right\" | \"arrow-down\" | \"arrow-left\" | \"arrow-right-down\" | \"arrow-right\" | \"arrow-up\" | \"attach\" | \"attachment-upload\" | \"audio-description1\" | \"audio-description2\" | \"audit-report\" | \"average\" | \"backup-filled\" | \"backup\" | \"bar-code\" | \"barchart\" | \"battery-check\" | \"battery-empty-question\" | \"battery-empty\" | \"battery-exclamation\" | \"battery-full-check\" | \"battery-full\" | \"battery-half\" | \"battery-low\" | \"battery-quarter\" | \"battery-slash\" | \"battery-three-quarter\" | \"battery-xmark\" | \"bezier-curve\" | \"binoculars-filled\" | \"binoculars\" | \"blazor\" | \"book\" | \"bookmark-filled\" | \"bookmark\" | \"boundary-signals\" | \"building1-filled\" | \"building1\" | \"building2-filled\" | \"building2\" | \"bulb-filled\" | \"bulb\" | \"calendar-filled\" | \"calendar-settings\" | \"calendar\" | \"cancel\" | \"cancelled\" | \"capacity-filled\" | \"capacity\" | \"capture\" | \"car-filled\" | \"car\" | \"card-layout-filled\" | \"card-layout\" | \"certificate-error-filled\" | \"certificate-error\" | \"certificate-exclamation-filled\" | \"certificate-exclamation\" | \"certificate-success-filled\" | \"certificate-success\" | \"chart-cursor\" | \"chart-curve-linear\" | \"chart-curve-spline\" | \"chart-curve-stepped\" | \"chart-diagram-add\" | \"chart-diagram\" | \"chart-diagrams\" | \"chart-labels-filled\" | \"chart-labels\" | \"check-in\" | \"check-out\" | \"check\" | \"checkbox-component-checked\" | \"checkbox-component-mixed\" | \"checkbox-component-unchecked\" | \"checkbox-filled\" | \"checkbox\" | \"checkboxes-filled\" | \"checkboxes\" | \"chevron-down-small\" | \"chevron-down\" | \"chevron-left-small\" | \"chevron-left\" | \"chevron-right-small\" | \"chevron-right\" | \"chevron-up-small\" | \"chevron-up\" | \"circle-dot-filled\" | \"circle-dot\" | \"circle-filled\" | \"circle-pause-filled\" | \"circle-pause\" | \"circle-play-filled\" | \"circle-play\" | \"circle-stop-filled\" | \"circle-stop\" | \"clear-filter-filled\" | \"clear-filter\" | \"clear\" | \"clock-filled\" | \"clock\" | \"close-small\" | \"cloud-download-add-filled\" | \"cloud-download-add\" | \"cloud-download-filled\" | \"cloud-download-list-filled\" | \"cloud-download-list\" | \"cloud-download\" | \"cloud-fail-filled\" | \"cloud-fail\" | \"cloud-filled\" | \"cloud-new-filled\" | \"cloud-new\" | \"cloud-success-filled\" | \"cloud-success\" | \"cloud-upload-filled\" | \"cloud-upload\" | \"cloud\" | \"coffee-empty-filled\" | \"coffee-empty\" | \"coffee-filled\" | \"coffee\" | \"cogwheel-filled\" | \"cogwheel\" | \"combine\" | \"compact-disc-filled\" | \"compact-disc\" | \"compound-block\" | \"configuration\" | \"configure-filled\" | \"configure\" | \"connected\" | \"connector-chart-filled\" | \"connector-chart\" | \"connector-filled\" | \"connector-hex-filled\" | \"connector-hex\" | \"connector-rect-filled\" | \"connector-rect\" | \"connector-rhomb-filled\" | \"connector-rhomb\" | \"connector\" | \"consistency-check\" | \"contact-details-filled\" | \"contact-details\" | \"context-menu\" | \"controlled-device\" | \"controller-device\" | \"corner-arrow-up-left\" | \"couch-filled\" | \"couch\" | \"create-plant-filled\" | \"create-plant\" | \"cut\" | \"cycle\" | \"data-egress\" | \"data-ingress-egress\" | \"data-ingress\" | \"database-filled\" | \"database\" | \"diagram-module-library\" | \"diagram-module-new\" | \"diagram-module\" | \"diamond\" | \"disconnected\" | \"disk-filled\" | \"disk-pen\" | \"disk\" | \"distribution\" | \"doc-document\" | \"document-bulk\" | \"document-fail\" | \"document-info\" | \"document-link\" | \"document-management\" | \"document-reference\" | \"document-settings\" | \"document-success\" | \"double-check\" | \"double-chevron-down\" | \"double-chevron-left\" | \"double-chevron-right\" | \"double-chevron-up\" | \"doublet-filled\" | \"doublet\" | \"download-add\" | \"download-list\" | \"drop\" | \"duplicate-document\" | \"duplicate\" | \"e-mail-filled\" | \"e-mail\" | \"earth-filled\" | \"earth\" | \"edit-plant\" | \"electrical-energy-filled\" | \"electrical-energy\" | \"ellipse-arc\" | \"ellipse-filled\" | \"error-filled\" | \"explore-filled\" | \"explore\" | \"export\" | \"eye-cancelled-filled\" | \"eye-cancelled\" | \"eye-filled\" | \"eye\" | \"factory-reset-filled\" | \"factory-reset\" | \"filter-filled\" | \"filter-outline\" | \"fit-to-screen\" | \"flag-filled\" | \"flag\" | \"folder-down-filled\" | \"folder-down\" | \"folder-filled\" | \"folder-new-filled\" | \"folder-new-outline\" | \"folder-new\" | \"folder-open-filled\" | \"folder-open-outline\" | \"folder-open\" | \"folder-outline\" | \"folder-up-filled\" | \"folder-up\" | \"folder\" | \"full-screeen-exit\" | \"full-screeen\" | \"full-screen-exit\" | \"full-screen\" | \"function-block-library\" | \"function-block-new\" | \"function-block\" | \"function-diagram-new\" | \"function-diagram\" | \"gauge-filled\" | \"gauge\" | \"gaugechart\" | \"global-plant-filled\" | \"global-plant\" | \"globe-filled\" | \"globe\" | \"goto\" | \"group\" | \"hard-reset\" | \"hardware-cabinet\" | \"health-filled\" | \"health\" | \"heart-filled\" | \"heart\" | \"hexagon-vertical-bars-database-filled\" | \"hexagon-vertical-bars-database\" | \"hexagon-vertical-bars-filled\" | \"hexagon-vertical-bars\" | \"hierarchy\" | \"highlight-filled\" | \"highlight\" | \"history-list\" | \"home-filled\" | \"home\" | \"hourglass\" | \"image-filled\" | \"info-feed\" | \"info-filled\" | \"ingestion-report\" | \"ingestion\" | \"ink-pen\" | \"inquiry-filled\" | \"inquiry-mail\" | \"inquiry\" | \"item-details-filled\" | \"item-details\" | \"label-filled\" | \"landing-page-logo\" | \"language-filled\" | \"language\" | \"layers-filled\" | \"layers\" | \"leaf\" | \"legal\" | \"library-new\" | \"library\" | \"license\" | \"light-dark\" | \"line-diagonal\" | \"list\" | \"live-schedule\" | \"location-filled\" | \"location-outline\" | \"lock-filled\" | \"lock-key-filled\" | \"lock-key\" | \"lock\" | \"log-in\" | \"log-out\" | \"logic-diagram\" | \"lower-limit\" | \"mail-filled\" | \"mail\" | \"maintenance-documents\" | \"maintenance-info\" | \"maintenance-warning-filled\" | \"maintenance-warning\" | \"maintenance\" | \"mandatory-done\" | \"mandatory\" | \"maximize\" | \"microphone-filled\" | \"microphone\" | \"minimize\" | \"minus\" | \"missing-symbol\" | \"mix\" | \"monitor-filled\" | \"monitor-trend\" | \"monitor\" | \"monitoring-add\" | \"monitoring\" | \"monitorings\" | \"moon-filled\" | \"moon\" | \"more-menu\" | \"mouse-click-filled\" | \"mouse-click\" | \"mouse-select-filled\" | \"mouse-select\" | \"mp4-document\" | \"namur-check-function-filled\" | \"namur-check-function\" | \"namur-failure-filled\" | \"namur-failure\" | \"namur-maintenance-required-filled\" | \"namur-maintenance-required\" | \"namur-ok-filled\" | \"namur-ok\" | \"namur-out-of-spec-filled\" | \"namur-out-of-spec\" | \"navigation-filled\" | \"navigation-left\" | \"navigation-right\" | \"navigation\" | \"new-indicator-filled\" | \"new-indicator\" | \"no-filter-filled\" | \"no-filter\" | \"no-image\" | \"note-filled\" | \"note\" | \"notification-filled\" | \"notification\" | \"notifications-filled\" | \"notifications\" | \"ontology-filled\" | \"ontology\" | \"open-external\" | \"open-file-filled\" | \"open-file\" | \"operate-plant-filled\" | \"operate-plant\" | \"optimize\" | \"p-and-i-symbols\" | \"p-i-diagram\" | \"pan\" | \"paste\" | \"pause\" | \"pc-tower-filled\" | \"pc-tower\" | \"pdf-document\" | \"pen-filled\" | \"pen\" | \"phone-filled\" | \"phone\" | \"photo-camera-add\" | \"photo-camera-cancelled-filled\" | \"photo-camera-cancelled\" | \"photo-camera-filled\" | \"photo-camera\" | \"photo-cameras\" | \"piechart-filled\" | \"piechart\" | \"pin-filled\" | \"pin\" | \"plant-filled\" | \"plant-handbook-filled\" | \"plant-handbook\" | \"plant-outline\" | \"plant-security\" | \"plant-settings-filled\" | \"plant-settings\" | \"plant-user-filled\" | \"plant-user\" | \"plant\" | \"plants-filled\" | \"plants\" | \"play-filled\" | \"play-pause-filled\" | \"play-pause\" | \"play-stepwise-filled\" | \"play-stepwise\" | \"play\" | \"plus-minus-times-divide\" | \"plus\" | \"point-up-filled\" | \"point-up\" | \"polar-plot\" | \"polygon-filled\" | \"polygon-line\" | \"ppt-document\" | \"print-filled\" | \"prio-high\" | \"prio-low\" | \"prio-middle\" | \"product-catalog\" | \"product-management\" | \"product\" | \"project-configuration\" | \"project-new\" | \"project-scenarios\" | \"project-server-filled\" | \"project-server\" | \"project\" | \"protocol\" | \"publish-document\" | \"publish\" | \"qr-code\" | \"quality-report\" | \"question-filled\" | \"question\" | \"radarchart\" | \"radio-waves-off\" | \"radio-waves-warning\" | \"radio-waves\" | \"random-filled\" | \"random\" | \"reboot\" | \"rectangle-filled\" | \"rectangle\" | \"redo\" | \"reference\" | \"refresh-cancelled\" | \"refresh\" | \"reload\" | \"remove-application\" | \"remove-eye-filled\" | \"remove-eye\" | \"rename\" | \"report-barchart\" | \"report-linechart\" | \"report-text\" | \"reset\" | \"restore-backup-filled\" | \"restore-backup-pc\" | \"restore-backup\" | \"rhomb-filled\" | \"rhomb\" | \"road-filled\" | \"road\" | \"rocket-filled\" | \"rocket\" | \"route-target\" | \"route\" | \"scatterplot\" | \"scheduler-filled\" | \"scheduler\" | \"screen-filled\" | \"screenshot-filled\" | \"script-add\" | \"scripts\" | \"search\" | \"share-filled\" | \"share\" | \"shopping-cart-filled\" | \"shopping-cart\" | \"shout-filled\" | \"shout\" | \"sign-language\" | \"signal-strength-0\" | \"signal-strength-1\" | \"signal-strength-2\" | \"signal-strength-3\" | \"signal-strength-4\" | \"signal-strength-5\" | \"signal-strength-6\" | \"signal-strength-7\" | \"signal-strength-8\" | \"simit-component\" | \"simit-macro-component-editor\" | \"simit-macro\" | \"single-check\" | \"skip-back-filled\" | \"skip-back\" | \"skip-filled\" | \"skip\" | \"snowflake\" | \"sort-ascending\" | \"sort-descending\" | \"sort\" | \"sound-loud-filled\" | \"sound-loud\" | \"sound-mute-filled\" | \"sound-mute\" | \"sound-off-filled\" | \"sound-off\" | \"sound-quiet-filled\" | \"sound-quiet\" | \"spatial\" | \"split-horizontally\" | \"split-vertically\" | \"stamp-filled\" | \"stamp\" | \"standby\" | \"star-add-filled\" | \"star-add\" | \"star-cancelled-filled\" | \"star-cancelled\" | \"star-filled\" | \"star-list-filled\" | \"star-list\" | \"star\" | \"start-data-analysis\" | \"steering-user-filled\" | \"steering-user\" | \"steering\" | \"stethoscope\" | \"stop-filled\" | \"success-filled\" | \"sun-filled\" | \"sun\" | \"support\" | \"surveillance-cancelled-filled\" | \"surveillance-cancelled\" | \"surveillance-filled\" | \"surveillance\" | \"svg-document\" | \"swap-left-right\" | \"switch-slider\" | \"table-columns\" | \"table-rows\" | \"table-settings\" | \"tag-filled\" | \"tag-plus-filled\" | \"tag-plus\" | \"tag\" | \"tasks-all\" | \"tasks-done\" | \"tasks-open\" | \"text-circle-rectangle-filled\" | \"text-circle-rectangle\" | \"text-document\" | \"threshold-cancelled\" | \"threshold-off\" | \"threshold-on\" | \"to-be-published\" | \"to-search\" | \"topic-filled\" | \"topic\" | \"touch-filled\" | \"touch\" | \"trashcan-filled\" | \"trashcan\" | \"tree\" | \"trend-downward-filled\" | \"trend-downward\" | \"trend-sideways-filled\" | \"trend-sideways\" | \"trend-upward-filled\" | \"trend-upward\" | \"trend\" | \"triangle-filled\" | \"triangle\" | \"truck-filled\" | \"truck\" | \"tulip-filled\" | \"tulip\" | \"txt-document\" | \"undo\" | \"ungroup\" | \"unlock-filled\" | \"unlock-plant-filled\" | \"unlock-plant\" | \"unlock\" | \"upload-document-note\" | \"upload-fail\" | \"upload-success\" | \"upload\" | \"upper-limit\" | \"user-check-filled\" | \"user-check\" | \"user-fail-filled\" | \"user-fail\" | \"user-filled\" | \"user-management-filled\" | \"user-management\" | \"user-profile-filled\" | \"user-profile\" | \"user-reading-reading\" | \"user-reading\" | \"user-settings-filled\" | \"user-settings\" | \"user\" | \"validate\" | \"vdi-folder\" | \"version-history\" | \"video-file-filled\" | \"video-file\" | \"warning-filled\" | \"warning-rhomb-filled\" | \"warning-rhomb\" | \"warning\" | \"water-bathing\" | \"water-fish\" | \"water-plant\" | \"water-sunbathing\" | \"waveform\" | \"webcam-cancelled-filled\" | \"webcam-cancelled\" | \"webcam-filled\" | \"webcam\" | \"wlan-off\" | \"wlan-strength-0\" | \"wlan-strength-1\" | \"wlan-strength-2\" | \"wlan-strength-3\" | \"work-case-filled\" | \"work-case\" | \"workspace\" | \"workspaces\" | \"x-axis-settings\" | \"xls-document\" | \"xml-document\" | \"y-axis-settings\" | \"youtube-filled\" | \"youtube\" | \"zoom-in\" | \"zoom-out\" | \"zoom-selection\"",
          "references": {
            "IxIcons": {
              "location": "import",
              "path": "./icons"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Use one of our defined icon names e.g. `copy`\n\nhttps://ix.siemens.io/docs/icon-library/icons\n\nor the import variant\n\n```\nimport { rocket } from '@siemens/ix-icons/icons';\n\n<ix-icon name={rocket}></ix-icon>\n```"
        },
        "attribute": "name",
        "reflect": false
      }
    };
  }
  static get states() {
    return {
      "svgContent": {}
    };
  }
  static get watchers() {
    return [{
        "propName": "name",
        "methodName": "loadIconContent"
      }];
  }
}
//# sourceMappingURL=icon.js.map
