/*
 * COPYRIGHT (c) Siemens AG 2018-2023 ALL RIGHTS RESERVED.
 */
import * as metaTag from "./../meta-tag";
import { resolveIcon } from "../resolveIcon";
const exampleSvg = `
<?xml version="1.0" encoding="UTF-8"?>
<svg width="512px" height="512px" viewBox="0 0 512 512" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>add</title>
    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Shape" fill="#000000" transform="translate(65.929697, 65.929697)">
            <polygon points="211.189225 2.36847579e-14 211.189225 168.95138 380.140606 168.95138 380.140606 211.189225 211.189225 211.189225 211.189225 380.140606 168.95138 380.140606 168.95138 211.189225 -1.42108547e-14 211.189225 -1.42108547e-14 168.95138 168.95138 168.95138 168.95138 -1.42108547e-14"></polygon>
        </g>
    </g>
</svg>
`;
const invalidexampleSvg = `
<?xml version="1.0" encoding="UTF-8"?>
<script>
    alert('Test!');
</script>
`;
jest.mock('../meta-tag');
jest.mock('../icons', () => ({
    iconStar: exampleSvg,
}));
let fetch = (global.fetch = jest.fn((url) => {
    console.log(url);
    if (url === '/svg/bulb.svg') {
        return Promise.resolve({
            text: () => Promise.resolve(exampleSvg),
            ok: true,
        });
    }
    if (url === 'http://localhost/test.svg') {
        return Promise.resolve({
            text: () => Promise.resolve(exampleSvg),
            ok: true,
        });
    }
    if (url === 'http://localhost/invalid.svg') {
        return Promise.resolve({
            text: () => Promise.resolve(invalidexampleSvg),
            ok: true,
        });
    }
}));
describe('resolve icon', () => {
    beforeEach(() => {
        fetch.mockClear();
    });
    it('should resolve svg from name', async () => {
        const icon = 'star';
        const data = await resolveIcon(icon);
        expect(data).toBe(`<svg width=\"512px\" height=\"512px\" viewBox=\"0 0 512 512\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"> <title>add</title> <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\"> <g id=\"Shape\" fill=\"#000000\" transform=\"translate(65.929697, 65.929697)\"> <polygon points=\"211.189225 2.36847579e-14 211.189225 168.95138 380.140606 168.95138 380.140606 211.189225 211.189225 211.189225 211.189225 380.140606 168.95138 380.140606 168.95138 211.189225 -1.42108547e-14 211.189225 -1.42108547e-14 168.95138 168.95138 168.95138 168.95138 -1.42108547e-14\"></polygon> </g> </g> </svg>`);
    });
    it('resolve by v3 preview feature flat', async () => {
        metaTag.isV3PreviewEnabled = jest.fn(() => true);
        const icon = 'bulb';
        const data = await resolveIcon(icon);
        expect(data).toBe(`<svg width=\"512px\" height=\"512px\" viewBox=\"0 0 512 512\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"> <title>add</title> <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\"> <g id=\"Shape\" fill=\"#000000\" transform=\"translate(65.929697, 65.929697)\"> <polygon points=\"211.189225 2.36847579e-14 211.189225 168.95138 380.140606 168.95138 380.140606 211.189225 211.189225 211.189225 211.189225 380.140606 168.95138 380.140606 168.95138 211.189225 -1.42108547e-14 211.189225 -1.42108547e-14 168.95138 168.95138 168.95138 168.95138 -1.42108547e-14\"></polygon> </g> </g> </svg>`);
    });
    it('should resolve svg from src', async () => {
        const expectedName = await resolveIcon('http://localhost/test.svg');
        expect(expectedName).toEqual(`<svg width=\"512px\" height=\"512px\" viewBox=\"0 0 512 512\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"> <title>add</title> <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\"> <g id=\"Shape\" fill=\"#000000\" transform=\"translate(65.929697, 65.929697)\"> <polygon points=\"211.189225 2.36847579e-14 211.189225 168.95138 380.140606 168.95138 380.140606 211.189225 211.189225 211.189225 211.189225 380.140606 168.95138 380.140606 168.95138 211.189225 -1.42108547e-14 211.189225 -1.42108547e-14 168.95138 168.95138 168.95138 168.95138 -1.42108547e-14\"></polygon> </g> </g> </svg>`);
    });
    it('should not resolve invalid svg from src', async () => {
        const icon = 'http://localhost/invalid.svg';
        await expect(resolveIcon(icon)).rejects.toThrow('No valid svg data provided');
    });
});
//# sourceMappingURL=resolveIcon.spec.js.map
