'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('./icon-4c954853.js');
const logicalFilterOperator = require('./logical-filter-operator-20233f71.js');
const flipTileState = require('./flip-tile-state-b5ff5ea0.js');
const modalUtils = require('./modal-utils-b645989b.js');
const defaultTreeItem = require('./default-tree-item-89cd1f3f.js');
const uploadFileState = require('./upload-file-state-a79acf2b.js');
const rwd_util = require('./rwd.util-9480f0b5.js');
const themeSwitcher = require('./theme-switcher-bdbd0d30.js');
require('./index-c978628a.js');
require('./typed-event-f0f051da.js');

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class FilterState {
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function getToastContainer() {
  const containerList = Array.from(document.querySelectorAll('ix-toast-container'));
  const [container] = containerList;
  if (containerList.length > 1) {
    console.warn('Multiple toast container are found. Only there first is used.');
    return container;
  }
  if (!container) {
    const toastContainer = document.createElement('ix-toast-container');
    document.body.appendChild(toastContainer);
    return toastContainer;
  }
  return container;
}
function setToastPosition(position) {
  getToastContainer().position = position;
}
async function toast(config) {
  const context = getToastContainer();
  const toast = await context.showToast(config);
  return toast;
}
toast.info = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'info' }));
};
toast.error = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'error' }));
};
toast.success = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'success' }));
};
toast.warning = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'warning' }));
};

exports.InputState = logicalFilterOperator.InputState;
Object.defineProperty(exports, 'LogicalFilterOperator', {
  enumerable: true,
  get: function () {
    return logicalFilterOperator.LogicalFilterOperator;
  }
});
Object.defineProperty(exports, 'FlipTileState', {
  enumerable: true,
  get: function () {
    return flipTileState.FlipTileState;
  }
});
exports.closeModal = modalUtils.closeModal;
exports.dismissModal = modalUtils.dismissModal;
exports.modal = modalUtils.modal;
exports.renderDefaultItem = defaultTreeItem.renderDefaultItem;
Object.defineProperty(exports, 'UploadFileState', {
  enumerable: true,
  get: function () {
    return uploadFileState.UploadFileState;
  }
});
exports.convertToAbbreviationString = rwd_util.convertToAbbreviationString;
exports.convertToRemString = rwd_util.convertToRemString;
exports.ThemeSwitcher = themeSwitcher.ThemeSwitcher;
exports.themeSwitcher = themeSwitcher.themeSwitcher;
exports.FilterState = FilterState;
exports.getToastContainer = getToastContainer;
exports.setToastPosition = setToastPosition;
exports.toast = toast;

//# sourceMappingURL=index.cjs.js.map