'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-c978628a.js');
const context = require('./context-a0900b95.js');
const service = require('./service-18dc5907.js');
require('./typed-event-f0f051da.js');

const applicationHeaderCss = ":host{display:flex;align-items:center;position:relative;width:100%;height:2.75rem;padding-left:1rem;color:var(--theme-app-header--color);background-color:var(--theme-app-header--background);border-bottom:var(--theme-app-header--border-width) solid var(--theme-app-header--border-color)}:host .name{margin-left:2.5rem;margin-right:2.5rem;color:var(--theme-app-header--color)}:host .logo{display:inline-flex;align-items:center;position:relative;height:32px;overflow:hidden;line-height:0rem;color:var(--theme-app-header-logo--color)}:host(.mode-mobile){padding-left:0.5rem}:host(.mode-mobile) .logo{margin-left:0.5rem}";

const ApplicationHeader = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.name = undefined;
    this.mode = 'desktop';
    this.menuExpanded = false;
  }
  componentWillLoad() {
    const layout = context.hostContext('ix-basic-navigation', this.host);
    if (context.isBasicNavigationLayout(layout)) {
      this.modeDisposable = service.screenMode.onChange.on((mode) => (this.mode = mode));
      this.mode = service.screenMode.mode;
      this.menuDisposable = context.menuController.expandChange.on((show) => {
        this.menuExpanded = show;
      });
    }
  }
  componentDidLoad() {
    this.attachSiemensLogoIfLoaded();
  }
  disconnectedCallback() {
    var _a, _b;
    (_a = this.menuDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
    (_b = this.modeDisposable) === null || _b === void 0 ? void 0 : _b.dispose();
  }
  async attachSiemensLogoIfLoaded() {
    await window.customElements.whenDefined('ix-siemens-logo');
    const logoElement = document.createElement('ix-siemens-logo');
    if (!this.host.querySelector('[slot="logo"]')) {
      this.host.shadowRoot.querySelector('.logo').appendChild(logoElement);
    }
  }
  async onMenuClick() {
    context.menuController.toggle();
  }
  render() {
    return (index.h(index.Host, { class: { [`mode-${this.mode}`]: true } }, this.mode === 'mobile' ? (index.h("ix-burger-menu", { onClick: () => this.onMenuClick(), expanded: this.menuExpanded })) : null, index.h("div", { class: "logo" }, index.h("slot", { name: "logo" })), index.h("div", { class: "name" }, this.name), index.h("slot", null)));
  }
  get host() { return index.getElement(this); }
};
ApplicationHeader.style = applicationHeaderCss;

exports.ix_application_header = ApplicationHeader;

//# sourceMappingURL=ix-application-header.cjs.entry.js.map