'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-c978628a.js');

const contentHeaderCss = ":host{display:flex;flex-direction:row;align-items:flex-start;padding:0px}:host .titleGroup{display:flex;flex-direction:column;flex:1 1 0%}:host .subtitle{margin-top:0.5rem}:host .backButton{margin-right:0.5rem}:host .buttons{flex:0 0 auto}";

const ContentHeader = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.backButtonClick = index.createEvent(this, "backButtonClick", 7);
    this.variant = 'Primary';
    this.headerTitle = undefined;
    this.headerSubtitle = undefined;
    this.hasBackButton = false;
  }
  render() {
    return (index.h(index.Host, null, this.hasBackButton ? (index.h("ix-icon-button", { class: 'backButton', variant: "Primary", icon: "arrow-left", ghost: true, onClick: () => this.backButtonClick.emit() })) : null, index.h("div", { class: "titleGroup" }, index.h("ix-typography", { variant: this.variant === 'Secondary' ? 'large-single' : 'h2' }, this.headerTitle), this.headerSubtitle !== undefined ? (index.h("ix-typography", { variant: 'caption', color: 'soft', class: "subtitle" }, this.headerSubtitle)) : null), index.h("div", { class: "buttons" }, index.h("slot", null))));
  }
};
ContentHeader.style = contentHeaderCss;

exports.ix_content_header = ContentHeader;

//# sourceMappingURL=ix-content-header.cjs.entry.js.map