'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-c978628a.js');
const floatingUi_dom_esm = require('./floating-ui.dom.esm-01fe5abe.js');

const tooltipCss = ":host{display:inline-block;position:fixed;left:0px;top:0px;z-index:var(--theme-z-index-tooltip);max-width:18.25rem;opacity:0;visibility:collapse !important;overflow-wrap:break-word;border-radius:0.25rem;background-color:var(--theme-tootlip--background);padding:0.375rem 0.75rem 0.375rem 0.875rem;box-shadow:var(--theme-shadow-4)}:host .tooltip-title{display:flex;align-items:center}:host .tooltip-title ::slotted(ix-icon){margin-right:0.35rem}:host(.visible){opacity:1;visibility:visible !important}:host(.visible) .arrow,:host(.visible) .arrow::before{position:absolute;width:8px;height:8px;background:inherit}:host(.visible) .arrow{visibility:hidden}:host(.visible) .arrow::before{visibility:visible;content:\"\";transform:rotate(45deg);background-color:var(--theme-tootlip--background)}";

const numberToPixel = (value) => (value != null ? `${value}px` : '');
const Tooltip = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.onMouseEnterBind = this.showTooltip.bind(this);
    this.onMouseLeaveBind = this.hideTooltip.bind(this);
    this.tooltipCloseTimeInMS = 50;
    this.for = undefined;
    this.titleContent = undefined;
    this.interactive = false;
    this.placement = 'top';
    this.visible = false;
  }
  get arrowElement() {
    return this.hostElement.shadowRoot.querySelector('.arrow');
  }
  destroyAutoUpdate() {
    if (this.disposeAutoUpdate !== undefined) {
      this.disposeAutoUpdate();
    }
  }
  showTooltip(e) {
    clearTimeout(this.hideTooltipTimeout);
    this.visible = true;
    this.computeTooltipPosition(e.target);
  }
  hideTooltip() {
    this.hideTooltipTimeout = setTimeout(() => {
      this.visible = false;
    }, this.tooltipCloseTimeInMS);
    this.destroyAutoUpdate();
  }
  computeArrowPosition({ placement, middlewareData, }) {
    let { x, y } = middlewareData.arrow;
    if (placement.startsWith('top')) {
      return {
        left: numberToPixel(x),
        top: numberToPixel(y),
      };
    }
    if (placement.startsWith('right')) {
      return {
        left: numberToPixel(-4),
        top: numberToPixel(y),
      };
    }
    if (placement.startsWith('bottom')) {
      return {
        left: numberToPixel(x),
        top: numberToPixel(-4),
      };
    }
    if (placement.startsWith('left')) {
      return {
        right: numberToPixel(-4),
        top: numberToPixel(y),
      };
    }
  }
  async computeTooltipPosition(target) {
    this.disposeAutoUpdate = floatingUi_dom_esm.autoUpdate(target, this.hostElement, async () => {
      setTimeout(async () => {
        const computeResponse = await floatingUi_dom_esm.computePosition(target, this.hostElement, {
          strategy: 'fixed',
          placement: this.placement,
          middleware: [
            floatingUi_dom_esm.shift(),
            floatingUi_dom_esm.offset(8),
            floatingUi_dom_esm.arrow({
              element: this.arrowElement,
            }),
            floatingUi_dom_esm.flip({
              fallbackStrategy: 'initialPlacement',
              padding: 10,
            }),
          ],
        });
        if (computeResponse.middlewareData.arrow) {
          const arrowPosition = this.computeArrowPosition(computeResponse);
          Object.assign(this.arrowElement.style, arrowPosition);
        }
        const { x, y } = computeResponse;
        Object.assign(this.hostElement.style, {
          left: x !== null ? `${x}px` : '',
          top: y !== null ? `${y}px` : '',
        });
      });
    }, {
      ancestorResize: true,
      ancestorScroll: true,
      elementResize: true,
    });
  }
  queryAnchorElements() {
    return Array.from(document.querySelectorAll(this.for));
  }
  registerTriggerListener() {
    const elements = this.queryAnchorElements();
    elements.forEach((e) => {
      e.addEventListener('mouseenter', this.onMouseEnterBind);
      e.addEventListener('mouseleave', this.onMouseLeaveBind);
    });
  }
  registerTooltipListener() {
    this.hostElement.addEventListener('mouseenter', () => {
      if (this.interactive) {
        clearTimeout(this.hideTooltipTimeout);
      }
    });
    this.hostElement.addEventListener('mouseleave', () => {
      this.hideTooltip();
    });
  }
  componentDidLoad() {
    if (this.interactive) {
      this.tooltipCloseTimeInMS = 150;
    }
    this.observer = new MutationObserver(() => {
      this.registerTriggerListener();
    });
    this.observer.observe(document.body, {
      attributes: true,
      attributeFilter: ['data-ix-tooltip'],
      childList: true,
      subtree: true,
    });
    this.registerTriggerListener();
    this.registerTooltipListener();
  }
  disconnectedCallback() {
    this.observer.disconnect();
    this.destroyAutoUpdate();
  }
  render() {
    const tooltipContentClass = {
      'tooltip-content': true,
    };
    return (index.h(index.Host, { class: {
        visible: this.visible,
      } }, index.h("div", { class: 'tooltip-title' }, index.h("slot", { name: "title-icon" }), index.h("ix-typography", { variant: "default-title" }, this.titleContent, index.h("slot", { name: "title-content" }))), index.h("div", { class: tooltipContentClass }, index.h("slot", null)), index.h("div", { class: "arrow" })));
  }
  get hostElement() { return index.getElement(this); }
};
Tooltip.style = tooltipCss;

exports.ix_tooltip = Tooltip;

//# sourceMappingURL=ix-tooltip.cjs.entry.js.map