'use strict';

const typedEvent = require('./typed-event-f0f051da.js');

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const mobileMediaQuery = `only screen and (max-width: 767px)`;
const createMediaQueryListener = (query, callback) => {
  const fn = (event) => {
    callback(event);
  };
  const listener = window.matchMedia(query);
  listener.addEventListener('change', fn);
  return {
    matchMedia: listener,
    dispose: () => {
      listener.removeEventListener('change', fn);
    },
  };
};
const createModeListener = (modeChangeCallback) => {
  const listener = createMediaQueryListener(mobileMediaQuery, ({ matches }) => {
    if (matches) {
      modeChangeCallback('mobile');
      return;
    }
    modeChangeCallback('desktop');
  });
  modeChangeCallback(listener.matchMedia.matches ? 'mobile' : 'desktop');
  return {
    dispose: listener.dispose,
    matchMedia: listener.matchMedia,
  };
};

var __classPrivateFieldGet = (undefined && undefined.__classPrivateFieldGet) || function (receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (undefined && undefined.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _ScreenMode_modeChangeListener, _ScreenMode_mode;
class ScreenMode {
  constructor() {
    _ScreenMode_modeChangeListener.set(this, new typedEvent.TypedEvent());
    _ScreenMode_mode.set(this, 'desktop');
    createModeListener((mode) => {
      __classPrivateFieldGet(this, _ScreenMode_modeChangeListener, "f").emit(mode);
      __classPrivateFieldSet(this, _ScreenMode_mode, mode, "f");
    });
  }
  get mode() {
    return __classPrivateFieldGet(this, _ScreenMode_mode, "f");
  }
  get onChange() {
    return __classPrivateFieldGet(this, _ScreenMode_modeChangeListener, "f");
  }
}
_ScreenMode_modeChangeListener = new WeakMap(), _ScreenMode_mode = new WeakMap();
const screenMode = new ScreenMode();

exports.screenMode = screenMode;

//# sourceMappingURL=service-18dc5907.js.map